/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.ContentProviderClient;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.DeadObjectException;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFa1fSDK;
import com.appsflyer.internal.AFc1tSDK;
import com.appsflyer.internal.AFg1tSDK;
import java.util.Observable;
import java.util.Observer;

@RequiresApi(api=19)
public final class AFg1rSDK
extends AFg1tSDK {
    final ProviderInfo AFKeystoreWrapper;
    private final AFc1tSDK values;

    public AFg1rSDK(ProviderInfo providerInfo, Runnable runnable, AFc1tSDK aFc1tSDK) {
        super("af_referrer", providerInfo.authority, runnable);
        this.values = aFc1tSDK;
        this.AFKeystoreWrapper = providerInfo;
    }

    @Override
    public final void valueOf(Context object) {
        object = new Runnable(this, (Context)object){
            private /* synthetic */ Context valueOf;
            private /* synthetic */ AFg1rSDK values;
            {
                this.values = aFg1rSDK;
                this.valueOf = context;
            }

            @Override
            public final void run() {
                AFg1rSDK aFg1rSDK = this.values;
                this.values.afDebugLog = System.currentTimeMillis();
                aFg1rSDK.afInfoLog = AFg1tSDK.AFa1ySDK.AFInAppEventType;
                aFg1rSDK.addObserver(new Observer(aFg1rSDK){
                    private /* synthetic */ AFg1tSDK valueOf;
                    {
                        this.valueOf = aFg1tSDK;
                    }

                    public final void update(Observable observable, Object object) {
                        this.valueOf.AFInAppEventType.run();
                    }
                });
                aFg1rSDK = Uri.parse((String)("content://" + this.values.AFKeystoreWrapper.authority + "/transaction_id"));
                ContentProviderClient contentProviderClient = AFg1rSDK.AFInAppEventParameterName(this.valueOf, (Uri)aFg1rSDK);
                Cursor cursor = null;
                if (contentProviderClient != null) {
                    try {
                        cursor = contentProviderClient.query((Uri)aFg1rSDK, null, "app_id=" + this.valueOf.getPackageName(), null, null);
                    }
                    catch (DeadObjectException deadObjectException) {
                        AFLogger.afErrorLog("[Preinstall]: Failed to acquire unstable content providerClient", deadObjectException, false);
                    }
                    catch (RemoteException remoteException) {
                        AFLogger.afErrorLog("[Preinstall]: Failed to query unstable content providerClient", remoteException, false);
                    }
                    catch (Throwable throwable) {
                        AFLogger.afErrorLog("[Preinstall]: Error to get data from providerClient ", throwable, false);
                    }
                    finally {
                        if (Build.VERSION.SDK_INT >= 24) {
                            contentProviderClient.close();
                        } else {
                            contentProviderClient.release();
                        }
                    }
                }
                if (cursor != null) {
                    int n2 = cursor.getColumnIndex("transaction_id");
                    if (n2 == -1) {
                        AFLogger.afWarnLog("[Preinstall]: Wrong column name");
                        this.values.valueOf.put("response", "FEATURE_NOT_SUPPORTED");
                    } else {
                        this.values.valueOf.put("response", "OK");
                        if (cursor.moveToFirst()) {
                            String string = cursor.getString(n2);
                            cursor.close();
                            if (string != null && !string.isEmpty()) {
                                this.values.valueOf.put("referrer", string);
                            }
                        }
                    }
                    cursor.close();
                } else {
                    AFLogger.afWarnLog("[Preinstall]: ContentProvider query failed, got null Cursor");
                    this.values.valueOf.put("response", "SERVICE_UNAVAILABLE");
                }
                this.values.valueOf.put("api_ver", AFa1fSDK.valueOf(this.valueOf, this.values.AFKeystoreWrapper.packageName));
                this.values.valueOf.put("api_ver_name", AFa1fSDK.AFInAppEventParameterName(this.valueOf, this.values.AFKeystoreWrapper.packageName));
                this.values.AFInAppEventParameterName();
            }
        };
        this.values.AFInAppEventParameterName().execute((Runnable)object);
    }

    @VisibleForTesting
    @Nullable
    public static ContentProviderClient AFInAppEventParameterName(Context context, Uri uri) {
        ContentProviderClient contentProviderClient = null;
        try {
            contentProviderClient = context.getContentResolver().acquireUnstableContentProviderClient(uri);
        }
        catch (SecurityException securityException) {
            AFLogger.afErrorLog("[Preinstall]: Failed to acquire unstable content providerClient due to SecurityException", securityException, false);
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("[Preinstall]: Failed to acquire unstable content providerClient due to unexpected throwable", throwable, false);
        }
        return contentProviderClient;
    }
}

