/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.internal.AFa1eSDK;
import com.appsflyer.internal.AFa1iSDK;
import com.appsflyer.oaid.OaidClient;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GoogleApiAvailability;
import java.util.Map;

public final class AFa1fSDK {
    static String AFInAppEventParameterName;
    @Nullable
    static Boolean AFInAppEventType;

    @Nullable
    public static AFa1eSDK AFInAppEventParameterName(ContentResolver contentResolver) {
        if (!AFa1fSDK.AFInAppEventType()) {
            return null;
        }
        if (contentResolver == null) {
            return null;
        }
        String string = AppsFlyerProperties.getInstance().getString("amazon_aid");
        AFa1eSDK aFa1eSDK = null;
        if (string == null && "Amazon".equals(Build.MANUFACTURER)) {
            int n = Settings.Secure.getInt((ContentResolver)contentResolver, (String)"limit_ad_tracking", (int)2);
            if (n == 0) {
                String string2 = Settings.Secure.getString((ContentResolver)contentResolver, (String)"advertising_id");
                aFa1eSDK = new AFa1eSDK(string2, Boolean.FALSE);
            } else if (n == 2) {
                aFa1eSDK = null;
            } else {
                String string3 = "";
                try {
                    string3 = Settings.Secure.getString((ContentResolver)contentResolver, (String)"advertising_id");
                }
                catch (Throwable throwable) {
                    AFLogger.afErrorLog("Couldn't fetch Amazon Advertising ID (Ad-Tracking is limited!)", throwable);
                }
                aFa1eSDK = new AFa1eSDK(string3, Boolean.TRUE);
            }
        }
        return aFa1eSDK;
    }

    @Nullable
    public static AFa1eSDK AFInAppEventParameterName(Context object) {
        AppsFlyerProperties appsFlyerProperties = AppsFlyerProperties.getInstance();
        String string = null;
        Boolean bl = null;
        boolean bl2 = AFInAppEventParameterName != null;
        if (bl2) {
            string = AFInAppEventParameterName;
        } else if (AFInAppEventType != null && AFInAppEventType.booleanValue() || AFInAppEventType == null && appsFlyerProperties.getBoolean("collectOAID", true)) {
            try {
                object = new OaidClient(object);
                object.setLogging(appsFlyerProperties.isEnableLog());
                object = object.fetch();
                if (object != null) {
                    string = object.getId();
                    bl = object.getLat();
                }
            }
            catch (Throwable throwable) {
                AFLogger.afDebugLog("No OAID library");
            }
        }
        if (string != null) {
            object = new AFa1eSDK(string, bl);
            boolean bl3 = bl2;
            new AFa1eSDK(string, bl).AFInAppEventParameterName = bl3;
            return object;
        }
        return null;
    }

    @Nullable
    public static AFa1eSDK AFKeystoreWrapper(Context context, Map<String, Object> map) {
        int n;
        StringBuilder stringBuilder;
        boolean bl;
        Boolean bl2;
        String string;
        block14: {
            if (!AFa1fSDK.AFInAppEventType()) {
                return null;
            }
            AFLogger.afInfoLog("Trying to fetch GAID..");
            string = null;
            bl2 = null;
            bl = false;
            stringBuilder = new StringBuilder();
            n = -1;
            try {
                n = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context);
            }
            catch (Throwable throwable) {
                AFLogger.afErrorLogForExcManagerOnly("isGooglePlayServicesAvailable error", throwable);
            }
            try {
                Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
                AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
                if (info != null) {
                    string = info.getId();
                    bl2 = info.isLimitAdTrackingEnabled();
                    bl = true;
                    if (string == null || string.length() == 0) {
                        stringBuilder.append("emptyOrNull |");
                    }
                    break block14;
                }
                stringBuilder.append("gpsAdInfo-null |");
                throw new IllegalStateException("GpsAdIndo is null");
            }
            catch (Throwable throwable) {
                AFLogger.afErrorLog("Google Play Services is missing " + throwable.getMessage(), throwable);
                stringBuilder.append(throwable.getClass().getSimpleName()).append(" |");
                AFLogger.afInfoLog("WARNING: Google Play Services is missing.");
                if (!AppsFlyerProperties.getInstance().getBoolean("enableGpsFallback", true)) break block14;
                try {
                    AFa1iSDK.AFa1xSDK aFa1xSDK = AFa1iSDK.valueOf(context);
                    string = aFa1xSDK.AFInAppEventParameterName;
                    bl2 = aFa1xSDK.AFInAppEventParameterName();
                    if (string == null || string.length() == 0) {
                        stringBuilder.append("emptyOrNull (bypass) |");
                    }
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    AFLogger.afErrorLog(throwable2.getMessage(), throwable3, true, false, false);
                    stringBuilder.append(throwable3.getClass().getSimpleName()).append(" |");
                    string = AppsFlyerProperties.getInstance().getString("advertiserId");
                    bl2 = !Boolean.parseBoolean(AppsFlyerProperties.getInstance().getString("advertiserIdEnabled"));
                    if (throwable3.getLocalizedMessage() != null) {
                        AFLogger.afInfoLog(throwable3.getLocalizedMessage());
                        break block14;
                    }
                    AFLogger.afInfoLog(((Object)throwable3).toString());
                }
            }
        }
        if (context.getClass().getName().equals("android.app.ReceiverRestrictedContext")) {
            string = AppsFlyerProperties.getInstance().getString("advertiserId");
            bl2 = !Boolean.parseBoolean(AppsFlyerProperties.getInstance().getString("advertiserIdEnabled"));
            stringBuilder.append("context = android.app.ReceiverRestrictedContext |");
        }
        if (stringBuilder.length() > 0) {
            map.put("gaidError", n + ": " + stringBuilder);
        }
        if (string != null && bl2 != null) {
            map.put("advertiserId", string);
            map.put("advertiserIdEnabled", String.valueOf(bl2 == false));
            AppsFlyerProperties.getInstance().set("advertiserId", string);
            AppsFlyerProperties.getInstance().set("advertiserIdEnabled", String.valueOf(bl2 == false));
            map.put("isGaidWithGps", String.valueOf(bl));
        }
        return new AFa1eSDK(string, bl2);
    }

    private static boolean AFInAppEventType() {
        return AFInAppEventType == null || AFInAppEventType != false;
    }
}

