/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.internal.AFa1dSDK;
import com.appsflyer.internal.AFb1fSDK;

public class AFLogger {
    private static final long AFInAppEventParameterName = System.currentTimeMillis();

    public static void afInfoLog(String string, boolean bl) {
        if (AFLogger.values(LogLevel.INFO)) {
            Log.i((String)"AppsFlyer_6.11.1", (String)AFLogger.values(string, false));
        }
        if (bl) {
            AFa1dSDK.valueOf().values().afErrorLogForExcManagerOnly().AFInAppEventType("I", AFLogger.values(string, true));
        }
    }

    @NonNull
    private static String values(String string, boolean bl) {
        if (string == null) {
            string = "null";
        }
        if (bl || LogLevel.VERBOSE.getLevel() <= AppsFlyerProperties.getInstance().getInt("logLevel", LogLevel.NONE.getLevel())) {
            return "(" + (System.currentTimeMillis() - AFInAppEventParameterName) + ") [" + Thread.currentThread().getName() + "] " + string;
        }
        return string;
    }

    public static void afErrorLog(String string, Throwable throwable, boolean bl, boolean bl2, boolean bl3) {
        if (string == null) {
            string = throwable.getClass().getSimpleName() + " at " + ((Object)throwable.getStackTrace()[0]).toString();
        }
        if (AFLogger.values(LogLevel.ERROR)) {
            String string2 = AFLogger.values(string, false);
            if (bl2) {
                Log.e((String)"AppsFlyer_6.11.1", (String)string2, (Throwable)throwable);
            } else if (bl) {
                Log.d((String)"AppsFlyer_6.11.1", (String)string2);
            }
        }
        AFa1dSDK.valueOf().values().afErrorLogForExcManagerOnly().AFInAppEventType(throwable);
        if (AFb1fSDK.AFKeystoreWrapper != null) {
            AFa1dSDK.AFInAppEventParameterName((Context)AFb1fSDK.AFKeystoreWrapper).edit().putLong("exception_number", (AFb1fSDK.AFKeystoreWrapper == null ? -1L : AFa1dSDK.AFInAppEventParameterName((Context)AFb1fSDK.AFKeystoreWrapper).getLong("exception_number", 0L)) + 1L).apply();
        }
        if (bl3) {
            AFa1dSDK.valueOf().values().onDeepLinking().AFInAppEventType(throwable, string);
        }
    }

    public static void valueOf(String string) {
        if (AFLogger.values(LogLevel.WARNING)) {
            Log.w((String)"AppsFlyer_6.11.1", (String)AFLogger.values(string, false));
        }
        AFa1dSDK.valueOf().values().afErrorLogForExcManagerOnly().AFInAppEventType("W", AFLogger.values(string, true));
    }

    public static void afRDLog(String string) {
        if (AFLogger.values(LogLevel.VERBOSE)) {
            Log.v((String)"AppsFlyer_6.11.1", (String)AFLogger.values(string, false));
        }
        AFa1dSDK.valueOf().values().afErrorLogForExcManagerOnly().AFInAppEventType("V", AFLogger.values(string, true));
    }

    private static boolean values(LogLevel logLevel) {
        return logLevel.getLevel() <= AppsFlyerProperties.getInstance().getInt("logLevel", LogLevel.NONE.getLevel());
    }

    public static void AFKeystoreWrapper(String string) {
        if (!AFLogger.valueOf()) {
            Log.d((String)"AppsFlyer_6.11.1", (String)AFLogger.values(string, false));
        }
        AFa1dSDK.valueOf().values().afErrorLogForExcManagerOnly().AFInAppEventType("F", string);
    }

    private static boolean valueOf() {
        return AppsFlyerProperties.getInstance().isLogsDisabledCompletely();
    }

    public static void afDebugLog(String string) {
        if (AFLogger.values(LogLevel.DEBUG)) {
            Log.d((String)"AppsFlyer_6.11.1", (String)AFLogger.values(string, false));
        }
        AFa1dSDK.valueOf().values().afErrorLogForExcManagerOnly().AFInAppEventType("D", AFLogger.values(string, true));
    }

    public static void afInfoLog(String string) {
        AFLogger.afInfoLog(string, true);
    }

    public static void afErrorLog(String string, Throwable throwable) {
        AFLogger.afErrorLog(string, throwable, true, false, true);
    }

    public static void afErrorLogForExcManagerOnly(String string, Throwable throwable) {
        AFLogger.afErrorLogForExcManagerOnly(string, throwable, false);
    }

    public static void afErrorLogForExcManagerOnly(String string, Throwable throwable, boolean bl) {
        AFLogger.afErrorLog(string, throwable, false, false, !bl);
    }

    public static void afErrorLog(String string, Throwable throwable, boolean bl) {
        AFLogger.afErrorLog(string, throwable, true, bl, true);
    }

    public static void afErrorLog(String string, Throwable throwable, boolean bl, boolean bl2) {
        AFLogger.afErrorLog(string, throwable, true, bl, bl2);
    }

    @Deprecated
    public static void afErrorLog(Throwable throwable) {
        AFLogger.afErrorLogForExcManagerOnly("Unknown", throwable);
    }

    public static void afWarnLog(String string) {
        AFLogger.valueOf(string);
    }

    public static enum LogLevel {
        NONE(0),
        ERROR(1),
        WARNING(2),
        INFO(3),
        DEBUG(4),
        VERBOSE(5);

        private int AFInAppEventType;

        private LogLevel(int n2) {
            this.AFInAppEventType = n2;
        }

        public final int getLevel() {
            return this.AFInAppEventType;
        }
    }
}

