/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.android.installreferrer.api.ReferrerDetails;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFa1cSDK;
import com.appsflyer.internal.AFf1jSDK;
import com.appsflyer.internal.AFf1pSDK;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

public class AFf1mSDK
extends AFf1pSDK {
    public final Map<String, Object> AFInAppEventParameterName = new HashMap<String, Object>();

    public AFf1mSDK(Runnable runnable) {
        super("store", "google", runnable);
    }

    private static boolean valueOf(@NonNull Context context) {
        if (!AFf1mSDK.AFKeystoreWrapper(context)) {
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AFa1cSDK.AFKeystoreWrapper(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                com.appsflyer.AFLogger.afDebugLog("Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("InstallReferrerClient not found", classNotFoundException);
            com.appsflyer.AFLogger.afRDLog("Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.afErrorLog("An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        com.appsflyer.AFLogger.afDebugLog("Install referrer is not allowed");
        return false;
    }

    @Override
    public final void values(final Context context) {
        if (!AFf1mSDK.valueOf(context)) {
            return;
        }
        AFf1mSDK aFf1mSDK = this;
        this.AFLogger = System.currentTimeMillis();
        aFf1mSDK.AFKeystoreWrapper = AFf1jSDK.AFa1wSDK.valueOf;
        aFf1mSDK.addObserver(new Observer(aFf1mSDK){
            private /* synthetic */ AFf1jSDK AFKeystoreWrapper;
            {
                this.AFKeystoreWrapper = aFf1jSDK;
            }

            public final void update(Observable observable, Object object) {
                this.AFKeystoreWrapper.values.run();
            }
        });
        try {
            aFf1mSDK = InstallReferrerClient.newBuilder((Context)context).build();
            com.appsflyer.AFLogger.afDebugLog("Connecting to Install Referrer Library...");
            aFf1mSDK.startConnection(new InstallReferrerStateListener((InstallReferrerClient)aFf1mSDK){
                final /* synthetic */ InstallReferrerClient val$referrerClient;
                {
                    this.val$referrerClient = installReferrerClient;
                }

                public final void onInstallReferrerSetupFinished(int n) {
                    AFf1mSDK.this.AFInAppEventParameterName.put("code", String.valueOf(n));
                    String string = "com.android.vending";
                    AFf1mSDK.this.AFInAppEventType.put("api_ver", AFa1cSDK.values(context, string));
                    AFf1mSDK.this.AFInAppEventType.put("api_ver_name", AFa1cSDK.AFInAppEventParameterName(context, string));
                    switch (n) {
                        case 0: {
                            AFf1mSDK.this.AFInAppEventType.put("response", "OK");
                            try {
                                com.appsflyer.AFLogger.afDebugLog("InstallReferrer connected");
                                if (this.val$referrerClient.isReady()) {
                                    ReferrerDetails referrerDetails = this.val$referrerClient.getInstallReferrer();
                                    String string2 = referrerDetails.getInstallReferrer();
                                    if (string2 != null) {
                                        AFf1mSDK.this.AFInAppEventParameterName.put("val", string2);
                                        AFf1mSDK.this.AFInAppEventType.put("referrer", string2);
                                    }
                                    long l = referrerDetails.getReferrerClickTimestampSeconds();
                                    AFf1mSDK.this.AFInAppEventParameterName.put("clk", Long.toString(l));
                                    AFf1mSDK.this.AFInAppEventType.put("click_ts", l);
                                    long l2 = referrerDetails.getInstallBeginTimestampSeconds();
                                    AFf1mSDK.this.AFInAppEventParameterName.put("install", Long.toString(l2));
                                    AFf1mSDK.this.AFInAppEventType.put("install_begin_ts", l2);
                                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                                    try {
                                        boolean bl = referrerDetails.getGooglePlayInstantParam();
                                        AFf1mSDK.this.AFInAppEventParameterName.put("instant", bl);
                                        hashMap.put("instant", bl);
                                    }
                                    catch (NoSuchMethodError noSuchMethodError) {
                                        com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("getGooglePlayInstantParam not exist", noSuchMethodError);
                                    }
                                    try {
                                        hashMap.put("click_server_ts", referrerDetails.getReferrerClickTimestampServerSeconds());
                                        hashMap.put("install_begin_server_ts", referrerDetails.getInstallBeginTimestampServerSeconds());
                                        hashMap.put("install_version", referrerDetails.getInstallVersion());
                                    }
                                    catch (NoSuchMethodError noSuchMethodError) {
                                        com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("some method not exist", noSuchMethodError);
                                    }
                                    if (hashMap.isEmpty()) break;
                                    AFf1mSDK.this.AFInAppEventType.put("google_custom", hashMap);
                                    break;
                                }
                                String string3 = "ReferrerClient: InstallReferrer is not ready";
                                com.appsflyer.AFLogger.afWarnLog("ReferrerClient: InstallReferrer is not ready");
                                AFf1mSDK.this.AFInAppEventParameterName.put("err", "ReferrerClient: InstallReferrer is not ready");
                            }
                            catch (Throwable throwable) {
                                com.appsflyer.AFLogger.afWarnLog("Failed to get install referrer: " + throwable.getMessage());
                                AFf1mSDK.this.AFInAppEventParameterName.put("err", throwable.getMessage());
                                com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("Failed to get install referrer", throwable);
                            }
                            break;
                        }
                        case 2: {
                            com.appsflyer.AFLogger.afWarnLog("InstallReferrer FEATURE_NOT_SUPPORTED");
                            AFf1mSDK.this.AFInAppEventType.put("response", "FEATURE_NOT_SUPPORTED");
                            break;
                        }
                        case 1: {
                            AFf1mSDK.this.AFInAppEventType.put("response", "SERVICE_UNAVAILABLE");
                            com.appsflyer.AFLogger.afWarnLog("InstallReferrer not supported");
                            break;
                        }
                        case 3: {
                            com.appsflyer.AFLogger.afWarnLog("InstallReferrer DEVELOPER_ERROR");
                            AFf1mSDK.this.AFInAppEventType.put("response", "DEVELOPER_ERROR");
                            break;
                        }
                        case -1: {
                            com.appsflyer.AFLogger.afWarnLog("InstallReferrer SERVICE_DISCONNECTED");
                            AFf1mSDK.this.AFInAppEventType.put("response", "SERVICE_DISCONNECTED");
                            break;
                        }
                        default: {
                            com.appsflyer.AFLogger.afWarnLog("responseCode not found.");
                        }
                    }
                    com.appsflyer.AFLogger.afDebugLog("Install Referrer collected locally");
                    AFf1mSDK.this.values();
                    this.val$referrerClient.endConnection();
                }

                public final void onInstallReferrerServiceDisconnected() {
                    com.appsflyer.AFLogger.afDebugLog("Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.afErrorLog("referrerClient -> startConnection", throwable);
            return;
        }
    }
}

