/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.android.installreferrer.api.ReferrerDetails;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFa1cSDK;
import com.appsflyer.internal.AFf1oSDK;
import com.appsflyer.internal.AFf1tSDK;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

public class AFf1qSDK
extends AFf1tSDK {
    public final Map<String, Object> AFInAppEventType = new HashMap<String, Object>();

    public AFf1qSDK(Runnable runnable) {
        super("store", "google", runnable);
    }

    private static boolean AFKeystoreWrapper(@NonNull Context context) {
        if (!AFf1qSDK.values(context)) {
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AFa1cSDK.values(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                com.appsflyer.AFLogger.afDebugLog("Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("InstallReferrerClient not found", classNotFoundException);
            com.appsflyer.AFLogger.afRDLog("Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.afErrorLog("An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        com.appsflyer.AFLogger.afDebugLog("Install referrer is not allowed");
        return false;
    }

    @Override
    public final void valueOf(final Context context) {
        if (!AFf1qSDK.AFKeystoreWrapper(context)) {
            return;
        }
        AFf1qSDK aFf1qSDK = this;
        this.afDebugLog = System.currentTimeMillis();
        aFf1qSDK.afRDLog = AFf1oSDK.AFa1zSDK.values;
        aFf1qSDK.addObserver(new Observer(aFf1qSDK){
            private /* synthetic */ AFf1oSDK valueOf;
            {
                this.valueOf = aFf1oSDK;
            }

            public final void update(Observable observable, Object object) {
                this.valueOf.AFInAppEventParameterName.run();
            }
        });
        try {
            aFf1qSDK = InstallReferrerClient.newBuilder((Context)context).build();
            com.appsflyer.AFLogger.afDebugLog("Connecting to Install Referrer Library...");
            aFf1qSDK.startConnection(new InstallReferrerStateListener((InstallReferrerClient)aFf1qSDK){
                final /* synthetic */ InstallReferrerClient val$referrerClient;
                {
                    this.val$referrerClient = installReferrerClient;
                }

                public final void onInstallReferrerSetupFinished(int n) {
                    AFf1qSDK.this.AFInAppEventType.put("code", String.valueOf(n));
                    String string = "com.android.vending";
                    AFf1qSDK.this.valueOf.put("api_ver", AFa1cSDK.AFKeystoreWrapper(context, string));
                    AFf1qSDK.this.valueOf.put("api_ver_name", AFa1cSDK.AFInAppEventType(context, string));
                    switch (n) {
                        case 0: {
                            AFf1qSDK.this.valueOf.put("response", "OK");
                            try {
                                com.appsflyer.AFLogger.afDebugLog("InstallReferrer connected");
                                if (this.val$referrerClient.isReady()) {
                                    ReferrerDetails referrerDetails = this.val$referrerClient.getInstallReferrer();
                                    String string2 = referrerDetails.getInstallReferrer();
                                    if (string2 != null) {
                                        AFf1qSDK.this.AFInAppEventType.put("val", string2);
                                        AFf1qSDK.this.valueOf.put("referrer", string2);
                                    }
                                    long l = referrerDetails.getReferrerClickTimestampSeconds();
                                    AFf1qSDK.this.AFInAppEventType.put("clk", Long.toString(l));
                                    AFf1qSDK.this.valueOf.put("click_ts", l);
                                    long l2 = referrerDetails.getInstallBeginTimestampSeconds();
                                    AFf1qSDK.this.AFInAppEventType.put("install", Long.toString(l2));
                                    AFf1qSDK.this.valueOf.put("install_begin_ts", l2);
                                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                                    try {
                                        boolean bl = referrerDetails.getGooglePlayInstantParam();
                                        AFf1qSDK.this.AFInAppEventType.put("instant", bl);
                                        hashMap.put("instant", bl);
                                    }
                                    catch (NoSuchMethodError noSuchMethodError) {
                                        com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("getGooglePlayInstantParam not exist", noSuchMethodError);
                                    }
                                    try {
                                        hashMap.put("click_server_ts", referrerDetails.getReferrerClickTimestampServerSeconds());
                                        hashMap.put("install_begin_server_ts", referrerDetails.getInstallBeginTimestampServerSeconds());
                                        hashMap.put("install_version", referrerDetails.getInstallVersion());
                                    }
                                    catch (NoSuchMethodError noSuchMethodError) {
                                        com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("some method not exist", noSuchMethodError);
                                    }
                                    if (hashMap.isEmpty()) break;
                                    AFf1qSDK.this.valueOf.put("google_custom", hashMap);
                                    break;
                                }
                                String string3 = "ReferrerClient: InstallReferrer is not ready";
                                com.appsflyer.AFLogger.afWarnLog("ReferrerClient: InstallReferrer is not ready");
                                AFf1qSDK.this.AFInAppEventType.put("err", "ReferrerClient: InstallReferrer is not ready");
                            }
                            catch (Throwable throwable) {
                                com.appsflyer.AFLogger.afWarnLog("Failed to get install referrer: " + throwable.getMessage());
                                AFf1qSDK.this.AFInAppEventType.put("err", throwable.getMessage());
                                com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("Failed to get install referrer", throwable);
                            }
                            break;
                        }
                        case 2: {
                            com.appsflyer.AFLogger.afWarnLog("InstallReferrer FEATURE_NOT_SUPPORTED");
                            AFf1qSDK.this.valueOf.put("response", "FEATURE_NOT_SUPPORTED");
                            break;
                        }
                        case 1: {
                            AFf1qSDK.this.valueOf.put("response", "SERVICE_UNAVAILABLE");
                            com.appsflyer.AFLogger.afWarnLog("InstallReferrer not supported");
                            break;
                        }
                        case 3: {
                            com.appsflyer.AFLogger.afWarnLog("InstallReferrer DEVELOPER_ERROR");
                            AFf1qSDK.this.valueOf.put("response", "DEVELOPER_ERROR");
                            break;
                        }
                        case -1: {
                            com.appsflyer.AFLogger.afWarnLog("InstallReferrer SERVICE_DISCONNECTED");
                            AFf1qSDK.this.valueOf.put("response", "SERVICE_DISCONNECTED");
                            break;
                        }
                        default: {
                            com.appsflyer.AFLogger.afWarnLog("responseCode not found.");
                        }
                    }
                    com.appsflyer.AFLogger.afDebugLog("Install Referrer collected locally");
                    AFf1qSDK.this.values();
                    this.val$referrerClient.endConnection();
                }

                public final void onInstallReferrerServiceDisconnected() {
                    com.appsflyer.AFLogger.afDebugLog("Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.afErrorLog("referrerClient -> startConnection", throwable);
            return;
        }
    }
}

