/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import android.support.annotation.NonNull;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.android.installreferrer.api.ReferrerDetails;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFa1dSDK;
import com.appsflyer.internal.AFf1uSDK;
import com.appsflyer.internal.AFf1zSDK;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

public class AFf1ySDK
extends AFf1zSDK {
    public final Map<String, Object> AFInAppEventParameterName = new HashMap<String, Object>();

    public AFf1ySDK(Runnable runnable) {
        super("store", "google", runnable);
    }

    private static boolean AFInAppEventParameterName(@NonNull Context context) {
        if (!AFf1ySDK.valueOf(context)) {
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AFa1dSDK.AFInAppEventParameterName(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                AFLogger.afDebugLog("Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            AFLogger.afErrorLogForExcManagerOnly("InstallReferrerClient not found", classNotFoundException);
            AFLogger.afRDLog("Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        AFLogger.afDebugLog("Install referrer is not allowed");
        return false;
    }

    @Override
    public final void AFInAppEventType(final Context context) {
        if (!AFf1ySDK.AFInAppEventParameterName(context)) {
            return;
        }
        AFf1ySDK aFf1ySDK = this;
        this.afRDLog = System.currentTimeMillis();
        aFf1ySDK.afDebugLog = AFf1uSDK.AFa1ySDK.AFInAppEventType;
        aFf1ySDK.addObserver(new Observer(aFf1ySDK){
            private /* synthetic */ AFf1uSDK AFKeystoreWrapper;
            {
                this.AFKeystoreWrapper = aFf1uSDK;
            }

            public final void update(Observable observable, Object object) {
                this.AFKeystoreWrapper.AFInAppEventType.run();
            }
        });
        try {
            aFf1ySDK = InstallReferrerClient.newBuilder((Context)context).build();
            AFLogger.afDebugLog("Connecting to Install Referrer Library...");
            aFf1ySDK.startConnection(new InstallReferrerStateListener((InstallReferrerClient)aFf1ySDK){
                final /* synthetic */ InstallReferrerClient val$referrerClient;
                {
                    this.val$referrerClient = installReferrerClient;
                }

                public final void onInstallReferrerSetupFinished(int n) {
                    AFf1ySDK.this.AFInAppEventParameterName.put("code", String.valueOf(n));
                    String string = "com.android.vending";
                    AFf1ySDK.this.values.put("api_ver", AFa1dSDK.AFKeystoreWrapper(context, string));
                    AFf1ySDK.this.values.put("api_ver_name", AFa1dSDK.values(context, string));
                    switch (n) {
                        case 0: {
                            AFf1ySDK.this.values.put("response", "OK");
                            try {
                                AFLogger.afDebugLog("InstallReferrer connected");
                                if (this.val$referrerClient.isReady()) {
                                    ReferrerDetails referrerDetails = this.val$referrerClient.getInstallReferrer();
                                    String string2 = referrerDetails.getInstallReferrer();
                                    if (string2 != null) {
                                        AFf1ySDK.this.AFInAppEventParameterName.put("val", string2);
                                        AFf1ySDK.this.values.put("referrer", string2);
                                    }
                                    long l = referrerDetails.getReferrerClickTimestampSeconds();
                                    AFf1ySDK.this.AFInAppEventParameterName.put("clk", Long.toString(l));
                                    AFf1ySDK.this.values.put("click_ts", l);
                                    long l2 = referrerDetails.getInstallBeginTimestampSeconds();
                                    AFf1ySDK.this.AFInAppEventParameterName.put("install", Long.toString(l2));
                                    AFf1ySDK.this.values.put("install_begin_ts", l2);
                                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                                    try {
                                        boolean bl = referrerDetails.getGooglePlayInstantParam();
                                        AFf1ySDK.this.AFInAppEventParameterName.put("instant", bl);
                                        hashMap.put("instant", bl);
                                    }
                                    catch (NoSuchMethodError noSuchMethodError) {
                                        AFLogger.afErrorLogForExcManagerOnly("getGooglePlayInstantParam not exist", noSuchMethodError);
                                    }
                                    try {
                                        hashMap.put("click_server_ts", referrerDetails.getReferrerClickTimestampServerSeconds());
                                        hashMap.put("install_begin_server_ts", referrerDetails.getInstallBeginTimestampServerSeconds());
                                        hashMap.put("install_version", referrerDetails.getInstallVersion());
                                    }
                                    catch (NoSuchMethodError noSuchMethodError) {
                                        AFLogger.afErrorLogForExcManagerOnly("some method not exist", noSuchMethodError);
                                    }
                                    if (hashMap.isEmpty()) break;
                                    AFf1ySDK.this.values.put("google_custom", hashMap);
                                    break;
                                }
                                String string3 = "ReferrerClient: InstallReferrer is not ready";
                                AFLogger.afWarnLog("ReferrerClient: InstallReferrer is not ready");
                                AFf1ySDK.this.AFInAppEventParameterName.put("err", "ReferrerClient: InstallReferrer is not ready");
                            }
                            catch (Throwable throwable) {
                                AFLogger.afWarnLog("Failed to get install referrer: " + throwable.getMessage());
                                AFf1ySDK.this.AFInAppEventParameterName.put("err", throwable.getMessage());
                                AFLogger.afErrorLogForExcManagerOnly("Failed to get install referrer", throwable);
                            }
                            break;
                        }
                        case 2: {
                            AFLogger.afWarnLog("InstallReferrer FEATURE_NOT_SUPPORTED");
                            AFf1ySDK.this.values.put("response", "FEATURE_NOT_SUPPORTED");
                            break;
                        }
                        case 1: {
                            AFf1ySDK.this.values.put("response", "SERVICE_UNAVAILABLE");
                            AFLogger.afWarnLog("InstallReferrer not supported");
                            break;
                        }
                        case 3: {
                            AFLogger.afWarnLog("InstallReferrer DEVELOPER_ERROR");
                            AFf1ySDK.this.values.put("response", "DEVELOPER_ERROR");
                            break;
                        }
                        case -1: {
                            AFLogger.afWarnLog("InstallReferrer SERVICE_DISCONNECTED");
                            AFf1ySDK.this.values.put("response", "SERVICE_DISCONNECTED");
                            break;
                        }
                        default: {
                            AFLogger.afWarnLog("responseCode not found.");
                        }
                    }
                    AFLogger.afDebugLog("Install Referrer collected locally");
                    AFf1ySDK.this.valueOf();
                    this.val$referrerClient.endConnection();
                }

                public final void onInstallReferrerServiceDisconnected() {
                    AFLogger.afDebugLog("Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("referrerClient -> startConnection", throwable);
            return;
        }
    }
}

