/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.AdvertisingIdObject;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.internal.p;
import com.appsflyer.oaid.OaidClient;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GoogleApiAvailability;
import java.util.Map;

public class AdvertisingIdUtil {
    public static final String AMAZON_MANUFACTURER = "Amazon";
    static String $$a;

    @Nullable
    public static AdvertisingIdObject getAmazonAID(ContentResolver contentResolver) {
        if (contentResolver == null) {
            return null;
        }
        String string = AppsFlyerProperties.getInstance().getString("amazon_aid");
        AdvertisingIdObject advertisingIdObject = null;
        if (string == null && AMAZON_MANUFACTURER.equals(Build.MANUFACTURER)) {
            int n = Settings.Secure.getInt((ContentResolver)contentResolver, (String)"limit_ad_tracking", (int)2);
            if (n == 0) {
                String string2 = Settings.Secure.getString((ContentResolver)contentResolver, (String)"advertising_id");
                advertisingIdObject = new AdvertisingIdObject(string2, Boolean.FALSE);
            } else if (n == 2) {
                advertisingIdObject = null;
            } else {
                String string3 = "";
                try {
                    string3 = Settings.Secure.getString((ContentResolver)contentResolver, (String)"advertising_id");
                }
                catch (Throwable throwable) {
                    AFLogger.afErrorLog("Couldn't fetch Amazon Advertising ID (Ad-Tracking is limited!)", throwable);
                }
                advertisingIdObject = new AdvertisingIdObject(string3, Boolean.TRUE);
            }
        }
        return advertisingIdObject;
    }

    @Nullable
    public static AdvertisingIdObject getOaid(Context context) {
        AdvertisingIdObject advertisingIdObject;
        AppsFlyerProperties appsFlyerProperties = AppsFlyerProperties.getInstance();
        String string = null;
        Boolean bl = null;
        boolean bl2 = $$a != null;
        if (bl2) {
            string = $$a;
        } else if (appsFlyerProperties.getBoolean("collectOAID", true)) {
            try {
                advertisingIdObject = new OaidClient(context);
                advertisingIdObject.setLogging(appsFlyerProperties.isEnableLog());
                OaidClient.Info info = advertisingIdObject.fetch();
                if (info != null) {
                    string = info.getId();
                    bl = info.getLat();
                }
            }
            catch (Throwable throwable) {
                AFLogger.afDebugLog("No OAID library");
            }
        }
        if (string != null) {
            advertisingIdObject = new AdvertisingIdObject(string, bl);
            advertisingIdObject.setManual(bl2);
            return advertisingIdObject;
        }
        return null;
    }

    public static AdvertisingIdObject getGaid(Context context, Map<String, Object> map) {
        int n;
        StringBuilder stringBuilder;
        boolean bl;
        Boolean bl2;
        String string;
        block13: {
            AFLogger.afInfoLog("Trying to fetch GAID..");
            string = null;
            bl2 = null;
            bl = false;
            stringBuilder = new StringBuilder();
            n = -1;
            try {
                n = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context);
            }
            catch (Throwable throwable) {}
            try {
                Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
                AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
                if (info != null) {
                    string = info.getId();
                    bl2 = info.isLimitAdTrackingEnabled();
                    bl = true;
                    if (string == null || string.length() == 0) {
                        stringBuilder.append("emptyOrNull |");
                    }
                    break block13;
                }
                stringBuilder.append("gpsAdInfo-null |");
                throw new IllegalStateException("GpsAdIndo is null");
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                AFLogger.afErrorLog(throwable.getMessage(), throwable2);
                stringBuilder.append(throwable2.getClass().getSimpleName()).append(" |");
                AFLogger.afInfoLog("WARNING: Google Play Services is missing.");
                if (!AppsFlyerProperties.getInstance().getBoolean("enableGpsFallback", true)) break block13;
                try {
                    p.c c2 = p.values(context);
                    string = c2.valueOf;
                    bl2 = c2.$$b();
                    if (string == null || string.length() == 0) {
                        stringBuilder.append("emptyOrNull (bypass) |");
                    }
                }
                catch (Throwable throwable3) {
                    Throwable throwable4 = throwable3;
                    AFLogger.afErrorLog(throwable3.getMessage(), throwable4);
                    stringBuilder.append(throwable4.getClass().getSimpleName()).append(" |");
                    string = AppsFlyerProperties.getInstance().getString("advertiserId");
                    bl2 = !Boolean.parseBoolean(AppsFlyerProperties.getInstance().getString("advertiserIdEnabled"));
                    if (throwable4.getLocalizedMessage() != null) {
                        AFLogger.afInfoLog(throwable4.getLocalizedMessage());
                        break block13;
                    }
                    AFLogger.afInfoLog(((Object)throwable4).toString());
                }
            }
        }
        if (context.getClass().getName().equals("android.app.ReceiverRestrictedContext")) {
            string = AppsFlyerProperties.getInstance().getString("advertiserId");
            bl2 = !Boolean.parseBoolean(AppsFlyerProperties.getInstance().getString("advertiserIdEnabled"));
            stringBuilder.append("context = android.app.ReceiverRestrictedContext |");
        }
        if (stringBuilder.length() > 0) {
            map.put("gaidError", n + ": " + stringBuilder);
        }
        if (string != null && bl2 != null) {
            map.put("advertiserId", string);
            map.put("advertiserIdEnabled", String.valueOf(bl2 == false));
            AppsFlyerProperties.getInstance().set("advertiserId", string);
            AppsFlyerProperties.getInstance().set("advertiserIdEnabled", String.valueOf(bl2 == false));
            map.put("isGaidWithGps", String.valueOf(bl));
        }
        return new AdvertisingIdObject(string, bl2);
    }
}

