/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.text.TextUtils;
import com.appsflyer.AFLogger;
import com.appsflyer.AppsFlyerLibCore;
import com.appsflyer.internal.ac;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;

public abstract class OneLinkHttpTask
implements Runnable {
    static final String NO_CONNECTION_ERROR_MSG = "Can't get one link data";
    protected static String BASE_URL = "https://%sonelink.%s/shortlink-sdk/v1";
    private static final int WAIT_TIMEOUT = 3000;
    public String oneLinkId;
    private HttpsUrlConnectionProvider connectionProvider;
    private AppsFlyerLibCore afLib;

    public OneLinkHttpTask(AppsFlyerLibCore appsFlyerLibCore) {
        this.afLib = appsFlyerLibCore;
    }

    public static void setUrl(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!"onelink".equals(entry.getKey())) continue;
            BASE_URL = entry.getValue();
        }
    }

    public void setConnProvider(HttpsUrlConnectionProvider httpsUrlConnectionProvider) {
        this.connectionProvider = httpsUrlConnectionProvider;
    }

    @Override
    public void run() {
        this.doRequest();
    }

    private void doRequest() {
        long l = System.currentTimeMillis() / 1000L;
        String string = "";
        String string2 = "";
        String string3 = this.getOneLinkUrl();
        AFLogger.afRDLog("oneLinkUrl: " + string3);
        try {
            HttpsURLConnection httpsURLConnection = this.connectionProvider.\u0269(string3);
            httpsURLConnection.addRequestProperty("content-type", "application/json");
            httpsURLConnection.addRequestProperty("authorization", ac.\u01c3(l));
            httpsURLConnection.addRequestProperty("af-timestamp", String.valueOf(l));
            httpsURLConnection.setReadTimeout(3000);
            httpsURLConnection.setConnectTimeout(3000);
            this.initRequest(httpsURLConnection);
            int n2 = httpsURLConnection.getResponseCode();
            string = this.afLib.\u01c3(httpsURLConnection);
            if (n2 == 200) {
                AFLogger.afInfoLog("Status 200 ok");
            } else {
                string2 = "Response code = " + n2 + " content = " + string;
            }
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("Error while calling " + string3, throwable);
            string2 = "Error while calling " + string3 + " stacktrace: " + throwable.toString();
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            AFLogger.afInfoLog("Connection call succeeded: " + string);
            this.handleResponse(string);
        } else {
            AFLogger.afWarnLog("Connection error: " + string2);
            this.onErrorResponse();
        }
    }

    protected abstract void initRequest(HttpsURLConnection var1) throws JSONException, IOException;

    protected abstract String getOneLinkUrl();

    protected abstract void handleResponse(String var1);

    protected abstract void onErrorResponse();

    public static class HttpsUrlConnectionProvider {
        final HttpsURLConnection \u0269(String string) throws IOException {
            return (HttpsURLConnection)new URL(string).openConnection();
        }
    }
}

