/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.VisibleForTesting;
import com.appsflyer.AFExecutor;
import com.appsflyer.AFLogger;
import com.appsflyer.AppsFlyerLibCore;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class AFDeepLinkManager {
    static final int \u03b9 = (int)TimeUnit.SECONDS.toMillis(2L);
    static volatile boolean \u01c3;
    static String[] \u0269;
    public static String[] \u0131;
    @VisibleForTesting
    public static AFDeepLinkManager instance;
    @VisibleForTesting
    public static Uri trampolineUri;

    private AFDeepLinkManager() {
    }

    public static AFDeepLinkManager getInstance() {
        if (instance == null) {
            instance = new AFDeepLinkManager();
        }
        return instance;
    }

    private static boolean \u0399(String string) {
        if (\u0269 == null) {
            return false;
        }
        if (string.contains("af_tranid=")) {
            return false;
        }
        AFLogger.afRDLog("Validate ESP URLs :" + Arrays.asList(\u0269));
        try {
            return Arrays.asList(\u0269).contains(new URL(string).getHost());
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    static void \u01c3(Context context, Map<String, Object> map, Uri uri) {
        if (AFDeepLinkManager.\u0399(uri.toString())) {
            \u01c3 = true;
            AFExecutor aFExecutor = AFExecutor.getInstance();
            if (aFExecutor.\u0269 == null) {
                aFExecutor.\u0269 = Executors.newSingleThreadScheduledExecutor(aFExecutor.\u0399);
            }
            aFExecutor.\u0269.execute(new Runnable(uri, map, context){
                private /* synthetic */ Uri \u0269;
                private /* synthetic */ Map \u0399;
                private /* synthetic */ Context \u03b9;
                {
                    this.\u0269 = uri;
                    this.\u0399 = map;
                    this.\u03b9 = context;
                }

                @Override
                public final void run() {
                    Map map;
                    long l = System.currentTimeMillis();
                    String string = this.\u0269.toString();
                    Integer n2 = null;
                    String string2 = null;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (int j = 0; j < 5; ++j) {
                        map = 3.\u0269(Uri.parse((String)string));
                        string = (String)map.get("res");
                        n2 = (Integer)map.get("status");
                        string2 = (String)map.get("error");
                        if (string == null || !AFDeepLinkManager.\u0399(string)) break;
                        if (j >= 4) continue;
                        ((AbstractCollection)arrayList).add(string);
                    }
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("res", string != null ? string : "");
                    hashMap.put("status", n2 != null ? n2 : -1);
                    if (string2 != null) {
                        hashMap.put("error", string2);
                    }
                    if (!((AbstractCollection)arrayList).isEmpty()) {
                        hashMap.put("redirects", arrayList);
                    }
                    hashMap.put("latency", System.currentTimeMillis() - l);
                    map = this.\u0399;
                    synchronized (map) {
                        this.\u0399.put("af_deeplink_r", hashMap);
                        this.\u0399.put("af_deeplink", this.\u0269.toString());
                    }
                    AppsFlyerLibCore.getInstance().handleDeepLinkCallback(this.\u03b9, this.\u0399, string != null ? Uri.parse((String)string) : this.\u0269);
                    \u01c3 = false;
                }

                private static Map<String, Object> \u0269(Uri uri) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    try {
                        AFLogger.afDebugLog("ESP deeplink resolving is started: " + uri.toString());
                        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(uri.toString()).openConnection();
                        httpURLConnection.setInstanceFollowRedirects(false);
                        httpURLConnection.setReadTimeout(\u03b9);
                        httpURLConnection.setConnectTimeout(\u03b9);
                        httpURLConnection.setRequestProperty("User-agent", "Dalvik/2.1.0 (Linux; U; Android 6.0.1; Nexus 5 Build/M4B30Z)");
                        httpURLConnection.setRequestProperty("af-esp", "5.4.4");
                        int n2 = httpURLConnection.getResponseCode();
                        ((AbstractMap)hashMap).put("status", n2);
                        if (300 <= n2 && n2 <= 305) {
                            ((AbstractMap)hashMap).put("res", httpURLConnection.getHeaderField("Location"));
                        }
                        httpURLConnection.disconnect();
                        AFLogger.afDebugLog("ESP deeplink resolving is finished");
                    }
                    catch (Throwable throwable) {
                        ((AbstractMap)hashMap).put("error", throwable.getLocalizedMessage());
                        AFLogger.afErrorLog(throwable.getMessage(), throwable);
                    }
                    return hashMap;
                }
            });
        } else {
            AppsFlyerLibCore.getInstance().handleDeepLinkCallback(context, map, uri);
        }
        trampolineUri = null;
    }

    final void \u0269(Intent intent, Context context, Map<String, Object> map) {
        Intent intent2;
        String string = "af_consumed";
        Intent intent3 = intent;
        Uri uri = null;
        if (intent3 != null && "android.intent.action.VIEW".equals(intent3.getAction())) {
            uri = intent3.getData();
        }
        Uri uri2 = uri;
        intent3 = intent2 = AppsFlyerLibCore.getInstance().pluginDeeplinkIntent;
        uri = null;
        if (intent3 != null && "android.intent.action.VIEW".equals(intent3.getAction())) {
            uri = intent3.getData();
        }
        Uri uri3 = uri;
        if (uri2 != null) {
            if (!intent.hasExtra(string)) {
                intent.putExtra(string, System.currentTimeMillis());
                AFDeepLinkManager.\u01c3(context, map, uri2);
                return;
            }
            AFLogger.afInfoLog("skipping re-use of previously consumed deep link: " + uri2.toString() + " w/af_consumed");
            return;
        }
        if (trampolineUri != null) {
            AFLogger.afInfoLog("using trampoline Intent fallback with URI: " + trampolineUri);
            AFDeepLinkManager.\u01c3(context, map, trampolineUri);
            return;
        }
        if (uri3 != null) {
            if (!intent2.hasExtra(string)) {
                intent2.putExtra(string, System.currentTimeMillis());
                AFLogger.afInfoLog("using Plugin Intent fallback with URI: " + uri3.toString());
                AFDeepLinkManager.\u01c3(context, map, uri3);
                return;
            }
            AFLogger.afInfoLog("skipping re-use of previously consumed plugin deep link: " + uri3.toString() + " w/af_consumed");
            return;
        }
        AFLogger.afDebugLog("No deep link detected");
    }

    protected void collectIntentsFromActivities(Intent intent) {
        Intent intent2 = intent;
        Uri uri = null;
        if (intent2 != null && "android.intent.action.VIEW".equals(intent2.getAction())) {
            uri = intent2.getData();
        }
        if (uri != null && intent.getData() != trampolineUri) {
            trampolineUri = intent.getData();
        }
    }
}

