/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.VisibleForTesting;
import com.appsflyer.AFExecutor;
import com.appsflyer.AFLogger;
import com.appsflyer.AppsFlyerLibCore;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class AFDeepLinkManager {
    static final int \u0131 = (int)TimeUnit.SECONDS.toMillis(2L);
    static volatile boolean \u01c3;
    static String[] \u03b9;
    public static String[] \u0269;
    @VisibleForTesting
    public static AFDeepLinkManager instance;
    @VisibleForTesting
    public static Uri trampolineUri;

    private AFDeepLinkManager() {
    }

    public static AFDeepLinkManager getInstance() {
        if (instance == null) {
            instance = new AFDeepLinkManager();
        }
        return instance;
    }

    private static boolean \u03b9(String string) {
        if (\u03b9 == null) {
            return false;
        }
        if (string.contains("af_tranid=")) {
            return false;
        }
        AFLogger.afRDLog("Validate ESP URLs :" + Arrays.asList(\u03b9));
        String[] stringArray = \u03b9;
        int n = \u03b9.length;
        for (int k = 0; k < n; ++k) {
            String string2 = stringArray[k];
            if (!string.contains("://".concat(String.valueOf(string2)))) continue;
            AFLogger.afRDLog("Deeplink matches ESP domain: ".concat(String.valueOf(string2)));
            return true;
        }
        return false;
    }

    static void \u03b9(Context context, Map<String, Object> map, Uri uri) {
        if (AFDeepLinkManager.\u03b9(uri.toString())) {
            \u01c3 = true;
            AFExecutor aFExecutor = AFExecutor.getInstance();
            if (aFExecutor.\u03b9 == null) {
                aFExecutor.\u03b9 = Executors.newSingleThreadScheduledExecutor(aFExecutor.\u0131);
            }
            aFExecutor.\u03b9.execute(new Runnable(uri, map, context){
                private /* synthetic */ Uri \u0269;
                private /* synthetic */ Map \u0399;
                private /* synthetic */ Context \u0131;
                {
                    this.\u0269 = uri;
                    this.\u0399 = map;
                    this.\u0131 = context;
                }

                @Override
                public final void run() {
                    long l2;
                    Object object;
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    long l3 = System.currentTimeMillis();
                    Object object2 = null;
                    try {
                        AFLogger.afDebugLog("ESP deeplink resolving is started: " + this.\u0269.toString());
                        object = (HttpURLConnection)new URL(this.\u0269.toString()).openConnection();
                        ((HttpURLConnection)object).setInstanceFollowRedirects(false);
                        ((URLConnection)object).setReadTimeout(\u0131);
                        ((URLConnection)object).setConnectTimeout(\u0131);
                        ((URLConnection)object).setRequestProperty("User-agent", "Dalvik/2.1.0 (Linux; U; Android 6.0.1; Nexus 5 Build/M4B30Z)");
                        ((URLConnection)object).setRequestProperty("af-esp", "5.4.3");
                        ((URLConnection)object).connect();
                        AFLogger.afDebugLog("ESP deeplink resolving is finished");
                        hashMap.put("status", String.valueOf(((HttpURLConnection)object).getResponseCode()));
                        if (((HttpURLConnection)object).getResponseCode() >= 300 && ((HttpURLConnection)object).getResponseCode() <= 305) {
                            object2 = Uri.parse((String)((URLConnection)object).getHeaderField("Location"));
                        }
                        l2 = System.currentTimeMillis() - l3;
                        ((HttpURLConnection)object).disconnect();
                    }
                    catch (Throwable throwable) {
                        hashMap.put("error", throwable.getLocalizedMessage());
                        hashMap.put("status", "-1");
                        l2 = System.currentTimeMillis() - l3;
                        AFLogger.afErrorLog(throwable.getMessage(), throwable);
                    }
                    hashMap.put("latency", Long.toString(l2));
                    if (object2 != null) {
                        hashMap.put("res", object2.toString());
                    } else {
                        hashMap.put("res", "");
                    }
                    object = this.\u0399;
                    synchronized (object) {
                        this.\u0399.put("af_deeplink_r", hashMap);
                        this.\u0399.put("af_deeplink", this.\u0269.toString());
                    }
                    \u01c3 = false;
                    object = object2 != null ? object2 : this.\u0269;
                    AppsFlyerLibCore.getInstance().handleDeepLinkCallback(this.\u0131, this.\u0399, (Uri)object);
                }
            });
        } else {
            AppsFlyerLibCore.getInstance().handleDeepLinkCallback(context, map, uri);
        }
        trampolineUri = null;
    }

    static void \u01c3(Intent intent, Context context, Map<String, Object> map) {
        Intent intent2;
        String string = "af_consumed";
        Intent intent3 = intent;
        Uri uri = null;
        if (intent3 != null && "android.intent.action.VIEW".equals(intent3.getAction())) {
            uri = intent3.getData();
        }
        Uri uri2 = uri;
        intent3 = intent2 = AppsFlyerLibCore.getInstance().pluginDeeplinkIntent;
        uri = null;
        if (intent3 != null && "android.intent.action.VIEW".equals(intent3.getAction())) {
            uri = intent3.getData();
        }
        Uri uri3 = uri;
        if (uri2 != null) {
            if (!intent.hasExtra(string)) {
                intent.putExtra(string, System.currentTimeMillis());
                AFDeepLinkManager.\u03b9(context, map, uri2);
                return;
            }
            AFLogger.afInfoLog("skipping re-use of previously consumed deep link: " + uri2.toString() + " w/af_consumed");
            return;
        }
        if (trampolineUri != null) {
            AFLogger.afInfoLog("using trampoline Intent fallback with URI: " + trampolineUri);
            AFDeepLinkManager.\u03b9(context, map, trampolineUri);
            return;
        }
        if (uri3 != null) {
            if (!intent2.hasExtra(string)) {
                intent2.putExtra(string, System.currentTimeMillis());
                AFLogger.afInfoLog("using Plugin Intent fallback with URI: " + uri3.toString());
                AFDeepLinkManager.\u03b9(context, map, uri3);
                return;
            }
            AFLogger.afInfoLog("skipping re-use of previously consumed plugin deep link: " + uri3.toString() + " w/af_consumed");
            return;
        }
        AFLogger.afDebugLog("No deep link detected");
    }

    protected void collectIntentsFromActivities(Intent intent) {
        Intent intent2 = intent;
        Uri uri = null;
        if (intent2 != null && "android.intent.action.VIEW".equals(intent2.getAction())) {
            uri = intent2.getData();
        }
        if (uri != null && intent.getData() != trampolineUri) {
            trampolineUri = intent.getData();
        }
    }
}

