/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.VisibleForTesting;
import com.appsflyer.AFExecutor;
import com.appsflyer.AFLogger;
import com.appsflyer.AppsFlyerLibCore;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class AFDeepLinkManager {
    static final int \u0399 = (int)TimeUnit.SECONDS.toMillis(2L);
    static volatile boolean \u0269;
    static String[] \u01c3;
    public static String[] \u0131;
    @VisibleForTesting
    public static AFDeepLinkManager instance;
    @VisibleForTesting
    public static Uri trampolineUri;

    private AFDeepLinkManager() {
    }

    public static AFDeepLinkManager getInstance() {
        if (instance == null) {
            instance = new AFDeepLinkManager();
        }
        return instance;
    }

    private static boolean \u01c3(String string) {
        if (\u01c3 == null) {
            return false;
        }
        if (string.contains("af_tranid=")) {
            return false;
        }
        AFLogger.afRDLog("Validate ESP URLs :" + Arrays.asList(\u01c3));
        String[] stringArray = \u01c3;
        int n2 = \u01c3.length;
        for (int i = 0; i < n2; ++i) {
            String string2 = stringArray[i];
            if (!string.contains("://".concat(String.valueOf(string2)))) continue;
            AFLogger.afRDLog("Deeplink matches ESP domain: ".concat(String.valueOf(string2)));
            return true;
        }
        return false;
    }

    static void \u0399(Context context, Map<String, Object> map, Uri uri) {
        if (AFDeepLinkManager.\u01c3(uri.toString())) {
            \u0269 = true;
            AFExecutor aFExecutor = AFExecutor.getInstance();
            if (aFExecutor.\u01c3 == null) {
                aFExecutor.\u01c3 = Executors.newSingleThreadScheduledExecutor(aFExecutor.\u0131);
            }
            aFExecutor.\u01c3.execute(new Runnable(uri, map, context){
                private /* synthetic */ Uri \u0399;
                private /* synthetic */ Map \u0269;
                private /* synthetic */ Context \u01c3;
                {
                    this.\u0399 = uri;
                    this.\u0269 = map;
                    this.\u01c3 = context;
                }

                @Override
                public final void run() {
                    long l;
                    Object object;
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    long l2 = System.currentTimeMillis();
                    Object object2 = null;
                    try {
                        AFLogger.afDebugLog("ESP deeplink resolving is started: " + this.\u0399.toString());
                        object = (HttpURLConnection)new URL(this.\u0399.toString()).openConnection();
                        ((HttpURLConnection)object).setInstanceFollowRedirects(false);
                        ((URLConnection)object).setReadTimeout(\u0399);
                        ((URLConnection)object).setConnectTimeout(\u0399);
                        ((URLConnection)object).setRequestProperty("User-agent", "Dalvik/2.1.0 (Linux; U; Android 6.0.1; Nexus 5 Build/M4B30Z)");
                        ((URLConnection)object).connect();
                        AFLogger.afDebugLog("ESP deeplink resolving is finished");
                        hashMap.put("status", String.valueOf(((HttpURLConnection)object).getResponseCode()));
                        if (((HttpURLConnection)object).getResponseCode() >= 300 && ((HttpURLConnection)object).getResponseCode() <= 305) {
                            object2 = Uri.parse((String)((URLConnection)object).getHeaderField("Location"));
                        }
                        l = System.currentTimeMillis() - l2;
                        ((HttpURLConnection)object).disconnect();
                    }
                    catch (Throwable throwable) {
                        hashMap.put("error", throwable.getLocalizedMessage());
                        hashMap.put("status", "-1");
                        l = System.currentTimeMillis() - l2;
                        AFLogger.afErrorLog(throwable.getMessage(), throwable);
                    }
                    hashMap.put("latency", Long.toString(l));
                    if (object2 != null) {
                        hashMap.put("res", object2.toString());
                    } else {
                        hashMap.put("res", "");
                    }
                    object = this.\u0269;
                    synchronized (object) {
                        this.\u0269.put("af_deeplink_r", hashMap);
                        this.\u0269.put("af_deeplink", this.\u0399.toString());
                    }
                    \u0269 = false;
                    object = object2 != null ? object2 : this.\u0399;
                    AppsFlyerLibCore.getInstance().handleDeepLinkCallback(this.\u01c3, this.\u0269, (Uri)object);
                }
            });
        } else {
            AppsFlyerLibCore.getInstance().handleDeepLinkCallback(context, map, uri);
        }
        trampolineUri = null;
    }

    static void \u0269(Intent intent, Context context, Map<String, Object> map) {
        Uri uri;
        Intent intent2 = intent;
        Uri uri2 = null;
        if (intent2 != null && "android.intent.action.VIEW".equals(intent2.getAction())) {
            uri2 = intent2.getData();
        }
        if ((uri = uri2) != null) {
            if (!intent.hasExtra("af_consumed")) {
                intent.putExtra("af_consumed", System.currentTimeMillis());
                AFDeepLinkManager.\u0399(context, map, uri);
                return;
            }
            AFLogger.afInfoLog("skipping re-use of previously consumed deep link: " + uri.toString() + " w/af_consumed");
            return;
        }
        if (trampolineUri != null) {
            AFLogger.afInfoLog("using trampoline Intent fallback with URI: " + trampolineUri);
            AFDeepLinkManager.\u0399(context, map, trampolineUri);
            return;
        }
        if (AppsFlyerLibCore.getInstance().latestDeepLink != null) {
            AFLogger.afInfoLog("using Unity/plugin Intent fallback with URI: " + AppsFlyerLibCore.getInstance().latestDeepLink.toString());
            AFDeepLinkManager.\u0399(context, map, AppsFlyerLibCore.getInstance().latestDeepLink);
            return;
        }
        AFLogger.afDebugLog("No deep link detected");
    }

    protected void collectIntentsFromActivities(Intent intent) {
        Intent intent2 = intent;
        Uri uri = null;
        if (intent2 != null && "android.intent.action.VIEW".equals(intent2.getAction())) {
            uri = intent2.getData();
        }
        if (uri != null && intent.getData() != trampolineUri) {
            trampolineUri = intent.getData();
        }
    }
}

