/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.os.SystemClock;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class EventDataCollector {
    private final Context \u0131;

    public EventDataCollector(Context context) {
        this.\u0131 = context;
    }

    public String signature() throws CertificateException, NoSuchAlgorithmException, PackageManager.NameNotFoundException {
        Signature[] signatureArray = this.\u0131.getPackageManager().getPackageInfo((String)this.\u0131.getPackageName(), (int)64).signatures;
        X509Certificate x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(signatureArray[0].toByteArray()));
        MessageDigest messageDigest = MessageDigest.getInstance("SHA256");
        messageDigest.update(x509Certificate.getEncoded());
        return String.format("%032X", new BigInteger(1, messageDigest.digest()));
    }

    public long bootTime() {
        return System.currentTimeMillis() - SystemClock.elapsedRealtime();
    }

    public String disk() {
        long l;
        long l2;
        StatFs statFs = new StatFs(Environment.getDataDirectory().getAbsolutePath());
        if (Build.VERSION.SDK_INT >= 18) {
            long l3 = statFs.getBlockSizeLong();
            l2 = statFs.getAvailableBlocksLong() * l3;
            l = statFs.getBlockCountLong() * l3;
        } else {
            int n2 = statFs.getBlockSize();
            l2 = statFs.getAvailableBlocks() * n2;
            l = statFs.getBlockCount() * n2;
        }
        double d2 = Math.pow(2.0, 20.0);
        l2 = (long)((double)l2 / d2);
        l = (long)((double)l / d2);
        return l2 + "/" + l;
    }
}

