/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.appsflyer.AFExecutor;
import com.appsflyer.AFLogger;
import com.appsflyer.AppsFlyerLibCore;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class AFDeepLinkManager {
    static final int \u03b9 = (int)TimeUnit.SECONDS.toMillis(2L);
    static volatile boolean \u01c3;
    static String[] \u0399;
    public static String[] \u0269;
    @VisibleForTesting
    public static AFDeepLinkManager instance;
    @VisibleForTesting
    public static Uri trampolineUri;

    private AFDeepLinkManager() {
    }

    static AFDeepLinkManager \u0269() {
        if (instance == null) {
            instance = new AFDeepLinkManager();
        }
        return instance;
    }

    private static boolean \u0399(String string) {
        if (\u0399 == null) {
            return false;
        }
        if (string.contains("af_tranid=")) {
            return false;
        }
        AFLogger.afRDLog("Validate ESP URLs :" + Arrays.asList(\u0399));
        String[] stringArray = \u0399;
        int n2 = \u0399.length;
        for (int j = 0; j < n2; ++j) {
            String string2 = stringArray[j];
            if (!string.contains("://".concat(String.valueOf(string2)))) continue;
            AFLogger.afRDLog("Deeplink matches ESP domain: ".concat(String.valueOf(string2)));
            return true;
        }
        return false;
    }

    private static void \u01c3(Context context, Map<String, Object> map, Uri uri) {
        if (AFDeepLinkManager.\u0399(uri.toString())) {
            \u01c3 = true;
            AFExecutor aFExecutor = AFExecutor.getInstance();
            if (aFExecutor.\u0269 == null) {
                aFExecutor.\u0269 = Executors.newSingleThreadScheduledExecutor(aFExecutor.\u01c3);
            }
            aFExecutor.\u0269.execute(new Runnable(uri, map, context){
                private /* synthetic */ Uri \u0269;
                private /* synthetic */ Map \u01c3;
                private /* synthetic */ Context \u03b9;
                {
                    this.\u0269 = uri;
                    this.\u01c3 = map;
                    this.\u03b9 = context;
                }

                @Override
                public final void run() {
                    long l;
                    Object object;
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    long l2 = System.currentTimeMillis();
                    Object object2 = null;
                    try {
                        AFLogger.afDebugLog("ESP deeplink resolving is started: " + this.\u0269.toString());
                        object = (HttpURLConnection)new URL(this.\u0269.toString()).openConnection();
                        ((HttpURLConnection)object).setInstanceFollowRedirects(false);
                        ((URLConnection)object).setReadTimeout(\u03b9);
                        ((URLConnection)object).setConnectTimeout(\u03b9);
                        ((URLConnection)object).setRequestProperty("User-agent", "Dalvik/2.1.0 (Linux; U; Android 6.0.1; Nexus 5 Build/M4B30Z)");
                        ((URLConnection)object).connect();
                        AFLogger.afDebugLog("ESP deeplink resolving is finished");
                        hashMap.put("status", String.valueOf(((HttpURLConnection)object).getResponseCode()));
                        if (((HttpURLConnection)object).getResponseCode() >= 300 && ((HttpURLConnection)object).getResponseCode() <= 305) {
                            object2 = Uri.parse((String)((URLConnection)object).getHeaderField("Location"));
                        }
                        l = System.currentTimeMillis() - l2;
                        ((HttpURLConnection)object).disconnect();
                    }
                    catch (Throwable throwable) {
                        hashMap.put("error", throwable.getLocalizedMessage());
                        hashMap.put("status", "-1");
                        l = System.currentTimeMillis() - l2;
                        AFLogger.afErrorLog(throwable.getMessage(), throwable);
                    }
                    hashMap.put("latency", Long.toString(l));
                    if (object2 != null) {
                        hashMap.put("res", object2.toString());
                    } else {
                        hashMap.put("res", "");
                    }
                    object = this.\u01c3;
                    synchronized (object) {
                        this.\u01c3.put("af_deeplink_r", hashMap);
                        this.\u01c3.put("af_deeplink", this.\u0269.toString());
                    }
                    \u01c3 = false;
                    object = object2 != null ? object2 : this.\u0269;
                    AppsFlyerLibCore.getInstance().handleDeepLinkCallback(this.\u03b9, this.\u01c3, (Uri)object);
                }

                static Map<String, String> \u03b9(@NonNull Context context) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    try {
                        DisplayMetrics displayMetrics = new DisplayMetrics();
                        ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
                        int n2 = context.getResources().getConfiguration().screenLayout & 0xF;
                        hashMap.put("x_px", String.valueOf(displayMetrics.widthPixels));
                        hashMap.put("y_px", String.valueOf(displayMetrics.heightPixels));
                        hashMap.put("d_dpi", String.valueOf(displayMetrics.densityDpi));
                        hashMap.put("size", String.valueOf(n2));
                        hashMap.put("xdp", String.valueOf(displayMetrics.xdpi));
                        hashMap.put("ydp", String.valueOf(displayMetrics.ydpi));
                    }
                    catch (Throwable throwable) {
                        AFLogger.afErrorLog("Couldn't aggregate screen stats: ", throwable);
                    }
                    return hashMap;
                }
            });
        } else {
            AppsFlyerLibCore.getInstance().handleDeepLinkCallback(context, map, uri);
        }
        trampolineUri = null;
    }

    static void \u03b9(Intent intent, Context context, Map<String, Object> map) {
        Uri uri;
        Intent intent2 = intent;
        Uri uri2 = null;
        if (intent2 != null && "android.intent.action.VIEW".equals(intent2.getAction())) {
            uri2 = intent2.getData();
        }
        if ((uri = uri2) != null) {
            if (!intent.hasExtra("af_consumed")) {
                intent.putExtra("af_consumed", System.currentTimeMillis());
                AFDeepLinkManager.\u01c3(context, map, uri);
                return;
            }
            AFLogger.afInfoLog("skipping re-use of previously consumed deep link: " + uri.toString() + " w/af_consumed");
            return;
        }
        if (trampolineUri != null) {
            AFLogger.afInfoLog("using trampoline Intent fallback with URI: " + trampolineUri);
            AFDeepLinkManager.\u01c3(context, map, trampolineUri);
            return;
        }
        if (AppsFlyerLibCore.getInstance().latestDeepLink != null) {
            AFLogger.afInfoLog("using Unity/plugin Intent fallback with URI: " + AppsFlyerLibCore.getInstance().latestDeepLink.toString());
            AFDeepLinkManager.\u01c3(context, map, AppsFlyerLibCore.getInstance().latestDeepLink);
            return;
        }
        AFLogger.afDebugLog("No deep link detected");
    }

    protected void collectIntentsFromActivities(Intent intent) {
        Intent intent2 = intent;
        Uri uri = null;
        if (intent2 != null && "android.intent.action.VIEW".equals(intent2.getAction())) {
            uri = intent2.getData();
        }
        if (uri != null && intent.getData() != trampolineUri) {
            trampolineUri = intent.getData();
        }
    }
}

