/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.share;

import android.content.Context;
import com.appsflyer.AFLogger;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.CreateOneLinkHttpTask;
import com.appsflyer.ServerConfigHandler;
import com.appsflyer.share.ShareInviteHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class LinkGenerator {
    private String channel;
    private String campaign;
    private String mediaSource;
    private String referrerUID;
    private String referrerCustomerId;
    private String referrerName;
    private String referrerImageURL;
    private String baseURL;
    private String appPackage;
    private String deeplinkPath;
    private String baseDeeplink;
    private Map<String, String> parameters = new HashMap<String, String>();
    private Map<String, String> linkGeneratorParameters = new HashMap<String, String>();

    /*
     * WARNING - void declaration
     */
    public LinkGenerator(String mediaSource) {
        void var1_1;
        this.mediaSource = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    LinkGenerator setAppPackage(String appPackage) {
        void var1_1;
        this.appPackage = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public LinkGenerator setDeeplinkPath(String deeplinkPath) {
        void var1_1;
        this.deeplinkPath = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public LinkGenerator setBaseDeeplink(String baseDeeplink) {
        void var1_1;
        this.baseDeeplink = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    LinkGenerator setBaseURL(String baseURL) {
        void var1_1;
        this.baseURL = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public LinkGenerator setChannel(String channel) {
        void var1_1;
        this.channel = var1_1;
        return this;
    }

    public String getChannel() {
        return this.channel;
    }

    /*
     * WARNING - void declaration
     */
    public LinkGenerator setReferrerCustomerId(String referrerCustomerId) {
        void var1_1;
        this.referrerCustomerId = var1_1;
        return this;
    }

    public String getMediaSource() {
        return this.mediaSource;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    /*
     * WARNING - void declaration
     */
    public LinkGenerator setCampaign(String campaign) {
        void var1_1;
        this.campaign = var1_1;
        return this;
    }

    public String getCampaign() {
        return this.campaign;
    }

    /*
     * WARNING - void declaration
     */
    public LinkGenerator addParameter(String key, String value) {
        void var2_2;
        void var1_1;
        this.parameters.put((String)var1_1, (String)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public LinkGenerator addParameters(Map<String, String> parameters) {
        if (parameters != null) {
            void var1_1;
            this.parameters.putAll((Map<String, String>)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public LinkGenerator setReferrerUID(String referrerUID) {
        void var1_1;
        this.referrerUID = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public LinkGenerator setReferrerName(String referrerName) {
        void var1_1;
        this.referrerName = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public LinkGenerator setReferrerImageURL(String referrerImageURL) {
        void var1_1;
        this.referrerImageURL = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public LinkGenerator setBaseURL(String onelinkID, String domain, String appPackage) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.baseURL = onelinkID == null || onelinkID.length() <= 0 ? String.format("https://%s/%s", ServerConfigHandler.getUrl("app.%s"), var3_3) : this.buildOneLinkBaseUrl((String)var1_1, (String)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private String buildOneLinkBaseUrl(String onelinkID, String domain) {
        void var1_1;
        void var2_2;
        if (domain == null || domain.length() < 5) {
            domain = "go.onelink.me";
        }
        return String.format("https://%s/%s", var2_2, var1_1);
    }

    private StringBuilder generateBaseURL() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.baseURL != null && this.baseURL.startsWith("http")) {
            stringBuilder.append(this.baseURL);
        } else {
            stringBuilder.append(ServerConfigHandler.getUrl("https://app.%s"));
        }
        if (this.appPackage != null) {
            stringBuilder.append('/').append(this.appPackage);
        }
        this.linkGeneratorParameters.put("pid", this.mediaSource);
        stringBuilder.append('?').append("pid=").append(this.getEncodedValue(this.mediaSource, "media source"));
        if (this.referrerUID != null) {
            this.linkGeneratorParameters.put("af_referrer_uid", this.referrerUID);
            stringBuilder.append('&').append("af_referrer_uid=").append(this.getEncodedValue(this.referrerUID, "referrerUID"));
        }
        if (this.channel != null) {
            this.linkGeneratorParameters.put("af_channel", this.channel);
            stringBuilder.append('&').append("af_channel=").append(this.getEncodedValue(this.channel, "channel"));
        }
        if (this.referrerCustomerId != null) {
            this.linkGeneratorParameters.put("af_referrer_customer_id", this.referrerCustomerId);
            stringBuilder.append('&').append("af_referrer_customer_id=").append(this.getEncodedValue(this.referrerCustomerId, "referrerCustomerId"));
        }
        if (this.campaign != null) {
            this.linkGeneratorParameters.put("c", this.campaign);
            stringBuilder.append('&').append("c=").append(this.getEncodedValue(this.campaign, "campaign"));
        }
        if (this.referrerName != null) {
            this.linkGeneratorParameters.put("af_referrer_name", this.referrerName);
            stringBuilder.append('&').append("af_referrer_name=").append(this.getEncodedValue(this.referrerName, "referrerName"));
        }
        if (this.referrerImageURL != null) {
            this.linkGeneratorParameters.put("af_referrer_image_url", this.referrerImageURL);
            stringBuilder.append('&').append("af_referrer_image_url=").append(this.getEncodedValue(this.referrerImageURL, "referrerImageURL"));
        }
        if (this.baseDeeplink != null) {
            StringBuilder stringBuilder2 = new StringBuilder().append(this.baseDeeplink);
            if (this.deeplinkPath != null && !this.baseDeeplink.endsWith("/")) {
                stringBuilder2.append(this.baseDeeplink.endsWith("/") ? "" : "/").append(this.deeplinkPath);
            }
            this.linkGeneratorParameters.put("af_dp", stringBuilder2.toString());
            stringBuilder.append('&').append("af_dp=").append(this.getEncodedValue(this.baseDeeplink, "baseDeeplink"));
            if (this.deeplinkPath != null) {
                stringBuilder.append(this.baseDeeplink.endsWith("/") ? "" : "%2F").append(this.getEncodedValue(this.deeplinkPath, "deeplinkPath"));
            }
        }
        for (String string : this.parameters.keySet()) {
            if (stringBuilder.toString().contains(string + "=" + this.getEncodedValue(this.parameters.get(string), string))) continue;
            stringBuilder.append('&').append(string).append('=').append(this.getEncodedValue(this.parameters.get(string), string));
        }
        return stringBuilder;
    }

    /*
     * WARNING - void declaration
     */
    private String getEncodedValue(String s2, String name) {
        try {
            return URLEncoder.encode(s2, "utf8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            void var1_1;
            void var2_2;
            AFLogger.afInfoLog("Illegal " + (String)var2_2 + ": " + (String)var1_1);
            return "";
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public String generateLink() {
        return this.generateBaseURL().toString();
    }

    /*
     * WARNING - void declaration
     */
    public void generateLink(Context context, CreateOneLinkHttpTask.ResponseListener listener) {
        void var2_2;
        void var1_1;
        String string = AppsFlyerProperties.getInstance().getString("oneLinkSlug");
        this.generateBaseURL();
        ShareInviteHelper.generateUserInviteLink((Context)var1_1, string, this.linkGeneratorParameters, (CreateOneLinkHttpTask.ResponseListener)var2_2);
    }
}

