/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import com.appsflyer.AFLogger;
import com.appsflyer.AFUninstallToken;
import com.appsflyer.AndroidUtils;
import com.appsflyer.AppsFlyerLib;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.FirebaseInstanceIdListener;
import com.appsflyer.GcmInstanceIdListener;
import com.google.android.gms.iid.InstanceIDListenerService;
import com.google.firebase.iid.FirebaseInstanceIdService;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;

class UninstallUtils {
    private static final String GCM_INSTANCE_ID_INTENT_FILTER_ACTION = "com.google.android.gms.iid.InstanceID";
    private static final String FIREBASE_INSTANCE_ID_INTENT_FILTER_ACTION = "com.google.firebase.INSTANCE_ID_EVENT";
    private static final String PERMISSION_C2_D_MESSAGE = ".permission.C2D_MESSAGE";
    private static final String GCM_RECEIVER = "com.google.android.gms.gcm.GcmReceiver";
    private static final String GCM_RECEIVER_INTENT_FILTER_ACTION = "com.google.android.c2dm.intent.RECEIVE";

    UninstallUtils() {
    }

    static boolean didConfigureTokenRefreshService(Context context) {
        boolean result = UninstallUtils.didConfigureGcmTokenRefreshService(context);
        return result |= UninstallUtils.didConfigureFirebaseTokenRefreshService(context);
    }

    private static boolean didConfigureGcmTokenRefreshService(Context context) {
        try {
            Intent afGcmInstanceIdServiceIntent = new Intent(GCM_INSTANCE_ID_INTENT_FILTER_ACTION, null, context, GcmInstanceIdListener.class);
            Intent gcmInstanceIdServiceIntent = new Intent(GCM_INSTANCE_ID_INTENT_FILTER_ACTION, null, context, InstanceIDListenerService.class);
            if (AndroidUtils.isServiceAvailable(context, afGcmInstanceIdServiceIntent) || AndroidUtils.isServiceAvailable(context, gcmInstanceIdServiceIntent)) {
                Intent gcmReceiverIntent = new Intent(GCM_RECEIVER_INTENT_FILTER_ACTION, null, context, Class.forName(GCM_RECEIVER));
                if (AndroidUtils.isReceiverAvailable(context, gcmReceiverIntent)) {
                    String packageName = context.getPackageName();
                    if (AndroidUtils.isPermissionAvailable(context, packageName + PERMISSION_C2_D_MESSAGE)) {
                        return true;
                    }
                    AFLogger.afWarnLog("Cannot verify existence of the app's \"permission.C2D_MESSAGE\" permission in the manifest. Please refer to documentation.");
                } else {
                    AFLogger.afWarnLog("Cannot verify existence of GcmReceiver receiver in the manifest. Please refer to documentation.");
                }
            }
        }
        catch (Throwable e) {
            AFLogger.afLogE("An error occurred while trying to verify manifest declarations: ", e);
        }
        return false;
    }

    private static boolean didConfigureFirebaseTokenRefreshService(Context context) {
        try {
            Intent afFirebaseInstanceIdServiceIntent = new Intent(FIREBASE_INSTANCE_ID_INTENT_FILTER_ACTION, null, context, FirebaseInstanceIdListener.class);
            Intent firebaseInstanceIdServiceIntent = new Intent(FIREBASE_INSTANCE_ID_INTENT_FILTER_ACTION, null, context, FirebaseInstanceIdService.class);
            if (AndroidUtils.isServiceAvailable(context, afFirebaseInstanceIdServiceIntent) || AndroidUtils.isServiceAvailable(context, firebaseInstanceIdServiceIntent)) {
                return true;
            }
            AFLogger.afWarnLog("Cannot verify existence of our InstanceID Listener Service in the manifest. Please refer to documentation.");
        }
        catch (Throwable e) {
            AFLogger.afLogE("An error occurred while trying to verify manifest declarations: ", e);
        }
        return false;
    }

    private static AFUninstallToken getGCMToken(WeakReference<Context> context, String gcmProjectNumber) {
        try {
            Class<?> gcmInstanceId = Class.forName(GCM_INSTANCE_ID_INTENT_FILTER_ACTION);
            Class.forName(GCM_RECEIVER);
            Method getInstance = gcmInstanceId.getDeclaredMethod("getInstance", Context.class);
            Object instance = getInstance.invoke(gcmInstanceId, context.get());
            Method getToken = gcmInstanceId.getDeclaredMethod("getToken", String.class, String.class);
            String token = (String)getToken.invoke(instance, gcmProjectNumber, "GCM");
            if (token == null) {
                AFLogger.afWarnLog("Couldn't get token using reflection.");
                return null;
            }
            return new AFUninstallToken(System.currentTimeMillis(), token);
        }
        catch (ClassNotFoundException gcmInstanceId) {
        }
        catch (Throwable t) {
            AFLogger.afLogE("Couldn't get token using GoogleCloudMessaging. ", t);
        }
        return null;
    }

    static void registerDeviceForUninstalls(final WeakReference<Context> weakContext) {
        new AsyncTask<Void, Void, AFUninstallToken>(){
            String gcmProjectNumber;

            protected void onPreExecute() {
                super.onPreExecute();
                this.gcmProjectNumber = AppsFlyerProperties.getInstance().getString("gcmProjectNumber");
            }

            protected AFUninstallToken doInBackground(Void ... params) {
                try {
                    AFUninstallToken uninstallToken = null;
                    if (this.gcmProjectNumber != null) {
                        uninstallToken = UninstallUtils.getGCMToken(weakContext, this.gcmProjectNumber);
                    }
                    return uninstallToken;
                }
                catch (Throwable t) {
                    AFLogger.afLogE("Error registering for uninstall feature", t);
                    return null;
                }
            }

            protected void onPostExecute(AFUninstallToken newAFUninstallToken) {
                if (newAFUninstallToken != null && newAFUninstallToken.getToken() != null) {
                    String tokenObjectString = AppsFlyerProperties.getInstance().getString("afUninstallToken");
                    if (tokenObjectString == null) {
                        UninstallUtils.updateServerUninstallToken((Context)weakContext.get(), newAFUninstallToken);
                    } else {
                        boolean shouldUpdateServerWithNewToken;
                        AFUninstallToken existingAFUninstallToken = AFUninstallToken.parse(tokenObjectString);
                        if (existingAFUninstallToken != null && (shouldUpdateServerWithNewToken = existingAFUninstallToken.testAndUpdate(newAFUninstallToken))) {
                            UninstallUtils.updateServerUninstallToken((Context)weakContext.get(), existingAFUninstallToken);
                        }
                    }
                }
            }
        }.execute((Object[])new Void[0]);
    }

    static void updateServerUninstallToken(Context context, AFUninstallToken token) {
        AFLogger.afLog("updateServerUninstallToken called with: " + token.toString());
        AppsFlyerProperties.getInstance().set("afUninstallToken", token.toString());
        AppsFlyerLib.getInstance().callRegisterBackground(context, token.getToken());
    }
}

