/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import com.appsflyer.AFLogger;
import com.appsflyer.AppsFlyerLib;
import com.appsflyer.AppsFlyerProperties;

public class SingleInstallBroadcastReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        if (intent == null) {
            return;
        }
        String newReferrer = intent.getStringExtra("referrer");
        if (newReferrer != null) {
            if (newReferrer.contains("AppsFlyer_Test") && intent.getStringExtra("TestIntegrationMode") != null) {
                AppsFlyerLib.getInstance().onReceive(context, intent);
                return;
            }
            SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
            if (sharedPreferences.getString("referrer", null) != null) {
                AppsFlyerLib.getInstance().addReferrer(context, newReferrer);
                return;
            }
        }
        String referrerTimestamp = AppsFlyerProperties.getInstance().getString("referrer_timestamp");
        long now = System.currentTimeMillis();
        if (referrerTimestamp != null && now - Long.valueOf(referrerTimestamp) < 2000L) {
            return;
        }
        AFLogger.afLog("SingleInstallBroadcastReceiver called");
        AppsFlyerLib.getInstance().onReceive(context, intent);
        AppsFlyerProperties.getInstance().set("referrer_timestamp", String.valueOf(System.currentTimeMillis()));
    }
}

