/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.pm.PackageManager;
import android.os.Build;
import com.appsflyer.AppsFlyerLib;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.BackgroundHttpTask;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class RemoteDebuggingManager {
    static final String REMOTE_DEBUGGING_SERVER_FLAG = "monitor";
    private static final int MONITORING_REQUEST_MAX_SIZE_KB = 98304;
    private static RemoteDebuggingManager instance;
    private static boolean shouldCollectPreLaunchDebugData;
    private static boolean shouldEnableRemoteDebuggingForThisApp;
    private final String DEVICE_DATA_BRAND = "brand";
    private final String DEVICE_DATA_MODEL = "model";
    private final String DEVICE_DATA_PLATFORM_NAME = "platform";
    private final String DEVICE_DATA_PLATFORM_VERSION = "platform_version";
    private final String DEVICE_DATA_GAID = "advertiserId";
    private final String DEVICE_DATA_IMEI = "imei";
    private final String DEVICE_DATA_ANDROID_ID = "android_id";
    private final String SDK_DATA_SDK_VERSION = "sdk_version";
    private final String SDK_DATA_DEV_KEY = "devkey";
    private final String SDK_DATA_ORIGINAL_AF_UID = "originalAppsFlyerId";
    private final String SDK_DATA_CURRENT_AF_UID = "uid";
    private final String APP_DATA_APP_ID = "app_id";
    private final String APP_DATA_APP_VERSION = "app_version";
    private final String APP_DATA_CHANNEL = "channel";
    private final String APP_DATA_PRE_INSTALL = "preInstall";
    private final String CHRONOLOGICAL_EVENTS_DATA = "data";
    private final String REMOTE_DEBUGGING_STOPPED = "r_debugging_off";
    private final String REMOTE_DEBUGGING_STARTED = "r_debugging_on";
    private final String PUBLIC_API_CALL = "public_api_call";
    private final String EXCEPTION = "exception";
    private final String SERVER_REQUEST = "server_request";
    private final String SERVER_RESPONSE = "server_response";
    private final String BQ_DATE_FORMAT = "yyyy-MM-dd HH:mm:ssZ";
    private final String EVENT_DATE_FORMAT = "MM-dd HH:mm:ss.SSS";
    private JSONObject remoteDebuggingJSON;
    private JSONArray chronologicalEvents = new JSONArray();
    private int requestSize = 0;
    private boolean remoteDebuggingEnabledFromServer = false;

    private RemoteDebuggingManager() {
    }

    static RemoteDebuggingManager getInstance() {
        if (instance == null) {
            instance = new RemoteDebuggingManager();
        }
        return instance;
    }

    synchronized void startRemoteDebuggingMode() {
        this.remoteDebuggingEnabledFromServer = true;
        this.addStartEvent(System.currentTimeMillis());
    }

    synchronized void stopRemoteDebuggingMode() {
        this.addStopEvent(System.currentTimeMillis());
        this.remoteDebuggingEnabledFromServer = false;
        shouldCollectPreLaunchDebugData = false;
    }

    synchronized void releaseRemoteDebugging() {
        this.remoteDebuggingJSON = null;
        this.chronologicalEvents = null;
        instance = null;
    }

    void sendRemoteDebuggingData(String packageName, PackageManager packageManager) {
        try {
            RemoteDebuggingManager.getInstance().loadStaticData(packageName, packageManager);
            String remoteDebuggingData = RemoteDebuggingManager.getInstance().getJSONString(true);
            BackgroundHttpTask remoteDebuggingTask = new BackgroundHttpTask(null);
            remoteDebuggingTask.bodyAsString = remoteDebuggingData;
            remoteDebuggingTask.setRemoteDebugMode(false);
            remoteDebuggingTask.execute(new String[]{"https://monitorsdk.appsflyer.com/remote-debug?app_id=" + packageName});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    boolean isRemoteDebugging() {
        return shouldEnableRemoteDebuggingForThisApp && (shouldCollectPreLaunchDebugData || this.remoteDebuggingEnabledFromServer);
    }

    private synchronized void setDeviceData(String brand, String model, String osVersion, String gaid, String imei, String androidId) {
        try {
            this.remoteDebuggingJSON.put("brand", (Object)brand);
            this.remoteDebuggingJSON.put("model", (Object)model);
            this.remoteDebuggingJSON.put("platform", (Object)"Android");
            this.remoteDebuggingJSON.put("platform_version", (Object)osVersion);
            if (gaid != null && gaid.length() > 0) {
                this.remoteDebuggingJSON.put("advertiserId", (Object)gaid);
            }
            if (imei != null && imei.length() > 0) {
                this.remoteDebuggingJSON.put("imei", (Object)imei);
            }
            if (androidId != null && androidId.length() > 0) {
                this.remoteDebuggingJSON.put("android_id", (Object)androidId);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private synchronized void setSDKData(String version, String devKey, String originalAFUID, String currentAFUID) {
        try {
            this.remoteDebuggingJSON.put("sdk_version", (Object)version);
            if (devKey != null && devKey.length() > 0) {
                this.remoteDebuggingJSON.put("devkey", (Object)devKey);
            }
            if (originalAFUID != null && originalAFUID.length() > 0) {
                this.remoteDebuggingJSON.put("originalAppsFlyerId", (Object)originalAFUID);
            }
            if (currentAFUID != null && currentAFUID.length() > 0) {
                this.remoteDebuggingJSON.put("uid", (Object)currentAFUID);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private synchronized void setAppData(String appId, String appVersion, String channel, String preInstall) {
        try {
            if (appId != null && appId.length() > 0) {
                this.remoteDebuggingJSON.put("app_id", (Object)appId);
            }
            if (appVersion != null && appVersion.length() > 0) {
                this.remoteDebuggingJSON.put("app_version", (Object)appVersion);
            }
            if (channel != null && channel.length() > 0) {
                this.remoteDebuggingJSON.put("channel", (Object)channel);
            }
            if (preInstall != null && preInstall.length() > 0) {
                this.remoteDebuggingJSON.put("preInstall", (Object)preInstall);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void addStartEvent(long startTime) {
        this.addEvent("r_debugging_on", new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ", Locale.ENGLISH).format(startTime), new String[0]);
    }

    private void addStopEvent(long endTime) {
        this.addEvent("r_debugging_off", new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ", Locale.ENGLISH).format(endTime), new String[0]);
    }

    void addApiEvent(String methodName, String ... args) {
        this.addEvent("public_api_call", methodName, args);
    }

    void addExceptionEvent(Throwable t) {
        Throwable cause = t.getCause();
        this.addEvent("exception", t.getClass().getSimpleName(), this.getThrowableStringData(cause == null ? t.getMessage() : cause.getMessage(), cause == null ? t.getStackTrace() : cause.getStackTrace()));
    }

    void addServerRequestEvent(String url, String requestBody) {
        this.addEvent("server_request", url, requestBody);
    }

    void addServerResponseEvent(String url, int responseCode, String responseBody) {
        this.addEvent("server_response", url, String.valueOf(responseCode), responseBody);
    }

    void addLogEntry(String type, String logMessage) {
        this.addEvent(null, type, logMessage);
    }

    private synchronized void addEvent(String eventType, String title, String ... body) {
        if (!this.isRemoteDebugging() || this.requestSize >= 98304) {
            return;
        }
        try {
            long now = System.currentTimeMillis();
            String bodyStr = "";
            if (body.length > 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = body.length - 1; i >= 1; --i) {
                    sb.append(body[i]).append(", ");
                }
                sb.append(body[0]);
                bodyStr = sb.toString();
            }
            String formattedTimestamp = new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.ENGLISH).format(now);
            String event = eventType != null ? String.format("%18s %5s _/%s [%s] %s %s", formattedTimestamp, Thread.currentThread().getId(), "AppsFlyer_4.7.1", eventType, title, bodyStr) : String.format("%18s %5s %s/%s %s", formattedTimestamp, Thread.currentThread().getId(), title, "AppsFlyer_4.7.1", bodyStr);
            this.chronologicalEvents.put((Object)event);
            this.requestSize += event.getBytes().length;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private synchronized String getJSONString(boolean shouldClearData) {
        String result = null;
        try {
            long now = System.currentTimeMillis();
            this.remoteDebuggingJSON.put("data", (Object)this.chronologicalEvents);
            result = this.remoteDebuggingJSON.toString();
            if (shouldClearData) {
                this.clearData();
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return result;
    }

    private synchronized void loadStaticData(String packageName, PackageManager packageManager) {
        AppsFlyerProperties props = AppsFlyerProperties.getInstance();
        AppsFlyerLib afLib = AppsFlyerLib.getInstance();
        String remoteDebugStaticDataFromProperties = props.getString("remote_debug_static_data");
        if (remoteDebugStaticDataFromProperties != null) {
            try {
                this.remoteDebuggingJSON = new JSONObject(remoteDebugStaticDataFromProperties);
            }
            catch (Throwable throwable) {}
        } else {
            this.remoteDebuggingJSON = new JSONObject();
            this.setDeviceData(Build.BRAND, Build.MODEL, Build.VERSION.RELEASE, props.getString("advertiserId"), afLib.userCustomImei, afLib.userCustomAndroidId);
            this.setSDKData("4.7.1.314", props.getString("AppsFlyerKey"), props.getString("KSAppsFlyerId"), props.getString("uid"));
            try {
                int appVersionCode = packageManager.getPackageInfo((String)packageName, (int)0).versionCode;
                String appChannel = props.getString("channel");
                String appPreInstallName = props.getString("preInstallName");
                this.setAppData(packageName, String.valueOf(appVersionCode), appChannel, appPreInstallName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            props.set("remote_debug_static_data", this.remoteDebuggingJSON.toString());
        }
    }

    private String[] getThrowableStringData(String msg, StackTraceElement[] stackTrace) {
        if (stackTrace == null) {
            return new String[]{msg};
        }
        String[] strArr = new String[stackTrace.length + 1];
        strArr[0] = msg;
        for (int i = 1; i < stackTrace.length; ++i) {
            strArr[i] = stackTrace[i].toString();
        }
        return strArr;
    }

    int getNumberOfLines() {
        return this.chronologicalEvents.length();
    }

    private synchronized void clearData() {
        this.chronologicalEvents = null;
        this.chronologicalEvents = new JSONArray();
        this.requestSize = 0;
    }

    synchronized void dropPreLaunchDebugData() {
        shouldCollectPreLaunchDebugData = false;
        this.clearData();
    }

    void disableRemoteDebuggingForThisApp() {
        shouldEnableRemoteDebuggingForThisApp = false;
    }

    boolean isRemoteDebuggingEnabledFromServer() {
        return this.remoteDebuggingEnabledFromServer;
    }

    static {
        shouldCollectPreLaunchDebugData = true;
        shouldEnableRemoteDebuggingForThisApp = true;
    }
}

