/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import com.appsflyer.AFLogger;
import java.security.MessageDigest;
import java.util.Formatter;
import java.util.Map;

class HashUtils {
    HashUtils() {
    }

    public native String getNativeCode(String var1, String var2, String var3);

    public String getHashCode(Map<String, Object> params) {
        String afDevKey = (String)params.get("appsflyerKey");
        String timestamp = (String)params.get("af_timestamp");
        String uid = (String)params.get("uid");
        String nativeSha1 = null;
        nativeSha1 = HashUtils.toSHA1(afDevKey.substring(0, 7) + uid.substring(0, 7) + timestamp.substring(timestamp.length() - 7));
        return nativeSha1;
    }

    public String getHashCodeV2(Map<String, Object> params) {
        String toHash = (String)params.get("appsflyerKey");
        toHash = toHash + params.get("af_timestamp");
        toHash = toHash + params.get("uid");
        toHash = toHash + params.get("installDate");
        toHash = toHash + params.get("counter");
        toHash = toHash + params.get("iaecounter");
        return HashUtils.toSHA1(HashUtils.toMD5(toHash));
    }

    public static String toSHA1(String input) {
        String nativeSha1 = null;
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(input.getBytes("UTF-8"));
            nativeSha1 = HashUtils.byteToHex(crypt.digest());
        }
        catch (Exception e) {
            AFLogger.afLogE("Error turning " + input.substring(0, 6) + ".. to SHA1", e);
        }
        return nativeSha1;
    }

    public static String toMD5(String input) {
        String nativeMd5 = null;
        try {
            MessageDigest crypt = MessageDigest.getInstance("MD5");
            crypt.reset();
            crypt.update(input.getBytes("UTF-8"));
            nativeMd5 = HashUtils.byteToHex(crypt.digest());
        }
        catch (Exception e) {
            AFLogger.afLogE("Error turning " + input.substring(0, 6) + ".. to MD5", e);
        }
        return nativeMd5;
    }

    public static String toSha256(String data) {
        String nativeSha256 = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(data.getBytes());
            nativeSha256 = HashUtils.bytesToHex(md.digest());
        }
        catch (Exception nse) {
            AFLogger.afLogE("Error turning " + data.substring(0, 6) + ".. to SHA-256", nse);
        }
        return nativeSha256;
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuffer result = new StringBuffer();
        for (byte byt : bytes) {
            result.append(Integer.toString((byt & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    private static String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }
}

