/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.RequiresApi;
import com.appsflyer.AFLogger;
import java.lang.ref.WeakReference;

@RequiresApi(api=14)
class Foreground
implements Application.ActivityLifecycleCallbacks {
    private static final long CHECK_DELAY = 500L;
    private static Foreground instance;
    private boolean foreground = false;
    private boolean paused = true;
    private Listener listener = null;

    Foreground() {
    }

    public static Foreground init(Application application) {
        if (instance == null) {
            instance = new Foreground();
            if (Build.VERSION.SDK_INT >= 14) {
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)instance);
            }
        }
        return instance;
    }

    public static Foreground get(Application application) {
        if (instance == null) {
            Foreground.init(application);
        }
        return instance;
    }

    public static Foreground get(Context ctx) {
        if (instance == null) {
            Context appCtx = ctx.getApplicationContext();
            if (appCtx instanceof Application) {
                Foreground.init((Application)appCtx);
            }
            throw new IllegalStateException("Foreground is not initialised and cannot obtain the Application object");
        }
        return instance;
    }

    public static Foreground getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Foreground is not initialised - invoke at least once with parameter init/get");
        }
        return instance;
    }

    public boolean isForeground() {
        return this.foreground;
    }

    public boolean isBackground() {
        return !this.foreground;
    }

    public void registerListener(Listener listener) {
        this.listener = listener;
    }

    public void unregisterListener() {
        this.listener = null;
    }

    public void onActivityResumed(Activity activity) {
        this.paused = false;
        boolean wasBackground = !this.foreground;
        this.foreground = true;
        if (wasBackground) {
            try {
                this.listener.onBecameForeground(activity);
            }
            catch (Exception exc) {
                AFLogger.afLogE("Listener threw exception! ", exc);
            }
        }
    }

    public void onActivityPaused(final Activity activity) {
        this.paused = true;
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    AFLogger.afLogE("Sleeping attempt failed (essential for background state verification)\n", e);
                }
                if (Foreground.this.foreground && Foreground.this.paused) {
                    Foreground.this.foreground = false;
                    try {
                        WeakReference<Activity> weakActivity = new WeakReference<Activity>(activity);
                        Foreground.this.listener.onBecameBackground(weakActivity);
                        weakActivity.clear();
                    }
                    catch (Exception exc) {
                        AFLogger.afLogE("Listener threw exception! ", exc);
                        this.cancel(true);
                    }
                }
                return null;
            }
        }.execute((Object[])new Void[0]);
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    static interface Listener {
        public void onBecameForeground(Activity var1);

        public void onBecameBackground(WeakReference<Activity> var1);
    }
}

