/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Looper;
import com.appsflyer.AFLogger;
import com.appsflyer.AppsFlyerLib;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.BackgroundHttpTask;
import com.appsflyer.RemoteDebuggingManager;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

class AFValidateInAppPurchase
implements Runnable {
    protected WeakReference<Context> ctxReference = null;
    private String appsFlyerDevKey;
    private String googlePublicKey;
    private String signature;
    private String purchaseData;
    private String price;
    private String currency;
    private HashMap<String, String> additionalParams;
    private ScheduledExecutorService executorService;

    public AFValidateInAppPurchase(Context context, String appsFlyerDevKey, String aPublicKey, String aSignature, String aPurchaseData, String aPrice, String aCurrency, HashMap<String, String> aAdditionalParams, ScheduledExecutorService executorService) {
        this.ctxReference = new WeakReference<Context>(context);
        this.appsFlyerDevKey = appsFlyerDevKey;
        this.googlePublicKey = aPublicKey;
        this.purchaseData = aPurchaseData;
        this.price = aPrice;
        this.currency = aCurrency;
        this.additionalParams = aAdditionalParams;
        this.signature = aSignature;
        this.executorService = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.appsFlyerDevKey == null || this.appsFlyerDevKey.length() == 0) {
            return;
        }
        HttpURLConnection legacyValidateConnection = null;
        try {
            Context context = (Context)this.ctxReference.get();
            if (context == null) {
                return;
            }
            HashMap<String, String> validateParams = new HashMap<String, String>();
            validateParams.put("public-key", this.googlePublicKey);
            validateParams.put("sig-data", this.purchaseData);
            validateParams.put("signature", this.signature);
            final HashMap<String, String> validateParamsForWH = new HashMap<String, String>();
            validateParamsForWH.putAll(validateParams);
            ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
            scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    AFValidateInAppPurchase.this.validateWHPurchaseEvent(validateParamsForWH, AFValidateInAppPurchase.this.ctxReference);
                }
            }, 5L, TimeUnit.MILLISECONDS);
            validateParams.put("dev_key", this.appsFlyerDevKey);
            validateParams.put("app_id", context.getPackageName());
            validateParams.put("uid", AppsFlyerLib.getInstance().getAppsFlyerUID(context));
            validateParams.put("advertiserId", AppsFlyerProperties.getInstance().getString("advertiserId"));
            JSONObject validateParamsJSON = new JSONObject(validateParams);
            String postData = validateParamsJSON.toString();
            RemoteDebuggingManager.getInstance().addServerRequestEvent("https://sdk-services.appsflyer.com/validate-android-signature", postData);
            legacyValidateConnection = this.sendDataToServer(postData, "https://sdk-services.appsflyer.com/validate-android-signature");
            int responseCode = -1;
            if (legacyValidateConnection != null) {
                responseCode = legacyValidateConnection.getResponseCode();
            }
            String str = AppsFlyerLib.getInstance().readServerResponse(legacyValidateConnection);
            RemoteDebuggingManager.getInstance().addServerResponseEvent("https://sdk-services.appsflyer.com/validate-android-signature", responseCode, str);
            JSONObject responseJsonObject = new JSONObject(str);
            responseJsonObject.put("code", responseCode);
            if (responseCode == 200) {
                AFLogger.afLog("Validate response 200 ok: " + responseJsonObject.toString());
                boolean validated = false;
                if (responseJsonObject.optBoolean("result")) {
                    validated = responseJsonObject.getBoolean("result");
                }
                this.validateCallback(validated, this.purchaseData, this.price, this.currency, this.additionalParams, responseJsonObject.toString());
            } else {
                AFLogger.afLog("Failed Validate request");
                this.validateCallback(false, this.purchaseData, this.price, this.currency, this.additionalParams, responseJsonObject.toString());
            }
        }
        catch (Throwable t) {
            if (AppsFlyerLib.validatorListener != null) {
                AFLogger.afLogE("Failed Validate request + ex", t);
                this.validateCallback(false, this.purchaseData, this.price, this.currency, this.additionalParams, t.getMessage());
            }
            AFLogger.afLogE(t.getMessage(), t);
        }
        finally {
            if (legacyValidateConnection != null) {
                legacyValidateConnection.disconnect();
            }
        }
        this.executorService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateWHPurchaseEvent(Map<String, Object> validateParams, WeakReference<Context> context) {
        if (context.get() == null) {
            return;
        }
        String validateWhUrlString = AppsFlyerLib.VALIDATE_WH_URL + ((Context)context.get()).getPackageName();
        SharedPreferences sharedPreferences = ((Context)context.get()).getSharedPreferences("appsflyer-data", 0);
        String referrer = this.getReferrer(sharedPreferences);
        Map<String, Object> validateWHParams = AppsFlyerLib.getInstance().getEventParameters((Context)context.get(), this.appsFlyerDevKey, "af_purchase", "", referrer, true, sharedPreferences, false);
        this.addValidateParameters(validateParams, validateWHParams);
        JSONObject validateWHParamsJSON = new JSONObject(validateWHParams);
        String postData = validateWHParamsJSON.toString();
        RemoteDebuggingManager.getInstance().addServerRequestEvent(validateWhUrlString, postData);
        HttpURLConnection validatePurchaseConnection = null;
        try {
            validatePurchaseConnection = this.sendDataToServer(postData, validateWhUrlString);
            int responseCode = -1;
            if (validatePurchaseConnection != null) {
                responseCode = validatePurchaseConnection.getResponseCode();
            }
            String responseString = AppsFlyerLib.getInstance().readServerResponse(validatePurchaseConnection);
            RemoteDebuggingManager.getInstance().addServerResponseEvent(validateWhUrlString, responseCode, responseString);
            JSONObject responseJsonObject = new JSONObject(responseString);
            if (responseCode == 200) {
                AFLogger.afLog("Validate-WH response - 200: " + responseJsonObject.toString());
            } else {
                AFLogger.afWarnLog("Validate-WH response failed - " + responseCode + ": " + responseJsonObject.toString());
            }
        }
        catch (Throwable t) {
            AFLogger.afLogE(t.getMessage(), t);
        }
        finally {
            if (validatePurchaseConnection != null) {
                validatePurchaseConnection.disconnect();
            }
        }
    }

    private void addValidateParameters(Map<String, Object> validateParams, Map<String, Object> validateWHParams) {
        validateWHParams.put("receipt_data", validateParams);
        validateWHParams.put("price", this.price);
        validateWHParams.put("currency", this.currency);
    }

    private String getReferrer(SharedPreferences sharedPreferences) {
        String referrer = sharedPreferences.getString("referrer", null);
        referrer = referrer == null ? "" : referrer;
        return referrer;
    }

    private HttpURLConnection sendDataToServer(String dataString, String url) throws IOException {
        try {
            BackgroundHttpTask validateRequest = new BackgroundHttpTask(null);
            validateRequest.bodyAsString = dataString;
            validateRequest.setShouldReadResponse(false);
            if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
                AFLogger.afDebugLog("Main thread detected. Calling " + url + " in a new thread.");
                validateRequest.execute(new String[]{url});
            } else {
                AFLogger.afDebugLog("Calling " + url + " (on current thread: " + Thread.currentThread().toString() + " )");
                validateRequest.onPreExecute();
                validateRequest.onPostExecute(validateRequest.doInBackground(url));
            }
            return validateRequest.getConnection();
        }
        catch (Throwable t) {
            AFLogger.afLogE("Could not send callStats request", t);
            return null;
        }
    }

    private void validateCallback(boolean validated, String purchaseData, String price, String currency, HashMap<String, String> additionalParams, String result) {
        if (AppsFlyerLib.validatorListener != null) {
            AFLogger.afLog("Validate callback parameters: " + purchaseData + " " + price + " " + currency);
            if (validated) {
                AFLogger.afLog("Validate in app purchase success: " + result);
                AppsFlyerLib.validatorListener.onValidateInApp();
            } else {
                AFLogger.afLog("Validate in app purchase failed: " + result);
                AppsFlyerLib.validatorListener.onValidateInAppFailure(result == null ? "Failed validating" : result);
            }
        }
    }
}

