/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;
import java.util.UUID;

public class Installation {
    private static String sID = null;
    private static final String INSTALLATION = "AF_INSTALLATION";

    public static synchronized String id(Context context) {
        if (sID == null) {
            String tmpSId = Installation.readInstallationSP(context);
            if (tmpSId != null) {
                sID = tmpSId;
            } else {
                File installation = new File(context.getFilesDir(), INSTALLATION);
                try {
                    if (!installation.exists()) {
                        sID = Installation.generateId(context);
                    } else {
                        sID = Installation.readInstallationFile(installation);
                        installation.delete();
                    }
                    Installation.writeInstallationSP(context, sID);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return sID;
    }

    private static String readInstallationFile(File installation) throws IOException {
        RandomAccessFile f = new RandomAccessFile(installation, "r");
        byte[] bytes = new byte[(int)f.length()];
        f.readFully(bytes);
        f.close();
        return new String(bytes);
    }

    private static void writeInstallationFile(File installation, Context context) throws IOException, PackageManager.NameNotFoundException {
        FileOutputStream out = new FileOutputStream(installation);
        String id = Installation.generateId(context);
        out.write(id.getBytes());
        out.close();
    }

    private static String generateId(Context context) throws PackageManager.NameNotFoundException {
        PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        String id = Build.VERSION.SDK_INT >= 9 ? packageInfo.firstInstallTime + "-" + Math.abs(new Random().nextLong()) : UUID.randomUUID().toString();
        return id;
    }

    private static String readInstallationSP(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
        return sharedPreferences.getString(INSTALLATION, null);
    }

    private static void writeInstallationSP(Context context) throws PackageManager.NameNotFoundException {
        Installation.writeInstallationSP(context, Installation.generateId(context));
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private static void writeInstallationSP(Context context, String sId) throws PackageManager.NameNotFoundException {
        SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(INSTALLATION, sId);
        if (Build.VERSION.SDK_INT >= 9) {
            editor.apply();
        } else {
            editor.commit();
        }
    }
}

