/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.appsflyer.AFLogger;
import com.appsflyer.AdvertisingIdClient;
import com.appsflyer.AppsFlyerConversionListener;
import com.appsflyer.AppsFlyerInAppPurchaseValidatorListener;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.AttributionIDNotReady;
import com.appsflyer.BackgroundHttpTask;
import com.appsflyer.ConversionDataListener;
import com.appsflyer.DebugLogQueue;
import com.appsflyer.Foreground;
import com.appsflyer.HashUtils;
import com.appsflyer.Installation;
import com.appsflyer.LogMessages;
import com.appsflyer.cache.CacheManager;
import com.appsflyer.cache.RequestCacheData;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.iid.InstanceID;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONException;
import org.json.JSONObject;

public class AppsFlyerLib
extends BroadcastReceiver {
    public static final String BUILD_NUMBER = "4.3.8";
    public static final String SERVER_BUILD_NUMBER = "4.3.8".substring(0, "4.3.8".indexOf("."));
    public static final String SDK_BUILD_NUMBER = "4.3.8".substring("4.3.8".indexOf(".") + 1);
    public static final String LOG_TAG = "AppsFlyer_" + SDK_BUILD_NUMBER;
    public static final String APPS_TRACKING_URL = "https://t.appsflyer.com/api/v" + SERVER_BUILD_NUMBER + "/androidevent?buildnumber=" + SDK_BUILD_NUMBER + "&app_id=";
    public static final String EVENTS_TRACKING_URL = "https://events.appsflyer.com/api/v" + SERVER_BUILD_NUMBER + "/androidevent?buildnumber=" + SDK_BUILD_NUMBER + "&app_id=";
    private static final String REGISTER_URL = "https://register.appsflyer.com/api/v" + SERVER_BUILD_NUMBER + "/androidevent?buildnumber=" + SDK_BUILD_NUMBER + "&app_id=";
    private static final String STATS_URL = "https://stats.appsflyer.com/stats";
    private static final String VALIDATE_URL = "https://sdk-services.appsflyer.com/validate-android-signature";
    private static final String CONVERSION_DATA_URL = "https://api.appsflyer.com/install_data/v3/";
    private static final String INSTALL_UPDATE_DATE_FORMAT = "yyyy-MM-dd_HHmmZ";
    protected static final String AF_SHARED_PREF = "appsflyer-data";
    static final String SENT_SUCCESSFULLY_PREF = "sentSuccessfully";
    static final String AF_COUNTER_PREF = "appsFlyerCount";
    static final String AF_EVENT_COUNTER_PREF = "appsFlyerInAppEventCount";
    static final String AF_TIME_PASSED_SINCE_LAST_LAUNCH = "AppsFlyerTimePassedSincePrevLaunch";
    static final String FIRST_INSTALL_PREF = "appsFlyerFirstInstall";
    protected static final String REFERRER_PREF = "referrer";
    static final String ATTRIBUTION_ID_PREF = "attributionId";
    private static final String PREPARE_DATA_ACTION = "collect data for server";
    private static final String CALL_SERVER_ACTION = "call server.";
    private static final String SERVER_RESPONDED_ACTION = "response from server. status=";
    public static final String ATTRIBUTION_ID_CONTENT_URI = "content://com.facebook.katana.provider.AttributionIdProvider";
    public static final String ATTRIBUTION_ID_COLUMN_NAME = "aid";
    private static final String WARNING_PREFIX = "WARNING: ";
    private static final String ERROR_PREFIX = "ERROR: ";
    private static final String CACHED_CHANNEL_PREF = "CACHED_CHANNEL";
    private static final String CACHED_URL_PARAMETER = "&isCachedRequest=true&timeincache=";
    private static final String INSTALL_STORE_PREF = "INSTALL_STORE";
    private static final List<String> IGNORABLE_KEYS = Arrays.asList("is_cache");
    private static final String DEEPLINK_ATTR_PREF = "deeplinkAttribution";
    private static final String PRE_INSTALL_PREF = "preInstallName";
    private static final String IMEI_CACHED_PREF = "imeiCached";
    private static final String PREV_EVENT_TIMESTAMP = "prev_event_timestamp";
    private static final String PREV_EVENT_VALUE = "prev_event_value";
    private static final String PREV_EVENT_NAME = "prev_event_name";
    private static final String PREV_EVENT = "prev_event";
    private static final long TEST_MODE_MAX_DURATION = 30000L;
    private static String userCustomImei;
    private static final String ANDROID_ID_CACHED_PREF = "androidIdCached";
    private static String userCustomAndroidId;
    private static final String IN_APP_EVENTS_API = "1";
    private static AppsFlyerConversionListener conversionDataListener;
    private static AppsFlyerInAppPurchaseValidatorListener validatorListener;
    private static boolean isDuringCheckCache;
    private static long lastCacheCheck;
    private static ScheduledExecutorService cacheScheduler;
    private static long timeInApp;
    private static final String CONVERSION_REQUEST_RETRIES = "appsflyerConversionDataRequestRetries";
    private static final int NUMBER_OF_CONVERSION_DATA_RETRIES = 5;
    private static final String CONVERSION_DATA_CACHE_EXPIRATION = "appsflyerConversionDataCacheExpiration";
    private static final String GET_CONVERSION_DATA_TIME = "appsflyerGetConversionDataTiming";
    private static final long SIXTY_DAYS = 5184000000L;
    private static final String VERSION_CODE = "versionCode";
    private static AppsFlyerLib instance;
    private Foreground.Listener listener;
    private long testModeStartTime;

    public void onReceive(Context context, Intent intent) {
        String shouldMonitor = intent.getStringExtra("shouldMonitor");
        if (shouldMonitor != null) {
            AFLogger.afLog("Turning on monitoring.");
            AppsFlyerProperties.getInstance().set("shouldMonitor", shouldMonitor.equals("true"));
            this.monitor(context, null, "START_TRACKING", context.getPackageName());
            return;
        }
        AFLogger.afLog("****** onReceive called *******");
        this.debugAction("******* onReceive: ", "", context);
        AppsFlyerProperties.getInstance().setOnReceiveCalled();
        String referrer = intent.getStringExtra(REFERRER_PREF);
        AFLogger.afLog("Play store referrer: " + referrer);
        if (referrer != null) {
            String testIntegration = intent.getStringExtra("TestIntegrationMode");
            if (testIntegration != null && testIntegration.equals("AppsFlyer_Test")) {
                SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.clear();
                this.editorCommit(editor);
                AppsFlyerProperties.getInstance().setFirstLaunchCalled(false);
                this.startTestMode();
            }
            this.debugAction("onReceive called. referrer: ", referrer, context);
            this.saveDataToSharedPreferences(context, REFERRER_PREF, referrer);
            AppsFlyerProperties.getInstance().setReferrer(referrer);
            if (AppsFlyerProperties.getInstance().isFirstLaunchCalled()) {
                AFLogger.afLog("onReceive: isLaunchCalled");
                this.runInBackground(context, null, null, null, referrer, false);
            }
        }
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private void editorCommit(SharedPreferences.Editor editor) {
        if (Build.VERSION.SDK_INT >= 9) {
            editor.apply();
        } else {
            editor.commit();
        }
    }

    private void startTestMode() {
        AFLogger.afLog("Test mode started..");
        this.testModeStartTime = System.currentTimeMillis();
    }

    private void endTestMode() {
        AFLogger.afLog("Test mode ended!");
        this.testModeStartTime = 0L;
    }

    private boolean isInTestMode() {
        long interval = System.currentTimeMillis() - this.testModeStartTime;
        return interval <= 30000L;
    }

    private AppsFlyerLib() {
    }

    public static AppsFlyerLib getInstance() {
        return instance;
    }

    private void registerForAppEvents(Application application) {
        if (this.listener == null) {
            AppsFlyerProperties.getInstance().loadProperties(application.getApplicationContext());
            if (Build.VERSION.SDK_INT >= 14) {
                Foreground.init(application);
                this.listener = new Foreground.Listener(){

                    @Override
                    public void onBecameForeground(Activity currentActivity) {
                        AFLogger.afLog("onBecameForeground");
                        AppsFlyerLib.this.trackEvent((Context)currentActivity, null, null);
                    }

                    @Override
                    public void onBecameBackground(Activity currentActivity) {
                        AFLogger.afLog("onBecameBackground");
                        AFLogger.afLog("callStatsBackground background call");
                        AppsFlyerLib.this.callStatsBackground(currentActivity.getApplicationContext());
                    }
                };
                Foreground.getInstance().addListener(this.listener);
            } else {
                AFLogger.afLog("SDK<14 call trackAppLaunch manually");
                this.trackEvent(application.getApplicationContext(), null, null);
            }
        }
    }

    private void registerOnGCM(final Context context) {
        final String gcmProjectID = AppsFlyerProperties.getInstance().getString("GCM_PROJECT_ID");
        if (gcmProjectID != null && AppsFlyerProperties.getInstance().getString("GCM_TOKEN") == null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        InstanceID instanceID = InstanceID.getInstance((Context)context);
                        String token = instanceID.getToken(gcmProjectID, "GCM", null);
                        AFLogger.afLog("token=" + token);
                        AppsFlyerProperties.getInstance().set("GCM_TOKEN", token);
                        String sInstanceId = instanceID.getId();
                        AFLogger.afLog("instance id=" + sInstanceId);
                        AppsFlyerProperties.getInstance().set("GCM_INSTANCE_ID", sInstanceId);
                        AppsFlyerLib.this.callRegisterBackground(context);
                    }
                    catch (Exception e) {
                        AFLogger.afLogE("Could not load registration ID", e);
                    }
                    catch (Error er) {
                        AFLogger.afLogE("Caught Exception", er);
                    }
                }
            }).start();
        }
    }

    @Deprecated
    public void setGCMProjectID(String id) {
        this.setGCMProjectNumber(id);
    }

    public void setGCMProjectNumber(String id) {
        AppsFlyerProperties.getInstance().set("GCM_PROJECT_ID", id);
    }

    public void setDebugLog(boolean shouldEnable) {
        AppsFlyerProperties.getInstance().enableLogOutput(shouldEnable);
    }

    public void setImeiData(String aImei) {
        userCustomImei = aImei;
    }

    public void setAndroidIdData(String aAndroidId) {
        userCustomAndroidId = aAndroidId;
    }

    private void debugAction(String actionMsg, String parameter, Context context) {
        try {
            if (context != null && this.isAppsFlyerPackage(context.getPackageName())) {
                DebugLogQueue.getInstance().push(actionMsg + parameter);
            }
        }
        catch (Exception e) {
            AFLogger.afLog(e.toString());
        }
    }

    private boolean isAppsFlyerPackage(String packageName) {
        return packageName.length() > 12 && "com.appsflyer".equals(packageName.toLowerCase().substring(0, 13));
    }

    private void saveDataToSharedPreferences(Context context, String key, String value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(key, value);
        this.editorCommit(editor);
    }

    private void saveIntegerToSharedPreferences(Context context, String key, int value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(key, value);
        this.editorCommit(editor);
    }

    private void saveLongToSharedPreferences(Context context, String key, long value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(key, value);
        this.editorCommit(editor);
    }

    private boolean checkWriteExternalPermission(Context context) {
        String permission = "android.permission.ACCESS_FINE_LOCATION";
        int res = context.checkCallingOrSelfPermission(permission);
        return res == 0;
    }

    protected void setProperty(String key, String value) {
        AppsFlyerProperties.getInstance().set(key, value);
    }

    public String getProperty(String key) {
        return AppsFlyerProperties.getInstance().getString(key);
    }

    @Deprecated
    public void setAppUserId(String id) {
        this.setCustomerUserId(id);
    }

    public void setCustomerUserId(String id) {
        AFLogger.afLog("setCustomerUserId = " + id);
        this.setProperty("AppUserId", id);
    }

    public void setAdditionalData(HashMap<String, Object> customData) {
        JSONObject jsonObject = new JSONObject(customData);
        AppsFlyerProperties.getInstance().setCustomData(jsonObject.toString());
    }

    public void sendDeepLinkData(Activity activity) {
        AFLogger.afLog("getDeepLinkData with activity " + activity.getIntent().getDataString());
        this.registerForAppEvents(activity.getApplication());
    }

    @Deprecated
    public void setUserEmail(String email) {
        this.setProperty("userEmail", email);
    }

    public void setUserEmails(String ... emails) {
        this.setUserEmails(AppsFlyerProperties.EmailsCryptType.NONE, emails);
    }

    public void setUserEmails(AppsFlyerProperties.EmailsCryptType cryptMethod, String ... emails) {
        AppsFlyerProperties.getInstance().set("userEmailsCryptType", cryptMethod.getValue());
        HashMap<String, String> emailData = new HashMap<String, String>();
        StringBuilder emailsString = new StringBuilder();
        for (String email : emails) {
            emailsString.append(email);
            emailsString.append(",");
        }
        switch (cryptMethod) {
            default: {
                emailData.put("sha1_el_arr", HashUtils.toSHA1(emailsString.toString()));
                break;
            }
            case MD5: {
                emailData.put("md5_el_arr", HashUtils.toMD5(emailsString.toString()));
                break;
            }
            case NONE: {
                emailData.put("plain_el_arr", emailsString.toString());
            }
        }
        JSONObject jsonObject = new JSONObject(emailData);
        AppsFlyerProperties.getInstance().setUserEmails(jsonObject.toString());
    }

    public void setUseHTTPFalback(boolean isUseHttp) {
        this.setProperty("useHttpFallback", Boolean.toString(isUseHttp));
    }

    public void setCollectAndroidID(boolean isCollect) {
        this.setProperty("collectAndroidId", Boolean.toString(isCollect));
    }

    public void setCollectMACAddress(boolean isCollect) {
        this.setProperty("collectMAC", Boolean.toString(isCollect));
    }

    public void setCollectIMEI(boolean isCollect) {
        this.setProperty("collectIMEI", Boolean.toString(isCollect));
    }

    public void setCollectFingerPrint(boolean isCollect) {
        this.setProperty("collectFingerPrint", Boolean.toString(isCollect));
    }

    public void startTracking(Application application, String key) {
        this.registerForAppEvents(application);
        this.registerOnGCM(application.getApplicationContext());
        this.setProperty("AppsFlyerKey", key);
        LogMessages.setDevKey(key);
    }

    public String getAppUserId() {
        return this.getProperty("AppUserId");
    }

    public void setAppId(String id) {
        this.setProperty("appid", id);
    }

    public String getAppId() {
        return this.getProperty("appid");
    }

    public void setExtension(String extension) {
        AppsFlyerProperties.getInstance().set("sdkExtension", extension);
    }

    public void setIsUpdate(boolean isUpdate) {
        AppsFlyerProperties.getInstance().set("IS_UPDATE", isUpdate);
    }

    public void setCurrencyCode(String currencyCode) {
        AppsFlyerProperties.getInstance().set("currencyCode", currencyCode);
    }

    public void trackLocation(Context context, double latitude, double longitude) {
        HashMap<String, Object> location = new HashMap<String, Object>();
        location.put("af_long", Double.toString(longitude));
        location.put("af_lat", Double.toString(latitude));
        this.trackEvent(context, "af_location_coordinates", location);
    }

    private void callStatsBackground(Context context) {
        String customUUID;
        AFLogger.afLog("app went to background");
        AppsFlyerProperties.getInstance().saveProperties(context);
        long sessionTime = System.currentTimeMillis() - timeInApp;
        HashMap<String, String> params = new HashMap<String, String>();
        String afDevKey = this.getProperty("AppsFlyerKey");
        params.put("app_id", context.getPackageName());
        params.put("devkey", afDevKey);
        params.put("uid", this.getAppsFlyerUID(context));
        params.put("time_in_app", String.valueOf(sessionTime / 1000L));
        params.put("statType", "user_closed_app");
        params.put("platform", "Android");
        params.put("launch_counter", Integer.toString(this.getCounter(context, AF_COUNTER_PREF, false)));
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        params.put("gcd_conversion_data_timing", Long.toString(sharedPreferences.getLong(GET_CONVERSION_DATA_TIME, 0L)));
        boolean collectFingerPrint = AppsFlyerProperties.getInstance().getBoolean("collectFingerPrint", true);
        if (collectFingerPrint && (customUUID = this.getUniquePsuedoID()) != null) {
            params.put("deviceFingerPrintId", customUUID);
        }
        try {
            BackgroundHttpTask statTask = new BackgroundHttpTask(context);
            statTask.bodyParameters = params;
            statTask.execute(new String[]{STATS_URL});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void trackAppLaunch(Context ctx) {
        this.trackEvent(ctx, null, null);
    }

    public void trackEvent(Context context, String eventName, Map<String, Object> eventValues) {
        JSONObject jsonObject = new JSONObject((Map)(eventValues == null ? new HashMap() : eventValues));
        String referrer = AppsFlyerProperties.getInstance().getReferrer(context);
        this.runInBackground(context, null, eventName, jsonObject.toString(), referrer == null ? "" : referrer, true);
    }

    private void monitor(Context context, String eventIdentifier, String message, String value) {
        if (AppsFlyerProperties.getInstance().getBoolean("shouldMonitor", false)) {
            Intent localIntent = new Intent("com.appsflyer.MonitorBroadcast");
            localIntent.setPackage("com.appsflyer.nightvision");
            localIntent.putExtra("message", message);
            localIntent.putExtra("value", value);
            localIntent.putExtra("packageName", "true");
            localIntent.putExtra("pid", (Serializable)new Integer(Process.myPid()));
            localIntent.putExtra("eventIdentifier", eventIdentifier);
            localIntent.putExtra("sdk", SERVER_BUILD_NUMBER + '.' + SDK_BUILD_NUMBER);
            context.sendBroadcast(localIntent);
        }
    }

    private void callRegisterBackground(Context context) {
        String customUUID;
        HashMap<String, String> params = new HashMap<String, String>();
        String afDevKey = this.getProperty("AppsFlyerKey");
        params.put("devkey", afDevKey);
        params.put("uid", this.getAppsFlyerUID(context));
        params.put("af_gcm_token", AppsFlyerProperties.getInstance().getString("GCM_TOKEN"));
        params.put("advertiserId", AppsFlyerProperties.getInstance().getString("advertiserId"));
        params.put("af_google_instance_id", AppsFlyerProperties.getInstance().getString("GCM_INSTANCE_ID"));
        params.put("launch_counter", Integer.toString(this.getCounter(context, AF_COUNTER_PREF, false)));
        params.put("sdk", Integer.toString(Build.VERSION.SDK_INT));
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            long firstInstallTime = packageInfo.firstInstallTime;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            params.put("install_date", dateFormat.format(new Date(firstInstallTime)));
        }
        catch (PackageManager.NameNotFoundException packageInfo) {
        }
        catch (NoSuchFieldError packageInfo) {
            // empty catch block
        }
        boolean collectFingerPrint = AppsFlyerProperties.getInstance().getBoolean("collectFingerPrint", true);
        if (collectFingerPrint && (customUUID = this.getUniquePsuedoID()) != null) {
            params.put("deviceFingerPrintId", customUUID);
        }
        try {
            BackgroundHttpTask statTask = new BackgroundHttpTask(context);
            statTask.bodyParameters = params;
            String url = REGISTER_URL + context.getPackageName();
            statTask.execute(new String[]{url});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void broadcastBacktoTestApp(Context context, HashMap<String, String> params) {
        Intent localIntent = new Intent("com.appsflyer.testIntgrationBroadcast");
        localIntent.putExtra("params", params);
        context.sendBroadcast(localIntent);
    }

    public void setDeviceTrackingDisabled(boolean isDisabled) {
        AppsFlyerProperties.getInstance().set("deviceTrackingDisabled", isDisabled);
    }

    public Map<String, String> getConversionData(Context context) throws AttributionIDNotReady {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        String referrer = AppsFlyerProperties.getInstance().getReferrer(context);
        if (referrer != null && referrer.length() > 0 && referrer.contains("af_tranid")) {
            return this.referrerStringToMap(context, referrer);
        }
        String attributionString = sharedPreferences.getString(ATTRIBUTION_ID_PREF, null);
        if (attributionString != null && attributionString.length() > 0) {
            return this.attributionStringToMap(attributionString);
        }
        throw new AttributionIDNotReady();
    }

    public void registerConversionListener(Context context, AppsFlyerConversionListener conversionDataListener) {
        if (conversionDataListener == null) {
            return;
        }
        AppsFlyerLib.conversionDataListener = conversionDataListener;
    }

    public void registerValidatorListener(Context context, AppsFlyerInAppPurchaseValidatorListener validationListener) {
        AFLogger.afDebugLog("registerValidatorListener called");
        if (validationListener == null) {
            AFLogger.afDebugLog("registerValidatorListener null listener");
            return;
        }
        validatorListener = validationListener;
    }

    @Deprecated
    public void getConversionData(Context context, final ConversionDataListener conversionDataListener) {
        this.registerConversionListener(context, new AppsFlyerConversionListener(){

            @Override
            public void onInstallConversionDataLoaded(Map<String, String> conversionData) {
                conversionDataListener.onConversionDataLoaded(conversionData);
            }

            @Override
            public void onInstallConversionFailure(String errorMessage) {
                conversionDataListener.onConversionFailure(errorMessage);
            }

            @Override
            public void onAppOpenAttribution(Map<String, String> attributionData) {
            }

            @Override
            public void onAttributionFailure(String errorMessage) {
            }
        });
    }

    private Map<String, String> referrerStringToMap(Context context, String referrer) {
        LinkedHashMap<String, String> conversionData = new LinkedHashMap<String, String>();
        String[] pairs = referrer.split("&");
        boolean didFindPrt = false;
        for (String pair : pairs) {
            String name;
            int idx = pair.indexOf("=");
            String string = name = idx > 0 ? pair.substring(0, idx) : pair;
            if (!conversionData.containsKey(name)) {
                if (name.equals("c")) {
                    name = "campaign";
                } else if (name.equals("pid")) {
                    name = "media_source";
                } else if (name.equals("af_prt")) {
                    didFindPrt = true;
                    name = "agency";
                }
                conversionData.put(name, new String());
            }
            String value = idx > 0 && pair.length() > idx + 1 ? pair.substring(idx + 1) : null;
            conversionData.put(name, value);
        }
        try {
            if (!conversionData.containsKey("install_time")) {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                long firstInstallTime = packageInfo.firstInstallTime;
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                conversionData.put("install_time", dateFormat.format(new Date(firstInstallTime)));
            }
        }
        catch (Exception e) {
            AFLogger.afWarnLog("Could not fetch install time");
        }
        if (!conversionData.containsKey("af_status")) {
            conversionData.put("af_status", "Non-organic");
        }
        if (didFindPrt) {
            conversionData.remove("media_source");
        }
        return conversionData;
    }

    private Map<String, String> attributionStringToMap(String inputString) {
        HashMap<String, String> conversionData = new HashMap<String, String>();
        try {
            JSONObject jsonObject = new JSONObject(inputString);
            Iterator iterator = jsonObject.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                if (IGNORABLE_KEYS.contains(key)) continue;
                conversionData.put(key, jsonObject.getString(key));
            }
        }
        catch (JSONException e) {
            AFLogger.afWarnLog(e.getMessage());
            return null;
        }
        return conversionData;
    }

    private void runInBackground(Context context, String appsFlyerKey, String eventName, String eventValue, String referrer, boolean isNewAPI) {
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        scheduler.schedule(new DataCollector(context, appsFlyerKey, eventName, eventValue, referrer, isNewAPI, scheduler), 5L, TimeUnit.MILLISECONDS);
    }

    private void sendTrackingWithEvent(Context context, String appsFlyerKey, String eventName, String eventValue, String referrer, boolean isUseNewAPI) {
        AppsFlyerProperties.getInstance().saveProperties(context);
        AFLogger.afLog("AsendTrackingWithEvent from activity: " + context.getClass().getName().toString());
        boolean isLaunchEvent = eventName == null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("af_timestamp", Long.toString(new Date().getTime()));
        try {
            String action;
            Intent intent;
            String instanceId;
            SharedPreferences sharedPreferences;
            String attributionString;
            String customUUID;
            String facebookAttributeId;
            String isUpdate;
            String currencyCode;
            String emailData;
            String afKEy;
            String currentStore;
            String preInstallName;
            String installStore;
            String currentChannel;
            String originalChannel;
            String customData;
            this.debugAction(PREPARE_DATA_ACTION, "", context);
            AFLogger.afLog("******* sendTrackingWithEvent: " + (isLaunchEvent ? "Launch" : eventName));
            this.debugAction("********* sendTrackingWithEvent: ", isLaunchEvent ? "Launch" : eventName, context);
            this.monitor(context, LOG_TAG, "EVENT_CREATED_WITH_NAME", isLaunchEvent ? "Launch" : eventName);
            CacheManager.getInstance().init(context);
            try {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
                List<String> requestedPermissions = Arrays.asList(packageInfo.requestedPermissions);
                if (!requestedPermissions.contains("android.permission.INTERNET")) {
                    AFLogger.afWarnLog("Permission android.permission.INTERNET is missing in the AndroidManifest.xml");
                    this.monitor(context, null, "PERMISSION_INTERNET_MISSING", null);
                }
                if (!requestedPermissions.contains("android.permission.ACCESS_NETWORK_STATE")) {
                    AFLogger.afWarnLog("Permission android.permission.ACCESS_NETWORK_STATE is missing in the AndroidManifest.xml");
                }
                if (!requestedPermissions.contains("android.permission.ACCESS_WIFI_STATE")) {
                    AFLogger.afWarnLog("Permission android.permission.ACCESS_WIFI_STATE is missing in the AndroidManifest.xml");
                }
            }
            catch (Exception packageInfo) {
                // empty catch block
            }
            StringBuilder urlString = new StringBuilder();
            urlString.append(isLaunchEvent ? APPS_TRACKING_URL : EVENTS_TRACKING_URL).append(context.getPackageName());
            if (isUseNewAPI) {
                params.put("af_events_api", IN_APP_EVENTS_API);
            }
            params.put("brand", Build.BRAND);
            params.put("device", Build.DEVICE);
            params.put("product", Build.PRODUCT);
            params.put("sdk", Integer.toString(Build.VERSION.SDK_INT));
            params.put("model", Build.MODEL);
            params.put("deviceType", Build.TYPE);
            if (isLaunchEvent) {
                if (this.isAppsFlyerFirstLaunch(context)) {
                    params.put("af_sdks", this.generateOtherSDKsString());
                }
            } else {
                this.lastEventsProcessing(context, params, eventName, eventValue);
            }
            if ((customData = this.getProperty("additionalCustomData")) != null) {
                params.put("customData", customData);
            }
            try {
                String installerPackage = context.getPackageManager().getInstallerPackageName(context.getPackageName());
                if (installerPackage != null) {
                    params.put("installer_package", installerPackage);
                }
            }
            catch (Exception installerPackage) {
                // empty catch block
            }
            String sdkExtension = AppsFlyerProperties.getInstance().getString("sdkExtension");
            if (sdkExtension != null && sdkExtension.length() > 0) {
                params.put("sdkExtension", sdkExtension);
            }
            if ((originalChannel = this.getCachedChannel(context, currentChannel = this.getConfiguredChannel(context))) != null) {
                params.put("channel", originalChannel);
            }
            if (originalChannel != null && !originalChannel.equals(currentChannel) || originalChannel == null && currentChannel != null) {
                params.put("af_latestchannel", currentChannel);
            }
            if ((installStore = this.getCachedStore(context)) != null) {
                params.put("af_installstore", installStore.toLowerCase());
            }
            if ((preInstallName = this.getPreInstallName(context)) != null) {
                params.put("af_preinstall_name", preInstallName.toLowerCase());
            }
            if ((currentStore = this.getCurrentStore(context)) != null) {
                params.put("af_currentstore", currentStore.toLowerCase());
            }
            if ((afKEy = appsFlyerKey) == null || afKEy.length() == 0) {
                afKEy = this.getProperty("AppsFlyerKey");
            }
            if (afKEy != null && afKEy.length() > 0) {
                params.put("appsflyerKey", afKEy);
                if (afKEy.length() > 8) {
                    params.put("dkh", afKEy.substring(0, 8));
                }
            } else {
                AFLogger.afLog("AppsFlyer dev key is missing!!! Please use  AppsFlyerLib.getInstance().setAppsFlyerKey(...) to set it. ");
                this.monitor(context, LOG_TAG, "DEV_KEY_MISSING", null);
                AFLogger.afLog("AppsFlyer will not track this event.");
                return;
            }
            String appUserId = this.getAppUserId();
            if (appUserId != null) {
                params.put("appUserId", appUserId);
            }
            if ((emailData = AppsFlyerProperties.getInstance().getString("userEmails")) != null) {
                params.put("user_emails", emailData);
            } else {
                String userEmail = this.getProperty("userEmail");
                if (userEmail != null) {
                    params.put("sha1_el", HashUtils.toSHA1(userEmail));
                }
            }
            if (eventName != null) {
                params.put("eventName", eventName);
                if (eventValue != null) {
                    params.put("eventValue", eventValue);
                }
            }
            if (this.getProperty("appid") != null) {
                params.put("appid", this.getProperty("appid"));
            }
            if ((currencyCode = this.getProperty("currencyCode")) != null) {
                if (currencyCode.length() != 3) {
                    AFLogger.afWarnLog("WARNING: currency code should be 3 characters!!! '" + currencyCode + "' is not a legal value.");
                }
                params.put("currency", currencyCode);
            }
            if ((isUpdate = this.getProperty("IS_UPDATE")) != null) {
                params.put("isUpdate", isUpdate);
            }
            boolean isPreInstall = this.isPreInstalledApp(context);
            params.put("af_preinstalled", Boolean.toString(isPreInstall));
            boolean shouldCollectFBId = AppsFlyerProperties.getInstance().getBoolean("collectFacebookAttrId", true);
            if (shouldCollectFBId && (facebookAttributeId = this.getAttributionId(context.getContentResolver())) != null) {
                params.put("fb", facebookAttributeId);
            }
            this.addDeviceTracking(context, params);
            try {
                String uid = Installation.id(context);
                if (uid != null) {
                    params.put("uid", uid);
                }
            }
            catch (Exception e) {
                AFLogger.afLog(ERROR_PREFIX + ERROR_PREFIX + "could not get uid " + e.getMessage());
            }
            try {
                params.put("lang", Locale.getDefault().getDisplayLanguage());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                params.put("lang_code", Locale.getDefault().getLanguage());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                params.put("country", Locale.getDefault().getCountry());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
                params.put("operator", manager.getSimOperatorName());
                params.put("carrier", manager.getNetworkOperatorName());
            }
            catch (Exception manager) {
                // empty catch block
            }
            try {
                params.put("network", this.getNetwork(context));
            }
            catch (Throwable e) {
                AFLogger.afLog("checking network error " + e.getMessage());
            }
            boolean collectFingerPrint = AppsFlyerProperties.getInstance().getBoolean("collectFingerPrint", true);
            if (collectFingerPrint && (customUUID = this.getUniquePsuedoID()) != null) {
                params.put("deviceFingerPrintId", customUUID);
            }
            this.addAdvertiserIDData(context, params);
            this.checkPlatform(context, params);
            SimpleDateFormat dateFormat = new SimpleDateFormat(INSTALL_UPDATE_DATE_FORMAT, Locale.US);
            if (Build.VERSION.SDK_INT >= 9) {
                try {
                    long installed = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).firstInstallTime;
                    params.put("installDate", dateFormat.format(new Date(installed)));
                }
                catch (Exception installed) {
                    // empty catch block
                }
            }
            try {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                SharedPreferences sharedPreferences2 = context.getSharedPreferences(AF_SHARED_PREF, 0);
                int versioncode = sharedPreferences2.getInt(VERSION_CODE, 0);
                if (packageInfo.versionCode > versioncode) {
                    this.saveIntegerToSharedPreferences(context, CONVERSION_REQUEST_RETRIES, 0);
                    this.saveIntegerToSharedPreferences(context, VERSION_CODE, packageInfo.versionCode);
                }
                params.put("app_version_code", Integer.toString(packageInfo.versionCode));
                params.put("app_version_name", packageInfo.versionName);
                if (Build.VERSION.SDK_INT >= 9) {
                    long firstInstallTime = packageInfo.firstInstallTime;
                    long lastUpdateTime = packageInfo.lastUpdateTime;
                    params.put("date1", dateFormat.format(new Date(firstInstallTime)));
                    params.put("date2", dateFormat.format(new Date(lastUpdateTime)));
                    String firstInstallDate = this.getFirstInstallDate(dateFormat, context);
                    params.put("firstLaunchDate", firstInstallDate);
                }
            }
            catch (PackageManager.NameNotFoundException packageInfo) {
            }
            catch (NoSuchFieldError packageInfo) {
                // empty catch block
            }
            if (referrer.length() > 0) {
                params.put(REFERRER_PREF, referrer);
            }
            if ((attributionString = (sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0)).getString(ATTRIBUTION_ID_PREF, null)) != null && attributionString.length() > 0) {
                params.put("installAttribution", attributionString);
            }
            if ((instanceId = AppsFlyerProperties.getInstance().getString("GCM_INSTANCE_ID")) != null) {
                params.put("af_google_instance_id", instanceId);
            }
            if (isLaunchEvent && context instanceof Activity && (intent = ((Activity)context).getIntent()) != null && (action = intent.getAction()) == "android.intent.action.VIEW") {
                Map<Object, Object> attributionMap;
                Uri uri = intent.getData();
                params.put("af_deeplink", uri.toString());
                if (uri.getQueryParameter("af_deeplink") != null) {
                    attributionMap = this.referrerStringToMap(context, uri.getQuery().toString());
                    if (uri.getPath() != null) {
                        attributionMap.put("path", uri.getPath());
                    }
                    if (uri.getScheme() != null) {
                        attributionMap.put("scheme", uri.getScheme());
                    }
                } else {
                    attributionMap = new HashMap<String, String>();
                    attributionMap.put("link", uri.toString());
                }
                String json = new JSONObject(attributionMap).toString();
                this.saveDataToSharedPreferences(context, DEEPLINK_ATTR_PREF, json);
                if (conversionDataListener != null) {
                    conversionDataListener.onAppOpenAttribution(attributionMap);
                }
            }
            if (this.isInTestMode() && "AppsFlyer_Test".equals(referrer)) {
                params.put("testAppMode", "true");
                AppsFlyerLib.broadcastBacktoTestApp(context, params);
                AFLogger.afLog("Sent params to test app");
                this.endTestMode();
            }
            AFLogger.afLog("AppsFlyerLib.sendTrackingWithEvent");
            new SendToServerRunnable(urlString.toString(), params, context.getApplicationContext(), isLaunchEvent).run();
        }
        catch (Throwable e) {
            AFLogger.afLogE(e.getLocalizedMessage(), e);
        }
    }

    private String generateOtherSDKsString() {
        return "" + this.numricBooleanIsClassExist("com.tune.Tune") + this.numricBooleanIsClassExist("com.adjust.sdk.Adjust") + this.numricBooleanIsClassExist("com.kochava.android.tracker.Feature") + this.numricBooleanIsClassExist("io.branch.referral.Branch") + this.numricBooleanIsClassExist("com.apsalar.sdk.Apsalar") + this.numricBooleanIsClassExist("com.localytics.android.Localytics") + this.numricBooleanIsClassExist("com.tenjin.android.TenjinSDK") + this.numricBooleanIsClassExist("com.talkingdata.sdk.TalkingDataSDK") + this.numricBooleanIsClassExist("it.partytrack.sdk.Track") + this.numricBooleanIsClassExist("jp.appAdForce.android.LtvManager");
    }

    private int numricBooleanIsClassExist(String className) {
        try {
            Class.forName(className);
            return 1;
        }
        catch (ClassNotFoundException e) {
            return 0;
        }
    }

    private void lastEventsProcessing(Context context, Map<String, String> params, String newEventName, String newEventValue) {
        SharedPreferences sp = context.getSharedPreferences(AF_SHARED_PREF, 0);
        SharedPreferences.Editor editor = sp.edit();
        try {
            String previousEventName = sp.getString(PREV_EVENT_NAME, null);
            if (previousEventName != null) {
                JSONObject json = new JSONObject();
                json.put(PREV_EVENT_TIMESTAMP, (Object)(sp.getLong(PREV_EVENT_TIMESTAMP, -1L) + ""));
                json.put(PREV_EVENT_VALUE, (Object)sp.getString(PREV_EVENT_VALUE, null));
                json.put(PREV_EVENT_NAME, (Object)previousEventName);
                params.put(PREV_EVENT, json.toString());
            }
            editor.putString(PREV_EVENT_NAME, newEventName);
            editor.putString(PREV_EVENT_VALUE, newEventValue);
            editor.putLong(PREV_EVENT_TIMESTAMP, System.currentTimeMillis());
            this.editorCommit(editor);
        }
        catch (Exception e) {
            AFLogger.afLogE("Error while processing previous event.", e);
        }
    }

    private boolean isGooglePlayServicesAvailable(Context context) {
        boolean retValue = false;
        try {
            int statusCode = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context);
            if (statusCode == 0) {
                retValue = true;
            }
        }
        catch (Throwable t) {
            AFLogger.afLog("WARNING: Google play services is unavailable.");
        }
        return retValue;
    }

    private void addDeviceTracking(Context context, Map<String, String> params) {
        boolean deviceTrackingDisabled = AppsFlyerProperties.getInstance().getBoolean("deviceTrackingDisabled", false);
        if (deviceTrackingDisabled) {
            params.put("deviceTrackingDisabled", "true");
        } else {
            SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
            boolean collectIMEI = AppsFlyerProperties.getInstance().getBoolean("collectIMEI", true);
            String cachedImei = sharedPreferences.getString(IMEI_CACHED_PREF, null);
            String imei = null;
            if (collectIMEI) {
                if (this.isIdCollectionAllowed(context)) {
                    try {
                        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
                        String deviceImei = (String)manager.getClass().getMethod("getDeviceId", new Class[0]).invoke((Object)manager, new Object[0]);
                        if (deviceImei != null) {
                            imei = deviceImei;
                        } else if (userCustomImei != null) {
                            imei = userCustomImei;
                        } else if (cachedImei != null) {
                            imei = cachedImei;
                        }
                    }
                    catch (Exception e) {
                        AFLogger.afLog("WARNING: READ_PHONE_STATE is missing");
                    }
                } else if (userCustomImei != null) {
                    imei = userCustomImei;
                }
            } else if (userCustomImei != null) {
                imei = userCustomImei;
            }
            if (imei != null) {
                this.saveDataToSharedPreferences(context, IMEI_CACHED_PREF, imei);
                params.put("imei", imei);
            } else {
                AFLogger.afLog("IMEI was not collected.");
            }
            boolean collectAndroidId = AppsFlyerProperties.getInstance().getBoolean("collectAndroidId", true);
            String cachedAndroidId = sharedPreferences.getString(ANDROID_ID_CACHED_PREF, null);
            String androidId = null;
            if (collectAndroidId) {
                if (this.isIdCollectionAllowed(context)) {
                    try {
                        String deviceAndroidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                        if (deviceAndroidId != null) {
                            androidId = deviceAndroidId;
                        } else if (userCustomAndroidId != null) {
                            androidId = userCustomAndroidId;
                        } else if (cachedAndroidId != null) {
                            androidId = cachedAndroidId;
                        }
                    }
                    catch (Exception exception) {}
                } else if (userCustomAndroidId != null) {
                    androidId = userCustomAndroidId;
                }
            } else if (userCustomAndroidId != null) {
                androidId = userCustomAndroidId;
            }
            if (androidId != null) {
                this.saveDataToSharedPreferences(context, ANDROID_ID_CACHED_PREF, androidId);
                params.put("android_id", androidId);
            } else {
                AFLogger.afLog("Android ID was not collected.");
            }
        }
    }

    private boolean isIdCollectionAllowed(Context context) {
        return Build.VERSION.SDK_INT < 19 || !this.isGooglePlayServicesAvailable(context);
    }

    private boolean isAppsFlyerFirstLaunch(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        return !sharedPreferences.contains(AF_COUNTER_PREF);
    }

    private String getCachedStore(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        if (sharedPreferences.contains(INSTALL_STORE_PREF)) {
            return sharedPreferences.getString(INSTALL_STORE_PREF, null);
        }
        boolean isFirstLaunch = this.isAppsFlyerFirstLaunch(context);
        String store = isFirstLaunch ? this.getCurrentStore(context) : null;
        this.saveDataToSharedPreferences(context, INSTALL_STORE_PREF, store);
        return store;
    }

    private String getCurrentStore(Context context) {
        try {
            Object storeObj;
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = applicationInfo.metaData;
            if (bundle != null && (storeObj = bundle.get("AF_STORE")) != null) {
                return storeObj instanceof String ? (String)storeObj : storeObj.toString();
            }
        }
        catch (Exception e) {
            AFLogger.afLogE("Could not find AF_STORE value in the manifest", e);
        }
        return null;
    }

    private String getPreInstallName(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        if (sharedPreferences.contains(PRE_INSTALL_PREF)) {
            return sharedPreferences.getString(PRE_INSTALL_PREF, null);
        }
        boolean isFirstLaunch = this.isAppsFlyerFirstLaunch(context);
        String preInstallProviderName = null;
        if (isFirstLaunch) {
            try {
                Object storeObj;
                ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                Bundle bundle = applicationInfo.metaData;
                if (bundle != null && (storeObj = bundle.get("AF_PRE_INSTALL_NAME")) != null) {
                    preInstallProviderName = storeObj instanceof String ? (String)storeObj : storeObj.toString();
                }
            }
            catch (Exception e) {
                AFLogger.afLogE("Could not find AF_PRE_INSTALL_NAME value in the manifest", e);
            }
        }
        this.saveDataToSharedPreferences(context, PRE_INSTALL_PREF, preInstallProviderName);
        return preInstallProviderName;
    }

    private void checkCache(Context context) {
        if (isDuringCheckCache || System.currentTimeMillis() - lastCacheCheck < 15000L) {
            return;
        }
        if (cacheScheduler != null) {
            return;
        }
        cacheScheduler = Executors.newSingleThreadScheduledExecutor();
        cacheScheduler.schedule(new CachedRequestSender(context), 1L, TimeUnit.SECONDS);
    }

    private String getConfiguredChannel(Context context) {
        String channel = AppsFlyerProperties.getInstance().getString("channel");
        if (channel == null) {
            try {
                Object channelObj;
                ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                Bundle bundle = applicationInfo.metaData;
                if (bundle != null && (channelObj = bundle.get("CHANNEL")) != null) {
                    channel = channelObj instanceof String ? (String)channelObj : channelObj.toString();
                }
            }
            catch (Exception e) {
                AFLogger.afLogE("Could not load CHANNEL value", e);
            }
        }
        return channel;
    }

    public boolean isPreInstalledApp(Context context) {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 0);
            if ((applicationInfo.flags & 1) != 0) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            AFLogger.afLogE("Could not check if app is pre installed", e);
        }
        return false;
    }

    private String getCachedChannel(Context context, String currentChannel) throws PackageManager.NameNotFoundException {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        if (sharedPreferences.contains(CACHED_CHANNEL_PREF)) {
            return sharedPreferences.getString(CACHED_CHANNEL_PREF, null);
        }
        this.saveDataToSharedPreferences(context, CACHED_CHANNEL_PREF, currentChannel);
        return currentChannel;
    }

    private String getFirstInstallDate(SimpleDateFormat dateFormat, Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        String firstLaunchDate = sharedPreferences.getString(FIRST_INSTALL_PREF, null);
        if (firstLaunchDate == null) {
            if (this.isAppsFlyerFirstLaunch(context)) {
                AFLogger.afDebugLog("AppsFlyer: first launch detected");
                firstLaunchDate = dateFormat.format(new Date());
            } else {
                firstLaunchDate = "";
            }
            this.saveDataToSharedPreferences(context, FIRST_INSTALL_PREF, firstLaunchDate);
        }
        AFLogger.afLog("AppsFlyer: first launch date: " + firstLaunchDate);
        return firstLaunchDate;
    }

    private void addAdvertiserIDData(Context context, Map<String, String> params) {
        String gaidError;
        boolean advertisingIdWithGps;
        String advertisingIdEnabled;
        String advertisingId;
        block13: {
            advertisingId = null;
            advertisingIdEnabled = null;
            advertisingIdWithGps = false;
            gaidError = null;
            try {
                Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
                AdvertisingIdClient.Info gpsAdInfo = com.google.android.gms.ads.identifier.AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
                if (gpsAdInfo != null) {
                    advertisingId = gpsAdInfo.getId();
                    advertisingIdEnabled = Boolean.toString(!gpsAdInfo.isLimitAdTrackingEnabled());
                    advertisingIdWithGps = true;
                    if (advertisingId == null || advertisingId.length() == 0) {
                        gaidError = "emptyOrNull";
                    }
                } else {
                    gaidError = "gpsAdInfo-null";
                }
            }
            catch (ClassNotFoundException e) {
                AFLogger.afLog("WARNING: Google Play services SDK jar is missing.");
                if (!AppsFlyerProperties.getInstance().getBoolean("enableGpsFallback", true)) break block13;
                try {
                    AdvertisingIdClient.AdInfo internalAdInfo = AdvertisingIdClient.getAdvertisingIdInfo(context);
                    if (internalAdInfo != null) {
                        advertisingId = internalAdInfo.getId();
                        advertisingIdEnabled = Boolean.toString(!internalAdInfo.isLimitAdTrackingEnabled());
                    }
                }
                catch (Exception e1) {
                    this.debugAction("GAID", "\tgot error: " + e1.getMessage(), context);
                }
            }
            catch (Exception e) {
                gaidError = e.getClass().getSimpleName();
                advertisingId = AppsFlyerProperties.getInstance().getString("advertiserId");
                advertisingIdEnabled = AppsFlyerProperties.getInstance().getString("advertiserIdEnabled");
                if (e.getLocalizedMessage() != null) {
                    AFLogger.afLog(e.getLocalizedMessage());
                } else {
                    AFLogger.afLog(e.toString());
                }
                this.debugAction("Could not fetch advertiser id: ", e.getLocalizedMessage(), context);
            }
        }
        if (gaidError != null) {
            params.put("gaidError", gaidError);
        }
        if (advertisingId != null && advertisingIdEnabled != null) {
            params.put("advertiserId", advertisingId);
            params.put("advertiserIdEnabled", advertisingIdEnabled);
            AppsFlyerProperties.getInstance().set("advertiserId", advertisingId);
            AppsFlyerProperties.getInstance().set("advertiserIdEnabled", advertisingIdEnabled);
            params.put("isGaidWithGps", String.valueOf(advertisingIdWithGps));
        }
    }

    private void checkPlatform(Context context, Map<String, String> params) {
        String sClassName = "com.unity3d.player.UnityPlayer";
        try {
            Class<?> classToInvestigate = Class.forName(sClassName);
            params.put("platformextension", "android_unity");
        }
        catch (ClassNotFoundException e) {
            params.put("platformextension", "android_native");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttributionId(ContentResolver contentResolver) {
        String[] projection = new String[]{ATTRIBUTION_ID_COLUMN_NAME};
        Cursor cursor = contentResolver.query(Uri.parse((String)ATTRIBUTION_ID_CONTENT_URI), projection, null, null, null);
        String attributionId = null;
        try {
            if (cursor == null || !cursor.moveToFirst()) {
                String string = null;
                return string;
            }
            attributionId = cursor.getString(cursor.getColumnIndex(ATTRIBUTION_ID_COLUMN_NAME));
        }
        catch (Exception e) {
            AFLogger.afWarnLog("Could not collect cursor attribution" + e);
        }
        finally {
            try {
                if (cursor != null) {
                    cursor.close();
                }
            }
            catch (Exception exception) {}
        }
        return attributionId;
    }

    private int getCounter(Context context, String parameterName, boolean isIncrease) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        int counter = sharedPreferences.getInt(parameterName, 0);
        if (isIncrease) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putInt(parameterName, ++counter);
            this.editorCommit(editor);
        }
        return counter;
    }

    private long getTimePassedSinceLastLaunch(Context context, boolean shouldSave) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        long lastLaunchTime = sharedPreferences.getLong(AF_TIME_PASSED_SINCE_LAST_LAUNCH, 0L);
        long currentTime = System.currentTimeMillis();
        long timeInterval = lastLaunchTime > 0L ? currentTime - lastLaunchTime : -1L;
        if (shouldSave) {
            this.saveLongToSharedPreferences(context, AF_TIME_PASSED_SINCE_LAST_LAUNCH, currentTime);
        }
        return timeInterval / 1000L;
    }

    public String getUniquePsuedoID() {
        String m_szDevIDShort = "35" + Build.BOARD.length() % 10 + Build.BRAND.length() % 10 + Build.CPU_ABI.length() % 10 + Build.DEVICE.length() % 10 + Build.MANUFACTURER.length() % 10 + Build.MODEL.length() % 10 + Build.PRODUCT.length() % 10;
        String serial = null;
        try {
            serial = Build.class.getField("SERIAL").get(null).toString();
            return new UUID(m_szDevIDShort.hashCode(), serial.hashCode()).toString();
        }
        catch (Exception exception) {
            serial = "serial";
            return new UUID(m_szDevIDShort.hashCode(), serial.hashCode()).toString();
        }
    }

    private String getNetwork(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        if (activeNetwork != null) {
            if (activeNetwork.getType() == 1) {
                return "WIFI";
            }
            if (activeNetwork.getType() == 0) {
                return "MOBILE";
            }
        }
        return "unknown";
    }

    public String getAppsFlyerUID(Context context) {
        return Installation.id(context);
    }

    private void sendRequestToServer(String urlString, String postDataString, String afDevKey, WeakReference<Context> ctxReference, String cacheKey, boolean shouldRequestConversion) throws IOException {
        URL url = new URL(urlString);
        AFLogger.afLog("url: " + url.toString());
        this.debugAction(CALL_SERVER_ACTION, "\n" + url.toString() + "\nPOST:" + postDataString, (Context)ctxReference.get());
        LogMessages.logMessageMaskKey("data: " + postDataString);
        this.monitor((Context)ctxReference.get(), LOG_TAG, "EVENT_DATA", postDataString);
        try {
            this.callServer(url, postDataString, afDevKey, ctxReference, cacheKey, shouldRequestConversion);
        }
        catch (IOException e) {
            boolean useHttpFallback = AppsFlyerProperties.getInstance().getBoolean("useHttpFallback", false);
            if (useHttpFallback) {
                this.debugAction("https failed: " + e.getLocalizedMessage(), "", (Context)ctxReference.get());
                this.callServer(new URL(urlString.replace("https:", "http:")), postDataString, afDevKey, ctxReference, cacheKey, shouldRequestConversion);
            }
            AFLogger.afLog("failed to send requeset to server. " + e.getLocalizedMessage());
            this.monitor((Context)ctxReference.get(), LOG_TAG, "ERROR", e.getLocalizedMessage());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callServer(URL url, String postData, String appsFlyerDevKey, WeakReference<Context> ctxReference, String cacheKey, boolean shouldRequestConversion) throws IOException {
        block18: {
            Context context = (Context)ctxReference.get();
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                int contentLength = postData.getBytes().length;
                connection.setRequestProperty("Content-Length", contentLength + "");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setConnectTimeout(10000);
                connection.setDoOutput(true);
                try (OutputStreamWriter out = null;){
                    out = new OutputStreamWriter(connection.getOutputStream());
                    out.write(postData);
                }
                int statusCode = connection.getResponseCode();
                AFLogger.afLogM("response code: " + statusCode);
                this.monitor(context, LOG_TAG, "SERVER_RESPONSE_CODE", Integer.toString(statusCode));
                this.debugAction(SERVER_RESPONDED_ACTION, Integer.toString(statusCode), context);
                SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
                if (statusCode == 200) {
                    if (cacheKey != null) {
                        CacheManager.getInstance().deleteRequest(cacheKey, context);
                    }
                    if (ctxReference.get() != null && cacheKey == null) {
                        this.saveDataToSharedPreferences(context, SENT_SUCCESSFULLY_PREF, "true");
                        this.checkCache(context);
                    }
                }
                int retries = sharedPreferences.getInt(CONVERSION_REQUEST_RETRIES, 0);
                long conversionDataCachedExpiration = sharedPreferences.getLong(CONVERSION_DATA_CACHE_EXPIRATION, 0L);
                if (conversionDataCachedExpiration != 0L && System.currentTimeMillis() - conversionDataCachedExpiration > 5184000000L) {
                    this.saveDataToSharedPreferences(context, ATTRIBUTION_ID_PREF, null);
                    this.saveLongToSharedPreferences(context, CONVERSION_DATA_CACHE_EXPIRATION, 0L);
                }
                if (sharedPreferences.getString(ATTRIBUTION_ID_PREF, null) == null && appsFlyerDevKey != null && shouldRequestConversion && conversionDataListener != null && retries <= 5) {
                    ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
                    scheduler.schedule(new InstallAttributionIdFetcher(context.getApplicationContext(), appsFlyerDevKey, scheduler), 10L, TimeUnit.MILLISECONDS);
                    break block18;
                }
                if (appsFlyerDevKey == null) {
                    AFLogger.afWarnLog("AppsFlyer dev key is missing.");
                    break block18;
                }
                if (!shouldRequestConversion || conversionDataListener == null || sharedPreferences.getString(ATTRIBUTION_ID_PREF, null) == null || this.getCounter(context, AF_COUNTER_PREF, false) <= 1) break block18;
                try {
                    Map<String, String> conversionData = this.getConversionData(context);
                    if (conversionData != null) {
                        conversionDataListener.onInstallConversionDataLoaded(conversionData);
                    }
                }
                catch (AttributionIDNotReady attributionIDNotReady) {
                    // empty catch block
                }
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
    }

    public void validateAndTrackInAppPurchase(Context context, String publicKey, String signature, String purchaseData, String price, String currency, HashMap<String, String> additionalParameters) {
        AFLogger.afLog("Validate in app called with parameters: " + purchaseData + " " + price + " " + currency);
        if (publicKey == null || price == null || signature == null || currency == null || purchaseData == null) {
            if (validatorListener != null) {
                validatorListener.onValidateInAppFailure("Please provide purchase parameters");
            }
        } else {
            ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
            scheduler.schedule(new AppsFlyerInAppPurchaseValidator(context.getApplicationContext(), this.getProperty("AppsFlyerKey"), publicKey, signature, purchaseData, price, currency, additionalParameters, scheduler), 10L, TimeUnit.MILLISECONDS);
        }
    }

    public String mapToString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder postData = new StringBuilder();
        for (String key : params.keySet()) {
            String value = params.get(key);
            String string = value = value == null ? "" : URLEncoder.encode(value, "UTF-8");
            if (postData.length() > 0) {
                postData.append('&');
            }
            postData.append(key).append('=').append(value);
        }
        return postData.toString();
    }

    static {
        conversionDataListener = null;
        validatorListener = null;
        isDuringCheckCache = false;
        cacheScheduler = null;
        timeInApp = System.currentTimeMillis();
        instance = new AppsFlyerLib();
    }

    private abstract class ValidateInAppPurchase
    implements Runnable {
        protected WeakReference<Context> ctxReference = null;
        private String appsFlyerDevKey;
        private String googlePublicKey;
        private String signature;
        private String purchaseData;
        private String price;
        private String currency;
        private HashMap<String, String> additionalParams;
        private ScheduledExecutorService executorService;

        protected abstract void validateCallback(boolean var1, String var2, String var3, String var4, HashMap<String, String> var5, String var6);

        public abstract String getUrl();

        public ValidateInAppPurchase(Context context, String appsFlyerDevKey, String aPublicKey, String aSignature, String aPurchaseData, String aPrice, String aCurrency, HashMap<String, String> aAdditionalParams, ScheduledExecutorService executorService) {
            this.ctxReference = new WeakReference<Context>(context);
            this.appsFlyerDevKey = appsFlyerDevKey;
            this.googlePublicKey = aPublicKey;
            this.purchaseData = aPurchaseData;
            this.price = aPrice;
            this.currency = aCurrency;
            this.additionalParams = aAdditionalParams;
            this.signature = aSignature;
            this.executorService = executorService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.appsFlyerDevKey == null || this.appsFlyerDevKey.length() == 0) {
                return;
            }
            HttpURLConnection connection = null;
            try {
                String output;
                Context context = (Context)this.ctxReference.get();
                if (context == null) {
                    return;
                }
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("app_id", context.getPackageName());
                parameters.put("dev_key", this.appsFlyerDevKey);
                parameters.put("public-key", this.googlePublicKey);
                parameters.put("sig-data", this.purchaseData);
                parameters.put("signature", this.signature);
                JSONObject requestJsonObject = new JSONObject(parameters);
                String postData = requestJsonObject.toString();
                URL url = new URL(this.getUrl());
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                int contentLength = postData.getBytes().length;
                connection.setRequestProperty("Content-Length", contentLength + "");
                connection.setRequestProperty("Connection", "close");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setConnectTimeout(10000);
                connection.setDoOutput(true);
                try (OutputStreamWriter out = null;){
                    out = new OutputStreamWriter(connection.getOutputStream());
                    out.write(postData);
                }
                int statusCode = connection.getResponseCode();
                BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder sb = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    sb.append(output);
                }
                String str = sb.toString();
                JSONObject responseJsonObject = new JSONObject(str);
                if (statusCode == 200) {
                    AFLogger.afLog("Validate response 200 ok: " + responseJsonObject.toString());
                    boolean validated = responseJsonObject.getBoolean("result");
                    this.validateCallback(validated, this.purchaseData, this.price, this.currency, this.additionalParams, null);
                } else {
                    AFLogger.afLog("Failed Validate request");
                    this.validateCallback(false, this.purchaseData, this.price, this.currency, this.additionalParams, str);
                }
            }
            catch (Throwable t) {
                if (validatorListener != null) {
                    AFLogger.afLog("Failed Validate request + ex = " + t.getMessage());
                    this.validateCallback(false, this.purchaseData, this.price, this.currency, this.additionalParams, t.getMessage());
                }
                AFLogger.afLogE(t.getMessage(), t);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            this.executorService.shutdown();
        }
    }

    private class AppsFlyerInAppPurchaseValidator
    extends ValidateInAppPurchase {
        public AppsFlyerInAppPurchaseValidator(Context context, String appsFlyerDevKey, String pubKey, String purData, String sig, String price, String currency, HashMap<String, String> additionalParams, ScheduledExecutorService executorService) {
            super(context, appsFlyerDevKey, pubKey, purData, sig, price, currency, additionalParams, executorService);
        }

        @Override
        public String getUrl() {
            return AppsFlyerLib.VALIDATE_URL;
        }

        @Override
        protected void validateCallback(boolean validated, String purchaseData, String price, String currency, HashMap<String, String> additionalParams, String error) {
            if (validatorListener != null) {
                AFLogger.afLog("Validate callback parameters: " + purchaseData + " " + price + " " + currency);
                if (error == null) {
                    if (validated) {
                        AFLogger.afLog("Validate in app purchase success");
                        validatorListener.onValidateInApp();
                    } else {
                        AFLogger.afLog("Validate in app purchase failed");
                        validatorListener.onValidateInAppFailure("Failed validating");
                    }
                } else {
                    validatorListener.onValidateInAppFailure(error);
                    AFLogger.afLog("Validate in app purchase failed: error : " + error);
                }
                HashMap<String, Object> eventMap = new HashMap<String, Object>();
                eventMap.put("af_validated", validated);
                eventMap.put("af_param_2", purchaseData);
                eventMap.put("af_revenue", price);
                eventMap.put("af_currency", currency);
                if (additionalParams != null) {
                    eventMap.put("af_param_1", additionalParams);
                }
                AppsFlyerLib.this.trackEvent((Context)this.ctxReference.get(), "af_purchase", eventMap);
            }
        }
    }

    private class CachedRequestSender
    implements Runnable {
        private WeakReference<Context> ctxReference = null;

        public CachedRequestSender(Context context) {
            this.ctxReference = new WeakReference<Context>(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (isDuringCheckCache) {
                return;
            }
            lastCacheCheck = System.currentTimeMillis();
            if (this.ctxReference == null) {
                return;
            }
            isDuringCheckCache = true;
            try {
                String afDevKey = AppsFlyerLib.this.getProperty("AppsFlyerKey");
                WeakReference<Context> weakReference = this.ctxReference;
                synchronized (weakReference) {
                    for (RequestCacheData requestCacheData : CacheManager.getInstance().getCachedRequests((Context)this.ctxReference.get())) {
                        AFLogger.afLog("resending request: " + requestCacheData.getRequestURL());
                        try {
                            long currentTime = System.currentTimeMillis();
                            String cachedTimeString = requestCacheData.getCacheKey();
                            long cachedTime = Long.parseLong(cachedTimeString, 10);
                            AppsFlyerLib.this.sendRequestToServer(requestCacheData.getRequestURL() + AppsFlyerLib.CACHED_URL_PARAMETER + Long.toString((currentTime - cachedTime) / 1000L), requestCacheData.getPostData(), afDevKey, this.ctxReference, requestCacheData.getCacheKey(), false);
                        }
                        catch (Exception e) {
                            AFLogger.afLog("Failed to resend cached request");
                        }
                    }
                }
            }
            catch (Exception e) {
                AFLogger.afLog("failed to check cache.");
            }
            finally {
                isDuringCheckCache = false;
            }
            cacheScheduler.shutdown();
            cacheScheduler = null;
        }
    }

    private abstract class AttributionIdFetcher
    implements Runnable {
        protected WeakReference<Context> ctxReference = null;
        private String appsFlyerDevKey;
        private ScheduledExecutorService executorService;
        private AtomicInteger currentRequestsCounter = new AtomicInteger(0);

        protected abstract void attributionCallback(Map<String, String> var1);

        public abstract String getUrl();

        protected abstract void attributionCallbackFailure(String var1, int var2);

        public AttributionIdFetcher(Context context, String appsFlyerDevKey, ScheduledExecutorService executorService) {
            this.ctxReference = new WeakReference<Context>(context);
            this.appsFlyerDevKey = appsFlyerDevKey;
            this.executorService = executorService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block25: {
                if (this.appsFlyerDevKey == null || this.appsFlyerDevKey.length() == 0) {
                    return;
                }
                this.currentRequestsCounter.incrementAndGet();
                HttpURLConnection connection = null;
                try {
                    Context context = (Context)this.ctxReference.get();
                    if (context == null) {
                        return;
                    }
                    long now = System.currentTimeMillis();
                    String channel = AppsFlyerLib.this.getCachedChannel(context, AppsFlyerLib.this.getConfiguredChannel(context));
                    String channelPostfix = "";
                    if (channel != null) {
                        channelPostfix = "-" + channel;
                    }
                    StringBuilder urlString = new StringBuilder().append(this.getUrl()).append(context.getPackageName()).append(channelPostfix).append("?devkey=").append(this.appsFlyerDevKey).append("&device_id=").append(AppsFlyerLib.this.getAppsFlyerUID(context));
                    LogMessages.logMessageMaskKey("Calling server for attribution url: " + urlString.toString());
                    connection = (HttpURLConnection)new URL(urlString.toString()).openConnection();
                    connection.setRequestMethod("GET");
                    connection.setConnectTimeout(10000);
                    connection.setRequestProperty("Connection", "close");
                    connection.connect();
                    if (connection.getResponseCode() == 200) {
                        Map<String, String> conversionData;
                        String conversionJsonString;
                        long responseTime = System.currentTimeMillis();
                        AppsFlyerLib.this.saveLongToSharedPreferences(context, AppsFlyerLib.GET_CONVERSION_DATA_TIME, (responseTime - now) / 1000L);
                        BufferedReader reader = null;
                        StringBuilder stringBuilder = new StringBuilder();
                        InputStreamReader inputStreamReader = null;
                        try {
                            inputStreamReader = new InputStreamReader(connection.getInputStream());
                            reader = new BufferedReader(inputStreamReader);
                            String line = null;
                            while ((line = reader.readLine()) != null) {
                                stringBuilder.append(line).append('\n');
                            }
                        }
                        finally {
                            if (reader != null) {
                                reader.close();
                            }
                            if (inputStreamReader != null) {
                                inputStreamReader.close();
                            }
                        }
                        LogMessages.logMessageMaskKey("Attribution data: " + stringBuilder.toString());
                        if (stringBuilder.length() <= 0 || context == null) break block25;
                        Map<String, String> conversionDataMap = AppsFlyerLib.this.attributionStringToMap(stringBuilder.toString());
                        String isCache = (String)conversionDataMap.get("iscache");
                        if (isCache != null && "false".equals(isCache)) {
                            AppsFlyerLib.this.saveLongToSharedPreferences(context, AppsFlyerLib.CONVERSION_DATA_CACHE_EXPIRATION, System.currentTimeMillis());
                        }
                        if ((conversionJsonString = new JSONObject((Map)conversionDataMap).toString()) != null) {
                            AppsFlyerLib.this.saveDataToSharedPreferences(context, AppsFlyerLib.ATTRIBUTION_ID_PREF, conversionJsonString);
                        } else {
                            AppsFlyerLib.this.saveDataToSharedPreferences(context, AppsFlyerLib.ATTRIBUTION_ID_PREF, stringBuilder.toString());
                        }
                        AFLogger.afDebugLog("iscache=" + isCache + " caching conversion data");
                        if (conversionDataListener == null || this.currentRequestsCounter.intValue() > 1) break block25;
                        try {
                            conversionData = AppsFlyerLib.this.getConversionData(context);
                        }
                        catch (AttributionIDNotReady ae) {
                            conversionData = conversionDataMap;
                        }
                        this.attributionCallback(conversionData);
                        break block25;
                    }
                    if (conversionDataListener != null) {
                        this.attributionCallbackFailure("Error connection to server: " + connection.getResponseCode(), connection.getResponseCode());
                    }
                    LogMessages.logMessageMaskKey("AttributionIdFetcher response code: " + connection.getResponseCode() + "  url: " + urlString);
                }
                catch (Throwable t) {
                    if (conversionDataListener != null) {
                        this.attributionCallbackFailure(t.getMessage(), 0);
                    }
                    AFLogger.afLogE(t.getMessage(), t);
                }
                finally {
                    this.currentRequestsCounter.decrementAndGet();
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            }
            this.executorService.shutdown();
        }
    }

    private class InstallAttributionIdFetcher
    extends AttributionIdFetcher {
        public InstallAttributionIdFetcher(Context context, String appsFlyerDevKey, ScheduledExecutorService executorService) {
            super(context, appsFlyerDevKey, executorService);
        }

        @Override
        public String getUrl() {
            return AppsFlyerLib.CONVERSION_DATA_URL;
        }

        @Override
        protected void attributionCallback(Map<String, String> conversionData) {
            conversionDataListener.onInstallConversionDataLoaded(conversionData);
            SharedPreferences sharedPreferences = ((Context)this.ctxReference.get()).getSharedPreferences(AppsFlyerLib.AF_SHARED_PREF, 0);
            AppsFlyerLib.this.saveIntegerToSharedPreferences((Context)this.ctxReference.get(), AppsFlyerLib.CONVERSION_REQUEST_RETRIES, 0);
        }

        @Override
        protected void attributionCallbackFailure(String error, int responseCode) {
            conversionDataListener.onInstallConversionFailure(error);
            if (responseCode >= 400 && responseCode < 500) {
                SharedPreferences sharedPreferences = ((Context)this.ctxReference.get()).getSharedPreferences(AppsFlyerLib.AF_SHARED_PREF, 0);
                int retries = sharedPreferences.getInt(AppsFlyerLib.CONVERSION_REQUEST_RETRIES, 0);
                AppsFlyerLib.this.saveIntegerToSharedPreferences((Context)this.ctxReference.get(), AppsFlyerLib.CONVERSION_REQUEST_RETRIES, ++retries);
            }
        }
    }

    private class SendToServerRunnable
    implements Runnable {
        private String urlString;
        private WeakReference<Context> ctxReference = null;
        Map<String, String> params;
        boolean isLaunch;

        private SendToServerRunnable(String urlString, Map<String, String> params, Context ctx, boolean isLaunch) {
            this.urlString = urlString;
            this.params = params;
            this.ctxReference = new WeakReference<Context>(ctx);
            this.isLaunch = isLaunch;
        }

        @Override
        public void run() {
            String postDataString = null;
            try {
                Context context = (Context)this.ctxReference.get();
                boolean sentSuccessfully = false;
                if (context != null) {
                    String referrer = AppsFlyerProperties.getInstance().getReferrer(context);
                    if (referrer != null && referrer.length() > 0 && this.params.get(AppsFlyerLib.REFERRER_PREF) == null) {
                        this.params.put(AppsFlyerLib.REFERRER_PREF, referrer);
                    }
                    SharedPreferences sharedPreferences = context.getSharedPreferences(AppsFlyerLib.AF_SHARED_PREF, 0);
                    sentSuccessfully = "true".equals(sharedPreferences.getString(AppsFlyerLib.SENT_SUCCESSFULLY_PREF, ""));
                    String eventName = this.params.get("eventName");
                    int counter = AppsFlyerLib.this.getCounter(context, AppsFlyerLib.AF_COUNTER_PREF, eventName == null);
                    this.params.put("counter", Integer.toString(counter));
                    this.params.put("iaecounter", Integer.toString(AppsFlyerLib.this.getCounter(context, AppsFlyerLib.AF_EVENT_COUNTER_PREF, eventName != null)));
                    this.params.put("timepassedsincelastlaunch", Long.toString(AppsFlyerLib.this.getTimePassedSinceLastLaunch(context, true)));
                    if (this.isLaunch && counter == 1) {
                        AppsFlyerProperties.getInstance().setFirstLaunchCalled();
                    }
                }
                this.params.put("isFirstCall", Boolean.toString(!sentSuccessfully));
                String afDevKey = this.params.get("appsflyerKey");
                if (afDevKey == null || afDevKey.length() == 0) {
                    AFLogger.afDebugLog("Not sending data yet, waiting for dev key");
                    return;
                }
                String hash = new HashUtils().getHashCode(this.params);
                this.params.put("af_v", hash);
                postDataString = new JSONObject(this.params).toString();
                AppsFlyerLib.this.sendRequestToServer(this.urlString, postDataString, afDevKey, this.ctxReference, null, this.isLaunch && conversionDataListener != null);
            }
            catch (IOException t) {
                if (postDataString != null && this.ctxReference != null && !this.urlString.contains(AppsFlyerLib.CACHED_URL_PARAMETER)) {
                    AFLogger.afLogE(t.getMessage(), t);
                    CacheManager.getInstance().cacheRequest(new RequestCacheData(this.urlString, postDataString, SDK_BUILD_NUMBER), (Context)this.ctxReference.get());
                }
            }
            catch (Throwable t) {
                AFLogger.afLogE(t.getMessage(), t);
            }
        }
    }

    private class DataCollector
    implements Runnable {
        private Context context;
        private String appsFlyerKey;
        private String eventName;
        private String eventValue;
        private String referrer;
        private ExecutorService executor;
        private boolean isNewAPI;

        private DataCollector(Context context, String appsFlyerKey, String eventName, String eventValue, String referrer, boolean useNewAPI, ExecutorService executorService) {
            this.context = context;
            this.appsFlyerKey = appsFlyerKey;
            this.eventName = eventName;
            this.eventValue = eventValue;
            this.referrer = referrer;
            this.isNewAPI = useNewAPI;
            this.executor = executorService;
        }

        @Override
        public void run() {
            AppsFlyerLib.this.sendTrackingWithEvent(this.context, this.appsFlyerKey, this.eventName, this.eventValue, this.referrer, this.isNewAPI);
            this.executor.shutdown();
        }
    }
}

