package com.appsflyer;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;
import java.util.UUID;

/**
 * Created by IntelliJ IDEA.
 * User: gil
 * Date: 7/31/12
 * Time: 12:17 PM
 * To change this template use File | Settings | File Templates.
 */
public class Installation {
    private static String sID = null;
    private static final String INSTALLATION = "AF_INSTALLATION";

    public synchronized static String id(Context context) {
        if (sID == null) {
            String tmpSId = readInstallationSP(context);
            if (tmpSId != null) {
                sID = tmpSId;
            } else {
                File installation = new File(context.getFilesDir(), INSTALLATION);
                try {
                    if (!installation.exists()) {
                        sID = generateId(context);
                    } else {
                        sID = readInstallationFile(installation);
                        installation.delete(); // remove the old file since it won't be in use anymore
                    }
                    writeInstallationSP(context,sID);
                } catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return sID;
    }

    private static String readInstallationFile(File installation) throws IOException {
        RandomAccessFile f = new RandomAccessFile(installation, "r");
        byte[] bytes = new byte[(int) f.length()];
        f.readFully(bytes);
        f.close();
        return new String(bytes);
    }

    private static void writeInstallationFile(File installation,Context context) throws IOException, PackageManager.NameNotFoundException {
        FileOutputStream out = new FileOutputStream(installation);
        String id = generateId(context);
        out.write(id.getBytes());
        out.close();
    }

    private static String generateId(Context context) throws PackageManager.NameNotFoundException {

        PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        String id;
        if (android.os.Build.VERSION.SDK_INT >= 9 ){
            id = packageInfo.firstInstallTime+"-"+Math.abs(new Random().nextLong()); // for organic in app events
        } else {
            id = UUID.randomUUID().toString();
        }
        return id;
    }

    private static String readInstallationSP(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AppsFlyerLib.AF_SHARED_PREF, Context.MODE_PRIVATE);
        return sharedPreferences.getString(INSTALLATION,null);
    }

    private static void writeInstallationSP(Context context) throws PackageManager.NameNotFoundException {
        writeInstallationSP(context, generateId(context));
    }

    private static void writeInstallationSP(Context context, String sId) throws PackageManager.NameNotFoundException {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AppsFlyerLib.AF_SHARED_PREF, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(INSTALLATION,sId);
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.GINGERBREAD) {
            editor.apply();
        } else {
            editor.commit();
        }
    }
}
