/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.cache;

import android.content.Context;
import android.util.Log;
import com.appsflyer.cache.RequestCacheData;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class CacheManager {
    public static final int CACHE_MAX_SIZE = 40;
    public static final String AF_CACHE_DIR = "AFRequestCache";
    private static CacheManager \u0971 = new CacheManager();

    private CacheManager() {
    }

    public static CacheManager getInstance() {
        return \u0971;
    }

    public void init(Context context) {
        try {
            Context context2 = context;
            if (!new File(context2.getFilesDir(), AF_CACHE_DIR).exists()) {
                context2 = context;
                new File(context2.getFilesDir(), AF_CACHE_DIR).mkdir();
            }
            return;
        }
        catch (Exception exception) {
            Log.i((String)"AppsFlyer_4.10.0", (String)"Could not create cache directory");
            return;
        }
    }

    /*
     * Loose catch block
     */
    public void cacheRequest(RequestCacheData requestCacheData, Context context) {
        Writer writer = null;
        Context context2 = context;
        File file = new File(context2.getFilesDir(), AF_CACHE_DIR);
        if (!file.exists()) {
            file.mkdir();
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length > 40) {
            Log.i((String)"AppsFlyer_4.10.0", (String)"reached cache limit, not caching request");
            return;
        }
        Log.i((String)"AppsFlyer_4.10.0", (String)"caching request...");
        context2 = context;
        File file2 = new File(new File(context2.getFilesDir(), AF_CACHE_DIR), Long.toString(System.currentTimeMillis()));
        file2.createNewFile();
        writer = new OutputStreamWriter(new FileOutputStream(file2.getPath(), true));
        writer.write("version=");
        writer.write(requestCacheData.getVersion());
        writer.write(10);
        writer.write("url=");
        writer.write(requestCacheData.getRequestURL());
        writer.write(10);
        writer.write("data=");
        writer.write(requestCacheData.getPostData());
        writer.write(10);
        writer.flush();
        try {
            writer.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (Exception exception) {
            try {
                Log.i((String)"AppsFlyer_4.10.0", (String)"Could not cache request");
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (writer != null) {
                    writer.close();
                }
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    public List<RequestCacheData> getCachedRequests(Context context) {
        ArrayList<RequestCacheData> arrayList = new ArrayList<RequestCacheData>();
        try {
            Context context2 = context;
            File file = new File(context2.getFilesDir(), AF_CACHE_DIR);
            if (!file.exists()) {
                file.mkdir();
            } else {
                for (File file2 : file.listFiles()) {
                    Log.i((String)"AppsFlyer_4.10.0", (String)("Found cached request" + file2.getName()));
                    arrayList.add(CacheManager.\u0971(file2));
                }
            }
        }
        catch (Exception exception) {
            Log.i((String)"AppsFlyer_4.10.0", (String)"Could not cache request");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static RequestCacheData \u0971(File file) {
        RequestCacheData requestCacheData2;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            char[] cArray = new char[(int)file.length()];
            fileReader.read(cArray);
            RequestCacheData requestCacheData = new RequestCacheData(cArray);
            requestCacheData.setCacheKey(file.getName());
            requestCacheData2 = requestCacheData;
        }
        catch (Exception exception) {
            try {
                if (fileReader == null) return null;
                ((Reader)fileReader).close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
        catch (Throwable throwable) {
            try {
                if (fileReader == null) throw throwable;
                ((Reader)fileReader).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((Reader)fileReader).close();
            return requestCacheData2;
        }
        catch (IOException iOException) {}
        return requestCacheData2;
    }

    public void deleteRequest(String string, Context context) {
        Context context2 = context;
        File file = new File(context2.getFilesDir(), AF_CACHE_DIR);
        File file2 = new File(file, string);
        Log.i((String)"AppsFlyer_4.10.0", (String)("Deleting " + string + " from cache"));
        if (file2.exists()) {
            try {
                file2.delete();
                return;
            }
            catch (Exception exception) {
                Log.i((String)"AppsFlyer_4.10.0", (String)("Could not delete " + string + " from cache"), (Throwable)exception);
            }
        }
    }

    public void clearCache(Context context) {
        try {
            Context context2 = context;
            File file = new File(context2.getFilesDir(), AF_CACHE_DIR);
            if (!file.exists()) {
                file.mkdir();
                return;
            }
            for (File file2 : file.listFiles()) {
                Log.i((String)"AppsFlyer_4.10.0", (String)("Found cached request" + file2.getName()));
                this.deleteRequest(CacheManager.\u0971(file2).getCacheKey(), context);
            }
            return;
        }
        catch (Exception exception) {
            Log.i((String)"AppsFlyer_4.10.0", (String)"Could not cache request");
            return;
        }
    }
}

