/*
 * Decompiled with CFR 0.152.
 */
package widowmaker110.logger;

import android.os.AsyncTask;
import android.os.Debug;
import android.util.Log;
import java.util.Arrays;

public class Logger {
    protected static boolean DEBUGMODE;
    protected static int messageLogLevel;
    protected static int errorLogLevel;
    protected static int infoLogLevel;
    protected static int warningLogLevel;
    protected static int verboseLogLevel;
    protected static int printlnLogLevel;
    protected static int wtfLogLevel;
    protected static String GenericTag;
    protected String[] protectedMethodNames = new String[]{"message", "error", "info", "warning", "verbose", "println", "wtf"};

    public Logger() {
        DEBUGMODE = Debug.isDebuggerConnected();
    }

    public String getCallingFunction(StackTraceElement[] elements) {
        String returningValue = "";
        for (int index = 0; index < elements.length - 1; ++index) {
            String tempValue = elements[index].getMethodName();
            if (!Arrays.asList(this.protectedMethodNames).contains(tempValue)) continue;
            returningValue = elements[index + 1].getMethodName();
        }
        return returningValue;
    }

    public String getCallingFile(StackTraceElement[] elements) {
        String returningValue = "";
        for (int index = 0; index < elements.length - 1; ++index) {
            String tempValue = elements[index].getMethodName();
            if (!Arrays.asList(this.protectedMethodNames).contains(tempValue)) continue;
            returningValue = elements[index + 1].getFileName();
        }
        return returningValue;
    }

    public void message(String Message) {
        if (DEBUGMODE) {
            StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
            new PrintOperation(messageLogLevel, this.getCallingFile(stacktrace) + " - " + this.getCallingFunction(stacktrace), Message).execute(new Void[0]);
        }
    }

    public void message(String Tag, String Message) {
        if (DEBUGMODE) {
            new PrintOperation(messageLogLevel, Tag, Message).execute(new Void[0]);
        }
    }

    public void message(String Message, Throwable Exception) {
        if (DEBUGMODE) {
            StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
            new PrintOperation(messageLogLevel, this.getCallingFile(stacktrace) + " - " + this.getCallingFunction(stacktrace), Message, Exception).execute(new Void[0]);
        }
    }

    public void message(String Tag, String Message, Throwable Exception) {
        if (DEBUGMODE) {
            new PrintOperation(messageLogLevel, Tag, Message, Exception).execute(new Void[0]);
        }
    }

    public void error(String Message) {
        if (DEBUGMODE) {
            StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
            new PrintOperation(errorLogLevel, this.getCallingFile(stacktrace) + " - " + this.getCallingFunction(stacktrace), Message).execute(new Void[0]);
        }
    }

    public void error(String Tag, String Message) {
        if (DEBUGMODE) {
            new PrintOperation(errorLogLevel, Tag, Message).execute(new Void[0]);
        }
    }

    public void error(String Message, Throwable Exception) {
        if (DEBUGMODE) {
            StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
            new PrintOperation(errorLogLevel, this.getCallingFile(stacktrace) + " - " + this.getCallingFunction(stacktrace), Message, Exception).execute(new Void[0]);
        }
    }

    public void error(String Tag, String Message, Throwable Exception) {
        if (DEBUGMODE) {
            new PrintOperation(errorLogLevel, Tag, Message, Exception).execute(new Void[0]);
        }
    }

    public void info(String Message) {
        if (DEBUGMODE) {
            StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
            new PrintOperation(infoLogLevel, this.getCallingFile(stacktrace) + " - " + this.getCallingFunction(stacktrace), Message).execute(new Void[0]);
        }
    }

    public void info(String Tag, String Message) {
        if (DEBUGMODE) {
            new PrintOperation(infoLogLevel, Tag, Message).execute(new Void[0]);
        }
    }

    public void info(String Message, Throwable Exception) {
        if (DEBUGMODE) {
            StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
            new PrintOperation(infoLogLevel, this.getCallingFile(stacktrace) + " - " + this.getCallingFunction(stacktrace), Message, Exception).execute(new Void[0]);
        }
    }

    public void info(String Tag, String Message, Throwable Exception) {
        if (DEBUGMODE) {
            new PrintOperation(infoLogLevel, Tag, Message, Exception).execute(new Void[0]);
        }
    }

    public void warning(String Message) {
        if (DEBUGMODE) {
            StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
            new PrintOperation(warningLogLevel, this.getCallingFile(stacktrace) + " - " + this.getCallingFunction(stacktrace), Message).execute(new Void[0]);
        }
    }

    public void warning(String Tag, String Message) {
        if (DEBUGMODE) {
            new PrintOperation(warningLogLevel, Tag, Message).execute(new Void[0]);
        }
    }

    public void warning(String Message, Throwable Exception) {
        if (DEBUGMODE) {
            StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
            new PrintOperation(warningLogLevel, this.getCallingFile(stacktrace) + " - " + this.getCallingFunction(stacktrace), Message, Exception).execute(new Void[0]);
        }
    }

    public void warning(String Tag, String Message, Throwable Exception) {
        if (DEBUGMODE) {
            new PrintOperation(warningLogLevel, Tag, Message, Exception).execute(new Void[0]);
        }
    }

    public void verbose(String Message) {
        if (DEBUGMODE) {
            StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
            new PrintOperation(verboseLogLevel, this.getCallingFile(stacktrace) + " - " + this.getCallingFunction(stacktrace), Message).execute(new Void[0]);
        }
    }

    public void verbose(String Tag, String Message) {
        if (DEBUGMODE) {
            new PrintOperation(verboseLogLevel, Tag, Message).execute(new Void[0]);
        }
    }

    public void verbose(String Message, Throwable Exception) {
        if (DEBUGMODE) {
            StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
            new PrintOperation(verboseLogLevel, this.getCallingFile(stacktrace) + " - " + this.getCallingFunction(stacktrace), Message, Exception).execute(new Void[0]);
        }
    }

    public void verbose(String Tag, String Message, Throwable Exception) {
        if (DEBUGMODE) {
            new PrintOperation(verboseLogLevel, Tag, Message, Exception).execute(new Void[0]);
        }
    }

    public void println(int Priority, String Message) {
        if (DEBUGMODE) {
            StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
            new PrintOperation(printlnLogLevel, Priority, this.getCallingFile(stacktrace) + " - " + this.getCallingFunction(stacktrace), Message).execute(new Void[0]);
        }
    }

    public void println(int Priority, String Tag, String Message) {
        if (DEBUGMODE) {
            new PrintOperation(printlnLogLevel, Priority, Tag, Message).execute(new Void[0]);
        }
    }

    public void println(int Priority, String Tag, String Message, Throwable Exception) {
        if (DEBUGMODE) {
            new PrintOperation(printlnLogLevel, Priority, Tag, Message, Exception).execute(new Void[0]);
        }
    }

    static {
        messageLogLevel = 1;
        errorLogLevel = 2;
        infoLogLevel = 3;
        warningLogLevel = 4;
        verboseLogLevel = 5;
        printlnLogLevel = 6;
        wtfLogLevel = 7;
        GenericTag = "LoggerTag";
    }

    protected static class PrintOperation
    extends AsyncTask<Void, Void, Void> {
        private int loggingLevel;
        private String Tag;
        private String Message;
        private Throwable Exception;
        private int Priority;

        public PrintOperation() {
        }

        public PrintOperation(int loggingLevelParam, String MessageParam) {
            this.loggingLevel = loggingLevelParam;
            this.Message = MessageParam;
        }

        public PrintOperation(int loggingLevelParam, String TagParam, String MessageParam) {
            this.loggingLevel = loggingLevelParam;
            this.Tag = TagParam;
            this.Message = MessageParam;
        }

        public PrintOperation(int loggingLevelParam, int PriorityParam, String MessageParam) {
            this.loggingLevel = loggingLevelParam;
            this.Priority = PriorityParam;
            this.Message = MessageParam;
        }

        public PrintOperation(int loggingLevelParam, int PriorityParam, String TagParam, String MessageParam) {
            this.loggingLevel = loggingLevelParam;
            this.Priority = PriorityParam;
            this.Tag = TagParam;
            this.Message = MessageParam;
        }

        public PrintOperation(int loggingLevelParam, int PriorityParam, String TagParam, String MessageParam, Throwable ExceptionParam) {
            this.loggingLevel = loggingLevelParam;
            this.Priority = PriorityParam;
            this.Tag = TagParam;
            this.Message = MessageParam;
            this.Exception = ExceptionParam;
        }

        public PrintOperation(int loggingLevelParam, String MessageParam, Throwable ExceptionParam) {
            this.loggingLevel = loggingLevelParam;
            this.Message = MessageParam;
            this.Exception = ExceptionParam;
        }

        public PrintOperation(int loggingLevelParam, String TagParam, String MessageParam, Throwable ExceptionParam) {
            this.loggingLevel = loggingLevelParam;
            this.Tag = TagParam;
            this.Message = MessageParam;
            this.Exception = ExceptionParam;
        }

        protected void onPreExecute() {
        }

        protected Void doInBackground(Void ... params) {
            if (this.loggingLevel == messageLogLevel) {
                if (this.Tag != null && !this.Tag.isEmpty()) {
                    Log.d((String)this.Tag, (String)this.Message, (Throwable)this.Exception);
                } else {
                    Log.d((String)GenericTag, (String)this.Message, (Throwable)this.Exception);
                }
            } else if (this.loggingLevel == errorLogLevel) {
                if (this.Tag != null && !this.Tag.isEmpty()) {
                    Log.e((String)this.Tag, (String)this.Message, (Throwable)this.Exception);
                } else {
                    Log.e((String)GenericTag, (String)this.Message, (Throwable)this.Exception);
                }
            } else if (this.loggingLevel == infoLogLevel) {
                if (this.Tag != null && !this.Tag.isEmpty()) {
                    Log.i((String)this.Tag, (String)this.Message, (Throwable)this.Exception);
                } else {
                    Log.i((String)GenericTag, (String)this.Message, (Throwable)this.Exception);
                }
            } else if (this.loggingLevel == warningLogLevel) {
                if (this.Tag != null && !this.Tag.isEmpty()) {
                    Log.w((String)this.Tag, (String)this.Message, (Throwable)this.Exception);
                } else {
                    Log.w((String)GenericTag, (String)this.Message, (Throwable)this.Exception);
                }
            } else if (this.loggingLevel == verboseLogLevel) {
                if (this.Tag != null && !this.Tag.isEmpty()) {
                    Log.v((String)this.Tag, (String)this.Message, (Throwable)this.Exception);
                } else {
                    Log.v((String)GenericTag, (String)this.Message, (Throwable)this.Exception);
                }
            } else if (this.Tag != null && !this.Tag.isEmpty()) {
                Log.println((int)this.Priority, (String)this.Tag, (String)this.Message);
            } else {
                Log.println((int)this.Priority, (String)GenericTag, (String)this.Message);
            }
            return null;
        }

        protected void onPostExecute(Void result) {
        }
    }
}

