/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.services;

import com.applitools.connectivity.UfgConnector;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.TaskListener;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.logging.Type;
import com.applitools.eyes.services.EyesService;
import com.applitools.eyes.visualgrid.model.RenderRequest;
import com.applitools.eyes.visualgrid.model.RenderStatus;
import com.applitools.eyes.visualgrid.model.RenderStatusResults;
import com.applitools.eyes.visualgrid.model.RunningRender;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.tuple.Pair;

public class RenderService
extends EyesService<RenderRequest, RenderStatusResults> {
    int RENDER_STATUS_POLLING_TIMEOUT = 3600000;
    private final AtomicBoolean isTimeElapsed = new AtomicBoolean(false);
    private final List<Pair<String, String>> renderingQueue = Collections.synchronizedList(new ArrayList());

    public RenderService(Logger logger, UfgConnector serverConnector) {
        super(logger, serverConnector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<Pair<String, String>> list;
        this.sendAllRenderRequests();
        if (this.renderingQueue.isEmpty()) {
            return;
        }
        List<Pair<String, String>> list2 = this.renderingQueue;
        synchronized (list2) {
            list = new ArrayList<Pair<String, String>>(this.renderingQueue);
            this.renderingQueue.clear();
        }
        ArrayList<String> testIds = new ArrayList<String>();
        ArrayList<String> renderIds = new ArrayList<String>();
        for (Pair pair : list) {
            testIds.add((String)pair.getLeft());
            renderIds.add((String)pair.getRight());
        }
        try {
            this.pollRenderingStatus(testIds, renderIds);
        }
        catch (Throwable t) {
            this.setRenderErrorToTasks(testIds, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAllRenderRequests() {
        if (this.inputQueue.isEmpty()) {
            return;
        }
        ArrayList<RenderRequest> renderRequests = new ArrayList<RenderRequest>();
        final ArrayList<String> stepIds = new ArrayList<String>();
        List list = this.inputQueue;
        synchronized (list) {
            for (Pair stringRenderRequestPair : this.inputQueue) {
                renderRequests.add((RenderRequest)stringRenderRequestPair.getRight());
                stepIds.add((String)stringRenderRequestPair.getLeft());
                this.logger.log(TraceLevel.Info, (String)stringRenderRequestPair.getLeft(), Stage.RENDER, new Pair[]{Pair.of((Object)"renderRequest", (Object)stringRenderRequestPair.getRight())});
            }
            this.inputQueue.clear();
        }
        TaskListener<List<RunningRender>> renderListener = new TaskListener<List<RunningRender>>(){

            public void onComplete(List<RunningRender> runningRenders) {
                if (runningRenders == null || runningRenders.size() != stepIds.size()) {
                    this.onFail();
                    return;
                }
                try {
                    int i;
                    for (i = 0; i < stepIds.size(); ++i) {
                        RunningRender runningRender = runningRenders.get(i);
                        RenderService.this.logger.log(TraceLevel.Info, (String)stepIds.get(i), Stage.RENDER, new Pair[]{Pair.of((Object)"runningRender", (Object)runningRender)});
                        RenderStatus renderStatus = runningRender.getRenderStatus();
                        if (renderStatus.equals((Object)RenderStatus.RENDERED) || renderStatus.equals((Object)RenderStatus.RENDERING)) continue;
                        RenderService.this.setRenderErrorToTasks(stepIds, (Throwable)new EyesException(String.format("Invalid response for render request. Status: %s", new Object[]{renderStatus})));
                        return;
                    }
                    for (i = 0; i < runningRenders.size(); ++i) {
                        RenderService.this.renderingQueue.add(Pair.of(stepIds.get(i), (Object)runningRenders.get(i).getRenderId()));
                    }
                }
                catch (Throwable t) {
                    RenderService.this.setRenderErrorToTasks(stepIds, t);
                }
            }

            public void onFail() {
                RenderService.this.setRenderErrorToTasks(stepIds, (Throwable)new EyesException("Invalid response for render request"));
            }
        };
        try {
            this.serverConnector.render(renderListener, renderRequests);
        }
        catch (Throwable t) {
            this.setRenderErrorToTasks(stepIds, t);
        }
    }

    private void pollRenderingStatus(final List<String> testIds, final List<String> renderIds) {
        final Timer timer = new Timer("VG_StopWatch", true);
        timer.schedule((TimerTask)new TimeoutTask(), this.RENDER_STATUS_POLLING_TIMEOUT);
        this.serverConnector.renderStatusById(new TaskListener<List<RenderStatusResults>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(List<RenderStatusResults> renderStatusResultsList) {
                if (renderStatusResultsList == null || renderStatusResultsList.size() != renderIds.size()) {
                    this.onFail();
                    return;
                }
                for (int i = 0; i < renderStatusResultsList.size(); ++i) {
                    List list;
                    RenderStatusResults renderStatusResults = renderStatusResultsList.get(i);
                    if (renderStatusResults == null) {
                        renderStatusResults = RenderStatusResults.createError((String)renderIds.get(i));
                    }
                    RenderService.this.logger.log(TraceLevel.Info, Collections.singleton(testIds.get(i)), Stage.RENDER, Type.RENDER_STATUS, new Pair[]{Pair.of((Object)"renderStatusResults", (Object)renderStatusResults)});
                    RenderStatus renderStatus = renderStatusResults.getStatus();
                    if (!renderStatus.equals((Object)RenderStatus.RENDERED) && !renderStatus.equals((Object)RenderStatus.ERROR)) continue;
                    String testId = (String)testIds.get(i);
                    String error = renderStatusResults.getError();
                    if (error != null) {
                        list = RenderService.this.errorQueue;
                        synchronized (list) {
                            EyesException t = new EyesException(error);
                            RenderService.this.errorQueue.add(Pair.of((Object)testId, (Object)t));
                        }
                    }
                    list = RenderService.this.outputQueue;
                    synchronized (list) {
                        RenderService.this.outputQueue.add(Pair.of((Object)testId, (Object)renderStatusResults));
                    }
                    renderIds.remove(i);
                    testIds.remove(i);
                    renderStatusResultsList.remove(i);
                    --i;
                }
                if (renderIds.isEmpty()) {
                    timer.cancel();
                    return;
                }
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!RenderService.this.isTimeElapsed.get()) {
                    RenderService.this.serverConnector.renderStatusById(this, testIds, renderIds);
                    return;
                }
                this.onFail();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFail() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!renderIds.isEmpty() && !RenderService.this.isTimeElapsed.get()) {
                    RenderService.this.serverConnector.renderStatusById(this, testIds, renderIds);
                    return;
                }
                timer.cancel();
                if (renderIds.isEmpty()) {
                    return;
                }
                for (int i = 0; i < testIds.size(); ++i) {
                    String renderId = (String)renderIds.get(i);
                    String testId = (String)testIds.get(i);
                    EyesException t = new EyesException(String.format("Render timeout. TestId: %s, RenderId: %s", testId, renderId));
                    List list = RenderService.this.errorQueue;
                    synchronized (list) {
                        RenderService.this.errorQueue.add(Pair.of((Object)testId, (Object)t));
                        continue;
                    }
                }
            }
        }, testIds, renderIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRenderErrorToTasks(List<String> testIds, Throwable t) {
        List list = this.errorQueue;
        synchronized (list) {
            for (String id : testIds) {
                this.errorQueue.add(Pair.of((Object)id, (Object)t));
            }
        }
    }

    private class TimeoutTask
    extends TimerTask {
        private TimeoutTask() {
        }

        @Override
        public void run() {
            RenderService.this.logger.log(TraceLevel.Error, new HashSet(), Stage.RENDER, Type.TIMEOUT, new Pair[0]);
            RenderService.this.isTimeElapsed.set(true);
        }
    }
}

