/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.connectivity;

import com.applitools.connectivity.ResponseParsingCallback;
import com.applitools.connectivity.RestClient;
import com.applitools.connectivity.api.AsyncRequest;
import com.applitools.connectivity.api.AsyncRequestCallback;
import com.applitools.connectivity.api.Request;
import com.applitools.connectivity.api.Response;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.SyncTaskListener;
import com.applitools.eyes.TaskListener;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.logging.Type;
import com.applitools.eyes.visualgrid.model.DeviceSize;
import com.applitools.eyes.visualgrid.model.RGridResource;
import com.applitools.eyes.visualgrid.model.RenderingInfo;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.tuple.Pair;

public class UfgConnector
extends RestClient {
    public static final int DEFAULT_CLIENT_TIMEOUT = 300000;
    public static final int MAX_CONNECTION_RETRIES = 3;
    private static final List<String> DOMAINS_FILTERED = Collections.singletonList("https://fonts.googleapis.com");
    static final String RESOURCES_SHA_256 = "/resources/sha256/";
    static final String API_SESSIONS = "api/sessions";
    static final String RENDER_INFO_PATH = "api/sessions/renderinfo";
    public static final String IOS_DEVICES_PATH = "/ios-devices-sizes";
    public static final String EMULATED_DEVICES_PATH = "/emulated-devices-sizes";
    static final String USER_AGENT_PATH = "/user-agents";
    private String apiKey = null;
    protected final AtomicReference<RenderingInfo> renderingInfo = new AtomicReference<Object>(null);
    private static final Map<String, Map<String, DeviceSize>> devicesSizes = new HashMap<String, Map<String, DeviceSize>>();
    private static final AtomicReference<Map<String, String>> userAgents = new AtomicReference();

    public UfgConnector(Logger logger, URI serverUrl, int timeout) {
        super(logger, serverUrl, timeout);
    }

    public UfgConnector(Logger logger, URI serverUrl) {
        this(logger, serverUrl, 300000);
    }

    public UfgConnector(Logger logger) {
        this(logger, GeneralUtils.getServerUrl());
    }

    public UfgConnector() {
        this(new Logger());
    }

    public void setApiKey(String apiKey) {
        ArgumentGuard.notNull((Object)apiKey, (String)"apiKey");
        this.apiKey = apiKey;
    }

    public String getApiKey() {
        return this.apiKey != null ? this.apiKey : GeneralUtils.getEnvString((String)"APPLITOOLS_API_KEY");
    }

    public boolean wasApiKeySet() {
        return this.apiKey != null;
    }

    public void sendAsyncRequest(AsyncRequestCallback callback, String url, String method, String ... accept) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("apiKey", this.getApiKey());
        super.sendAsyncRequest(callback, url, method, queryParams, accept);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRenderingInfo(RenderingInfo renderInfo) {
        AtomicReference<RenderingInfo> atomicReference = this.renderingInfo;
        synchronized (atomicReference) {
            this.renderingInfo.set(renderInfo);
        }
    }

    public <T> T getFromServer(RestClient.HttpRequestBuilder builder, TypeReference<T> typeReference) {
        AsyncRequest request = this.makeEyesRequest(builder);
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>(1);
        validStatusCodes.add(200);
        SyncTaskListener listener = new SyncTaskListener(this.logger, "getFromServer");
        ResponseParsingCallback callback = new ResponseParsingCallback((RestClient)this, validStatusCodes, (TaskListener)listener, typeReference);
        this.sendLongRequest(request, "GET", (AsyncRequestCallback)callback, null, null);
        Object result = listener.get();
        if (result == null) {
            throw new EyesException("Failed getting object from the server");
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderingInfo getRenderInfo() {
        AtomicReference<RenderingInfo> atomicReference = this.renderingInfo;
        synchronized (atomicReference) {
            if (this.renderingInfo.get() != null) {
                return this.renderingInfo.get();
            }
            this.renderingInfo.set(this.getFromServer(new RestClient.HttpRequestBuilder(){

                public AsyncRequest build() {
                    return UfgConnector.this.restClient.target(UfgConnector.this.serverUrl).path(UfgConnector.RENDER_INFO_PATH).queryParam("apiKey", UfgConnector.this.getApiKey()).asyncRequest(new String[0]);
                }
            }, new TypeReference<RenderingInfo>(){}));
            return this.renderingInfo.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, DeviceSize> getDevicesSizes(final String path) {
        Map<String, Map<String, DeviceSize>> map = devicesSizes;
        synchronized (map) {
            if (devicesSizes.containsKey(path)) {
                return devicesSizes.get(path);
            }
            try {
                Map<String, DeviceSize> result = this.getFromServer(new RestClient.HttpRequestBuilder(){

                    public AsyncRequest build() {
                        return UfgConnector.this.restClient.target(UfgConnector.this.getRenderInfo().getServiceUrl()).path(path).queryParam("apiKey", UfgConnector.this.getApiKey()).asyncRequest(new String[0]);
                    }
                }, new TypeReference<Map<String, DeviceSize>>(){});
                devicesSizes.put(path, result);
            }
            catch (Throwable t) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.GENERAL, (Throwable)t, (String[])new String[0]);
                devicesSizes.put(path, new HashMap());
            }
            return devicesSizes.get(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getUserAgents() {
        AtomicReference<Map<String, String>> atomicReference = userAgents;
        synchronized (atomicReference) {
            if (userAgents.get() != null) {
                return userAgents.get();
            }
            try {
                userAgents.set(this.getFromServer(new RestClient.HttpRequestBuilder(){

                    public AsyncRequest build() {
                        return UfgConnector.this.restClient.target(UfgConnector.this.getRenderInfo().getServiceUrl()).path(UfgConnector.USER_AGENT_PATH).queryParam("apiKey", UfgConnector.this.getApiKey()).asyncRequest(new String[0]);
                    }
                }, new TypeReference<Map<String, String>>(){}));
            }
            catch (Throwable t) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.GENERAL, (Throwable)t, (String[])new String[0]);
                userAgents.set(new HashMap());
            }
            return userAgents.get();
        }
    }

    public Future<?> downloadResource(URI url, String userAgent, String refererUrl, TaskListener<RGridResource> listener) {
        return this.downloadResource(url, userAgent, refererUrl, listener, 1);
    }

    public Future<?> downloadResource(final URI url, final String userAgent, final String refererUrl, final TaskListener<RGridResource> listener, final int attemptNumber) {
        AsyncRequest asyncRequest = this.restClient.target(url.toString()).asyncRequest(new String[]{"*/*"});
        asyncRequest.header("Referer", refererUrl);
        if (!DOMAINS_FILTERED.contains(url.toString())) {
            asyncRequest.header("User-Agent", userAgent);
        }
        this.logger.log(TraceLevel.Info, new HashSet(), null, Type.DOWNLOAD_RESOURCE, new Pair[]{Pair.of((Object)"url", (Object)url.toString())});
        return asyncRequest.method("GET", new AsyncRequestCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(Response response) {
                RGridResource rgResource;
                block6: {
                    rgResource = null;
                    try {
                        int statusCode = response.getStatusCode();
                        if (statusCode == 200 || statusCode == 201) break block6;
                        UfgConnector.this.logger.log(TraceLevel.Error, null, null, Type.DOWNLOAD_RESOURCE, new Pair[]{Pair.of((Object)"statusCode", (Object)statusCode), Pair.of((Object)"url", (Object)url)});
                        rgResource = RGridResource.createEmpty(url.toString());
                    }
                    catch (Throwable throwable) {
                        listener.onComplete(rgResource);
                        response.close();
                        throw throwable;
                    }
                    listener.onComplete((Object)rgResource);
                    response.close();
                    return;
                }
                byte[] fileContent = UfgConnector.this.downloadFile(response);
                String contentType = response.getHeader(Request.CONTENT_TYPE_HEADER, true);
                String contentEncoding = response.getHeader("Content-Encoding", true);
                if (contentEncoding != null && contentEncoding.contains("gzip")) {
                    try {
                        fileContent = GeneralUtils.getUnGzipByteArrayOutputStream((byte[])fileContent);
                    }
                    catch (IOException e) {
                        GeneralUtils.logExceptionStackTrace((Logger)UfgConnector.this.logger, null, (Type)Type.DOWNLOAD_RESOURCE, (Throwable)e, (String[])new String[0]);
                    }
                }
                rgResource = new RGridResource(url.toString(), contentType, fileContent);
                UfgConnector.this.logger.log(TraceLevel.Info, new HashSet(), null, Type.DOWNLOAD_RESOURCE, new Pair[]{Pair.of((Object)"resource", (Object)rgResource)});
                listener.onComplete((Object)rgResource);
                response.close();
            }

            public void onFail(Throwable throwable) {
                GeneralUtils.logExceptionStackTrace((Logger)UfgConnector.this.logger, null, (Type)Type.DOWNLOAD_RESOURCE, (Throwable)throwable, (String[])new String[0]);
                if (attemptNumber < 3) {
                    UfgConnector.this.downloadResource(url, userAgent, refererUrl, (TaskListener<RGridResource>)listener, attemptNumber + 1);
                } else {
                    UfgConnector.this.logger.log(TraceLevel.Error, null, null, Type.DOWNLOAD_RESOURCE, new Pair[]{Pair.of((Object)"url", (Object)url)});
                    listener.onComplete((Object)RGridResource.createEmpty(url.toString()));
                }
            }
        }, null, null, false);
    }

    public Future<?> renderPutResource(Set<String> testIds, String renderID, RGridResource resource, TaskListener<Void> listener) {
        try {
            return this.renderPutResource(testIds, renderID, resource, listener, 1);
        }
        catch (Throwable t) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.RESOURCE_COLLECTION, (Type)Type.UPLOAD_RESOURCE, (Throwable)t, (String[])testIds.toArray(new String[0]));
            listener.onFail();
            return new FutureTask<Void>(new Callable<Void>(){

                @Override
                public Void call() {
                    return null;
                }
            });
        }
    }

    public Future<?> renderPutResource(final Set<String> testIds, String renderId, final RGridResource resource, final TaskListener<Void> listener, final int attemptNumber) {
        ArgumentGuard.notNull((Object)resource, (String)"resource");
        final String finalRenderId = renderId == null ? "NONE" : renderId;
        byte[] content = resource.getContent();
        if (content == null) {
            listener.onComplete(null);
            return new FutureTask<Void>(new Callable<Void>(){

                @Override
                public Void call() {
                    return null;
                }
            });
        }
        String hash = resource.getSha256();
        this.logger.log(TraceLevel.Info, testIds, Stage.RESOURCE_COLLECTION, Type.UPLOAD_RESOURCE, new Pair[]{Pair.of((Object)"resource", (Object)resource), Pair.of((Object)"url", (Object)resource.getUrl()), Pair.of((Object)"renderId", (Object)renderId)});
        AsyncRequest asyncRequest = this.restClient.target(this.getRenderInfo().getServiceUrl()).path(RESOURCES_SHA_256 + hash).queryParam("render-id", renderId).asyncRequest(new String[]{resource.getContentType()});
        asyncRequest.header("X-Auth-Token", this.getRenderInfo().getAccessToken());
        String contentType = resource.getContentType();
        if (contentType == null || "None".equalsIgnoreCase(contentType)) {
            contentType = "application/octet-stream";
        }
        return asyncRequest.method("PUT", new AsyncRequestCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(Response response) {
                int statusCode = response.getStatusCode();
                if (statusCode != 200) {
                    UfgConnector.this.logger.log(TraceLevel.Error, testIds, Stage.RESOURCE_COLLECTION, Type.UPLOAD_RESOURCE, new Pair[]{Pair.of((Object)"statusCode", (Object)statusCode), Pair.of((Object)"url", (Object)resource.getUrl())});
                    if (statusCode < 500 || attemptNumber >= 3) {
                        listener.onFail();
                        return;
                    }
                    try {
                        UfgConnector.this.renderPutResource(testIds, finalRenderId, resource, (TaskListener<Void>)listener, attemptNumber + 1);
                    }
                    catch (Throwable t) {
                        GeneralUtils.logExceptionStackTrace((Logger)UfgConnector.this.logger, (Stage)Stage.RESOURCE_COLLECTION, (Type)Type.UPLOAD_RESOURCE, (Throwable)t, (String[])testIds.toArray(new String[0]));
                        listener.onFail();
                    }
                    return;
                }
                try {
                    String responseData = response.getBodyString();
                    JsonNode jsonObject = UfgConnector.this.jsonMapper.readTree(responseData);
                    JsonNode value = jsonObject.get("hash");
                    if (value == null) {
                        UfgConnector.this.logger.log(TraceLevel.Warn, testIds, Stage.RESOURCE_COLLECTION, Type.UPLOAD_RESOURCE, new Pair[]{Pair.of((Object)"message", (Object)"Didn't receive hash in the server response"), Pair.of((Object)"url", (Object)resource.getUrl())});
                        return;
                    }
                    if (value.isValueNode() && value.asText().equals(resource.getSha256())) {
                        resource.resetContent();
                        return;
                    }
                    UfgConnector.this.logger.log(TraceLevel.Warn, testIds, Stage.RESOURCE_COLLECTION, Type.UPLOAD_RESOURCE, new Pair[]{Pair.of((Object)"message", (Object)"Resource hash doesn't match to the server hash"), Pair.of((Object)"url", (Object)resource.getUrl())});
                }
                catch (IOException e) {
                    GeneralUtils.logExceptionStackTrace((Logger)UfgConnector.this.logger, (Stage)Stage.RESOURCE_COLLECTION, (Type)Type.UPLOAD_RESOURCE, (Throwable)e, (String[])testIds.toArray(new String[0]));
                }
                finally {
                    listener.onComplete(null);
                    response.close();
                }
            }

            public void onFail(Throwable throwable) {
                GeneralUtils.logExceptionStackTrace((Logger)UfgConnector.this.logger, (Stage)Stage.RESOURCE_COLLECTION, (Type)Type.UPLOAD_RESOURCE, (Throwable)throwable, (String[])testIds.toArray(new String[0]));
                if (attemptNumber >= 3) {
                    listener.onFail();
                    return;
                }
                try {
                    UfgConnector.this.renderPutResource(testIds, finalRenderId, resource, (TaskListener<Void>)listener, attemptNumber + 1);
                }
                catch (Throwable t) {
                    GeneralUtils.logExceptionStackTrace((Logger)UfgConnector.this.logger, (Stage)Stage.RESOURCE_COLLECTION, (Type)Type.UPLOAD_RESOURCE, (Throwable)t, (String[])testIds.toArray(new String[0]));
                    listener.onFail();
                }
            }
        }, (Object)content, contentType);
    }
}

