/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.model;

import com.applitools.eyes.Logger;
import com.applitools.eyes.visualgrid.model.CssTokenizer;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

public class RGridResource {
    @JsonIgnore
    private static final String TEXT_CSS = "text/css";
    @JsonIgnore
    private static final String IMAGE_SVG_XML = "image/svg+xml";
    @JsonIgnore
    private static final int MAX_RESOURCE_SIZE = 0xF00000;
    @JsonIgnore
    private Logger logger;
    @JsonIgnore
    private final String url;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String contentType;
    @JsonIgnore
    private byte[] content;
    @JsonProperty(value="hash")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String sha256;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Integer errorStatusCode;
    @JsonInclude
    private final String hashFormat = "sha256";
    @JsonIgnore
    private final Map<String, Set<URI>> subResources = Collections.synchronizedMap(new HashMap());
    @JsonIgnore
    private boolean wasDebugWritten = false;

    public static RGridResource createEmpty(String url) {
        return new RGridResource(url, "application/empty-response", new byte[0]);
    }

    public String getUrl() {
        return this.url;
    }

    public RGridResource(String url, String contentType, byte[] content) {
        this(url, contentType, content, null);
    }

    public RGridResource(String url, String contentType, byte[] content, Integer errorStatusCode) {
        this.contentType = contentType;
        this.url = url;
        this.errorStatusCode = errorStatusCode;
        if (content == null) {
            content = new byte[]{};
        }
        this.content = content.length > 0xF00000 ? Arrays.copyOf(content, 0xF00000) : content;
        this.sha256 = GeneralUtils.getSha256hash((byte[])this.content);
    }

    public String getContentType() {
        return this.contentType;
    }

    public void resetContent() {
        this.content = null;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public String getHashFormat() {
        return "sha256";
    }

    public String getSha256() {
        return this.sha256;
    }

    public Integer getErrorStatusCode() {
        return this.errorStatusCode;
    }

    public boolean wasDebugWritten() {
        return this.wasDebugWritten;
    }

    public void setWasDebugWritten() {
        this.wasDebugWritten = true;
    }

    public Set<URI> parse(Logger logger, String baseUriStr) {
        Set<URI> resources;
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        this.logger = logger;
        if (baseUriStr == null) {
            return new HashSet<URI>();
        }
        if (!this.subResources.containsKey(baseUriStr)) {
            if (this.content == null) {
                return new HashSet<URI>();
            }
            URI baseUri = URI.create(baseUriStr);
            TextualDataResource tdr = this.tryGetTextualData(baseUri);
            if (tdr == null) {
                this.subResources.put(baseUriStr, new HashSet());
            } else {
                HashSet<URI> newResources = new HashSet<URI>();
                switch (tdr.mimeType) {
                    case "text/css": {
                        this.parseCSS(tdr, newResources);
                        break;
                    }
                    case "image/svg+xml": {
                        this.parseSVG(tdr, newResources);
                    }
                }
                this.subResources.put(baseUriStr, newResources);
            }
        }
        if ((resources = this.subResources.get(baseUriStr)) == null || resources.isEmpty()) {
            return new HashSet<URI>();
        }
        return new HashSet<URI>(resources);
    }

    private TextualDataResource tryGetTextualData(URI baseUrl) {
        if (this.contentType == null) {
            return null;
        }
        if (this.content == null) {
            this.logger.log(String.format("base: %s url: %s sub: %s", baseUrl, this.url, Arrays.toString(this.subResources.keySet().toArray())));
        }
        if (this.content.length == 0) {
            return null;
        }
        String[] parts = this.contentType.split(";");
        TextualDataResource tdr = new TextualDataResource();
        if (parts.length > 0) {
            tdr.mimeType = parts[0].toLowerCase();
        }
        String charset = "UTF-8";
        if (parts.length > 1) {
            String[] keyVal = parts[1].split("=");
            String key = keyVal[0].trim();
            String val = keyVal[1].trim();
            if (key.equalsIgnoreCase("charset")) {
                charset = val.toUpperCase();
            }
        }
        charset = charset.replaceAll("\"", "");
        try {
            tdr.data = new String(this.content, charset);
        }
        catch (UnsupportedEncodingException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        URI uri = null;
        try {
            uri = new URI(GeneralUtils.sanitizeURL((String)this.url));
            tdr.uri = baseUrl.resolve(uri);
        }
        catch (Exception e) {
            this.logger.log("Error resolving uri:" + uri);
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        tdr.originalData = this.content;
        this.logger.verbose("exit");
        return tdr;
    }

    private void parseSVG(TextualDataResource tdr, Set<URI> resourceUrls) {
        try {
            Document doc = Jsoup.parse((String)new String(tdr.originalData), (String)tdr.uri.toString(), (Parser)Parser.xmlParser());
            Elements links = doc.select("[href]");
            links.addAll((Collection)doc.select("[xlink:href]"));
            for (Element element : links) {
                URI uri;
                String href = element.attr("href");
                if (href.isEmpty() && (href = element.attr("xlink:href")).startsWith("#") || (uri = this.resolveUriString(tdr.uri, href = GeneralUtils.sanitizeURL((String)href))) == null) continue;
                resourceUrls.add(uri);
            }
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
    }

    private void parseCSS(TextualDataResource css, Set<URI> resourceUrls) {
        try {
            String data = css.data;
            if (data == null) {
                return;
            }
            Set<String> urlsString = CssTokenizer.getImportedUrls(data);
            for (String urlString : urlsString) {
                URI uri = this.resolveUriString(css.uri, urlString = GeneralUtils.sanitizeURL((String)urlString));
                if (uri == null) continue;
                resourceUrls.add(uri);
            }
        }
        catch (Throwable e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
    }

    private URI resolveUriString(URI baseUrl, String uri) {
        if (uri.toLowerCase().startsWith("data:") || uri.toLowerCase().startsWith("javascript:")) {
            return null;
        }
        try {
            return baseUrl.resolve(uri);
        }
        catch (Exception e) {
            this.logger.log("Error resolving uri:" + uri);
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            return null;
        }
    }

    public String toString() {
        return "RGridResource{url='" + this.url + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RGridResource)) {
            return false;
        }
        RGridResource that = (RGridResource)o;
        return this.getSha256().equals(that.getSha256()) && this.getHashFormat().equals(that.getHashFormat());
    }

    public int hashCode() {
        int result = Objects.hash(this.getSha256(), this.getHashFormat());
        result = 31 * result + Arrays.hashCode(this.getContent());
        return result;
    }

    private static class TextualDataResource {
        String mimeType;
        URI uri;
        String data;
        byte[] originalData;

        private TextualDataResource() {
        }
    }
}

