/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.universal.mapper;

import com.applitools.eyes.selenium.ElementReference;
import com.applitools.eyes.selenium.ElementSelector;
import com.applitools.eyes.selenium.PathNodeValue;
import com.applitools.eyes.selenium.TargetPathLocator;
import com.applitools.eyes.selenium.universal.dto.ElementRegionDto;
import com.applitools.eyes.selenium.universal.dto.TargetPathLocatorDto;
import com.applitools.eyes.selenium.universal.mapper.ElementRegionMapper;

public class TargetPathLocatorMapper {
    public static TargetPathLocatorDto toTargetPathLocatorDto(TargetPathLocator locator) {
        TargetPathLocatorDto currentDto;
        if (locator == null) {
            return null;
        }
        TargetPathLocatorDto parentDto = new TargetPathLocatorDto();
        TargetPathLocator parentLocator = locator;
        do {
            locator = parentLocator;
            parentLocator = locator.getParent();
            currentDto = parentDto;
            parentDto = new TargetPathLocatorDto();
            parentDto.setShadow(currentDto);
            PathNodeValue value = locator.getValue();
            if (value instanceof ElementSelector) {
                currentDto.setType(((ElementSelector)value).getType());
                currentDto.setSelector(((ElementSelector)value).getSelector());
                continue;
            }
            if (!(value instanceof ElementReference)) continue;
            ElementRegionDto erd = ElementRegionMapper.toElementRegionDto(((ElementReference)value).getElement());
            currentDto.setElementId(erd.getElementId());
        } while (locator.getParent() != null);
        return currentDto;
    }
}

