/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.positioning;

import com.applitools.eyes.Logger;
import com.applitools.eyes.Region;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.selenium.SeleniumEyes;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.positioning.RegionPositionCompensation;
import com.applitools.eyes.selenium.wrappers.EyesSeleniumDriver;

public class FirefoxRegionPositionCompensation
implements RegionPositionCompensation {
    private final SeleniumEyes eyes;
    private final Logger logger;
    private final UserAgent userAgent;

    public FirefoxRegionPositionCompensation(SeleniumEyes eyes, UserAgent userAgent, Logger logger) {
        this.eyes = eyes;
        this.logger = logger;
        this.userAgent = userAgent;
    }

    public Region compensateRegionPosition(Region region, double pixelRatio) {
        if (this.userAgent.getOS().equalsIgnoreCase("Windows") && Integer.parseInt(this.userAgent.getOSMajorVersion()) <= 7) {
            return region.offset(0, (int)pixelRatio);
        }
        if (pixelRatio == 1.0) {
            return region;
        }
        EyesSeleniumDriver eyesSeleniumDriver = (EyesSeleniumDriver)this.eyes.getDriver();
        FrameChain frameChain = eyesSeleniumDriver.getFrameChain();
        if (frameChain.size() > 0) {
            return region;
        }
        if ((region = region.offset(0, -((int)Math.ceil(pixelRatio / 2.0)))).getWidth() <= 0 || region.getHeight() <= 0) {
            return Region.EMPTY;
        }
        return region;
    }
}

