/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.capture;

import com.applitools.eyes.IEyesJsExecutor;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.ViewportMetaTag;
import com.applitools.eyes.selenium.capture.ISizeAdjuster;

public class MobileDeviceSizeAdjuster
implements ISizeAdjuster {
    private static final String GetViewportMetaTagContentScript = "var meta = document.querySelector('head > meta[name=viewport]');var viewport = (meta == null) ? '' : meta.getAttribute('content');return viewport;";
    private static final float THRESHOLD_RATIO_FOR_ADJUSTING = 0.02f;
    private final ViewportMetaTag viewportMetaTag;
    private final long innerWidth;

    public MobileDeviceSizeAdjuster(IEyesJsExecutor jsExecutor, long innerWidth) {
        String viewportMetaTagContent = (String)jsExecutor.executeScript(GetViewportMetaTagContentScript, new Object[0]);
        this.viewportMetaTag = ViewportMetaTag.parseViewportMetaTag((String)viewportMetaTagContent);
        this.innerWidth = innerWidth;
    }

    @Override
    public Region adjustRegion(Region inputRegion, RectangleSize deviceLogicalViewportSize) {
        if (this.viewportMetaTag.getFollowDeviceWidth() && (this.innerWidth == 0L || this.innerWidth == (long)deviceLogicalViewportSize.getWidth())) {
            return inputRegion;
        }
        float widthRatio = (float)inputRegion.getWidth() / (float)deviceLogicalViewportSize.getWidth();
        if (Math.abs(widthRatio - 1.0f) < 0.02f) {
            return inputRegion;
        }
        return new Region(inputRegion.getLeft(), inputRegion.getTop(), deviceLogicalViewportSize.getWidth(), Math.round((float)inputRegion.getHeight() / widthRatio));
    }
}

