/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.eyes.Logger;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.fluent.FrameLocator;
import com.applitools.eyes.selenium.fluent.IScrollRootElementContainer;
import com.applitools.eyes.selenium.frames.Frame;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.eyes.selenium.wrappers.EyesSeleniumDriver;
import com.applitools.utils.GeneralUtils;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class EyesSeleniumUtils {
    public static WebElement getDefaultRootElement(Logger logger, EyesSeleniumDriver driver) {
        EyesRemoteWebElement chosenElement;
        WebElement scrollingElement;
        try {
            scrollingElement = (WebElement)driver.executeScript("return document.scrollingElement", new Object[0]);
        }
        catch (Throwable t) {
            GeneralUtils.logExceptionStackTrace((Logger)logger, (Stage)Stage.GENERAL, (Throwable)t, (String[])new String[0]);
            scrollingElement = null;
        }
        EyesRemoteWebElement eyesScrollingElement = null;
        if (scrollingElement != null) {
            eyesScrollingElement = new EyesRemoteWebElement(logger, driver, scrollingElement);
        }
        WebElement html = driver.findElement(By.tagName((String)"html"));
        EyesRemoteWebElement htmlElement = new EyesRemoteWebElement(logger, driver, html);
        if (eyesScrollingElement != null && eyesScrollingElement.canScrollVertically()) {
            chosenElement = eyesScrollingElement;
        } else if (!EyesSeleniumUtils.doesBodyExist(logger, driver)) {
            chosenElement = htmlElement;
        } else {
            WebElement body = driver.findElement(By.tagName((String)"body"));
            EyesRemoteWebElement bodyElement = new EyesRemoteWebElement(logger, driver, body);
            boolean scrollableHtml = htmlElement.canScrollVertically();
            boolean scrollableBody = bodyElement.canScrollVertically();
            chosenElement = scrollableHtml && !scrollableBody ? htmlElement : (!scrollableHtml && scrollableBody ? bodyElement : (scrollingElement != null ? eyesScrollingElement : htmlElement));
        }
        logger.log(new HashSet(), Stage.GENERAL, new Pair[]{Pair.of((Object)"defaultRootElement", (Object)chosenElement.getTagName())});
        return chosenElement;
    }

    private static boolean doesBodyExist(Logger logger, EyesSeleniumDriver driver) {
        try {
            driver.findElement(By.tagName((String)"body"));
            return true;
        }
        catch (Throwable t) {
            GeneralUtils.logExceptionStackTrace((Logger)logger, (Stage)Stage.GENERAL, (Throwable)t, (String[])new String[0]);
            return false;
        }
    }

    public static WebElement getScrollRootElement(Logger logger, EyesSeleniumDriver driver, IScrollRootElementContainer scrollRootElementContainer) {
        if (EyesDriverUtils.isMobileDevice((WebDriver)driver)) {
            return null;
        }
        if (scrollRootElementContainer == null) {
            return EyesSeleniumUtils.getDefaultRootElement(logger, driver);
        }
        WebElement scrollRootElement = scrollRootElementContainer.getScrollRootElement();
        if (scrollRootElement != null) {
            return scrollRootElement;
        }
        By scrollRootSelector = scrollRootElementContainer.getScrollRootSelector();
        if (scrollRootSelector != null) {
            return driver.findElement(scrollRootSelector);
        }
        return EyesSeleniumUtils.getDefaultRootElement(logger, driver);
    }

    public static WebElement findFrameByFrameCheckTarget(FrameLocator frameTarget, EyesSeleniumDriver driver) {
        if (frameTarget.getFrameIndex() != null) {
            return driver.findElement(By.xpath((String)("IFRAME[" + frameTarget.getFrameIndex() + "]")));
        }
        String nameOrId = frameTarget.getFrameNameOrId();
        if (nameOrId != null) {
            List<WebElement> byId = driver.findElements(By.id((String)nameOrId));
            if (byId.size() > 0) {
                return byId.get(0);
            }
            return driver.findElement(By.name((String)nameOrId));
        }
        WebElement reference = frameTarget.getFrameReference();
        if (reference != null) {
            return reference;
        }
        By selector = frameTarget.getFrameSelector();
        if (selector != null) {
            return driver.findElement(selector);
        }
        return null;
    }

    public static WebElement getCurrentFrameScrollRootElement(Logger logger, EyesSeleniumDriver driver, WebElement userDefinedSRE) {
        WebElement scrollRootElement = EyesSeleniumUtils.tryGetCurrentFrameScrollRootElement(driver);
        if (scrollRootElement == null) {
            scrollRootElement = userDefinedSRE != null ? userDefinedSRE : EyesSeleniumUtils.getDefaultRootElement(logger, driver);
        }
        return scrollRootElement;
    }

    public static WebElement tryGetCurrentFrameScrollRootElement(EyesSeleniumDriver driver) {
        FrameChain fc = driver.getFrameChain().clone();
        Frame currentFrame = fc.peek();
        WebElement scrollRootElement = null;
        if (currentFrame != null) {
            scrollRootElement = currentFrame.getScrollRootElement();
        }
        return scrollRootElement;
    }
}

