/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.Region;
import com.applitools.eyes.SyncTaskListener;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.exceptions.DiffsFoundException;
import com.applitools.eyes.exceptions.NewTestException;
import com.applitools.eyes.exceptions.TestFailedException;
import com.applitools.eyes.locators.TextRegion;
import com.applitools.eyes.selenium.Reference;
import com.applitools.eyes.selenium.USDKConnection;
import com.applitools.eyes.selenium.universal.dto.CheckEyes;
import com.applitools.eyes.selenium.universal.dto.CheckSettingsDto;
import com.applitools.eyes.selenium.universal.dto.Command;
import com.applitools.eyes.selenium.universal.dto.ConfigurationDto;
import com.applitools.eyes.selenium.universal.dto.DriverDto;
import com.applitools.eyes.selenium.universal.dto.ErrorDto;
import com.applitools.eyes.selenium.universal.dto.EventDto;
import com.applitools.eyes.selenium.universal.dto.ExtractTextDto;
import com.applitools.eyes.selenium.universal.dto.ExtractTextRegionsDto;
import com.applitools.eyes.selenium.universal.dto.LocateDto;
import com.applitools.eyes.selenium.universal.dto.MakeManager;
import com.applitools.eyes.selenium.universal.dto.MakeSdk;
import com.applitools.eyes.selenium.universal.dto.OCRExtractSettingsDto;
import com.applitools.eyes.selenium.universal.dto.OCRSearchSettingsDto;
import com.applitools.eyes.selenium.universal.dto.OpenEyes;
import com.applitools.eyes.selenium.universal.dto.RectangleSizeDto;
import com.applitools.eyes.selenium.universal.dto.RequestDto;
import com.applitools.eyes.selenium.universal.dto.ResponseDto;
import com.applitools.eyes.selenium.universal.dto.TestResultsSummaryDto;
import com.applitools.eyes.selenium.universal.dto.VisualLocatorSettingsDto;
import com.applitools.eyes.selenium.universal.dto.request.CommandCloseAllEyesRequestDto;
import com.applitools.eyes.selenium.universal.dto.request.CommandCloseManagerRequestDto;
import com.applitools.eyes.selenium.universal.dto.request.CommandCloseRequestDto;
import com.applitools.eyes.selenium.universal.dto.request.CommandGetViewportSizeRequestDto;
import com.applitools.eyes.selenium.universal.dto.response.CommandCloseResponseDto;
import com.applitools.utils.GeneralUtils;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.openqa.selenium.StaleElementReferenceException;

public class CommandExecutor {
    private static USDKConnection connection;
    private static volatile CommandExecutor instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CommandExecutor getInstance(String name, String version) {
        if (instance != null) return instance;
        Class<CommandExecutor> clazz = CommandExecutor.class;
        synchronized (CommandExecutor.class) {
            if (instance != null) return instance;
            instance = new CommandExecutor(name, version);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    private CommandExecutor(String name, String version) {
        connection = new USDKConnection();
        connection.init();
        this.makeSdk(name, version, GeneralUtils.getPropertyString((String)"user.dir"), "webdriver");
    }

    public void makeSdk(String name, String version, String cwd, String protocol) {
        EventDto<MakeSdk> request = new EventDto<MakeSdk>();
        MakeSdk makeSdk = new MakeSdk(name, version, cwd, protocol);
        request.setName("Core.makeSDK");
        request.setPayload(makeSdk);
        CommandExecutor.checkedCommand(request, false);
    }

    public Reference coreMakeManager(String type, Integer concurrency, Boolean isLegacy) {
        RequestDto<MakeManager> request = new RequestDto<MakeManager>();
        request.setName("Core.makeManager");
        request.setKey(UUID.randomUUID().toString());
        request.setPayload(new MakeManager(type, concurrency, isLegacy));
        SyncTaskListener syncTaskListener = CommandExecutor.checkedCommand(request, true);
        ResponseDto response = (ResponseDto)syncTaskListener.get();
        if (response != null && response.getPayload().getError() != null) {
            String message = response.getPayload().getError().getMessage();
            if (message != null && message.contains("stale element reference")) {
                throw new StaleElementReferenceException(message);
            }
            throw new EyesException(message);
        }
        return (Reference)response.getPayload().getResult();
    }

    public Reference managerOpenEyes(Reference ref, DriverDto driverDto, ConfigurationDto config) {
        RequestDto<OpenEyes> request = new RequestDto<OpenEyes>();
        request.setName("EyesManager.openEyes");
        request.setKey(UUID.randomUUID().toString());
        request.setPayload(new OpenEyes(ref, driverDto, config));
        SyncTaskListener syncTaskListener = CommandExecutor.checkedCommand(request, true);
        ResponseDto referenceResponseDto = (ResponseDto)syncTaskListener.get();
        if (referenceResponseDto != null && referenceResponseDto.getPayload().getError() != null) {
            String message = referenceResponseDto.getPayload().getError().getMessage();
            if (message != null && message.contains("stale element reference")) {
                throw new StaleElementReferenceException(message);
            }
            throw new EyesException(message);
        }
        return (Reference)referenceResponseDto.getPayload().getResult();
    }

    public void eyesCheck(Reference eyesRef, CheckSettingsDto settings, ConfigurationDto config) {
        RequestDto<CheckEyes> request = new RequestDto<CheckEyes>();
        request.setName("Eyes.check");
        request.setKey(UUID.randomUUID().toString());
        request.setPayload(new CheckEyes(eyesRef, settings, config));
        SyncTaskListener syncTaskListener = CommandExecutor.checkedCommand(request, true);
        ResponseDto responseDto = (ResponseDto)syncTaskListener.get();
        if (responseDto != null && responseDto.getPayload().getError() != null) {
            String message = responseDto.getPayload().getError().getMessage();
            if (message != null && message.contains("stale element reference")) {
                throw new StaleElementReferenceException(message);
            }
            throw new EyesException(message);
        }
    }

    public Map<String, List<Region>> locate(Reference eyesRef, VisualLocatorSettingsDto locatorSettingsDto, ConfigurationDto config) {
        RequestDto<LocateDto> request = new RequestDto<LocateDto>();
        request.setName("Eyes.locate");
        request.setKey(UUID.randomUUID().toString());
        request.setPayload(new LocateDto(eyesRef, locatorSettingsDto, config));
        SyncTaskListener syncTaskListener = CommandExecutor.checkedCommand(request, true);
        ResponseDto locateResponse = (ResponseDto)syncTaskListener.get();
        if (locateResponse != null && locateResponse.getPayload().getError() != null) {
            String message = locateResponse.getPayload().getError().getMessage();
            if (message != null && message.contains("stale element reference")) {
                throw new StaleElementReferenceException(message);
            }
            throw new EyesException(message);
        }
        return (Map)locateResponse.getPayload().getResult();
    }

    public Map<String, List<TextRegion>> extractTextRegions(Reference eyesRef, OCRSearchSettingsDto searchSettingsDto, ConfigurationDto config) {
        RequestDto<ExtractTextRegionsDto> request = new RequestDto<ExtractTextRegionsDto>();
        request.setName("Eyes.extractTextRegions");
        request.setKey(UUID.randomUUID().toString());
        request.setPayload(new ExtractTextRegionsDto(eyesRef, searchSettingsDto, config));
        SyncTaskListener syncTaskListener = CommandExecutor.checkedCommand(request, true);
        ResponseDto extractTextRegionsResponse = (ResponseDto)syncTaskListener.get();
        if (extractTextRegionsResponse != null && extractTextRegionsResponse.getPayload().getError() != null) {
            String message = extractTextRegionsResponse.getPayload().getError().getMessage();
            if (message != null && message.contains("stale element reference")) {
                throw new StaleElementReferenceException(message);
            }
            throw new EyesException(message);
        }
        return (Map)extractTextRegionsResponse.getPayload().getResult();
    }

    public List<String> extractText(Reference eyesRef, List<OCRExtractSettingsDto> extractSettingsDtoList, ConfigurationDto config) {
        RequestDto<ExtractTextDto> request = new RequestDto<ExtractTextDto>();
        request.setName("Eyes.extractText");
        request.setKey(UUID.randomUUID().toString());
        request.setPayload(new ExtractTextDto(eyesRef, extractSettingsDtoList, config));
        SyncTaskListener syncTaskListener = CommandExecutor.checkedCommand(request, true);
        ResponseDto responseDto = (ResponseDto)syncTaskListener.get();
        if (responseDto != null && responseDto.getPayload().getError() != null) {
            String message = responseDto.getPayload().getError().getMessage();
            if (message != null && message.contains("stale element reference")) {
                throw new StaleElementReferenceException(message);
            }
            throw new EyesException(message);
        }
        return (List)responseDto.getPayload().getResult();
    }

    public List<CommandCloseResponseDto> close(Reference eyesRef, boolean waitResult) {
        RequestDto<CommandCloseRequestDto> request = new RequestDto<CommandCloseRequestDto>();
        request.setName("Eyes.close");
        request.setKey(UUID.randomUUID().toString());
        request.setPayload(new CommandCloseRequestDto(eyesRef));
        SyncTaskListener syncTaskListener = CommandExecutor.checkedCommand(request, waitResult);
        if (!waitResult) {
            return null;
        }
        ResponseDto closeResponse = (ResponseDto)syncTaskListener.get();
        if (closeResponse != null && closeResponse.getPayload() != null && closeResponse.getPayload().getError() != null) {
            String message = closeResponse.getPayload().getError().getMessage();
            if (message != null && message.contains("stale element reference")) {
                throw new StaleElementReferenceException(message);
            }
            throw new EyesException(message);
        }
        return (List)closeResponse.getPayload().getResult();
    }

    public List<CommandCloseResponseDto> abort(Reference eyesRef, boolean waitResult) {
        RequestDto<CommandCloseRequestDto> request = new RequestDto<CommandCloseRequestDto>();
        request.setName("Eyes.abort");
        request.setKey(UUID.randomUUID().toString());
        request.setPayload(new CommandCloseRequestDto(eyesRef));
        SyncTaskListener syncTaskListener = CommandExecutor.checkedCommand(request, waitResult);
        if (!waitResult) {
            return null;
        }
        ResponseDto closeResponse = (ResponseDto)syncTaskListener.get();
        if (closeResponse != null && closeResponse.getPayload().getError() != null) {
            String message = closeResponse.getPayload().getError().getMessage();
            if (message != null && message.contains("stale element reference")) {
                throw new StaleElementReferenceException(message);
            }
            throw new EyesException(message);
        }
        return (List)closeResponse.getPayload().getResult();
    }

    public static RectangleSizeDto getViewportSize(DriverDto driver) {
        RequestDto<CommandGetViewportSizeRequestDto> request = new RequestDto<CommandGetViewportSizeRequestDto>();
        request.setName("Core.getViewportSize");
        request.setKey(UUID.randomUUID().toString());
        request.setPayload(new CommandGetViewportSizeRequestDto(driver));
        SyncTaskListener syncTaskListener = CommandExecutor.checkedCommand(request, true);
        ResponseDto getViewportSizeResponse = (ResponseDto)syncTaskListener.get();
        return (RectangleSizeDto)getViewportSizeResponse.getPayload().getResult();
    }

    public List<CommandCloseResponseDto> closeAllEyes(Reference managerRef) {
        RequestDto<CommandCloseAllEyesRequestDto> request = new RequestDto<CommandCloseAllEyesRequestDto>();
        request.setName("EyesManager.closeAllEyes");
        request.setKey(UUID.randomUUID().toString());
        request.setPayload(new CommandCloseAllEyesRequestDto(managerRef));
        SyncTaskListener syncTaskListener = CommandExecutor.checkedCommand(request, true);
        ResponseDto closeResponse = (ResponseDto)syncTaskListener.get();
        if (closeResponse != null && closeResponse.getPayload().getError() != null) {
            String message = closeResponse.getPayload().getError().getMessage();
            if (message != null && message.contains("stale element reference")) {
                throw new StaleElementReferenceException(message);
            }
            throw new EyesException(message);
        }
        return (List)closeResponse.getPayload().getResult();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TestResultsSummaryDto closeManager(Reference managerRef, Boolean throwError) {
        RequestDto<CommandCloseManagerRequestDto> request = new RequestDto<CommandCloseManagerRequestDto>();
        request.setName("EyesManager.closeManager");
        request.setKey(UUID.randomUUID().toString());
        request.setPayload(new CommandCloseManagerRequestDto(managerRef, throwError));
        SyncTaskListener syncTaskListener = CommandExecutor.checkedCommand(request, true);
        ResponseDto closeResponse = (ResponseDto)syncTaskListener.get();
        if (closeResponse == null || closeResponse.getPayload() == null) return null;
        if (closeResponse.getPayload().getError() == null) return (TestResultsSummaryDto)closeResponse.getPayload().getResult();
        ErrorDto error = closeResponse.getPayload().getError();
        String message = error.getMessage();
        if (message != null && message.contains("stale element reference")) {
            throw new StaleElementReferenceException(message);
        }
        if (error.getReason() == null) throw new EyesException("Message: " + error.getMessage() + ", Stack: " + error.getStack());
        CommandExecutor.throwExceptionBasedOnReason(error.getReason(), error.getInfo() == null ? null : error.getInfo().getTestResult());
        return null;
    }

    public static SyncTaskListener checkedCommand(Command command, boolean waitResult) {
        try {
            return connection.executeCommand(command, waitResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void throwExceptionBasedOnReason(String reason, TestResults testResults) {
        String appIdOrName;
        String scenarioIdOrName;
        if (reason == null || reason.isEmpty()) {
            return;
        }
        if (testResults == null) {
            scenarioIdOrName = "(no test results)";
            appIdOrName = "";
        } else {
            scenarioIdOrName = testResults.getName();
            appIdOrName = testResults.getAppName();
        }
        switch (reason) {
            case "test different": {
                throw new DiffsFoundException(testResults, scenarioIdOrName, appIdOrName);
            }
            case "test failed": {
                throw new TestFailedException(testResults, scenarioIdOrName, appIdOrName);
            }
            case "test new": {
                throw new NewTestException(testResults, scenarioIdOrName, appIdOrName);
            }
        }
        throw new UnsupportedOperationException("Unsupported exception type: " + reason);
    }
}

