/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.positioning;

import com.applitools.eyes.IEyesJsExecutor;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.EyesSeleniumUtils;
import com.applitools.eyes.selenium.exceptions.EyesDriverOperationException;
import com.applitools.eyes.selenium.positioning.ScrollPositionMemento;
import com.applitools.utils.ArgumentGuard;
import org.openqa.selenium.WebDriverException;

public class ScrollPositionProvider
implements PositionProvider {
    protected final Logger logger;
    protected final IEyesJsExecutor executor;

    public ScrollPositionProvider(Logger logger, IEyesJsExecutor executor) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)executor, (String)"executor");
        this.logger = logger;
        this.executor = executor;
        logger.verbose("creating ScrollPositionProvider");
    }

    public Location getCurrentPosition() {
        Location result;
        this.logger.verbose("ScrollPositionProvider - getCurrentPosition()");
        try {
            result = EyesSeleniumUtils.getCurrentScrollPosition(this.executor);
        }
        catch (WebDriverException e) {
            throw new EyesDriverOperationException("Failed to extract current scroll position!", e);
        }
        this.logger.verbose("Current position: " + result);
        return result;
    }

    public void setPosition(Location location) {
        this.logger.verbose("ScrollPositionProvider - Scrolling to " + location);
        EyesSeleniumUtils.setCurrentScrollPosition(this.executor, location);
        this.logger.verbose("ScrollPositionProvider - Done scrolling!");
    }

    public RectangleSize getEntireSize() {
        RectangleSize result = EyesSeleniumUtils.getCurrentFrameContentEntireSize(this.executor);
        this.logger.verbose("ScrollPositionProvider - Entire size: " + result);
        return result;
    }

    public PositionMemento getState() {
        return new ScrollPositionMemento(this.getCurrentPosition());
    }

    public void restoreState(PositionMemento state) {
        ScrollPositionMemento s = (ScrollPositionMemento)state;
        this.setPosition(new Location(s.getX(), s.getY()));
    }
}

