/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.positioning;

import com.applitools.eyes.IEyesJsExecutor;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.EyesSeleniumUtils;
import com.applitools.eyes.selenium.positioning.CssTranslatePositionMemento;
import com.applitools.eyes.selenium.positioning.ScrollPositionProvider;
import com.applitools.utils.ArgumentGuard;

public class CssTranslatePositionProvider
implements PositionProvider {
    private final Logger logger;
    private final IEyesJsExecutor executor;
    private Location lastSetPosition;

    public CssTranslatePositionProvider(Logger logger, IEyesJsExecutor executor) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)executor, (String)"executor");
        this.logger = logger;
        this.executor = executor;
        logger.verbose("creating CssTranslatePositionProvider");
    }

    public Location getCurrentPosition() {
        this.logger.verbose("position to return: " + this.lastSetPosition);
        return this.lastSetPosition;
    }

    public void setPosition(Location location) {
        ArgumentGuard.notNull((Object)location, (String)"location");
        this.logger.verbose("CssTranslatePositionProvider - Setting position to: " + location);
        ScrollPositionProvider spp = new ScrollPositionProvider(this.logger, this.executor);
        spp.setPosition(Location.ZERO);
        EyesSeleniumUtils.translateTo(this.executor, location);
        this.logger.verbose("Done!");
        this.lastSetPosition = location;
    }

    public RectangleSize getEntireSize() {
        RectangleSize entireSize = EyesSeleniumUtils.getCurrentFrameContentEntireSize(this.executor);
        this.logger.verbose("CssTranslatePositionProvider - Entire size: " + entireSize);
        return entireSize;
    }

    public PositionMemento getState() {
        return new CssTranslatePositionMemento(EyesSeleniumUtils.getCurrentTransform(this.executor), this.lastSetPosition);
    }

    public void restoreState(PositionMemento state) {
        EyesSeleniumUtils.setTransforms(this.executor, ((CssTranslatePositionMemento)state).getTransform());
        this.lastSetPosition = ((CssTranslatePositionMemento)state).getPosition();
    }
}

