/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.capture;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.NullCutProvider;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.ScaleProvider;
import com.applitools.eyes.ScaleProviderFactory;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.capture.EyesScreenshotFactory;
import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.exceptions.EyesDriverOperationException;
import com.applitools.eyes.selenium.positioning.NullRegionPositionCompensation;
import com.applitools.eyes.selenium.positioning.RegionPositionCompensation;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;

public class FullPageCaptureAlgorithm {
    private static final int MIN_SCREENSHOT_PART_HEIGHT = 10;
    private final Logger logger;
    private final UserAgent userAgent;

    public FullPageCaptureAlgorithm(Logger logger, UserAgent userAgent) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)userAgent, (String)"userAgent");
        this.logger = logger;
        this.userAgent = userAgent;
    }

    private static void saveDebugScreenshotPart(DebugScreenshotsProvider debugScreenshotsProvider, BufferedImage image, Region region, String name) {
        String suffix = "part-" + name + "-" + region.getLeft() + "_" + region.getTop() + "_" + region.getWidth() + "x" + region.getHeight();
        debugScreenshotsProvider.save(image, suffix);
    }

    public BufferedImage getStitchedRegion(ImageProvider imageProvider, Region region, PositionProvider originProvider, PositionProvider positionProvider, ScaleProviderFactory scaleProviderFactory, CutProvider cutProvider, int waitBeforeScreenshots, DebugScreenshotsProvider debugScreenshotsProvider, EyesScreenshotFactory screenshotFactory, int stitchingOverlap, RegionPositionCompensation regionPositionCompensation) {
        RectangleSize entireSize;
        this.logger.verbose("getStitchedRegion()");
        ArgumentGuard.notNull((Object)region, (String)"region");
        ArgumentGuard.notNull((Object)positionProvider, (String)"positionProvider");
        this.logger.verbose(String.format("getStitchedRegion: originProvider: %s ; positionProvider: %s ; cutProvider: %s", originProvider.getClass(), positionProvider.getClass(), cutProvider.getClass()));
        this.logger.verbose(String.format("Region to check: %s", region));
        PositionMemento originalPosition = originProvider.getState();
        PositionMemento originalStitchedState = positionProvider.getState();
        this.logger.verbose("Getting top/left image...");
        BufferedImage image = imageProvider.getImage();
        debugScreenshotsProvider.save(image, "original");
        ScaleProvider scaleProvider = scaleProviderFactory.getScaleProvider(image.getWidth());
        double pixelRatio = 1.0 / scaleProvider.getScaleRatio();
        cutProvider = cutProvider.scale(pixelRatio);
        if (!(cutProvider instanceof NullCutProvider)) {
            image = cutProvider.cut(image);
            debugScreenshotsProvider.save(image, "original-cut");
        }
        this.logger.verbose("Done! Creating screenshot object...");
        EyesScreenshot screenshot = screenshotFactory.makeScreenshot(image);
        this.logger.verbose("Done! Getting region in screenshot...");
        Region regionInScreenshot = this.getRegionInScreenshot(region, image, pixelRatio, screenshot, regionPositionCompensation);
        if (!regionInScreenshot.getSize().equals((Object)region.getSize())) {
            regionInScreenshot = this.getRegionInScreenshot(region, image, pixelRatio, screenshot, regionPositionCompensation);
        }
        if (!regionInScreenshot.isSizeEmpty()) {
            image = ImageUtils.getImagePart((BufferedImage)image, (Region)regionInScreenshot);
            FullPageCaptureAlgorithm.saveDebugScreenshotPart(debugScreenshotsProvider, image, region, "cropped");
        }
        if (pixelRatio != 1.0) {
            image = ImageUtils.scaleImage((BufferedImage)image, (ScaleProvider)scaleProvider);
            debugScreenshotsProvider.save(image, "scaled");
        }
        try {
            entireSize = positionProvider.getEntireSize();
            this.logger.verbose("Entire size of region context: " + entireSize);
        }
        catch (EyesDriverOperationException e) {
            this.logger.log("WARNING: Failed to extract entire size of region context" + e.getMessage());
            this.logger.log("Using image size instead: " + image.getWidth() + "x" + image.getHeight());
            entireSize = new RectangleSize(image.getWidth(), image.getHeight());
        }
        if (image.getWidth() >= entireSize.getWidth() && image.getHeight() >= entireSize.getHeight()) {
            originProvider.restoreState(originalPosition);
            return image;
        }
        RectangleSize partImageSize = new RectangleSize(image.getWidth(), Math.max(image.getHeight() - stitchingOverlap, 10));
        this.logger.verbose(String.format("Total size: %s, image part size: %s", entireSize, partImageSize));
        Region entirePage = new Region(Location.ZERO, entireSize);
        Iterable imageParts = entirePage.getSubRegions(partImageSize);
        this.logger.verbose("Creating stitchedImage container. Size: " + entireSize);
        BufferedImage stitchedImage = new BufferedImage(entireSize.getWidth(), entireSize.getHeight(), image.getType());
        this.logger.verbose("Done! Adding initial screenshot..");
        Raster initialPart = image.getData();
        this.logger.verbose(String.format("Initial part:(0,0)[%d x %d]", initialPart.getWidth(), initialPart.getHeight()));
        stitchedImage.getRaster().setRect(0, 0, initialPart);
        this.logger.verbose("Done!");
        Location lastSuccessfulLocation = new Location(0, 0);
        RectangleSize lastSuccessfulPartSize = new RectangleSize(initialPart.getWidth(), initialPart.getHeight());
        this.logger.verbose("Getting the rest of the image parts...");
        BufferedImage partImage = null;
        for (Region partRegion : imageParts) {
            this.logger.verbose(String.format("Taking screenshot for %s", partRegion));
            positionProvider.setPosition(partRegion.getLocation());
            GeneralUtils.sleep((long)waitBeforeScreenshots);
            Location currentPosition = positionProvider.getCurrentPosition();
            this.logger.verbose(String.format("Set position to %s", currentPosition));
            this.logger.verbose("Getting image...");
            partImage = imageProvider.getImage();
            debugScreenshotsProvider.save(partImage, "original-scrolled-" + positionProvider.getCurrentPosition().toStringForFilename());
            if (!(cutProvider instanceof NullCutProvider)) {
                this.logger.verbose("cutting...");
                partImage = cutProvider.cut(partImage);
                debugScreenshotsProvider.save(partImage, "original-scrolled-cut-" + positionProvider.getCurrentPosition().toStringForFilename());
            }
            if (!regionInScreenshot.isSizeEmpty()) {
                this.logger.verbose("cropping...");
                partImage = ImageUtils.getImagePart((BufferedImage)partImage, (Region)regionInScreenshot);
                FullPageCaptureAlgorithm.saveDebugScreenshotPart(debugScreenshotsProvider, partImage, partRegion, "original-scrolled-" + positionProvider.getCurrentPosition().toStringForFilename());
            }
            if (pixelRatio != 1.0) {
                this.logger.verbose("scaling...");
                partImage = ImageUtils.scaleImage((BufferedImage)partImage, (ScaleProvider)scaleProvider);
                FullPageCaptureAlgorithm.saveDebugScreenshotPart(debugScreenshotsProvider, partImage, partRegion, "original-scrolled-" + positionProvider.getCurrentPosition().toStringForFilename() + "-scaled-");
            }
            this.logger.verbose("Stitching part into the image container...");
            stitchedImage.getRaster().setRect(currentPosition.getX(), currentPosition.getY(), partImage.getData());
            this.logger.verbose("Done!");
            lastSuccessfulLocation = currentPosition;
        }
        if (partImage != null) {
            lastSuccessfulPartSize = new RectangleSize(partImage.getWidth(), partImage.getHeight());
        }
        this.logger.verbose("Stitching done!");
        positionProvider.restoreState(originalStitchedState);
        originProvider.restoreState(originalPosition);
        int actualImageWidth = lastSuccessfulLocation.getX() + lastSuccessfulPartSize.getWidth();
        int actualImageHeight = lastSuccessfulLocation.getY() + lastSuccessfulPartSize.getHeight();
        this.logger.verbose("Extracted entire size: " + entireSize);
        this.logger.verbose("Actual stitched size: " + actualImageWidth + "x" + actualImageHeight);
        if (actualImageWidth < stitchedImage.getWidth() || actualImageHeight < stitchedImage.getHeight()) {
            this.logger.verbose("Trimming unnecessary margins..");
            stitchedImage = ImageUtils.getImagePart((BufferedImage)stitchedImage, (Region)new Region(0, 0, Math.min(actualImageWidth, stitchedImage.getWidth()), Math.min(actualImageHeight, stitchedImage.getHeight())));
            this.logger.verbose("Done!");
        }
        debugScreenshotsProvider.save(stitchedImage, "stitched");
        return stitchedImage;
    }

    private Region getRegionInScreenshot(Region region, BufferedImage image, double pixelRatio, EyesScreenshot screenshot, RegionPositionCompensation regionPositionCompensation) {
        Region regionInScreenshot = screenshot.getIntersectedRegion(region, CoordinatesType.SCREENSHOT_AS_IS);
        this.logger.verbose("Done! Region in screenshot: " + regionInScreenshot);
        regionInScreenshot = regionInScreenshot.scale(pixelRatio);
        this.logger.verbose("Scaled region: " + regionInScreenshot);
        if (regionPositionCompensation == null) {
            regionPositionCompensation = new NullRegionPositionCompensation();
        }
        regionInScreenshot = regionPositionCompensation.compensateRegionPosition(regionInScreenshot, pixelRatio);
        regionInScreenshot.intersect(new Region(0, 0, image.getWidth(), image.getHeight()));
        this.logger.verbose("Region after intersect: " + regionInScreenshot);
        return regionInScreenshot;
    }
}

