const assert = require('assert');
const chunkify = require('../src/chunkify');

describe('chunkify', () => {
  function split(str, breakpoints) {
    return [0, ...breakpoints].map((breakpoint, index, breakpoints) => {
      return str.substring(breakpoint, breakpoints[index + 1]);
    });
  }

  it('works with latin (1 byte)', async () => {
    const str = 'abcdefgh1234';
    const chunks = split(str, chunkify(str, 4));
    assert.strictEqual(chunks.length, 3);
    assert.deepStrictEqual(chunks, ['abcd', 'efgh', '1234']);
  });

  it('works with cyrillic (2 bytes)', async () => {
    const str = 'абвгґдеє1234';
    const chunks = split(str, chunkify(str, 4));
    assert.strictEqual(chunks.length, 5);
    assert.deepStrictEqual(chunks, ['аб', 'вг', 'ґд', 'еє', '1234']);
  });

  it('works with currency signs (3 bytes)', async () => {
    const str = '€₭₴';
    const chunks = split(str, chunkify(str, 4));
    assert.strictEqual(chunks.length, 3);
    assert.deepStrictEqual(chunks, ['€', '₭', '₴']);
  });

  it('works with emoji (4 bytes)', async () => {
    const str = '😊🥺😉😍';
    const chunks = split(str, chunkify('😊🥺😉😍', 4));
    assert.strictEqual(chunks.length, 4);
    assert.deepStrictEqual(chunks, ['😊', '🥺', '😉', '😍']);
  });
});
