/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.capture;

import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.logging.Type;
import com.applitools.eyes.selenium.SeleniumEyes;
import com.applitools.eyes.selenium.capture.MobileScreenshotImageProvider;
import com.applitools.utils.ImageUtils;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Collections;
import org.apache.commons.lang3.tuple.Pair;
import org.openqa.selenium.TakesScreenshot;

public class AndroidScreenshotImageProvider
extends MobileScreenshotImageProvider {
    public AndroidScreenshotImageProvider(SeleniumEyes eyes, Logger logger, TakesScreenshot tsInstance, UserAgent userAgent) {
        super(eyes, logger, tsInstance, userAgent);
    }

    public BufferedImage getImage() {
        BufferedImage image = super.getImage();
        this.logger.log(TraceLevel.Info, Collections.singleton(this.eyes.getTestId()), Stage.CHECK, Type.CAPTURE_SCREENSHOT, new Pair[]{Pair.of((Object)"imageSize", (Object)new RectangleSize(image.getWidth(), image.getHeight()))});
        this.eyes.getDebugScreenshotsProvider().save(image, "ANDROID");
        if (this.eyes.getIsCutProviderExplicitlySet()) {
            return image;
        }
        RectangleSize originalViewportSize = this.getViewportSize();
        this.logger.log(TraceLevel.Info, Collections.singleton(this.eyes.getTestId()), Stage.CHECK, Type.CAPTURE_SCREENSHOT, new Pair[]{Pair.of((Object)"originalViewportSize", (Object)originalViewportSize)});
        float widthRatio = (float)image.getWidth() / (float)originalViewportSize.getWidth();
        float height = widthRatio * (float)originalViewportSize.getHeight();
        Rectangle cropRect = new Rectangle(0, 0, image.getWidth(), Math.round(height));
        image = ImageUtils.cropImage((Logger)this.logger, (BufferedImage)image, (Rectangle)cropRect);
        return image;
    }
}

