/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.ICheckSettings;
import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.AppEnvironment;
import com.applitools.eyes.AppOutput;
import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.IBatchCloser;
import com.applitools.eyes.IEyesJsExecutor;
import com.applitools.eyes.IRegion;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.MatchWindowTask;
import com.applitools.eyes.NullCutProvider;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.RunningTest;
import com.applitools.eyes.ScaleProvider;
import com.applitools.eyes.ScaleProviderFactory;
import com.applitools.eyes.ScaleProviderIdentityFactory;
import com.applitools.eyes.TestResultContainer;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.capture.EyesScreenshotFactory;
import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.capture.ScreenshotProvider;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.config.ConfigurationProvider;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.exceptions.TestFailedException;
import com.applitools.eyes.fluent.GetSimpleRegion;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.eyes.fluent.SimpleRegionByRectangle;
import com.applitools.eyes.locators.BaseOcrRegion;
import com.applitools.eyes.locators.OcrRegion;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.logging.Type;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.scaling.FixedScaleProviderFactory;
import com.applitools.eyes.scaling.NullScaleProvider;
import com.applitools.eyes.selenium.Borders;
import com.applitools.eyes.selenium.CaretVisibilityProvider;
import com.applitools.eyes.selenium.CheckState;
import com.applitools.eyes.selenium.ClassicRunner;
import com.applitools.eyes.selenium.ContextBasedScaleProviderFactory;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.EyesSeleniumUtils;
import com.applitools.eyes.selenium.ISeleniumEyes;
import com.applitools.eyes.selenium.NullPositionProvider;
import com.applitools.eyes.selenium.PageState;
import com.applitools.eyes.selenium.SeleniumJavaScriptExecutor;
import com.applitools.eyes.selenium.SizeAndBorders;
import com.applitools.eyes.selenium.StitchMode;
import com.applitools.eyes.selenium.capture.DomCapture;
import com.applitools.eyes.selenium.capture.EyesWebDriverScreenshot;
import com.applitools.eyes.selenium.capture.EyesWebDriverScreenshotFactory;
import com.applitools.eyes.selenium.capture.FullPageCaptureAlgorithm;
import com.applitools.eyes.selenium.capture.ISizeAdjuster;
import com.applitools.eyes.selenium.capture.ImageProviderFactory;
import com.applitools.eyes.selenium.capture.MobileScreenshotImageProvider;
import com.applitools.eyes.selenium.capture.SeleniumScreenshotProvider;
import com.applitools.eyes.selenium.fluent.FrameLocator;
import com.applitools.eyes.selenium.fluent.IScrollRootElementContainer;
import com.applitools.eyes.selenium.fluent.ISeleniumCheckTarget;
import com.applitools.eyes.selenium.fluent.SeleniumCheckSettings;
import com.applitools.eyes.selenium.fluent.SimpleRegionByElement;
import com.applitools.eyes.selenium.fluent.Target;
import com.applitools.eyes.selenium.frames.Frame;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.positioning.CssTranslatePositionProvider;
import com.applitools.eyes.selenium.positioning.ElementPositionProvider;
import com.applitools.eyes.selenium.positioning.ISeleniumPositionProvider;
import com.applitools.eyes.selenium.positioning.ImageRotation;
import com.applitools.eyes.selenium.positioning.PositionProviderFactory;
import com.applitools.eyes.selenium.positioning.RegionPositionCompensation;
import com.applitools.eyes.selenium.positioning.RegionPositionCompensationFactory;
import com.applitools.eyes.selenium.positioning.ScrollPositionProviderFactory;
import com.applitools.eyes.selenium.positioning.SeleniumScrollPositionProvider;
import com.applitools.eyes.selenium.regionVisibility.MoveToRegionVisibilityStrategy;
import com.applitools.eyes.selenium.regionVisibility.NopRegionVisibilityStrategy;
import com.applitools.eyes.selenium.regionVisibility.RegionVisibilityStrategy;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.eyes.selenium.wrappers.EyesSeleniumDriver;
import com.applitools.eyes.selenium.wrappers.EyesTargetLocator;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.eyes.triggers.MouseAction;
import com.applitools.eyes.visualgrid.model.RenderingInfo;
import com.applitools.eyes.visualgrid.model.VisualGridSelector;
import com.applitools.eyes.visualgrid.services.CheckTask;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ClassVersionGetter;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageUtils;
import com.applitools.utils.PropertyHandler;
import com.applitools.utils.ReadOnlyPropertyHandler;
import com.applitools.utils.SimplePropertyHandler;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.annotation.Obsolete;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;

public class SeleniumEyes
extends RunningTest
implements ISeleniumEyes {
    private static final String SCROLL_ELEMENT_ATTRIBUTE = "data-applitools-scroll";
    private static final String ACTIVE_FRAME_ATTRIBUTE = "data-applitools-active-frame";
    public static final double UNKNOWN_DEVICE_PIXEL_RATIO = 0.0;
    public static final double DEFAULT_DEVICE_PIXEL_RATIO = 1.0;
    private static final int USE_DEFAULT_MATCH_TIMEOUT = -1;
    private FrameChain originalFC;
    private WebElement userDefinedSRE;
    private PositionProvider currentFramePositionProvider;
    private EyesSeleniumDriver driver;
    private boolean doNotGetTitle;
    public boolean checkFrameOrElement;
    private Region regionToCheck;
    private ImageRotation rotation;
    private double devicePixelRatio;
    private PropertyHandler<RegionVisibilityStrategy> regionVisibilityStrategyHandler;
    private SeleniumJavaScriptExecutor jsExecutor;
    private UserAgent userAgent;
    private ImageProvider imageProvider;
    private RegionPositionCompensation regionPositionCompensation;
    private Region effectiveViewport;
    private EyesScreenshotFactory screenshotFactory;
    private final ConfigurationProvider configurationProvider;

    @Obsolete
    public boolean shouldStitchContent() {
        return false;
    }

    public SeleniumEyes(ConfigurationProvider configurationProvider, ClassicRunner runner) {
        super(runner);
        this.configurationProvider = configurationProvider;
        this.checkFrameOrElement = false;
        this.doNotGetTitle = false;
        this.devicePixelRatio = 0.0;
        this.regionVisibilityStrategyHandler = new SimplePropertyHandler();
        this.regionVisibilityStrategyHandler.set((Object)new MoveToRegionVisibilityStrategy());
    }

    public String getBaseAgentId() {
        return "eyes.selenium.java/" + ClassVersionGetter.CURRENT_VERSION;
    }

    public void apiKey(String apiKey) {
        this.setApiKey(apiKey);
    }

    public void proxy(AbstractProxySettings proxySettings) {
        this.setProxy(proxySettings);
    }

    public boolean isEyesClosed() {
        return this.isCompleted();
    }

    public IBatchCloser getBatchCloser() {
        return this;
    }

    public String getBatchId() {
        return this.getConfiguration().getBatch().getId();
    }

    public Map<String, RunningTest> getAllRunningTests() {
        HashMap<String, RunningTest> map = new HashMap<String, RunningTest>();
        map.put(this.getTestId(), this);
        return map;
    }

    public List<TestResultContainer> getAllTestResults() {
        if (!this.isCompleted()) {
            return null;
        }
        return Collections.singletonList(this.testResultContainer);
    }

    public boolean isCompleted() {
        return this.testResultContainer != null;
    }

    public void serverUrl(String serverUrl) {
        this.setServerUrl(serverUrl);
    }

    public void serverUrl(URI serverUrl) {
        this.setServerUrl(serverUrl);
    }

    @Override
    public WebDriver getDriver() {
        return this.driver;
    }

    public FrameChain getOriginalFC() {
        return this.originalFC;
    }

    public PositionProvider getCurrentFramePositionProvider() {
        return this.currentFramePositionProvider;
    }

    public Region getRegionToCheck() {
        return this.regionToCheck;
    }

    public void setRegionToCheck(Region regionToCheck) {
        this.regionToCheck = regionToCheck;
    }

    public void setScrollToRegion(boolean shouldScroll) {
        this.regionVisibilityStrategyHandler = shouldScroll ? new ReadOnlyPropertyHandler((Object)new MoveToRegionVisibilityStrategy()) : new ReadOnlyPropertyHandler((Object)new NopRegionVisibilityStrategy(this.logger));
    }

    public boolean getScrollToRegion() {
        return !(this.regionVisibilityStrategyHandler.get() instanceof NopRegionVisibilityStrategy);
    }

    public ImageRotation getRotation() {
        return this.rotation;
    }

    public void setRotation(ImageRotation rotation) {
        this.rotation = rotation;
        if (this.driver != null) {
            this.driver.setRotation(rotation);
        }
    }

    public double getDevicePixelRatio() {
        return this.devicePixelRatio;
    }

    @Override
    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize) throws EyesException {
        this.logger.log(TraceLevel.Info, Collections.singleton(this.getTestId()), Stage.OPEN, Type.CALLED, new Pair[]{Pair.of((Object)"appName", (Object)appName), Pair.of((Object)"testName", (Object)testName), Pair.of((Object)"viewportSize", (Object)(viewportSize == null ? "default" : viewportSize))});
        this.getConfigurationInstance().setAppName(appName).setTestName(testName);
        if (viewportSize != null && !viewportSize.isEmpty()) {
            this.getConfigurationInstance().setViewportSize(new RectangleSize(viewportSize));
        }
        return this.open(driver);
    }

    @Override
    public WebDriver open(WebDriver driver) throws EyesException {
        this.openLogger();
        if (this.getIsDisabled()) {
            return driver;
        }
        this.initDriver(driver);
        this.jsExecutor = new SeleniumJavaScriptExecutor(this.driver);
        String uaString = this.driver.getUserAgent();
        if (uaString != null) {
            if (uaString.startsWith("useragent:")) {
                uaString = uaString.substring(10);
            }
            this.userAgent = UserAgent.parseUserAgentString((String)uaString, (boolean)true);
        }
        this.initDevicePixelRatio();
        this.screenshotFactory = new EyesWebDriverScreenshotFactory(this.logger, this.driver);
        this.imageProvider = ImageProviderFactory.getImageProvider(this.userAgent, this, this.logger, (TakesScreenshot)this.driver);
        this.regionPositionCompensation = RegionPositionCompensationFactory.getRegionPositionCompensation(this.userAgent, this, this.logger);
        if (!this.getConfigurationInstance().isVisualGrid()) {
            this.openBase();
        } else {
            this.isOpen = true;
        }
        this.driver.setRotation(this.rotation);
        this.runner.addBatch(this.getConfigurationInstance().getBatch().getId(), (IBatchCloser)this);
        return this.driver;
    }

    private void initDevicePixelRatio() {
        try {
            this.devicePixelRatio = this.driver.getDevicePixelRatio();
        }
        catch (Exception ex) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.GENERAL, (Throwable)ex, (String[])new String[0]);
            this.devicePixelRatio = 1.0;
        }
        this.logger.log(this.getTestId(), Stage.GENERAL, new Pair[]{Pair.of((Object)"devicePixelRatio", (Object)this.devicePixelRatio)});
    }

    private void initDriver(WebDriver driver) {
        if (driver instanceof RemoteWebDriver) {
            this.driver = new EyesSeleniumDriver(this.logger, this, (RemoteWebDriver)driver);
        } else if (driver instanceof EyesSeleniumDriver) {
            this.driver = (EyesSeleniumDriver)driver;
        } else {
            throw new EyesException("Driver is not a RemoteWebDriver (" + driver.getClass().getName() + ")");
        }
        if (EyesDriverUtils.isMobileDevice((WebDriver)driver)) {
            this.regionVisibilityStrategyHandler.set((Object)new NopRegionVisibilityStrategy(this.logger));
        }
    }

    public WebElement getScrollRootElement() {
        if (this.userDefinedSRE == null) {
            this.userDefinedSRE = EyesSeleniumUtils.getDefaultRootElement(this.logger, this.driver);
        }
        return this.userDefinedSRE;
    }

    private PositionProvider createPositionProvider() {
        return this.createPositionProvider(this.userDefinedSRE);
    }

    private PositionProvider createPositionProvider(WebElement scrollRootElement) {
        StitchMode stitchMode = this.getConfigurationInstance().getStitchMode();
        if (stitchMode == StitchMode.CSS) {
            return new CssTranslatePositionProvider(this.logger, this.jsExecutor, scrollRootElement);
        }
        return ScrollPositionProviderFactory.getScrollPositionProvider(this.userAgent, this.logger, (IEyesJsExecutor)this.jsExecutor, scrollRootElement);
    }

    public void checkWindow() {
        this.checkWindow(null);
    }

    public void checkWindow(String tag) {
        this.check(tag, (ICheckSettings)Target.window());
    }

    public void checkWindow(int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.window().timeout(matchTimeout));
    }

    public void check(ICheckSettings ... checkSettings) {
        boolean originalForceFPS;
        if (this.getIsDisabled()) {
            return;
        }
        Boolean forceFullPageScreenshot = this.getConfigurationInstance().getForceFullPageScreenshot();
        boolean bl = originalForceFPS = forceFullPageScreenshot != null && forceFullPageScreenshot != false;
        if (checkSettings.length > 1) {
            this.getConfigurationInstance().setForceFullPageScreenshot(true);
        }
        Hashtable<Integer, GetSimpleRegion> getRegions = new Hashtable<Integer, GetSimpleRegion>();
        Hashtable<Integer, ICheckSettingsInternal> checkSettingsInternalDictionary = new Hashtable<Integer, ICheckSettingsInternal>();
        for (int i = 0; i < checkSettings.length; ++i) {
            ISeleniumCheckTarget seleniumCheckTarget;
            ICheckSettings settings = checkSettings[i];
            ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)settings;
            ((Dictionary)checkSettingsInternalDictionary).put(i, checkSettingsInternal);
            Region targetRegion = checkSettingsInternal.getTargetRegion();
            if (targetRegion != null) {
                ((Dictionary)getRegions).put(i, (GetSimpleRegion)new SimpleRegionByRectangle(targetRegion));
                continue;
            }
            ISeleniumCheckTarget iSeleniumCheckTarget = seleniumCheckTarget = settings instanceof ISeleniumCheckTarget ? (ISeleniumCheckTarget)settings : null;
            if (seleniumCheckTarget == null) continue;
            seleniumCheckTarget.init(this.logger, this.driver);
            WebElement targetElement = this.getTargetElement(seleniumCheckTarget);
            if (targetElement == null && seleniumCheckTarget.getFrameChain().size() == 1) {
                targetElement = EyesSeleniumUtils.findFrameByFrameCheckTarget(seleniumCheckTarget.getFrameChain().get(0), this.driver);
            }
            if (targetElement == null) continue;
            SimpleRegionByElement simpleRegionByElement = new SimpleRegionByElement(targetElement);
            simpleRegionByElement.init(this.logger, (EyesWebDriver)this.driver);
            ((Dictionary)getRegions).put(i, (GetSimpleRegion)simpleRegionByElement);
        }
        this.userDefinedSRE = EyesSeleniumUtils.getScrollRootElement(this.logger, this.driver, (IScrollRootElementContainer)checkSettings[0]);
        this.currentFramePositionProvider = null;
        this.setPositionProvider(this.createPositionProvider());
        this.matchRegions(getRegions, checkSettingsInternalDictionary, checkSettings);
        this.getConfigurationInstance().setForceFullPageScreenshot(originalForceFPS);
    }

    private void matchRegions(Dictionary<Integer, GetSimpleRegion> getRegions, Dictionary<Integer, ICheckSettingsInternal> checkSettingsInternalDictionary, ICheckSettings[] checkSettings) {
        boolean hasFrames;
        if (getRegions.size() == 0) {
            return;
        }
        this.originalFC = this.driver.getFrameChain().clone();
        Region bBox = this.findBoundingBox(getRegions, checkSettings);
        ScaleProviderFactory scaleProviderFactory = this.updateScalingParams();
        FullPageCaptureAlgorithm algo = this.createFullPageCaptureAlgorithm(scaleProviderFactory, new RenderingInfo());
        Object activeElement = null;
        if (this.getConfigurationInstance().getHideCaret()) {
            try {
                activeElement = this.driver.executeScript("var activeElement = document.activeElement; activeElement && activeElement.blur(); return activeElement;", new Object[0]);
            }
            catch (WebDriverException e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Throwable)e, (String[])new String[]{this.getTestId()});
            }
        }
        Region region = Region.EMPTY;
        boolean bl = hasFrames = this.driver.getFrameChain().size() > 0;
        if (hasFrames) {
            region = new Region(bBox.getLocation(), ((EyesRemoteWebElement)this.userDefinedSRE).getClientSize());
        } else {
            WebElement defaultRootElement = EyesSeleniumUtils.getDefaultRootElement(this.logger, this.driver);
            if (!this.userDefinedSRE.equals(defaultRootElement)) {
                EyesRemoteWebElement eyesScrollRootElement = this.userDefinedSRE instanceof EyesRemoteWebElement ? (EyesRemoteWebElement)this.userDefinedSRE : new EyesRemoteWebElement(this.logger, this.driver, this.userDefinedSRE);
                Point location = eyesScrollRootElement.getLocation();
                SizeAndBorders sizeAndBorders = eyesScrollRootElement.getSizeAndBorders();
                region = new Region(location.getX() + sizeAndBorders.getBorders().getLeft(), location.getY() + sizeAndBorders.getBorders().getTop(), sizeAndBorders.getSize().getWidth(), sizeAndBorders.getSize().getHeight());
            }
        }
        region.intersect(this.effectiveViewport);
        BufferedImage screenshotImage = algo.getStitchedRegion(region, bBox, (PositionProvider)this.positionProviderHandler.get(), (PositionProvider)this.positionProviderHandler.get(), RectangleSize.EMPTY);
        this.debugScreenshotsProvider.save(screenshotImage, "original");
        EyesWebDriverScreenshot screenshot = new EyesWebDriverScreenshot(this.logger, this.driver, screenshotImage, EyesWebDriverScreenshot.ScreenshotType.VIEWPORT, Location.ZERO);
        for (int i = 0; i < checkSettings.length; ++i) {
            if (!((Hashtable)getRegions).containsKey(i)) continue;
            GetSimpleRegion simpleRegion = getRegions.get(i);
            ICheckSettingsInternal checkSettingsInternal = checkSettingsInternalDictionary.get(i);
            List<EyesScreenshot> subScreenshots = this.getSubScreenshots(hasFrames ? Region.EMPTY : bBox, screenshot, simpleRegion);
            this.matchRegion(checkSettingsInternal, subScreenshots);
        }
        if (this.getConfigurationInstance().getHideCaret() && activeElement != null) {
            try {
                this.driver.executeScript("arguments[0].focus();", activeElement);
            }
            catch (WebDriverException e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Throwable)e, (String[])new String[]{this.getTestId()});
            }
        }
        ((EyesTargetLocator)this.driver.switchTo()).frames(this.originalFC);
    }

    private List<EyesScreenshot> getSubScreenshots(Region bBox, EyesWebDriverScreenshot screenshot, GetSimpleRegion getSimpleRegion) {
        ArrayList<EyesScreenshot> subScreenshots = new ArrayList<EyesScreenshot>();
        for (Region r : getSimpleRegion.getRegions((EyesScreenshot)screenshot)) {
            r = r.offset(-bBox.getLeft(), -bBox.getTop());
            EyesWebDriverScreenshot subScreenshot = screenshot.getSubScreenshotForRegion(r, false);
            subScreenshots.add(subScreenshot);
        }
        return subScreenshots;
    }

    private void matchRegion(ICheckSettingsInternal checkSettingsInternal, List<EyesScreenshot> subScreenshots) {
        String name = checkSettingsInternal.getName();
        String source = EyesDriverUtils.isMobileDevice((WebDriver)this.driver) ? null : this.driver.getCurrentUrl();
        for (EyesScreenshot subScreenshot : subScreenshots) {
            this.debugScreenshotsProvider.save(subScreenshot.getImage(), String.format("subscreenshot_%s", name));
            ImageMatchSettings ims = MatchWindowTask.createImageMatchSettings((ICheckSettingsInternal)checkSettingsInternal, (EyesScreenshot)subScreenshot, (EyesBase)this);
            Location location = subScreenshot.getLocationInScreenshot(Location.ZERO, CoordinatesType.SCREENSHOT_AS_IS);
            AppOutput appOutput = new AppOutput(name, subScreenshot, null, null, location);
            MatchWindowData data = this.prepareForMatch(checkSettingsInternal, new ArrayList(), appOutput, name, false, ims, null, source);
            this.performMatch(data);
        }
    }

    private Region findBoundingBox(Dictionary<Integer, GetSimpleRegion> getRegions, ICheckSettings[] checkSettings) {
        RectangleSize rectSize = this.getViewportSize();
        EyesWebDriverScreenshot screenshot = new EyesWebDriverScreenshot(this.logger, this.driver, new BufferedImage(rectSize.getWidth(), rectSize.getHeight(), 1));
        return this.findBoundingBox(getRegions, checkSettings, screenshot);
    }

    private Region findBoundingBox(Dictionary<Integer, GetSimpleRegion> getRegions, ICheckSettings[] checkSettings, EyesScreenshot screenshot) {
        Region bBox = null;
        for (int i = 0; i < checkSettings.length; ++i) {
            GetSimpleRegion simpleRegion = getRegions.get(i);
            if (simpleRegion == null) continue;
            List regions = simpleRegion.getRegions(screenshot);
            for (Region region : regions) {
                if (bBox == null) {
                    bBox = new Region((IRegion)region);
                    continue;
                }
                bBox = bBox.expandToContain(region);
            }
        }
        Location offset = screenshot.getLocationInScreenshot(Location.ZERO, CoordinatesType.CONTEXT_AS_IS);
        return bBox.offset(offset);
    }

    private WebElement getTargetElement(ISeleniumCheckTarget seleniumCheckTarget) {
        assert (seleniumCheckTarget != null);
        By targetSelector = seleniumCheckTarget.getTargetSelector();
        Object targetElement = seleniumCheckTarget.getTargetElement();
        if (targetElement == null && targetSelector != null) {
            targetElement = this.driver.findElement(targetSelector);
        } else if (targetElement != null && !(targetElement instanceof EyesRemoteWebElement)) {
            targetElement = new EyesRemoteWebElement(this.logger, this.driver, (WebElement)targetElement);
        }
        return targetElement;
    }

    public void check(String name, ICheckSettings checkSettings) {
        if (this.getIsDisabled()) {
            return;
        }
        ArgumentGuard.isValidState((boolean)this.isOpen, (String)"Eyes not open");
        ArgumentGuard.notNull((Object)checkSettings, (String)"checkSettings");
        if (name != null) {
            checkSettings = checkSettings.withName(name);
        }
        this.check(checkSettings);
    }

    public void setIsDisabled(boolean disabled) {
        super.setIsDisabled(disabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tryCaptureDom() {
        String fullWindowDom = "";
        FrameChain fc = this.driver.getFrameChain().clone();
        try {
            Frame frame = fc.peek();
            WebElement scrollRootElement = null;
            if (frame != null) {
                scrollRootElement = frame.getScrollRootElement();
            }
            if (scrollRootElement == null) {
                scrollRootElement = EyesSeleniumUtils.getDefaultRootElement(this.logger, this.driver);
            }
            SeleniumScrollPositionProvider positionProvider = ScrollPositionProviderFactory.getScrollPositionProvider(this.userAgent, this.logger, (IEyesJsExecutor)this.jsExecutor, scrollRootElement);
            DomCapture domCapture = new DomCapture(this);
            fullWindowDom = domCapture.getPageDom((PositionProvider)positionProvider);
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Type)Type.DOM_SCRIPT, (Throwable)e, (String[])new String[]{this.getBaseAgentId()});
        }
        finally {
            ((EyesTargetLocator)this.driver.switchTo()).frames(fc);
        }
        return fullWindowDom;
    }

    protected void setEffectiveViewportSize(RectangleSize size) {
        this.effectiveViewport = new Region(Location.ZERO, size);
    }

    public void check(ICheckSettings checkSettings) {
        if (this.getIsDisabled()) {
            return;
        }
        this.logger.log(TraceLevel.Info, Collections.singleton(this.getTestId()), Stage.CHECK, Type.CALLED, new Pair[]{Pair.of((Object)"configuration", (Object)this.getConfiguration()), Pair.of((Object)"checkSettings", (Object)checkSettings)});
        try {
            RectangleSize viewportSize;
            ArgumentGuard.isValidState((boolean)this.isOpen, (String)"Eyes not open");
            ArgumentGuard.notNull((Object)checkSettings, (String)"checkSettings");
            ArgumentGuard.notOfType((Object)checkSettings, ISeleniumCheckTarget.class, (String)"checkSettings");
            boolean isMobileDevice = EyesDriverUtils.isMobileDevice((WebDriver)this.driver);
            String source = null;
            if (!isMobileDevice) {
                source = this.driver.getCurrentUrl();
            }
            ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)checkSettings;
            ISeleniumCheckTarget seleniumCheckTarget = (ISeleniumCheckTarget)checkSettings;
            CheckState state = new CheckState();
            seleniumCheckTarget.setState(state);
            Boolean forceFullPageScreenshot = this.getConfigurationInstance().getForceFullPageScreenshot();
            Boolean fully = checkSettingsInternal.getStitchContent();
            state.setStitchContent(fully != null && fully != false || forceFullPageScreenshot != null && forceFullPageScreenshot != false);
            ((SeleniumCheckSettings)checkSettings).sanitizeSettings(this.driver, state.isStitchContent());
            seleniumCheckTarget.init(this.logger, this.driver);
            Region targetRegion = checkSettingsInternal.getTargetRegion();
            WebElement scrollRootElement = this.userDefinedSRE = SeleniumEyes.tryGetUserDefinedSREFromSREContainer(seleniumCheckTarget, this.driver);
            if (scrollRootElement == null && !isMobileDevice) {
                scrollRootElement = EyesSeleniumUtils.getDefaultRootElement(this.logger, this.driver);
            }
            this.currentFramePositionProvider = null;
            this.positionProviderHandler.set((Object)PositionProviderFactory.getPositionProvider(this.logger, this.getConfigurationInstance().getStitchMode(), this.jsExecutor, scrollRootElement, this.userAgent));
            CaretVisibilityProvider caretVisibilityProvider = new CaretVisibilityProvider(this.driver, this.getConfigurationInstance());
            PageState pageState = new PageState(this.logger, this.driver, this.getConfigurationInstance().getStitchMode(), this.userAgent);
            pageState.preparePage(seleniumCheckTarget, this.getConfigurationInstance(), scrollRootElement);
            FrameChain frameChainAfterSwitchToTarget = this.driver.getFrameChain().clone();
            if (this.effectiveViewport == null) {
                viewportSize = this.getViewportSize();
                this.setEffectiveViewportSize(viewportSize);
            }
            viewportSize = this.effectiveViewport.getSize();
            Region effectiveViewport = this.computeEffectiveViewport(frameChainAfterSwitchToTarget, viewportSize);
            state.setEffectiveViewport(effectiveViewport);
            WebElement targetElement = this.getTargetElementFromSettings(seleniumCheckTarget);
            caretVisibilityProvider.hideCaret();
            if (targetElement != null) {
                if (isMobileDevice) {
                    this.checkNativeElement(checkSettingsInternal, targetElement);
                } else if (state.isStitchContent()) {
                    this.checkFullElement(checkSettingsInternal, targetElement, targetRegion, state, source);
                } else {
                    this.checkElement(checkSettingsInternal, targetElement, targetRegion, state, source);
                }
            } else if (targetRegion != null) {
                boolean originalFully = state.isStitchContent();
                state.setStitchContent(true);
                this.checkFullRegion(checkSettingsInternal, targetRegion, state, source);
                state.setStitchContent(originalFully);
            } else if (!isMobileDevice && seleniumCheckTarget.getFrameChain().size() > 0) {
                if (state.isStitchContent()) {
                    this.checkFullFrame(checkSettingsInternal, state, source);
                }
            } else if (state.isStitchContent()) {
                this.checkFullWindow(checkSettingsInternal, state, scrollRootElement, source);
            } else {
                this.checkWindow(checkSettingsInternal, state, scrollRootElement, source);
            }
            caretVisibilityProvider.restoreCaret();
            pageState.restorePageState();
        }
        catch (Exception ex) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Throwable)ex, (String[])new String[]{this.getTestId()});
            throw ex;
        }
    }

    private void checkFullFrame(ICheckSettingsInternal checkSettingsInternal, CheckState state, String source) {
        FrameChain currentFrameChain = this.driver.getFrameChain().clone();
        Location visualOffset = this.getFrameChainOffset(currentFrameChain);
        Frame currentFrame = currentFrameChain.peek();
        state.setEffectiveViewport(state.getEffectiveViewport().getIntersected(new Region(visualOffset, currentFrame.getInnerSize())));
        WebElement currentFrameSRE = this.getCurrentFrameScrollRootElement();
        RectangleSize currentSREScrollSize = EyesRemoteWebElement.getScrollSize(currentFrameSRE, (JavascriptExecutor)this.driver, this.logger);
        state.setFullRegion(new Region(state.getEffectiveViewport().getLocation(), currentSREScrollSize));
        state.setOriginalLocation(Location.ZERO);
        this.checkWindowBase(null, checkSettingsInternal, source);
    }

    private void checkFullRegion(ICheckSettingsInternal checkSettingsInternal, Region targetRegion, CheckState state, String source) {
        FrameChain currentFrameChain = this.driver.getFrameChain().clone();
        Frame currentFrame = currentFrameChain.peek();
        if (currentFrame != null) {
            Region currentFrameBoundsWithoutBorders = SeleniumEyes.removeBorders(currentFrame.getBounds(), currentFrame.getBorderWidths());
            state.setEffectiveViewport(state.getEffectiveViewport().getIntersected(currentFrameBoundsWithoutBorders));
            WebElement currentFrameSRE = this.getCurrentFrameScrollRootElement();
            RectangleSize currentSREScrollSize = EyesRemoteWebElement.getScrollSize(currentFrameSRE, (JavascriptExecutor)this.driver, this.logger);
            state.setFullRegion(new Region(state.getEffectiveViewport().getLocation(), currentSREScrollSize));
        } else {
            Location visualOffset = this.getFrameChainOffset(currentFrameChain);
            targetRegion = targetRegion.offset(visualOffset);
        }
        this.checkWindowBase(targetRegion, checkSettingsInternal, source);
    }

    private static Region removeBorders(Region region, Borders borders) {
        return new Region(region.getLeft() + borders.getLeft(), region.getTop() + borders.getTop(), region.getWidth() - borders.getHorizontal(), region.getHeight() - borders.getVertical(), region.getCoordinatesType());
    }

    private void checkElement(ICheckSettingsInternal checkSettingsInternal, WebElement targetElement, Region targetRegion, CheckState state, String source) {
        List<FrameLocator> frameLocators = ((ISeleniumCheckTarget)checkSettingsInternal).getFrameChain();
        FrameChain currentFrameChain = this.driver.getFrameChain().clone();
        Region bounds = EyesRemoteWebElement.getClientBounds(targetElement, (JavascriptExecutor)this.driver, this.logger);
        WebElement defaultSRE = EyesSeleniumUtils.getDefaultRootElement(this.logger, this.driver);
        PositionProvider defaultSREPositionProvider = this.getPositionProviderForScrollRootElement(defaultSRE);
        state.setOriginalLocation(bounds.offset(defaultSREPositionProvider.getCurrentPosition()).getLocation());
        WebElement currentFrameSRE = this.getCurrentFrameScrollRootElement();
        PositionProvider currentFramePositionProvider = this.getPositionProviderForScrollRootElement(currentFrameSRE);
        Location currentFramePosition = currentFramePositionProvider.getCurrentPosition();
        Location visualOffset = this.getFrameChainOffset(currentFrameChain);
        bounds = bounds.offset(visualOffset);
        currentFramePositionProvider.setPosition(bounds.offset(currentFramePosition).getLocation());
        Region actualElementBounds = EyesRemoteWebElement.getClientBounds(targetElement, (JavascriptExecutor)this.driver, this.logger);
        actualElementBounds = actualElementBounds.offset(visualOffset);
        Location actualFramePosition = new Location(bounds.getLeft() - actualElementBounds.getLeft(), bounds.getTop() - actualElementBounds.getTop());
        bounds = bounds.offset(-actualFramePosition.getX(), -actualFramePosition.getY());
        EyesTargetLocator switchTo = (EyesTargetLocator)this.driver.switchTo();
        FrameChain fcClone = currentFrameChain.clone();
        while (!state.getEffectiveViewport().isIntersected(bounds) && fcClone.size() > 0) {
            fcClone.pop();
            switchTo.parentFrame();
            currentFrameSRE = this.getCurrentFrameScrollRootElement();
            currentFramePositionProvider = this.getPositionProviderForScrollRootElement(currentFrameSRE);
            currentFramePosition = currentFramePositionProvider.getCurrentPosition();
            bounds = bounds.offset(currentFramePosition);
            actualFramePosition = currentFramePositionProvider.setPosition(bounds.getLocation());
            bounds = bounds.offset(-actualFramePosition.getX(), -actualFramePosition.getY());
        }
        switchTo.frames(currentFrameChain);
        Region crop = SeleniumEyes.computeCropRectangle(bounds, targetRegion);
        if (crop == null) {
            crop = bounds;
        }
        this.checkWindowBase(crop, checkSettingsInternal, source);
    }

    private void checkFullElement(ICheckSettingsInternal checkSettingsInternal, WebElement targetElement, Region targetRegion, CheckState state, String source) {
        boolean isScrollableElement;
        String originalOverflow = EyesDriverUtils.setOverflow((JavascriptExecutor)this.driver, (String)"hidden", (WebElement)targetElement);
        RectangleSize scrollSize = EyesRemoteWebElement.getScrollSize(targetElement, (JavascriptExecutor)this.driver, this.logger);
        Region elementBounds = EyesRemoteWebElement.getClientBounds(targetElement, (JavascriptExecutor)this.driver, this.logger);
        Region elementInnerBounds = EyesRemoteWebElement.getClientBoundsWithoutBorders(targetElement, this.driver);
        boolean bl = isScrollableElement = scrollSize.getHeight() > elementInnerBounds.getHeight() || scrollSize.getWidth() > elementInnerBounds.getWidth();
        if (isScrollableElement) {
            elementBounds = elementInnerBounds;
        }
        this.initPositionProvidersForCheckElement(isScrollableElement, targetElement, state);
        Location location = SeleniumScrollPositionProvider.getCurrentPosition(this.driver, EyesSeleniumUtils.getDefaultRootElement(this.logger, this.driver));
        state.setOriginalLocation(elementBounds.offset(location).getLocation());
        Location originalElementLocation = elementBounds.getLocation();
        String positionStyle = ((EyesRemoteWebElement)targetElement).getComputedStyle("position");
        if (!positionStyle.equalsIgnoreCase("fixed")) {
            if (this.getConfiguration().getStitchMode().equals((Object)StitchMode.CSS)) {
                this.bringRegionToViewCss(elementBounds, state.getEffectiveViewport().getLocation());
                elementBounds = isScrollableElement ? EyesRemoteWebElement.getClientBoundsWithoutBorders(targetElement, this.driver) : EyesRemoteWebElement.getClientBounds(targetElement, (JavascriptExecutor)this.driver, this.logger);
                state.setEffectiveViewport(this.computeEffectiveViewport(this.driver.getFrameChain().clone(), this.effectiveViewport.getSize()));
            } else {
                elementBounds = this.bringRegionToView(elementBounds, state.getEffectiveViewport().getLocation());
            }
        }
        Region fullElementBounds = new Region((IRegion)elementBounds);
        fullElementBounds.setWidth(Math.max(fullElementBounds.getWidth(), scrollSize.getWidth()));
        fullElementBounds.setHeight(Math.max(fullElementBounds.getHeight(), scrollSize.getHeight()));
        FrameChain currentFrameChain = this.driver.getFrameChain().clone();
        Location screenshotOffset = this.getFrameChainOffset(currentFrameChain);
        fullElementBounds = fullElementBounds.offset(screenshotOffset);
        state.setFullRegion(fullElementBounds);
        if (this.getConfigurationInstance().getStitchMode() == StitchMode.CSS && this.userDefinedSRE != null) {
            Region viewportInScreenshot = state.getEffectiveViewport();
            int elementTranslationWidth = originalElementLocation.getX() - elementBounds.getLeft();
            int elementTranslationHeight = originalElementLocation.getY() - elementBounds.getTop();
            state.setEffectiveViewport(new Region(viewportInScreenshot.getLeft(), viewportInScreenshot.getTop(), viewportInScreenshot.getWidth() - elementTranslationWidth, viewportInScreenshot.getHeight() - elementTranslationHeight));
        }
        if (this.getConfigurationInstance().getStitchMode() == StitchMode.SCROLL && !isScrollableElement) {
            EyesRemoteWebElement sre = (EyesRemoteWebElement)this.getCurrentFrameScrollRootElement();
            state.setStitchOffset(new RectangleSize(sre.getScrollLeft(), sre.getScrollTop()));
        }
        Region elementBoundsInScreenshotCoordinates = elementBounds.offset(screenshotOffset);
        Region intersectedViewport = state.getEffectiveViewport().getIntersected(elementBoundsInScreenshotCoordinates);
        state.setEffectiveViewport(intersectedViewport);
        Region crop = SeleniumEyes.computeCropRectangle(fullElementBounds, targetRegion);
        this.checkWindowBase(crop, checkSettingsInternal, source);
        EyesDriverUtils.setOverflow((JavascriptExecutor)this.driver, (String)originalOverflow, (WebElement)targetElement);
    }

    private void checkNativeElement(ICheckSettingsInternal checkSettingsInternal, WebElement targetElement) {
        Rectangle rect = targetElement.getRect();
        Region region = checkSettingsInternal.getTargetRegion();
        if (region == null) {
            region = new Region(rect.x, rect.y, rect.width, rect.height);
        }
        this.checkWindowBase(region, checkSettingsInternal, null);
    }

    private void checkWindow(ICheckSettingsInternal checkSettingsInternal, CheckState state, WebElement scrollRootElement, String source) {
        Location location = Location.ZERO;
        if (!EyesDriverUtils.isMobileDevice((WebDriver)this.driver)) {
            location = SeleniumScrollPositionProvider.getCurrentPosition(this.driver, scrollRootElement);
        }
        state.setOriginalLocation(location);
        this.checkWindowBase(null, checkSettingsInternal, source);
    }

    private void checkFullWindow(ICheckSettingsInternal checkSettingsInternal, CheckState state, WebElement scrollRootElement, String source) {
        this.initPositionProvidersForCheckWindow(state, scrollRootElement);
        state.setOriginalLocation(Location.ZERO);
        this.checkWindowBase(null, checkSettingsInternal, source);
    }

    private void initPositionProvidersForCheckWindow(CheckState state, WebElement scrollRootElement) {
        if (this.getConfigurationInstance().getStitchMode() == StitchMode.SCROLL) {
            state.setStitchPositionProvider((PositionProvider)new SeleniumScrollPositionProvider(this.logger, this.driver, scrollRootElement));
        } else if (this.userDefinedSRE != null) {
            state.setStitchPositionProvider(new ElementPositionProvider(this.logger, this.driver, this.userDefinedSRE));
        } else {
            state.setStitchPositionProvider(new CssTranslatePositionProvider(this.logger, this.driver, scrollRootElement));
            state.setOriginPositionProvider((PositionProvider)new SeleniumScrollPositionProvider(this.logger, this.driver, scrollRootElement));
        }
    }

    private static Region computeCropRectangle(Region fullRect, Region cropRect) {
        if (cropRect == null) {
            return null;
        }
        Region crop = new Region((IRegion)fullRect);
        Location cropLocation = crop.getLocation();
        Region cropRectClone = cropRect.offset(cropLocation);
        crop.intersect(cropRectClone);
        return crop;
    }

    private Location getFrameChainOffset(FrameChain frameChain) {
        Location offset = Location.ZERO;
        for (Frame frame : frameChain) {
            offset = offset.offset(frame.getLocation());
        }
        return offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Region bringRegionToViewCss(Region bounds, Location viewportLocation) {
        FrameChain frames = this.driver.getFrameChain().clone();
        if (frames.size() <= 0) {
            return this.bringRegionToView(bounds, viewportLocation);
        }
        Location currentFrameOffset = frames.getCurrentFrameOffset();
        EyesTargetLocator locator = (EyesTargetLocator)this.driver.switchTo();
        locator.defaultContent();
        try {
            EyesRemoteWebElement currentFrameSRE = (EyesRemoteWebElement)this.getCurrentFrameScrollRootElement();
            PositionProvider currentFramePositionProvider = PositionProviderFactory.getPositionProvider(this.logger, StitchMode.CSS, this.jsExecutor, (WebElement)currentFrameSRE, this.userAgent);
            Location currentFramePosition = currentFramePositionProvider.getCurrentPosition();
            Location boundsPosition = bounds.getLocation();
            Location newFramePosition = boundsPosition.offset(-viewportLocation.getX(), -viewportLocation.getY());
            newFramePosition = newFramePosition.offset(currentFrameOffset);
            Location currentCssLocation = currentFrameSRE.getCurrentCssStitchingLocation();
            if (currentCssLocation != null) {
                newFramePosition = newFramePosition.offset(currentCssLocation);
            }
            Location actualFramePosition = currentFramePositionProvider.setPosition(newFramePosition);
            bounds = bounds.offset(-actualFramePosition.getX(), -actualFramePosition.getY());
            Region region = bounds = bounds.offset(currentFramePosition);
            return region;
        }
        finally {
            locator.frames(frames);
        }
    }

    private Region bringRegionToView(Region bounds, Location viewportLocation) {
        WebElement currentFrameSRE = this.getCurrentFrameScrollRootElement();
        StitchMode stitchMode = this.getConfigurationInstance().getStitchMode();
        PositionProvider currentFramePositionProvider = PositionProviderFactory.getPositionProvider(this.logger, stitchMode, this.jsExecutor, currentFrameSRE, this.userAgent);
        Location currentFramePosition = currentFramePositionProvider.getCurrentPosition();
        Location boundsPosition = bounds.getLocation();
        Location newFramePosition = boundsPosition.offset(-viewportLocation.getX(), -viewportLocation.getY());
        if (stitchMode.equals((Object)StitchMode.SCROLL)) {
            newFramePosition = newFramePosition.offset(currentFramePosition);
        }
        Location actualFramePosition = currentFramePositionProvider.setPosition(newFramePosition);
        bounds = bounds.offset(-actualFramePosition.getX(), -actualFramePosition.getY());
        bounds = bounds.offset(currentFramePosition);
        return bounds;
    }

    private void initPositionProvidersForCheckElement(boolean isScrollableElement, WebElement targetElement, CheckState state) {
        if (isScrollableElement) {
            state.setStitchPositionProvider(new ElementPositionProvider(this.logger, this.driver, targetElement));
        } else {
            WebElement scrollRootElement = this.getCurrentFrameScrollRootElement();
            if (this.getConfigurationInstance().getStitchMode() == StitchMode.CSS) {
                state.setStitchPositionProvider(new CssTranslatePositionProvider(this.logger, this.driver, targetElement));
                state.setOriginPositionProvider(new NullPositionProvider());
            } else {
                state.setStitchPositionProvider((PositionProvider)new SeleniumScrollPositionProvider(this.logger, this.driver, scrollRootElement));
            }
        }
    }

    public static WebElement tryGetUserDefinedSREFromSREContainer(IScrollRootElementContainer scrollRootElementContainer, EyesSeleniumDriver driver) {
        By scrollRootSelector;
        WebElement scrollRootElement = scrollRootElementContainer.getScrollRootElement();
        if (scrollRootElement == null && (scrollRootSelector = scrollRootElementContainer.getScrollRootSelector()) != null) {
            scrollRootElement = driver.findElement(scrollRootSelector);
        }
        return scrollRootElement;
    }

    public static WebElement getScrollRootElementFromSREContainer(Logger logger, IScrollRootElementContainer scrollRootElementContainer, EyesSeleniumDriver driver) {
        WebElement scrollRootElement = SeleniumEyes.tryGetUserDefinedSREFromSREContainer(scrollRootElementContainer, driver);
        if (scrollRootElement == null) {
            scrollRootElement = EyesSeleniumUtils.getDefaultRootElement(logger, driver);
        }
        return scrollRootElement;
    }

    private PositionProvider getPositionProviderForScrollRootElement(WebElement scrollRootElement) {
        return SeleniumEyes.getPositionProviderForScrollRootElement(this.logger, this.driver, this.getConfigurationInstance().getStitchMode(), this.userAgent, scrollRootElement);
    }

    public static PositionProvider getPositionProviderForScrollRootElement(Logger logger, EyesSeleniumDriver driver, StitchMode stitchMode, UserAgent ua, WebElement scrollRootElement) {
        Object positionProvider = null;
        WebElement defaultSRE = EyesSeleniumUtils.getDefaultRootElement(logger, driver);
        positionProvider = scrollRootElement.equals(defaultSRE) ? PositionProviderFactory.getPositionProvider(logger, stitchMode, driver, scrollRootElement, ua) : new ElementPositionProvider(logger, driver, scrollRootElement);
        return positionProvider;
    }

    private Region computeEffectiveViewport(FrameChain frameChain, RectangleSize initialSize) {
        Region viewport = new Region(Location.ZERO, initialSize);
        if (this.userDefinedSRE != null) {
            Region sreInnerBounds = EyesRemoteWebElement.getClientBoundsWithoutBorders(this.userDefinedSRE, this.driver);
            viewport.intersect(sreInnerBounds);
            this.logger.log(this.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"intersectedViewport", (Object)viewport)});
        }
        Location offset = Location.ZERO;
        for (Frame frame : frameChain) {
            offset = offset.offset(frame.getLocation());
            Region frameViewport = new Region(offset, frame.getInnerSize());
            viewport.intersect(frameViewport);
            Region frameSreInnerBounds = frame.getScrollRootElementInnerBounds();
            if (frameSreInnerBounds.isSizeEmpty()) continue;
            frameSreInnerBounds = frameSreInnerBounds.offset(offset);
            viewport.intersect(frameSreInnerBounds);
        }
        this.logger.log(this.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"effectiveViewport", (Object)viewport)});
        return viewport;
    }

    private WebElement getTargetElementFromSettings(ISeleniumCheckTarget seleniumCheckTarget) {
        By targetSelector = seleniumCheckTarget.getTargetSelector();
        Object targetElement = seleniumCheckTarget.getTargetElement();
        if (targetElement == null && targetSelector != null) {
            targetElement = this.driver.findElement(targetSelector);
        } else if (targetElement != null && !(targetElement instanceof EyesRemoteWebElement)) {
            targetElement = new EyesRemoteWebElement(this.logger, this.driver, (WebElement)targetElement);
        }
        return targetElement;
    }

    protected ScaleProviderFactory updateScalingParams() {
        if (this.scaleProviderHandler.get() instanceof NullScaleProvider) {
            try {
                this.devicePixelRatio = this.driver.getDevicePixelRatio();
            }
            catch (Exception e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.GENERAL, (Throwable)e, (String[])new String[]{this.getTestId()});
                this.devicePixelRatio = 1.0;
            }
            Object factory = !EyesDriverUtils.isMobileDevice((WebDriver)this.driver) ? this.getScaleProviderFactory() : new FixedScaleProviderFactory(this.logger, 1.0 / this.devicePixelRatio, this.scaleProviderHandler);
            return factory;
        }
        SimplePropertyHandler nullProvider = new SimplePropertyHandler();
        return new ScaleProviderIdentityFactory(this.logger, (ScaleProvider)this.scaleProviderHandler.get(), (PropertyHandler)nullProvider);
    }

    private ScaleProviderFactory getScaleProviderFactory() {
        WebElement element = EyesSeleniumUtils.getDefaultRootElement(this.logger, this.driver);
        RectangleSize entireSize = EyesDriverUtils.getEntireElementSize((Logger)this.logger, (IEyesJsExecutor)this.jsExecutor, (WebElement)element);
        return new ContextBasedScaleProviderFactory(this.logger, entireSize, this.getConfigurationInstance().getViewportSize(), this.devicePixelRatio, false, (PropertyHandler<ScaleProvider>)this.scaleProviderHandler);
    }

    public WebElement getCurrentFrameScrollRootElement() {
        return EyesSeleniumUtils.getCurrentFrameScrollRootElement(this.logger, this.driver, this.userDefinedSRE);
    }

    public void checkFrame(String frameNameOrId) {
        this.check((String)null, (ICheckSettings)Target.frame(frameNameOrId));
    }

    public void checkFrame(String frameNameOrId, String tag) {
        this.check(tag, (ICheckSettings)Target.frame(frameNameOrId).fully());
    }

    public void checkFrame(String frameNameOrId, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.frame(frameNameOrId).timeout(matchTimeout).fully());
    }

    public void checkFrame(int frameIndex) {
        this.checkFrame(frameIndex, -1, null);
    }

    public void checkFrame(int frameIndex, String tag) {
        this.checkFrame(frameIndex, -1, tag);
    }

    public void checkFrame(int frameIndex, int matchTimeout, String tag) {
        if (this.getIsDisabled()) {
            return;
        }
        ArgumentGuard.greaterThanOrEqualToZero((long)frameIndex, (String)"frameIndex");
        this.check(tag, (ICheckSettings)Target.frame(frameIndex).timeout(matchTimeout).fully());
    }

    public void checkFrame(WebElement frameReference) {
        this.checkFrame(frameReference, -1, null);
    }

    public void checkFrame(WebElement frameReference, String tag) {
        this.checkFrame(frameReference, -1, tag);
    }

    public void checkFrame(WebElement frameReference, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.frame(frameReference).timeout(matchTimeout));
    }

    public void checkFrame(String[] framePath, int matchTimeout, String tag) {
        SeleniumCheckSettings settings = Target.frame(framePath[0]);
        for (int i = 1; i < framePath.length; ++i) {
            settings.frame(framePath[i]);
        }
        this.check(tag, (ICheckSettings)settings.timeout(matchTimeout).fully());
    }

    public void checkRegionInFrame(String[] framePath, By selector, int matchTimeout, String tag, boolean stitchContent) {
        SeleniumCheckSettings settings = Target.frame(framePath[0]);
        for (int i = 1; i < framePath.length; ++i) {
            settings = settings.frame(framePath[i]);
        }
        this.check(tag, (ICheckSettings)settings.region(selector).timeout(matchTimeout).fully(stitchContent));
    }

    public void checkElement(WebElement element, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.region(element).timeout(matchTimeout).fully());
    }

    public void checkElement(By selector) {
        this.check((String)null, (ICheckSettings)Target.region(selector).fully());
    }

    public void checkElement(By selector, String tag) {
        this.check(tag, (ICheckSettings)Target.region(selector).fully());
    }

    public void checkElement(By selector, int matchTimeout, String tag) {
        this.check(tag, (ICheckSettings)Target.region(selector).timeout(matchTimeout).fully());
    }

    public void addMouseTrigger(MouseAction action, Region control, Location cursor) {
        if (this.getIsDisabled()) {
            return;
        }
        if (this.lastScreenshot == null) {
            return;
        }
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), ((EyesWebDriverScreenshot)this.lastScreenshot).getFrameChain())) {
            return;
        }
        this.addMouseTriggerBase(action, control, cursor);
    }

    public void addMouseTrigger(MouseAction action, WebElement element) {
        if (this.getIsDisabled()) {
            return;
        }
        ArgumentGuard.notNull((Object)element, (String)"element");
        Point pl = element.getLocation();
        Dimension ds = element.getSize();
        Region elementRegion = new Region(pl.getX(), pl.getY(), ds.getWidth(), ds.getHeight());
        if (this.lastScreenshot == null) {
            return;
        }
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), ((EyesWebDriverScreenshot)this.lastScreenshot).getFrameChain())) {
            return;
        }
        elementRegion = this.lastScreenshot.getIntersectedRegion(elementRegion, CoordinatesType.CONTEXT_RELATIVE);
        this.addMouseTriggerBase(action, elementRegion, elementRegion.getMiddleOffset());
    }

    public void addTextTrigger(Region control, String text) {
        if (this.getIsDisabled()) {
            return;
        }
        if (this.lastScreenshot == null) {
            return;
        }
        if (!FrameChain.isSameFrameChain(this.driver.getFrameChain(), ((EyesWebDriverScreenshot)this.lastScreenshot).getFrameChain())) {
            return;
        }
        this.addTextTriggerBase(control, text);
    }

    public void addTextTrigger(WebElement element, String text) {
        if (this.getIsDisabled()) {
            return;
        }
        ArgumentGuard.notNull((Object)element, (String)"element");
        Point pl = element.getLocation();
        Dimension ds = element.getSize();
        Region elementRegion = new Region(pl.getX(), pl.getY(), ds.getWidth(), ds.getHeight());
        this.addTextTrigger(elementRegion, text);
    }

    public MatchWindowData prepareForMatch(CheckTask checkTask) {
        return null;
    }

    public CheckTask issueCheck(ICheckSettings checkSettings, List<VisualGridSelector[]> regionSelectors, String source) {
        return null;
    }

    public void checkCompleted(CheckTask checkTask, MatchResult matchResult) {
    }

    public RectangleSize getViewportSize() {
        RectangleSize vpSize;
        if (!this.isOpen && this.driver == null) {
            return null;
        }
        if (!EyesDriverUtils.isMobileDevice((WebDriver)this.driver)) {
            if (this.imageProvider instanceof MobileScreenshotImageProvider) {
                BufferedImage image = this.imageProvider.getImage();
                vpSize = new RectangleSize((int)Math.round((double)image.getWidth() / this.devicePixelRatio), (int)Math.round((double)image.getHeight() / this.devicePixelRatio));
            } else {
                vpSize = EyesDriverUtils.getViewportSize((JavascriptExecutor)this.driver);
            }
        } else {
            vpSize = SeleniumEyes.getViewportSize((WebDriver)this.driver);
        }
        return vpSize;
    }

    static RectangleSize getViewportSize(WebDriver driver) {
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        return EyesDriverUtils.getViewportSizeOrDisplaySize((Logger)new Logger(), (WebDriver)driver);
    }

    protected Configuration setViewportSize(RectangleSize size) {
        if (!EyesDriverUtils.isMobileDevice((WebDriver)this.driver)) {
            FrameChain originalFrame = this.driver.getFrameChain();
            this.driver.switchTo().defaultContent();
            try {
                EyesDriverUtils.setViewportSize((Logger)this.logger, (WebDriver)this.driver, (RectangleSize)size);
                this.effectiveViewport = new Region(Location.ZERO, size);
            }
            catch (EyesException e1) {
                ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrame);
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.OPEN, (Throwable)e1, (String[])new String[]{this.getTestId()});
                throw new TestFailedException("Failed to set the viewport size", (Throwable)e1);
            }
            ((EyesTargetLocator)this.driver.switchTo()).frames(originalFrame);
        }
        this.getConfigurationInstance().setViewportSize(new RectangleSize(size.getWidth(), size.getHeight()));
        return this.getConfigurationInstance();
    }

    protected EyesScreenshot getScreenshot(Region targetRegion, ICheckSettingsInternal checkSettingsInternal) {
        EyesWebDriverScreenshot result;
        if (!EyesDriverUtils.isMobileDevice((WebDriver)this.driver)) {
            this.setElementAttribute(this.driver.findElement(By.tagName((String)"html")), ACTIVE_FRAME_ATTRIBUTE, "true");
        }
        ScaleProviderFactory scaleProviderFactory = this.updateScalingParams();
        CheckState state = ((ISeleniumCheckTarget)checkSettingsInternal).getState();
        this.logger.log(this.getTestId(), Stage.CHECK, Type.CAPTURE_SCREENSHOT, new Pair[]{Pair.of((Object)"checkState", (Object)state)});
        WebElement targetElement = state.getTargetElementInternal();
        boolean stitchContent = state.isStitchContent();
        Region effectiveViewport = state.getEffectiveViewport();
        Region fullRegion = state.getFullRegion();
        if (effectiveViewport.contains(fullRegion) && !fullRegion.isEmpty()) {
            result = this.getViewportScreenshot(scaleProviderFactory);
            result = result.getSubScreenshot(fullRegion, true);
        } else {
            result = targetElement != null || stitchContent ? this.getFrameOrElementScreenshot(scaleProviderFactory, state) : this.getViewportScreenshot(scaleProviderFactory);
        }
        if (targetRegion != null && !targetRegion.isSizeEmpty()) {
            result = result.getSubScreenshot(targetRegion, false);
            this.debugScreenshotsProvider.save(result.getImage(), "SUB_SCREENSHOT");
        }
        if (!EyesDriverUtils.isMobileDevice((WebDriver)this.driver) && this.shouldCaptureDom(checkSettingsInternal.isSendDom())) {
            result.setDomUrl(this.tryCaptureAndPostDom());
        }
        result.setOriginalLocation(state.getOriginalLocation());
        return result;
    }

    private EyesWebDriverScreenshot getViewportScreenshot(ScaleProviderFactory scaleProviderFactory) {
        try {
            Thread.sleep(this.getWaitBeforeScreenshots());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.getScaledAndCroppedScreenshot(scaleProviderFactory);
    }

    boolean shouldTakeFullPageScreenshot(ICheckSettingsInternal checkSettingsInternal) {
        Boolean isFully = checkSettingsInternal.getStitchContent();
        if (isFully != null) {
            return isFully;
        }
        Boolean isForceFullPage = this.getConfigurationInstance().getForceFullPageScreenshot();
        if (isForceFullPage == null) {
            return false;
        }
        return isForceFullPage;
    }

    private EyesWebDriverScreenshot getFrameOrElementScreenshot(ScaleProviderFactory scaleProviderFactory, CheckState state) {
        RenderingInfo renderingInfo = this.serverConnector.getRenderInfo();
        FullPageCaptureAlgorithm algo = this.createFullPageCaptureAlgorithm(scaleProviderFactory, renderingInfo);
        PositionProvider positionProvider = state.getStitchPositionProvider();
        PositionProvider originPositionProvider = state.getOriginPositionProvider();
        if (positionProvider == null) {
            WebElement scrollRootElement = this.getCurrentFrameScrollRootElement();
            positionProvider = SeleniumEyes.getPositionProviderForScrollRootElement(this.logger, this.driver, this.getConfigurationInstance().getStitchMode(), this.userAgent, scrollRootElement);
        }
        if (originPositionProvider == null) {
            originPositionProvider = new NullPositionProvider();
        }
        if (state.isStitchContent()) {
            this.setElementAttribute(((ISeleniumPositionProvider)positionProvider).getScrolledElement(), SCROLL_ELEMENT_ATTRIBUTE, "true");
        }
        BufferedImage entireFrameOrElement = algo.getStitchedRegion(state.getEffectiveViewport(), state.getFullRegion(), positionProvider, originPositionProvider, state.getStitchOffset());
        Location frameLocationInScreenshot = new Location(-state.getFullRegion().getLeft(), -state.getFullRegion().getTop());
        EyesWebDriverScreenshot result = new EyesWebDriverScreenshot(this.logger, this.driver, entireFrameOrElement, new RectangleSize(entireFrameOrElement.getWidth(), entireFrameOrElement.getHeight()), frameLocationInScreenshot);
        return result;
    }

    private EyesWebDriverScreenshot getScaledAndCroppedScreenshot(ScaleProviderFactory scaleProviderFactory) {
        BufferedImage screenshotImage = this.imageProvider.getImage();
        this.debugScreenshotsProvider.save(screenshotImage, "original");
        ScaleProvider scaleProvider = scaleProviderFactory.getScaleProvider(screenshotImage.getWidth());
        CutProvider cutProvider = (CutProvider)this.cutProviderHandler.get();
        if (scaleProvider.getScaleRatio() != 1.0) {
            screenshotImage = ImageUtils.scaleImage((BufferedImage)screenshotImage, (double)scaleProvider.getScaleRatio());
            this.debugScreenshotsProvider.save(screenshotImage, "scaled");
            cutProvider.scale(scaleProvider.getScaleRatio());
        }
        if (!(cutProvider instanceof NullCutProvider)) {
            screenshotImage = cutProvider.cut(screenshotImage);
            this.debugScreenshotsProvider.save(screenshotImage, "cut");
        }
        return new EyesWebDriverScreenshot(this.logger, this.driver, screenshotImage);
    }

    private long getWaitBeforeScreenshots() {
        return this.getConfigurationInstance().getWaitBeforeScreenshots();
    }

    private void setElementAttribute(WebElement element, String key, String value) {
        if (EyesDriverUtils.isMobileDevice((WebDriver)this.driver)) {
            return;
        }
        if (element != null) {
            try {
                this.jsExecutor.executeScript(String.format("var e = arguments[0]; if (e != null) e.setAttribute('%s','%s');", key, value), element);
            }
            catch (Exception e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Throwable)e, (String[])new String[]{this.getTestId()});
            }
        }
    }

    private FullPageCaptureAlgorithm createFullPageCaptureAlgorithm(ScaleProviderFactory scaleProviderFactory, RenderingInfo renderingInfo) {
        ISizeAdjuster sizeAdjuster = ImageProviderFactory.getImageSizeAdjuster(this.userAgent, this.jsExecutor);
        return new FullPageCaptureAlgorithm(this.logger, this.getTestId(), this.regionPositionCompensation, this.getConfigurationInstance().getWaitBeforeScreenshots(), this.debugScreenshotsProvider, this.screenshotFactory, scaleProviderFactory, (CutProvider)this.cutProviderHandler.get(), this.getConfigurationInstance().getStitchOverlap(), this.imageProvider, renderingInfo.getMaxImageHeight(), renderingInfo.getMaxImageArea(), sizeAdjuster);
    }

    protected String getTitle() {
        if (!this.doNotGetTitle && !EyesDriverUtils.isMobileDevice((WebDriver)this.driver)) {
            try {
                return this.driver.getTitle();
            }
            catch (Exception ex) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.GENERAL, (Throwable)ex, (String[])new String[]{this.getTestId()});
                this.doNotGetTitle = true;
            }
        }
        return "";
    }

    protected String getInferredEnvironment() {
        String userAgent = this.driver.getUserAgent();
        if (userAgent != null) {
            return "useragent:" + userAgent;
        }
        return null;
    }

    protected Object getAppEnvironment() {
        AppEnvironment appEnv = (AppEnvironment)super.getAppEnvironment();
        RemoteWebDriver underlyingDriver = this.driver.getRemoteWebDriver();
        if (appEnv.getOs() == null && EyesDriverUtils.isMobileDevice((WebDriver)underlyingDriver)) {
            String platformName = null;
            if (EyesDriverUtils.isAndroid((WebDriver)underlyingDriver)) {
                platformName = "Android";
            } else if (EyesDriverUtils.isIOS((WebDriver)underlyingDriver)) {
                platformName = "iOS";
            }
            if (platformName != null) {
                String majorVersion;
                String os = platformName;
                String platformVersion = EyesDriverUtils.getPlatformVersion((HasCapabilities)underlyingDriver);
                if (platformVersion != null && !(majorVersion = platformVersion.split("\\.", 2)[0]).isEmpty()) {
                    os = os + " " + majorVersion;
                }
                appEnv.setOs(os);
            }
            if (appEnv.getDeviceInfo() == null) {
                appEnv.setDeviceInfo(EyesDriverUtils.getMobileDeviceName((HasCapabilities)this.driver.getRemoteWebDriver()));
            }
        }
        return appEnv;
    }

    public void setIsDisabled(Boolean disabled) {
        super.setIsDisabled(disabled);
    }

    public TestResults close(boolean throwEx) {
        TestResults results;
        this.logger.log(this.getTestId(), Stage.CLOSE, Type.CALLED, new Pair[]{Pair.of((Object)"throwEx", (Object)throwEx)});
        try {
            results = this.stopSession(false);
            this.closeCompleted(results);
        }
        catch (Throwable e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CLOSE, (Throwable)e, (String[])new String[]{this.getTestId()});
            this.closeFailed(e);
            throw e;
        }
        if (this.error != null && throwEx) {
            throw new Error(this.error);
        }
        if (this.runner != null) {
            this.runner.aggregateResult(this.testResultContainer);
        }
        return results;
    }

    protected void getAppOutputForOcr(BaseOcrRegion ocrRegion) {
        OcrRegion seleniumOcrRegion = (OcrRegion)ocrRegion;
        SeleniumCheckSettings checkSettings = null;
        if (seleniumOcrRegion.getRegion() != null) {
            checkSettings = Target.region(seleniumOcrRegion.getRegion());
        }
        if (seleniumOcrRegion.getElement() != null) {
            ocrRegion.hint(EyesRemoteWebElement.getInnerText(this.logger, this.driver, seleniumOcrRegion.getElement()));
            checkSettings = Target.region(seleniumOcrRegion.getElement()).fully();
        }
        if (seleniumOcrRegion.getSelector() != null) {
            try {
                WebElement element = this.driver.findElement(seleniumOcrRegion.getSelector());
                ocrRegion.hint(EyesRemoteWebElement.getInnerText(this.logger, this.driver, element));
            }
            catch (Throwable t) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.OCR, (Throwable)t, (String[])new String[0]);
            }
            checkSettings = Target.region(seleniumOcrRegion.getSelector()).fully();
        }
        if (checkSettings == null) {
            throw new IllegalArgumentException("Got uninitialized ocr region");
        }
        this.check(checkSettings.ocrRegion(ocrRegion));
    }

    protected ScreenshotProvider getScreenshotProvider() {
        return new SeleniumScreenshotProvider(this, this.driver, this.logger, this.getDebugScreenshotsProvider());
    }

    public Boolean isSendDom() {
        return !EyesDriverUtils.isMobileDevice((WebDriver)this.driver) && super.isSendDom() != false;
    }

    protected Configuration getConfigurationInstance() {
        return this.configurationProvider.get();
    }

    void setDebugScreenshotProvider(DebugScreenshotsProvider debugScreenshotProvider) {
        this.debugScreenshotsProvider = debugScreenshotProvider;
    }

    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    public ScaleProvider getScaleProvider() {
        return (ScaleProvider)this.scaleProviderHandler.get();
    }

    public CutProvider getCutProvider() {
        return (CutProvider)this.cutProviderHandler.get();
    }

    public ImageProvider getImageProvider() {
        return this.imageProvider;
    }

    public static interface WebDriverAction {
        public void drive(WebDriver var1);
    }
}

