/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.rendering;

import com.applitools.ICheckSettings;
import com.applitools.ICheckSettingsInternal;
import com.applitools.connectivity.ServerConnector;
import com.applitools.eyes.BatchInfo;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.GetAccessibilityRegion;
import com.applitools.eyes.IBatchCloser;
import com.applitools.eyes.LogHandler;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.MultiLogHandler;
import com.applitools.eyes.NetworkLogHandler;
import com.applitools.eyes.NullLogHandler;
import com.applitools.eyes.PropertyData;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.TestResultContainer;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.config.ConfigurationProvider;
import com.applitools.eyes.fluent.CheckSettings;
import com.applitools.eyes.fluent.GetFloatingRegion;
import com.applitools.eyes.fluent.GetSimpleRegion;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.selenium.BrowserType;
import com.applitools.eyes.selenium.ClassicRunner;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.EyesSeleniumUtils;
import com.applitools.eyes.selenium.ISeleniumEyes;
import com.applitools.eyes.selenium.SeleniumEyes;
import com.applitools.eyes.selenium.fluent.FrameLocator;
import com.applitools.eyes.selenium.fluent.IGetSeleniumRegion;
import com.applitools.eyes.selenium.fluent.IScrollRootElementContainer;
import com.applitools.eyes.selenium.fluent.ISeleniumCheckTarget;
import com.applitools.eyes.selenium.fluent.ISeleniumFrameCheckTarget;
import com.applitools.eyes.selenium.fluent.SeleniumCheckSettings;
import com.applitools.eyes.selenium.frames.Frame;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.rendering.EyesConnector;
import com.applitools.eyes.selenium.rendering.WebElementRegion;
import com.applitools.eyes.selenium.wrappers.EyesSeleniumDriver;
import com.applitools.eyes.selenium.wrappers.EyesTargetLocator;
import com.applitools.eyes.visualgrid.model.AttributeData;
import com.applitools.eyes.visualgrid.model.BlobData;
import com.applitools.eyes.visualgrid.model.CdtData;
import com.applitools.eyes.visualgrid.model.FrameData;
import com.applitools.eyes.visualgrid.model.RenderBrowserInfo;
import com.applitools.eyes.visualgrid.model.RenderingInfo;
import com.applitools.eyes.visualgrid.model.VisualGridOption;
import com.applitools.eyes.visualgrid.model.VisualGridSelector;
import com.applitools.eyes.visualgrid.services.IEyesConnector;
import com.applitools.eyes.visualgrid.services.IRenderingEyes;
import com.applitools.eyes.visualgrid.services.RunningTest;
import com.applitools.eyes.visualgrid.services.ScoreTask;
import com.applitools.eyes.visualgrid.services.VisualGridRunner;
import com.applitools.eyes.visualgrid.services.VisualGridTask;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ClassVersionGetter;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;

public class VisualGridEyes
implements ISeleniumEyes,
IRenderingEyes {
    private final Logger logger;
    private String apiKey;
    private String serverUrl;
    private final VisualGridRunner renderingGridRunner;
    private final List<RunningTest> testList = Collections.synchronizedList(new ArrayList());
    List<TestResultContainer> allTestResults = new ArrayList<TestResultContainer>();
    private final String PROCESS_PAGE;
    private final String PROCESS_PAGE_FOR_IE;
    private final String POLL_RESULT;
    private final String POLL_RESULT_FOR_IE;
    private EyesSeleniumDriver webDriver;
    private RenderingInfo renderingInfo;
    private IEyesConnector eyesConnector;
    private String url;
    private Set<Future<TestResultContainer>> closeFuturesSet = new HashSet<Future<TestResultContainer>>();
    private Boolean isDisabled = Boolean.FALSE;
    private ServerConnector serverConnector = null;
    private final ConfigurationProvider configurationProvider;
    private UserAgent userAgent = null;
    private RectangleSize viewportSize;
    private final List<PropertyData> properties = new ArrayList<PropertyData>();
    private static final String GET_ELEMENT_XPATH_JS = "var el = arguments[0];var xpath = '';do { var parent = el.parentElement; var index = 1; if (parent !== null) {  var children = parent.children;  for (var childIdx in children) {    var child = children[childIdx];    if (child === el) break;    if (child.tagName === el.tagName) index++;  }}xpath = '/' + el.tagName + '[' + index + ']' + xpath; el = parent;} while (el !== null);return '/' + xpath;";

    public VisualGridEyes(VisualGridRunner renderingGridManager, ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
        ArgumentGuard.notNull((Object)renderingGridManager, (String)"renderingGridRunner");
        this.renderingGridRunner = renderingGridManager;
        this.logger = renderingGridManager.getLogger();
        try {
            this.PROCESS_PAGE = GeneralUtils.readToEnd((InputStream)VisualGridEyes.class.getResourceAsStream("/dom-snapshot/dist/processPagePoll.js"));
            this.PROCESS_PAGE_FOR_IE = GeneralUtils.readToEnd((InputStream)VisualGridEyes.class.getResourceAsStream("/dom-snapshot/dist/processPagePollForIE.js"));
            this.POLL_RESULT = GeneralUtils.readToEnd((InputStream)VisualGridEyes.class.getResourceAsStream("/dom-snapshot/dist/pollResult.js"));
            this.POLL_RESULT_FOR_IE = GeneralUtils.readToEnd((InputStream)VisualGridEyes.class.getResourceAsStream("/dom-snapshot/dist/pollResultForIE.js"));
        }
        catch (IOException e) {
            throw new EyesException("Failed getting resources for dom scripts", (Throwable)e);
        }
    }

    public void setLogHandler(LogHandler logHandler) {
        if (this.getIsDisabled()) {
            return;
        }
        LogHandler currentLogHandler = this.logger.getLogHandler();
        this.logger.setLogHandler((LogHandler)new MultiLogHandler(new LogHandler[]{currentLogHandler, logHandler}));
        if (currentLogHandler.isOpen() && !logHandler.isOpen()) {
            logHandler.open();
        }
    }

    public LogHandler getLogHandler() {
        if (this.getIsDisabled()) {
            return NullLogHandler.instance;
        }
        return this.logger.getLogHandler();
    }

    @Override
    public void apiKey(String apiKey) {
        this.setApiKey(apiKey);
    }

    @Override
    public void serverUrl(String serverUrl) {
        this.setServerUrl(serverUrl);
    }

    public void serverUrl(URI serverUrl) {
        this.setServerUrl(serverUrl.toString());
    }

    @Override
    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize) throws EyesException {
        this.getConfiguration().setAppName(appName).setTestName(testName);
        if (viewportSize != null && !viewportSize.isEmpty()) {
            this.getConfiguration().setViewportSize(new RectangleSize(viewportSize));
        }
        return this.open(driver);
    }

    @Override
    public WebDriver open(WebDriver webDriver) {
        this.logger.verbose("enter");
        if (!this.validateEyes()) {
            return webDriver;
        }
        ArgumentGuard.notNull((Object)webDriver, (String)"webDriver");
        ArgumentGuard.notNullOrEmpty((String)this.getConfiguration().getAppName(), (String)"appIdOrName");
        ArgumentGuard.notNullOrEmpty((String)this.getConfiguration().getTestName(), (String)"scenarioIdOrName");
        this.initDriver(webDriver);
        String uaString = this.webDriver.getUserAgent();
        if (uaString != null) {
            this.logger.verbose(String.format("User-Agent: %s", uaString));
            this.userAgent = UserAgent.parseUserAgentString((String)uaString, (boolean)true);
        }
        this.setViewportSize(this.webDriver);
        this.ensureBrowsers();
        if (this.getConfiguration().getBatch() == null) {
            this.getConfiguration().setBatch(new BatchInfo(null));
        }
        List browserInfoList = this.getConfiguration().getBrowsersInfo();
        this.logger.verbose(String.format("got %d browser infos", browserInfoList.size()));
        this.logger.verbose("creating test descriptors for each browser info...");
        this.getConfiguration().setViewportSize(this.viewportSize);
        if (this.getConfiguration().getBrowsersInfo() == null) {
            RectangleSize viewportSize = this.getConfiguration().getViewportSize();
            this.getConfiguration().addBrowser(new RenderBrowserInfo(viewportSize.getWidth(), viewportSize.getHeight(), BrowserType.CHROME, this.getConfiguration().getBaselineEnvName()));
        }
        for (RenderBrowserInfo browserInfo : browserInfoList) {
            this.logger.verbose("creating test descriptor");
            RunningTest test = new RunningTest((IRenderingEyes)this, this.createEyesConnector(browserInfo), this.configurationProvider, browserInfo, this.logger);
            this.testList.add(test);
        }
        this.logger.verbose(String.format("opening %d tests...", this.testList.size()));
        this.renderingGridRunner.open((IRenderingEyes)this, this.renderingInfo);
        this.logger.verbose("done");
        return this.webDriver != null ? this.webDriver : webDriver;
    }

    private void ensureBrowsers() {
        if (this.getConfiguration().getBrowsersInfo().isEmpty()) {
            this.getConfiguration().getBrowsersInfo().add(new RenderBrowserInfo(this.viewportSize, BrowserType.CHROME));
        }
    }

    private void setViewportSize(EyesSeleniumDriver webDriver) {
        List browserInfoList;
        this.viewportSize = this.getConfiguration().getViewportSize();
        if (this.viewportSize == null && (browserInfoList = this.getConfiguration().getBrowsersInfo()) != null && !browserInfoList.isEmpty()) {
            for (RenderBrowserInfo deviceInfo : browserInfoList) {
                if (deviceInfo.getEmulationInfo() != null) continue;
                this.viewportSize = new RectangleSize(deviceInfo.getWidth(), deviceInfo.getHeight());
            }
        }
        if (this.viewportSize == null) {
            this.viewportSize = EyesDriverUtils.getViewportSize((JavascriptExecutor)webDriver);
        }
        try {
            EyesDriverUtils.setViewportSize((Logger)this.logger, (WebDriver)webDriver, (RectangleSize)this.viewportSize);
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
    }

    private IEyesConnector createEyesConnector(RenderBrowserInfo browserInfo) {
        String apiKey;
        URI serverUri;
        this.logger.verbose("creating VisualGridEyes server connector");
        EyesConnector eyesConnector = new EyesConnector(this.getConfiguration(), this.properties, browserInfo);
        eyesConnector.setLogHandler(this.logger.getLogHandler());
        eyesConnector.setProxy(this.getConfiguration().getProxy());
        if (this.serverConnector != null) {
            eyesConnector.setServerConnector(this.serverConnector);
        }
        if ((serverUri = this.getServerUrl()) != null) {
            eyesConnector.setServerUrl(serverUri.toString());
        }
        if ((apiKey = this.getApiKey()) == null) {
            throw new EyesException("Missing API key");
        }
        eyesConnector.setApiKey(apiKey);
        if (this.renderingInfo == null) {
            this.logger.verbose("initializing rendering info...");
            this.renderingInfo = eyesConnector.getRenderingInfo();
        }
        eyesConnector.setRenderInfo(this.renderingInfo);
        this.eyesConnector = eyesConnector;
        return eyesConnector;
    }

    private void initDriver(WebDriver webDriver) {
        String currentUrl;
        if (webDriver instanceof RemoteWebDriver) {
            SeleniumEyes seleniumEyes = new SeleniumEyes(this.configurationProvider, new ClassicRunner());
            this.webDriver = new EyesSeleniumDriver(this.logger, seleniumEyes, (RemoteWebDriver)webDriver);
        }
        this.url = currentUrl = webDriver.getCurrentUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunningTest getNextTestToClose() {
        List<RunningTest> list = this.testList;
        synchronized (list) {
            for (RunningTest runningTest : this.testList) {
                if (runningTest.isTestClose() || !runningTest.isTestReadyToClose()) continue;
                return runningTest;
            }
        }
        return null;
    }

    public Collection<Future<TestResultContainer>> close() {
        this.logger.verbose("enter");
        if (!this.validateEyes()) {
            return new ArrayList<Future<TestResultContainer>>();
        }
        return this.closeAndReturnResults(false);
    }

    @Override
    public TestResults close(boolean throwException) {
        Collection<Future<TestResultContainer>> close = this.close();
        return this.parseCloseFutures(close, throwException);
    }

    private TestResults parseCloseFutures(Collection<Future<TestResultContainer>> close, boolean shouldThrowException) {
        if (close != null && !close.isEmpty()) {
            TestResultContainer errorResult = null;
            TestResultContainer firstResult = null;
            try {
                for (Future<TestResultContainer> closeFuture : close) {
                    Throwable error;
                    TestResultContainer testResultContainer = closeFuture.get();
                    if (firstResult == null) {
                        firstResult = testResultContainer;
                    }
                    if ((error = testResultContainer.getException()) == null || errorResult != null) continue;
                    errorResult = testResultContainer;
                }
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            if (errorResult != null) {
                if (shouldThrowException) {
                    throw new Error(errorResult.getException());
                }
                return errorResult.getTestResults();
            }
            if (firstResult != null) {
                return firstResult.getTestResults();
            }
        }
        return null;
    }

    public TestResults abortIfNotClosed() {
        List<Future<TestResultContainer>> futures = this.abortAndCollectTasks();
        return this.parseCloseFutures(futures, false);
    }

    public boolean getIsOpen() {
        return !this.isEyesClosed();
    }

    public String getApiKey() {
        return this.apiKey == null ? this.renderingGridRunner.getApiKey() : this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setIsDisabled(Boolean disabled) {
        this.isDisabled = disabled;
    }

    public boolean getIsDisabled() {
        return this.isDisabled == null ? this.renderingGridRunner.getIsDisabled() : this.isDisabled.booleanValue();
    }

    public URI getServerUrl() {
        URI uri;
        if (this.eyesConnector != null && (uri = this.eyesConnector.getServerUrl()) != null) {
            return uri;
        }
        String str = this.serverUrl == null ? this.renderingGridRunner.getServerUrl() : this.serverUrl;
        return str == null ? null : URI.create(str);
    }

    private Collection<Future<TestResultContainer>> closeAndReturnResults(boolean throwException) {
        this.logger.verbose("enter " + this.getConfiguration().getBatch());
        if (!this.validateEyes()) {
            return new ArrayList<Future<TestResultContainer>>();
        }
        if (this.closeFuturesSet == null) {
            this.closeFuturesSet = new HashSet<Future<TestResultContainer>>();
        }
        Throwable exception = null;
        try {
            Collection<Future<TestResultContainer>> futureList = this.closeAsync();
            this.renderingGridRunner.close((IRenderingEyes)this);
            for (Future<TestResultContainer> future : futureList) {
                try {
                    TestResultContainer testResultContainer = future.get();
                    if (exception != null || testResultContainer.getException() == null) continue;
                    exception = testResultContainer.getException();
                }
                catch (Throwable e) {
                    GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
                    if (exception != null) continue;
                    exception = e;
                }
            }
        }
        catch (Throwable e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        if (throwException && exception != null) {
            throw new Error(exception);
        }
        return this.closeFuturesSet;
    }

    public Collection<Future<TestResultContainer>> closeAsync() {
        this.logger.verbose("enter");
        if (!this.validateEyes()) {
            return new ArrayList<Future<TestResultContainer>>();
        }
        ArrayList<Future<TestResultContainer>> futureList = null;
        try {
            futureList = new ArrayList<Future<TestResultContainer>>();
            this.logger.verbose(String.format("closing %d running tests", this.testList.size()));
            for (RunningTest runningTest : this.testList) {
                this.logger.verbose("running test name: " + this.getConfiguration().getTestName());
                this.logger.verbose("running test device info: " + runningTest.getBrowserInfo());
                this.logger.verbose("is current running test open: " + runningTest.isTestOpen());
                this.logger.verbose("is current running test ready to close: " + runningTest.isTestReadyToClose());
                this.logger.verbose("is current running test closed: " + runningTest.isTestClose());
                this.logger.verbose("closing current running test");
                FutureTask closeFuture = runningTest.close();
                if (closeFuture == null) continue;
                futureList.addAll(Collections.singleton(closeFuture));
                this.logger.verbose("adding closeFuture to futureList");
            }
            this.closeFuturesSet.addAll(futureList);
        }
        catch (Throwable e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        this.logger.verbose("exit");
        return futureList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ScoreTask getBestScoreTaskForCheck() {
        int bestScore = -1;
        ScoreTask currentBest = null;
        for (RunningTest runningTest : this.testList) {
            List visualGridTaskList;
            List list = visualGridTaskList = runningTest.getVisualGridTaskList();
            synchronized (list) {
                if (visualGridTaskList.isEmpty()) {
                    continue;
                }
                VisualGridTask visualGridTask = (VisualGridTask)visualGridTaskList.get(0);
                if (!runningTest.isTestOpen() || visualGridTask.getType() != VisualGridTask.TaskType.CHECK || !visualGridTask.isTaskReadyToCheck()) {
                    continue;
                }
            }
            ScoreTask scoreTask = runningTest.getScoreTaskObjectByType(VisualGridTask.TaskType.CHECK);
            if (scoreTask == null || bestScore >= scoreTask.getScore()) continue;
            currentBest = scoreTask;
            bestScore = scoreTask.getScore();
        }
        return currentBest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScoreTask getBestScoreTaskForOpen() {
        int bestMark = -1;
        ScoreTask currentBest = null;
        List<RunningTest> list = this.testList;
        synchronized (list) {
            for (RunningTest runningTest : this.testList) {
                ScoreTask currentScoreTask = runningTest.getScoreTaskObjectByType(VisualGridTask.TaskType.OPEN);
                if (currentScoreTask == null || bestMark >= currentScoreTask.getScore()) continue;
                bestMark = currentScoreTask.getScore();
                currentBest = currentScoreTask;
            }
        }
        return currentBest;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public boolean isEyesClosed() {
        boolean isVGEyesClosed = true;
        for (RunningTest runningTest : this.testList) {
            isVGEyesClosed = isVGEyesClosed && runningTest.isTestClose();
        }
        return isVGEyesClosed;
    }

    public void setListener(IRenderingEyes.EyesListener listener) {
        for (RunningTest test : this.testList) {
            test.setListener(listener);
        }
    }

    @Override
    public void check(ICheckSettings ... checkSettings) {
        if (!this.validateEyes()) {
            return;
        }
        for (ICheckSettings checkSetting : checkSettings) {
            this.check(checkSetting);
        }
    }

    @Override
    public void check(String name, ICheckSettings checkSettings) {
        if (!this.validateEyes()) {
            return;
        }
        ArgumentGuard.notNull((Object)checkSettings, (String)"checkSettings");
        if (name != null) {
            checkSettings = checkSettings.withName(name);
        }
        this.check(checkSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(ICheckSettings checkSettings) {
        this.logger.verbose("enter");
        if (!this.validateEyes()) {
            return;
        }
        ArgumentGuard.notOfType((Object)checkSettings, ICheckSettings.class, (String)"checkSettings");
        if (checkSettings instanceof ISeleniumCheckTarget) {
            ((ISeleniumCheckTarget)checkSettings).init(this.logger, this.webDriver);
        }
        this.waitBeforeDomSnapshot();
        try {
            String logMessage = this.renderingGridRunner.getConcurrencyLog();
            if (logMessage != null) {
                NetworkLogHandler.sendSingleLog((ServerConnector)this.eyesConnector.getServerConnector(), (TraceLevel)TraceLevel.Notice, (String)logMessage);
            }
        }
        catch (JsonProcessingException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        FrameChain originalFC = this.webDriver.getFrameChain().clone();
        EyesTargetLocator switchTo = (EyesTargetLocator)this.webDriver.switchTo();
        try {
            checkSettings = this.switchFramesAsNeeded(checkSettings, switchTo);
            ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)checkSettings;
            this.addOpenTaskToAllRunningTest();
            ArrayList<VisualGridTask> checkVisualGridTasks = new ArrayList<VisualGridTask>();
            FrameData scriptResult = this.captureDomSnapshot(switchTo);
            Object[] blobsUrls = new String[scriptResult.getBlobs().size()];
            for (int i = 0; i < scriptResult.getBlobs().size(); ++i) {
                blobsUrls[i] = ((BlobData)scriptResult.getBlobs().get(i)).getUrl();
            }
            this.logger.verbose(String.format("Cdt length: %d", scriptResult.getCdt().size()));
            this.logger.verbose(String.format("Blobs urls: %s", Arrays.toString(blobsUrls)));
            this.logger.verbose(String.format("Resources urls: %s", scriptResult.getResourceUrls().toString()));
            List<VisualGridSelector[]> regionsXPaths = this.getRegionsXPaths(checkSettingsInternal);
            this.logger.verbose("regionXPaths : " + regionsXPaths);
            this.trySetTargetSelector((SeleniumCheckSettings)checkSettings);
            checkSettingsInternal = this.updateCheckSettings(checkSettings);
            List<RunningTest> filteredTests = VisualGridEyes.collectTestsForCheck(this.logger, this.testList);
            this.logger.verbose(String.format("Collected %d tests", filteredTests.size()));
            String source = this.webDriver.getCurrentUrl();
            for (RunningTest runningTest : filteredTests) {
                VisualGridTask checkVisualGridTask = runningTest.check((ICheckSettings)checkSettingsInternal, regionsXPaths, source);
                checkVisualGridTasks.add(checkVisualGridTask);
            }
            this.logger.verbose(String.format("added %d check tasks", checkVisualGridTasks.size()));
            this.renderingGridRunner.check((ICheckSettings)checkSettingsInternal, this.getConfiguration().getDebugResourceWriter(), scriptResult, this.eyesConnector, checkVisualGridTasks, regionsXPaths, this.userAgent);
            this.logger.verbose("created renderTask  (" + checkSettings.toString() + ")");
        }
        catch (Throwable e) {
            Error error = new Error(e);
            this.abort(e);
            for (RunningTest runningTest : this.testList) {
                runningTest.setTestInExceptionMode((Throwable)error);
            }
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
        finally {
            switchTo.frames(originalFC);
        }
    }

    public static List<RunningTest> collectTestsForCheck(Logger logger, List<RunningTest> tests) {
        logger.verbose(String.format("Called with %d tests", tests.size()));
        ArrayList<RunningTest> filteredTests = new ArrayList<RunningTest>();
        for (RunningTest test : tests) {
            List taskList = test.getVisualGridTaskList();
            logger.verbose(String.format("test %s has %d tasks", test.getTestName(), taskList.size()));
            VisualGridTask visualGridTask = null;
            if (!taskList.isEmpty()) {
                visualGridTask = (VisualGridTask)taskList.get(taskList.size() - 1);
            }
            VisualGridTask.TaskType lastTaskType = null;
            if (visualGridTask != null) {
                lastTaskType = visualGridTask.getType();
            }
            boolean testIsOpenAndNotClosed = lastTaskType == null && test.isOpenTaskIssued() && !test.isCloseTaskIssued();
            boolean lastTaskIsNotAClosingTask = lastTaskType != null && lastTaskType != VisualGridTask.TaskType.CLOSE && lastTaskType != VisualGridTask.TaskType.ABORT;
            logger.verbose(String.format("testIsOpenAndNotClosed: %b, lastTaskIsNotAClosingTask: %b", testIsOpenAndNotClosed, lastTaskIsNotAClosingTask));
            if (!testIsOpenAndNotClosed && !lastTaskIsNotAClosingTask) continue;
            filteredTests.add(test);
        }
        return filteredTests;
    }

    private ICheckSettings switchFramesAsNeeded(ICheckSettings checkSettings, EyesTargetLocator switchTo) {
        int switchedToCount = this.switchToFrame((ISeleniumCheckTarget)checkSettings);
        boolean isFullPage = this.isFullPage((ICheckSettingsInternal)checkSettings);
        if (switchedToCount > 0 && isFullPage) {
            FrameChain frameChain = this.webDriver.getFrameChain().clone();
            Frame frame = frameChain.pop();
            checkSettings = ((SeleniumCheckSettings)checkSettings).region(frame.getReference());
            switchTo.parentFrame();
        }
        return checkSettings;
    }

    private boolean isFullPage(ICheckSettingsInternal checkSettingsInternal) {
        boolean isFullPage = true;
        Boolean b = checkSettingsInternal.isStitchContent();
        if (b != null) {
            isFullPage = b;
        } else {
            b = this.getConfiguration().isForceFullPageScreenshot();
            if (b != null) {
                isFullPage = b;
            }
        }
        return isFullPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FrameData captureDomSnapshot(EyesTargetLocator switchTo) throws Exception {
        String domScript = this.userAgent.isInternetExplorer() ? this.PROCESS_PAGE_FOR_IE : this.PROCESS_PAGE;
        String pollingScript = this.userAgent.isInternetExplorer() ? this.POLL_RESULT_FOR_IE : this.POLL_RESULT;
        Map map = this.renderingGridRunner.getResourcesCacheMap();
        synchronized (map) {
            String skipList = new ObjectMapper().writeValueAsString(new HashSet(this.renderingGridRunner.getResourcesCacheMap().keySet()));
        }
        HashMap<String, Object> arguments = new HashMap<String, Object>(){
            {
                this.put("serializeResources", true);
                this.put("dontFetchResources", VisualGridEyes.this.getConfiguration().isDisableBrowserFetching());
            }
        };
        String result = EyesSeleniumUtils.runDomScript(this.logger, this.webDriver, this.userAgent, domScript, (Map<String, Object>)arguments, pollingScript);
        FrameData frameData = (FrameData)GeneralUtils.parseJsonToObject((String)result, FrameData.class);
        this.analyzeFrameData(frameData, switchTo);
        return frameData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeFrameData(FrameData frameData, EyesTargetLocator switchTo) {
        FrameChain frameChain = this.webDriver.getFrameChain().clone();
        for (FrameData.CrossFrame crossFrame : frameData.getCrossFrames()) {
            if (crossFrame.getSelector() == null) {
                this.logger.verbose("cross frame with null selector");
                continue;
            }
            try {
                WebElement frame = this.webDriver.findElement(By.cssSelector((String)crossFrame.getSelector()));
                switchTo.frame(frame);
                FrameData result = this.captureDomSnapshot(switchTo);
                frameData.addFrame(result);
                ((CdtData)frameData.getCdt().get((int)crossFrame.getIndex())).attributes.add(new AttributeData("data-applitools-src", result.getUrl()));
            }
            catch (Throwable t) {
                this.logger.verbose(String.format("Failed finding cross frame with selector %s. Reason: %s", crossFrame.getSelector(), t.getMessage()));
            }
            finally {
                switchTo.frames(frameChain);
            }
        }
        for (FrameData frame : frameData.getFrames()) {
            if (frame.getSelector() == null) {
                this.logger.verbose("cross frame with null selector");
                continue;
            }
            try {
                WebElement frameElement = this.webDriver.findElement(By.cssSelector((String)frame.getSelector()));
                switchTo.frame(frameElement);
                this.analyzeFrameData(frame, switchTo);
            }
            catch (Throwable t) {
                this.logger.verbose(String.format("Failed finding cross frame with selector %s. Reason: %s", frame.getSelector(), t.getMessage()));
            }
            finally {
                switchTo.frames(frameChain);
            }
        }
    }

    private void waitBeforeDomSnapshot() {
        int waitBeforeScreenshots = this.getConfiguration().getWaitBeforeScreenshots();
        try {
            Thread.sleep(waitBeforeScreenshots);
        }
        catch (InterruptedException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
        }
    }

    ICheckSettingsInternal updateCheckSettings(ICheckSettings checkSettings) {
        ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)checkSettings;
        MatchLevel matchLevel = checkSettingsInternal.getMatchLevel();
        Boolean fully = checkSettingsInternal.isStitchContent();
        Boolean sendDom = checkSettingsInternal.isSendDom();
        Boolean ignoreDisplacements = checkSettingsInternal.isIgnoreDisplacements();
        if (matchLevel == null) {
            checkSettings = checkSettings.matchLevel(this.getConfiguration().getMatchLevel());
        }
        if (fully == null) {
            Boolean isForceFullPageScreenshot = this.getConfiguration().isForceFullPageScreenshot();
            boolean stitchContent = isForceFullPageScreenshot == null ? checkSettings.isCheckWindow() : isForceFullPageScreenshot.booleanValue();
            checkSettings = checkSettings.fully(Boolean.valueOf(stitchContent));
        }
        if (sendDom == null) {
            Boolean isSendDom = this.getConfiguration().isSendDom();
            checkSettings = checkSettings.sendDom(isSendDom == null || isSendDom != false);
        }
        if (ignoreDisplacements == null) {
            checkSettings = checkSettings.ignoreDisplacements(this.getConfiguration().getIgnoreDisplacements());
        }
        ArrayList options = new ArrayList();
        options.addAll(this.getConfiguration().getVisualGridOptions());
        options.addAll(checkSettingsInternal.getVisualGridOptions());
        checkSettings = checkSettings.visualGridOptions(options.size() > 0 ? options.toArray(new VisualGridOption[0]) : null);
        return (ICheckSettingsInternal)checkSettings;
    }

    private void trySetTargetSelector(SeleniumCheckSettings checkSettings) {
        By targetSelector;
        WebElement element = checkSettings.getTargetElement();
        FrameChain frameChain = this.webDriver.getFrameChain().clone();
        EyesTargetLocator switchTo = (EyesTargetLocator)this.webDriver.switchTo();
        this.switchToFrame(checkSettings);
        if (element == null && (targetSelector = checkSettings.getTargetSelector()) != null) {
            element = this.webDriver.findElement(targetSelector);
        }
        if (element != null) {
            String xpath = (String)this.webDriver.executeScript(GET_ELEMENT_XPATH_JS, element);
            VisualGridSelector vgs = new VisualGridSelector(xpath, (Object)"target");
            checkSettings.setTargetSelector(vgs);
        }
        switchTo.frames(frameChain);
    }

    private int switchToFrame(ISeleniumCheckTarget checkTarget) {
        if (checkTarget == null) {
            return 0;
        }
        List<FrameLocator> frameChain = checkTarget.getFrameChain();
        int switchedToFrameCount = 0;
        for (FrameLocator frameLocator : frameChain) {
            if (!this.switchToFrame(frameLocator)) continue;
            ++switchedToFrameCount;
        }
        return switchedToFrameCount;
    }

    private boolean switchToFrame(ISeleniumFrameCheckTarget frameTarget) {
        WebElement frameElement;
        WebDriver.TargetLocator switchTo = this.webDriver.switchTo();
        if (frameTarget.getFrameIndex() != null) {
            switchTo.frame(frameTarget.getFrameIndex().intValue());
            this.updateFrameScrollRoot(frameTarget);
            return true;
        }
        if (frameTarget.getFrameNameOrId() != null) {
            switchTo.frame(frameTarget.getFrameNameOrId());
            this.updateFrameScrollRoot(frameTarget);
            return true;
        }
        if (frameTarget.getFrameReference() != null) {
            switchTo.frame(frameTarget.getFrameReference());
            this.updateFrameScrollRoot(frameTarget);
            return true;
        }
        if (frameTarget.getFrameSelector() != null && (frameElement = this.webDriver.findElement(frameTarget.getFrameSelector())) != null) {
            switchTo.frame(frameElement);
            this.updateFrameScrollRoot(frameTarget);
            return true;
        }
        return false;
    }

    private void updateFrameScrollRoot(IScrollRootElementContainer frameTarget) {
        WebElement rootElement = EyesSeleniumUtils.getScrollRootElement(this.logger, this.webDriver, frameTarget);
        Frame frame = this.webDriver.getFrameChain().peek();
        frame.setScrollRootElement(rootElement);
    }

    private synchronized void addOpenTaskToAllRunningTest() {
        this.logger.verbose(String.format("Add open tasks for %d tests", this.testList.size()));
        for (RunningTest runningTest : this.testList) {
            if (runningTest.isOpenTaskIssued()) continue;
            runningTest.open();
        }
        this.logger.verbose("exit");
    }

    public Logger getLogger() {
        return this.logger;
    }

    public List<RunningTest> getAllRunningTests() {
        return this.testList;
    }

    public String toString() {
        return "SeleniumVGEyes - url: " + this.url;
    }

    public void setServerConnector(ServerConnector serverConnector) {
        this.serverConnector = serverConnector;
    }

    public String getFullAgentId() {
        String agentId = this.getConfiguration().getAgentId();
        if (agentId == null) {
            return this.getBaseAgentId();
        }
        return String.format("%s [%s]", agentId, this.getBaseAgentId());
    }

    private Configuration getConfiguration() {
        return this.configurationProvider.get();
    }

    public String getBaseAgentId() {
        return "eyes.selenium.visualgrid.java/" + ClassVersionGetter.CURRENT_VERSION;
    }

    public void setBatch(BatchInfo batch) {
        if (this.isDisabled.booleanValue()) {
            this.logger.verbose("Ignored");
            return;
        }
        this.logger.verbose("setBatch(" + batch + ")");
        this.getConfiguration().setBatch(batch);
    }

    private List<VisualGridSelector[]> getRegionsXPaths(ICheckSettingsInternal csInternal) {
        List<WebElementRegion>[] elementLists;
        ArrayList<VisualGridSelector[]> result = new ArrayList<VisualGridSelector[]>();
        for (List<WebElementRegion> elementList : elementLists = this.collectSeleniumRegions(csInternal)) {
            ArrayList<VisualGridSelector> xpaths = new ArrayList<VisualGridSelector>();
            for (WebElementRegion webElementRegion : elementList) {
                if (webElementRegion.getElement() == null) continue;
                String xpath = (String)this.webDriver.executeScript(GET_ELEMENT_XPATH_JS, webElementRegion.getElement());
                xpaths.add(new VisualGridSelector(xpath, webElementRegion.getRegion()));
            }
            result.add(xpaths.toArray(new VisualGridSelector[0]));
        }
        return result;
    }

    private List<WebElementRegion>[] collectSeleniumRegions(ICheckSettingsInternal csInternal) {
        By targetSelector;
        CheckSettings settings = (CheckSettings)csInternal;
        GetSimpleRegion[] ignoreRegions = settings.getIgnoreRegions();
        GetSimpleRegion[] layoutRegions = settings.getLayoutRegions();
        GetSimpleRegion[] strictRegions = settings.getStrictRegions();
        GetSimpleRegion[] contentRegions = settings.getContentRegions();
        GetFloatingRegion[] floatingRegions = settings.getFloatingRegions();
        GetAccessibilityRegion[] accessibilityRegions = settings.getAccessibilityRegions();
        List<WebElementRegion> ignoreElements = this.getElementsFromRegions(Arrays.asList(ignoreRegions));
        List<WebElementRegion> layoutElements = this.getElementsFromRegions(Arrays.asList(layoutRegions));
        List<WebElementRegion> strictElements = this.getElementsFromRegions(Arrays.asList(strictRegions));
        List<WebElementRegion> contentElements = this.getElementsFromRegions(Arrays.asList(contentRegions));
        List<WebElementRegion> floatingElements = this.getElementsFromRegions(Arrays.asList(floatingRegions));
        List<WebElementRegion> accessibilityElements = this.getElementsFromRegions(Arrays.asList(accessibilityRegions));
        ISeleniumCheckTarget iSeleniumCheckTarget = (ISeleniumCheckTarget)csInternal;
        WebElement targetElement = iSeleniumCheckTarget.getTargetElement();
        if (targetElement == null && (targetSelector = iSeleniumCheckTarget.getTargetSelector()) != null) {
            targetElement = this.webDriver.findElement(targetSelector);
        }
        WebElementRegion target = new WebElementRegion(targetElement, "target");
        ArrayList<WebElementRegion> targetElementList = new ArrayList<WebElementRegion>();
        targetElementList.add(target);
        List[] lists = new List[]{ignoreElements, layoutElements, strictElements, contentElements, floatingElements, accessibilityElements, targetElementList};
        return lists;
    }

    private List<WebElementRegion> getElementsFromRegions(List regionsProvider) {
        ArrayList<WebElementRegion> elements = new ArrayList<WebElementRegion>();
        for (Object getRegion : regionsProvider) {
            if (!(getRegion instanceof IGetSeleniumRegion)) continue;
            IGetSeleniumRegion getSeleniumRegion = (IGetSeleniumRegion)getRegion;
            List webElements = getSeleniumRegion.getElements();
            for (WebElement webElement : webElements) {
                elements.add(new WebElementRegion(webElement, getRegion));
            }
        }
        return elements;
    }

    public void addProperty(String name, String value) {
        PropertyData pd = new PropertyData(name, value);
        this.properties.add(pd);
    }

    public void clearProperties() {
        this.properties.clear();
    }

    private boolean validateEyes() {
        if (this.isDisabled.booleanValue()) {
            this.logger.verbose("WARNING! Invalid Operation - Eyes Disabled!");
            return false;
        }
        if (!this.renderingGridRunner.isServicesOn()) {
            this.logger.verbose("WARNING! Invalid Operation - visualGridRunner.getAllTestResults already called!");
            return false;
        }
        return true;
    }

    public List<TestResultContainer> getAllTestResults() {
        return this.allTestResults;
    }

    public EyesSeleniumDriver getDriver() {
        return this.webDriver;
    }

    public IBatchCloser getBatchCloser() {
        return this.testList.get(0).getBatchCloser();
    }

    public String getBatchId() {
        return this.getConfiguration().getBatch().getId();
    }

    private void abort(Throwable e) {
        for (RunningTest runningTest : this.testList) {
            runningTest.abort(true, e);
        }
    }

    public void abortAsync() {
        this.abortAndCollectTasks();
    }

    public TestResults abort() {
        List<Future<TestResultContainer>> tasks = this.abortAndCollectTasks();
        return this.parseCloseFutures(tasks, false);
    }

    private List<Future<TestResultContainer>> abortAndCollectTasks() {
        ArrayList<Future<TestResultContainer>> tasks = new ArrayList<Future<TestResultContainer>>();
        for (RunningTest runningTest : this.testList) {
            Future task = runningTest.abort(false, null);
            tasks.add(task);
        }
        return tasks;
    }

    public boolean isServerConcurrencyLimitReached() {
        for (RunningTest runningTest : this.testList) {
            if (!runningTest.isServerConcurrencyLimitReached()) continue;
            return true;
        }
        return false;
    }
}

