/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.ScriptResponse;
import com.applitools.eyes.selenium.fluent.FrameLocator;
import com.applitools.eyes.selenium.fluent.IScrollRootElementContainer;
import com.applitools.eyes.selenium.frames.Frame;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.eyes.selenium.wrappers.EyesSeleniumDriver;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class EyesSeleniumUtils {
    private static final long DOM_EXTRACTION_TIMEOUT = 300000L;
    private static final String DOM_SCRIPTS_WRAPPER = "return (%s)(%s);";

    public static WebElement getDefaultRootElement(Logger logger, EyesSeleniumDriver driver) {
        EyesRemoteWebElement chosenElement;
        WebElement scrollingElement;
        try {
            scrollingElement = (WebElement)driver.executeScript("return document.scrollingElement", new Object[0]);
        }
        catch (Throwable t) {
            GeneralUtils.logExceptionStackTrace((Logger)logger, (Throwable)t);
            scrollingElement = null;
        }
        EyesRemoteWebElement eyesScrollingElement = null;
        if (scrollingElement != null) {
            eyesScrollingElement = new EyesRemoteWebElement(logger, driver, scrollingElement);
        }
        WebElement html = driver.findElement(By.tagName((String)"html"));
        EyesRemoteWebElement htmlElement = new EyesRemoteWebElement(logger, driver, html);
        if (eyesScrollingElement != null && eyesScrollingElement.canScrollVertically()) {
            chosenElement = eyesScrollingElement;
        } else if (!EyesSeleniumUtils.doesBodyExist(logger, driver)) {
            chosenElement = htmlElement;
        } else {
            WebElement body = driver.findElement(By.tagName((String)"body"));
            EyesRemoteWebElement bodyElement = new EyesRemoteWebElement(logger, driver, body);
            boolean scrollableHtml = htmlElement.canScrollVertically();
            boolean scrollableBody = bodyElement.canScrollVertically();
            chosenElement = scrollableHtml && !scrollableBody ? htmlElement : (!scrollableHtml && scrollableBody ? bodyElement : (scrollingElement != null ? eyesScrollingElement : htmlElement));
        }
        logger.verbose(String.format("Chosen default root element is %s", chosenElement.getTagName()));
        return chosenElement;
    }

    private static boolean doesBodyExist(Logger logger, EyesSeleniumDriver driver) {
        try {
            driver.findElement(By.tagName((String)"body"));
            return true;
        }
        catch (Throwable t) {
            logger.log("Failed finding the body element");
            return false;
        }
    }

    public static WebElement getScrollRootElement(Logger logger, EyesSeleniumDriver driver, IScrollRootElementContainer scrollRootElementContainer) {
        if (EyesDriverUtils.isMobileDevice((WebDriver)driver)) {
            return null;
        }
        if (scrollRootElementContainer == null) {
            return EyesSeleniumUtils.getDefaultRootElement(logger, driver);
        }
        WebElement scrollRootElement = scrollRootElementContainer.getScrollRootElement();
        if (scrollRootElement != null) {
            return scrollRootElement;
        }
        By scrollRootSelector = scrollRootElementContainer.getScrollRootSelector();
        if (scrollRootSelector != null) {
            return driver.findElement(scrollRootSelector);
        }
        logger.log("Warning: Got an empty scroll root element container");
        return EyesSeleniumUtils.getDefaultRootElement(logger, driver);
    }

    public static WebElement findFrameByFrameCheckTarget(FrameLocator frameTarget, EyesSeleniumDriver driver) {
        if (frameTarget.getFrameIndex() != null) {
            return driver.findElement(By.xpath((String)("IFRAME[" + frameTarget.getFrameIndex() + "]")));
        }
        String nameOrId = frameTarget.getFrameNameOrId();
        if (nameOrId != null) {
            List<WebElement> byId = driver.findElements(By.id((String)nameOrId));
            if (byId.size() > 0) {
                return byId.get(0);
            }
            return driver.findElement(By.name((String)nameOrId));
        }
        WebElement reference = frameTarget.getFrameReference();
        if (reference != null) {
            return reference;
        }
        By selector = frameTarget.getFrameSelector();
        if (selector != null) {
            return driver.findElement(selector);
        }
        return null;
    }

    public static WebElement getCurrentFrameScrollRootElement(Logger logger, EyesSeleniumDriver driver, WebElement userDefinedSRE) {
        WebElement scrollRootElement = EyesSeleniumUtils.tryGetCurrentFrameScrollRootElement(driver);
        if (scrollRootElement == null) {
            scrollRootElement = userDefinedSRE != null ? userDefinedSRE : EyesSeleniumUtils.getDefaultRootElement(logger, driver);
        }
        return scrollRootElement;
    }

    public static WebElement tryGetCurrentFrameScrollRootElement(EyesSeleniumDriver driver) {
        FrameChain fc = driver.getFrameChain().clone();
        Frame currentFrame = fc.peek();
        WebElement scrollRootElement = null;
        if (currentFrame != null) {
            scrollRootElement = currentFrame.getScrollRootElement();
        }
        return scrollRootElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String runDomScript(Logger logger, EyesWebDriver driver, UserAgent userAgent, String domScript, Map<String, Object> domScriptArguments, String pollingScript) throws Exception {
        logger.verbose("Starting dom extraction");
        if (domScriptArguments == null) {
            domScriptArguments = new HashMap<String, Object>();
        }
        HashMap<String, Integer> pollingScriptArguments = new HashMap<String, Integer>();
        int chunkByteLength = userAgent.getOS().toLowerCase().contains("ios") ? 0xA00000 : 0x10000000;
        domScriptArguments.put("chunkByteLength", chunkByteLength);
        pollingScriptArguments.put("chunkByteLength", chunkByteLength);
        ObjectMapper mapper = new ObjectMapper();
        String domScriptWrapped = String.format(DOM_SCRIPTS_WRAPPER, domScript, mapper.writeValueAsString(domScriptArguments));
        String pollingScriptWrapped = String.format(DOM_SCRIPTS_WRAPPER, pollingScript, mapper.writeValueAsString(pollingScriptArguments));
        AtomicBoolean isCheckTimerTimedOut = new AtomicBoolean(false);
        Timer timer = new Timer("VG_Check_StopWatch", true);
        timer.schedule((TimerTask)new TimeoutTask(isCheckTimerTimedOut), 300000L);
        try {
            String resultAsString = (String)driver.executeScript(domScriptWrapped, new Object[0]);
            ScriptResponse scriptResponse = (ScriptResponse)GeneralUtils.parseJsonToObject((String)resultAsString, ScriptResponse.class);
            ScriptResponse.Status status = scriptResponse.getStatus();
            while (status == ScriptResponse.Status.WIP && !isCheckTimerTimedOut.get()) {
                logger.verbose("Dom script polling...");
                resultAsString = (String)driver.executeScript(pollingScriptWrapped, new Object[0]);
                scriptResponse = (ScriptResponse)GeneralUtils.parseJsonToObject((String)resultAsString, ScriptResponse.class);
                status = scriptResponse.getStatus();
                Thread.sleep(200L);
            }
            if (status == ScriptResponse.Status.ERROR) {
                throw new EyesException("DomSnapshot Error: " + scriptResponse.getError());
            }
            if (isCheckTimerTimedOut.get()) {
                throw new EyesException("Domsnapshot Timed out");
            }
            if (status == ScriptResponse.Status.SUCCESS) {
                String string = scriptResponse.getValue().toString();
                return string;
            }
            StringBuilder value = new StringBuilder();
            while (status == ScriptResponse.Status.SUCCESS_CHUNKED && !scriptResponse.isDone() && !isCheckTimerTimedOut.get()) {
                logger.verbose("Dom script chunks polling...");
                value.append((String)GeneralUtils.parseJsonToObject((String)scriptResponse.getValue().toString(), String.class));
                resultAsString = (String)driver.executeScript(pollingScriptWrapped, new Object[0]);
                scriptResponse = (ScriptResponse)GeneralUtils.parseJsonToObject((String)resultAsString, ScriptResponse.class);
                status = scriptResponse.getStatus();
                Thread.sleep(200L);
            }
            if (status == ScriptResponse.Status.ERROR) {
                throw new EyesException("DomSnapshot Error: " + scriptResponse.getError());
            }
            if (isCheckTimerTimedOut.get()) {
                throw new EyesException("Domsnapshot Timed out");
            }
            value.append((String)GeneralUtils.parseJsonToObject((String)scriptResponse.getValue().toString(), String.class));
            String string = value.toString();
            return string;
        }
        finally {
            timer.cancel();
            logger.verbose("Finished dom extraction");
        }
    }

    private static class TimeoutTask
    extends TimerTask {
        private final AtomicBoolean isCheckTimerTimedOut;

        public TimeoutTask(AtomicBoolean isCheckTimerTimedOut) {
            this.isCheckTimerTimedOut = isCheckTimerTimedOut;
        }

        @Override
        public void run() {
            this.isCheckTimerTimedOut.set(true);
        }
    }
}

