/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium;

import com.applitools.eyes.Logger;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.wrappers.EyesSeleniumDriver;
import com.applitools.eyes.selenium.wrappers.EyesTargetLocator;
import org.openqa.selenium.WebDriver;

class CaretVisibilityProvider {
    private final Logger logger;
    private final EyesSeleniumDriver driver;
    private final Configuration configuration;
    private Object activeElement = null;
    private FrameChain frameChain;
    private static final String HIDE_CARET = "var activeElement = document.activeElement; activeElement && activeElement.blur(); return activeElement;";

    public CaretVisibilityProvider(Logger logger, EyesSeleniumDriver driver, Configuration configuration) {
        this.logger = logger;
        this.driver = driver;
        this.configuration = configuration;
    }

    public void hideCaret() {
        if (!EyesDriverUtils.isMobileDevice((WebDriver)this.driver) && this.configuration.getHideCaret()) {
            this.frameChain = this.driver.getFrameChain().clone();
            this.logger.verbose("Hiding caret. driver.FrameChain.Count: " + this.frameChain.size());
            this.activeElement = this.driver.executeScript(HIDE_CARET, new Object[0]);
        }
    }

    public void restoreCaret() {
        if (!EyesDriverUtils.isMobileDevice((WebDriver)this.driver) && this.configuration.getHideCaret() && this.activeElement != null) {
            this.logger.verbose("Restoring caret. driver.FrameChain.Count: " + this.driver.getFrameChain().size());
            ((EyesTargetLocator)this.driver.switchTo()).frames(this.frameChain);
            this.driver.executeScript("arguments[0].focus();", this.activeElement);
        }
    }
}

