/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.wrappers;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.IEyesJsExecutor;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.selenium.Borders;
import com.applitools.eyes.selenium.SeleniumJavaScriptExecutor;
import com.applitools.eyes.selenium.SizeAndBorders;
import com.applitools.eyes.selenium.frames.Frame;
import com.applitools.eyes.selenium.frames.FrameChain;
import com.applitools.eyes.selenium.positioning.ScrollPositionProvider;
import com.applitools.eyes.selenium.positioning.ScrollPositionProviderFactory;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.utils.ArgumentGuard;
import java.util.List;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;

public class EyesTargetLocator
implements WebDriver.TargetLocator {
    private final Logger logger;
    private final EyesWebDriver driver;
    private ScrollPositionProvider scrollPosition;
    private final WebDriver.TargetLocator targetLocator;
    private final SeleniumJavaScriptExecutor jsExecutor;
    private PositionMemento defaultContentPositionMemento;

    public EyesTargetLocator(EyesWebDriver driver, Logger logger, WebDriver.TargetLocator targetLocator) {
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        ArgumentGuard.notNull((Object)targetLocator, (String)"targetLocator");
        this.driver = driver;
        this.logger = logger;
        this.targetLocator = targetLocator;
        this.jsExecutor = new SeleniumJavaScriptExecutor(driver);
        if (this.driver.getEyes() != null) {
            this.scrollPosition = ScrollPositionProviderFactory.getScrollPositionProvider(driver.getUserAgent(), logger, (IEyesJsExecutor)this.jsExecutor, driver.getEyes().getCurrentFrameScrollRootElement());
        }
    }

    private void willSwitchToFrame(WebElement targetFrame) {
        ArgumentGuard.notNull((Object)targetFrame, (String)"targetFrame");
        EyesRemoteWebElement eyesFrame = targetFrame instanceof EyesRemoteWebElement ? (EyesRemoteWebElement)targetFrame : new EyesRemoteWebElement(this.logger, this.driver, targetFrame);
        Point pl = targetFrame.getLocation();
        Dimension ds = targetFrame.getSize();
        SizeAndBorders sizeAndBorders = eyesFrame.getSizeAndBorders();
        Borders borders = sizeAndBorders.getBorders();
        RectangleSize frameInnerSize = sizeAndBorders.getSize();
        Rectangle bounds = eyesFrame.getBoundingClientRect();
        Location contentLocation = new Location(bounds.getX() + borders.getLeft(), bounds.getY() + borders.getTop());
        Location originalLocation = eyesFrame.getScrollLocation();
        Frame frame = new Frame(this.logger, targetFrame, contentLocation, new RectangleSize(ds.getWidth(), ds.getHeight()), frameInnerSize, originalLocation, this.driver);
        this.driver.getFrameChain().push(frame);
    }

    public WebDriver frame(int index) {
        this.logger.verbose(String.format("(%d)", index));
        this.logger.verbose("Getting frames list...");
        List<WebElement> frames = this.driver.findElementsByCssSelector("frame, iframe");
        if (index > frames.size()) {
            throw new NoSuchFrameException(String.format("Frame index [%d] is invalid!", index));
        }
        this.logger.verbose("Done! getting the specific frame...");
        WebElement targetFrame = frames.get(index);
        this.logger.verbose("Done! Making preparations...");
        this.willSwitchToFrame(targetFrame);
        this.logger.verbose("Done! Switching to frame...");
        this.targetLocator.frame(index);
        this.logger.verbose("Done!");
        return this.driver;
    }

    public WebDriver frame(String nameOrId) {
        this.logger.verbose(String.format("('%s')", nameOrId));
        this.logger.verbose("Getting frames by name...");
        List<WebElement> frames = this.driver.findElementsByName(nameOrId);
        if (frames.size() == 0) {
            this.logger.verbose("No frames Found! Trying by id...");
            frames = this.driver.findElementsById(nameOrId);
            if (frames.size() == 0) {
                throw new NoSuchFrameException(String.format("No frame with name or id '%s' exists!", nameOrId));
            }
        }
        this.logger.verbose("Done! Making preparations...");
        this.willSwitchToFrame(frames.get(0));
        this.logger.verbose("Done! Switching to frame " + nameOrId + "...");
        this.targetLocator.frame(nameOrId);
        this.logger.verbose("Done!");
        return this.driver;
    }

    public WebDriver frame(WebElement frameElement) {
        this.logger.verbose("Making preparations...");
        this.willSwitchToFrame(frameElement);
        this.logger.verbose("Done! Switching to frame...");
        this.targetLocator.frame(frameElement);
        this.logger.verbose("Done!");
        return this.driver;
    }

    public WebDriver parentFrame() {
        this.logger.verbose("enter");
        if (this.driver.getFrameChain().size() != 0) {
            this.logger.verbose("Making preparations...");
            Frame frame = this.driver.getFrameChain().pop();
            frame.returnToOriginalPosition(this.driver);
            this.logger.verbose("Done! Switching to parent frame...");
            EyesTargetLocator.parentFrame(this.logger, this.targetLocator, this.driver.getFrameChain());
        }
        this.logger.verbose("Done!");
        return this.driver;
    }

    public static void parentFrame(Logger logger, WebDriver.TargetLocator targetLocator, FrameChain frameChainToParent) {
        logger.verbose("enter (static)");
        try {
            targetLocator.parentFrame();
        }
        catch (Exception WebDriverException) {
            targetLocator.defaultContent();
            for (Frame frame : frameChainToParent) {
                targetLocator.frame(frame.getReference());
            }
        }
    }

    public WebDriver framesDoScroll(FrameChain frameChain) {
        this.logger.verbose("enter");
        this.defaultContent();
        ScrollPositionProvider scrollProvider = ScrollPositionProviderFactory.getScrollPositionProvider(this.driver.getUserAgent(), this.logger, (IEyesJsExecutor)this.jsExecutor, this.driver.getEyes().getCurrentFrameScrollRootElement());
        this.defaultContentPositionMemento = scrollProvider.getState();
        for (Frame frame : frameChain) {
            this.logger.verbose("Scrolling by parent scroll position...");
            Location frameLocation = frame.getLocation();
            scrollProvider.setPosition(frameLocation);
            this.logger.verbose("Done! Switching to frame...");
            this.frame(frame.getReference());
            Frame newFrame = this.driver.getFrameChain().peek();
            newFrame.setScrollRootElement(frame.getScrollRootElement());
            this.logger.verbose("Done!");
        }
        this.logger.verbose("Done switching into nested frames!");
        return this.driver;
    }

    public WebDriver frames(FrameChain frameChain) {
        this.logger.verbose("enter");
        this.defaultContent();
        for (Frame frame : frameChain) {
            this.frame(frame.getReference());
            this.logger.verbose(String.format("frame.Reference: %s ; frame.ScrollRootElement: %s", frame.getReference(), frame.getScrollRootElement()));
            Frame newFrame = this.driver.getFrameChain().peek();
            newFrame.setScrollRootElement(frame.getScrollRootElement());
        }
        this.logger.verbose("Done switching into nested frames!");
        return this.driver;
    }

    public WebDriver frames(String[] framesPath) {
        this.logger.verbose("enter");
        for (String frameNameOrId : framesPath) {
            this.logger.verbose("Switching to frame...");
            this.targetLocator.frame(frameNameOrId);
            this.logger.verbose("Done!");
        }
        this.logger.verbose("Done switching into nested frames!");
        return this.driver;
    }

    public WebDriver window(String nameOrHandle) {
        this.logger.verbose("enter");
        this.driver.getFrameChain().clear();
        this.logger.verbose("Done! Switching to window...");
        this.targetLocator.window(nameOrHandle);
        this.logger.verbose("Done!");
        return this.driver;
    }

    public WebDriver defaultContent() {
        this.logger.verbose("enter");
        if (this.driver.getFrameChain().size() != 0) {
            this.logger.verbose("Making preparations...");
            this.driver.getFrameChain().clear();
            this.logger.verbose("Done! Switching to default content...");
        }
        this.targetLocator.defaultContent();
        this.logger.verbose("Done!");
        return this.driver;
    }

    public WebElement activeElement() {
        this.logger.verbose("Switching to element...");
        WebElement element = this.targetLocator.activeElement();
        if (!(element instanceof RemoteWebElement)) {
            throw new EyesException("Not a remote web element!");
        }
        EyesRemoteWebElement result = new EyesRemoteWebElement(this.logger, this.driver, element);
        this.logger.verbose("Done!");
        return result;
    }

    public Alert alert() {
        this.logger.verbose("Switching to alert...");
        Alert result = this.targetLocator.alert();
        this.logger.verbose("Done!");
        return result;
    }

    public void resetScroll() {
        this.logger.verbose("enter");
        if (this.defaultContentPositionMemento != null) {
            this.scrollPosition.restoreState(this.defaultContentPositionMemento);
        }
    }
}

