/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.fluent;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.Location;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.fluent.GetRegion;
import com.applitools.eyes.selenium.SeleniumEyes;
import com.applitools.eyes.selenium.rendering.IGetSeleniumRegion;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SimpleRegionBySelector
implements GetRegion,
IGetSeleniumRegion {
    private By selector;

    public SimpleRegionBySelector(By selector) {
        this.selector = selector;
    }

    public List<Region> getRegions(EyesBase eyesBase, EyesScreenshot screenshot) {
        List elements = ((SeleniumEyes)eyesBase).getDriver().findElements(this.selector);
        ArrayList<Region> values = new ArrayList<Region>(elements.size());
        for (WebElement element : elements) {
            Point locationAsPoint = element.getLocation();
            Dimension size = element.getSize();
            Location adjustedLocation = new Location(locationAsPoint.getX(), locationAsPoint.getY());
            if (screenshot != null) {
                adjustedLocation = screenshot.convertLocation(adjustedLocation, CoordinatesType.CONTEXT_RELATIVE, CoordinatesType.SCREENSHOT_AS_IS);
            }
            values.add(new Region(adjustedLocation, new RectangleSize(size.getWidth(), size.getHeight()), CoordinatesType.SCREENSHOT_AS_IS));
        }
        return values;
    }

    @Override
    public List<WebElement> getElements(WebDriver webDriver) {
        return webDriver.findElements(this.selector);
    }
}

