/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.EyesWebDriver;
import com.applitools.eyes.Frame;
import com.applitools.eyes.FrameChain;
import com.applitools.eyes.Location;
import com.applitools.eyes.OutOfBoundsException;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.utils.ArgumentGuard;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class EyesWebDriverScreenshot
extends EyesScreenshot {
    private final EyesWebDriver driver;
    private final RectangleSize viewportSize;
    private final FrameChain frameChain;
    private final RectangleSize frameSize;
    private final Location scrollPosition;
    private final ScreenshotType screenshotType;
    private final Location frameLocationInScreenshot;
    private final Region frameScreenshotIntersect;

    private static Location calcFrameLocationInScreenshot(FrameChain frameChain, ScreenshotType screenshotType) {
        Iterator<Frame> frameIterator = frameChain.iterator();
        Frame firstFrame = frameIterator.next();
        Location locationInScreenshot = new Location(firstFrame.getLocation());
        if (screenshotType == ScreenshotType.VIEWPORT) {
            Location defaultContentScroll = firstFrame.getParentScrollPosition();
            locationInScreenshot.offset(-defaultContentScroll.getX(), -defaultContentScroll.getY());
        }
        while (frameIterator.hasNext()) {
            Frame frame = frameIterator.next();
            Location frameLocation = frame.getLocation();
            Location frameParentScrollPosition = frame.getParentScrollPosition();
            locationInScreenshot.offset(frameLocation.getX() - frameParentScrollPosition.getX(), frameLocation.getY() - frameParentScrollPosition.getY());
        }
        return locationInScreenshot;
    }

    public EyesWebDriverScreenshot(EyesWebDriver driver, BufferedImage image, ScreenshotType screenshotType, Location location, Location frameLocationInScreenshot) {
        super(image);
        Location sp;
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        this.driver = driver;
        this.viewportSize = driver.getDefaultContentViewportSize();
        this.frameChain = driver.getFrameChain();
        if (this.frameChain.size() != 0) {
            this.frameSize = this.frameChain.getCurrentFrameSize();
        } else {
            RectangleSize fs;
            try {
                fs = driver.getEntirePageSize();
            }
            catch (WebDriverException e) {
                fs = this.viewportSize;
            }
            this.frameSize = fs;
        }
        try {
            sp = driver.getCurrentScrollPosition();
        }
        catch (WebDriverException e) {
            sp = new Location(0, 0);
        }
        this.scrollPosition = sp;
        if (screenshotType == null) {
            screenshotType = image.getWidth() <= this.viewportSize.getWidth() && image.getHeight() <= this.viewportSize.getHeight() ? ScreenshotType.VIEWPORT : ScreenshotType.FULL_PAGE;
        }
        this.screenshotType = screenshotType;
        if (location != null && this.screenshotType == ScreenshotType.VIEWPORT) {
            if (this.frameChain.size() != 0) {
                this.bounds.setLocation(this.frameChain.getDefaultContentScrollPosition());
            } else {
                this.bounds.setLocation(this.scrollPosition);
            }
        }
        if (frameLocationInScreenshot == null) {
            if (this.frameChain.size() > 0) {
                frameLocationInScreenshot = EyesWebDriverScreenshot.calcFrameLocationInScreenshot(this.frameChain, this.screenshotType);
            } else {
                frameLocationInScreenshot = new Location(0, 0);
                if (this.screenshotType == ScreenshotType.VIEWPORT) {
                    frameLocationInScreenshot.offset(-this.scrollPosition.getX(), -this.scrollPosition.getY());
                }
            }
        }
        this.frameLocationInScreenshot = frameLocationInScreenshot;
        this.frameScreenshotIntersect = new Region(frameLocationInScreenshot, this.frameSize);
        this.frameScreenshotIntersect.intersect(new Region(0, 0, image.getWidth(), image.getHeight()));
    }

    public EyesWebDriverScreenshot(EyesWebDriver driver, BufferedImage image) {
        this(driver, image, null, null, null);
    }

    public FrameChain getFrameChain() {
        return new FrameChain(this.frameChain);
    }

    protected Location getLocationRelativeToFrameViewport(Location location) {
        Location result = new Location(location);
        if (this.frameChain.size() != 0 || this.screenshotType == ScreenshotType.VIEWPORT) {
            result.offset(-this.scrollPosition.getX(), -this.scrollPosition.getY());
        }
        return result;
    }

    public Location getLocationInScreenshot(Location location) throws OutOfBoundsException {
        location = this.getLocationRelativeToFrameViewport(location);
        location.offset(this.frameScreenshotIntersect.getLocation());
        if (!this.frameScreenshotIntersect.contains(location)) {
            throw new OutOfBoundsException("Location is out of the frame's region in the screenshot!");
        }
        return location;
    }

    public Region getElementRegionInFrameViewport(WebElement element) {
        int diff;
        Point pLocation = element.getLocation();
        Dimension dSize = element.getSize();
        Location location = new Location(pLocation.getX(), pLocation.getY());
        Location relativeLocation = this.getLocationRelativeToFrameViewport(location);
        int x = relativeLocation.getX();
        int y = relativeLocation.getY();
        int width = dSize.getWidth();
        int height = dSize.getHeight();
        if (x < 0) {
            diff = -x;
            x = location.getX() + diff;
            width -= diff;
        }
        if (y < 0) {
            diff = -y;
            y = location.getY() + diff;
            height -= diff;
        }
        if (width <= 0 || height <= 0) {
            throw new OutOfBoundsException(String.format("Element's region is outside the viewport! [(%d, %d) %d x %d]", location.getX(), location.getY(), dSize.getWidth(), dSize.getHeight()));
        }
        return new Region(x, y, width, height);
    }

    public Region getIntersectedRegion(Region region) {
        ArgumentGuard.notNull((Object)region, (String)"region");
        Region regionInScreenshot = new Region(region);
        Location location = regionInScreenshot.getLocation();
        location.offset(this.frameLocationInScreenshot);
        regionInScreenshot.setLocation(location);
        regionInScreenshot.intersect(this.frameScreenshotIntersect);
        return regionInScreenshot;
    }

    public Region getIntersectedRegion(WebElement element) {
        ArgumentGuard.notNull((Object)element, (String)"element");
        Region elementRegionInFrameViewport = this.getElementRegionInFrameViewport(element);
        return this.getIntersectedRegion(elementRegionInFrameViewport);
    }

    public EyesWebDriverScreenshot getSubScreenshot(Region region) {
        ArgumentGuard.notNull((Object)region, (String)"region");
        Region subScreenshotRegion = this.getIntersectedRegion(region);
        if (subScreenshotRegion.isEmpty()) {
            throw new OutOfBoundsException(String.format("Region [%s] has no intersection with the screenshot [%s]", region, this.bounds));
        }
        BufferedImage subScreenshotImage = this.getSubImage(subScreenshotRegion);
        Location regionLocation = region.getLocation();
        Location subScreenshotFrameLocation = new Location(-regionLocation.getX(), -regionLocation.getY());
        Location relativeRegionLocation = new Location(regionLocation);
        relativeRegionLocation.offset(this.scrollPosition);
        return new EyesWebDriverScreenshot(this.driver, subScreenshotImage, this.screenshotType, relativeRegionLocation, subScreenshotFrameLocation);
    }

    public EyesWebDriverScreenshot getSubScreenshot(WebElement element) {
        ArgumentGuard.notNull((Object)element, (String)"element");
        Region elementRegion = this.getElementRegionInFrameViewport(element);
        return this.getSubScreenshot(elementRegion);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ScreenshotType {
        VIEWPORT,
        FULL_PAGE;

    }
}

