/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.Frame;
import com.applitools.eyes.Location;
import com.applitools.eyes.NoFramesException;
import com.applitools.eyes.RectangleSize;
import com.applitools.utils.ArgumentGuard;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameChain
implements Iterable<Frame> {
    private List<Frame> frames;

    public static boolean isSameFrameChain(FrameChain c1, FrameChain c2) {
        int lc2;
        int lc1 = c1.frames.size();
        if (lc1 != (lc2 = c2.frames.size())) {
            return false;
        }
        Iterator<Frame> c1Iterator = c1.iterator();
        Iterator<Frame> c2Iterator = c2.iterator();
        for (int i = 0; i < lc1; ++i) {
            if (c1Iterator.next().getId().equals(c2Iterator.next().getId())) continue;
            return false;
        }
        return true;
    }

    public FrameChain() {
        this.frames = new LinkedList<Frame>();
    }

    public FrameChain(FrameChain other) {
        ArgumentGuard.notNull((Object)other, (String)"other");
        this.frames = new LinkedList<Frame>();
        for (Frame otherFrame : other.frames) {
            this.frames.add(new Frame(otherFrame.getReference(), otherFrame.getId(), otherFrame.getLocation(), otherFrame.getSize(), otherFrame.getParentScrollPosition()));
        }
    }

    public int size() {
        return this.frames.size();
    }

    public void clear() {
        this.frames.clear();
    }

    public void pop() {
        this.frames.remove(this.frames.size() - 1);
    }

    public void push(Frame frame) {
        this.frames.add(frame);
    }

    public Location getCurrentFrameOffset() {
        Location result = new Location(0, 0);
        for (Frame frame : this.frames) {
            result.offset(frame.getLocation());
        }
        return result;
    }

    public Location getDefaultContentScrollPosition() {
        if (this.frames.size() == 0) {
            throw new NoFramesException("No frames in frame chain");
        }
        return new Location(this.frames.get(0).getParentScrollPosition());
    }

    public RectangleSize getCurrentFrameSize() {
        return this.frames.get(this.frames.size() - 1).getSize();
    }

    @Override
    public Iterator<Frame> iterator() {
        return new Iterator<Frame>(){
            Iterator<Frame> framesIterator;
            {
                this.framesIterator = FrameChain.this.frames.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.framesIterator.hasNext();
            }

            @Override
            public Frame next() {
                return this.framesIterator.next();
            }

            @Override
            public void remove() {
                throw new EyesException("Remove is forbidden using the iterator!");
            }
        };
    }
}

