/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.fluent;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.fluent.GetSimpleRegion;
import com.applitools.eyes.selenium.fluent.IGetSeleniumRegion;
import com.applitools.eyes.selenium.fluent.ImplicitInitiation;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;

public class SimpleRegionBySelector
implements GetSimpleRegion,
IGetSeleniumRegion,
ImplicitInitiation {
    private Logger logger;
    private EyesWebDriver driver;
    private final By selector;

    public SimpleRegionBySelector(By selector) {
        this.selector = selector;
    }

    @Override
    public void init(Logger logger, EyesWebDriver driver) {
        this.logger = logger;
        this.driver = driver;
    }

    public List<Region> getRegions(EyesScreenshot screenshot) {
        List<WebElement> elements = this.driver.findElements(this.selector);
        ArrayList<Region> values = new ArrayList<Region>(elements.size());
        for (WebElement element : elements) {
            Point locationAsPoint = element.getLocation();
            Dimension size = element.getSize();
            Location adjustedLocation = new Location(locationAsPoint.getX(), locationAsPoint.getY());
            if (screenshot != null) {
                adjustedLocation = screenshot.convertLocation(adjustedLocation, CoordinatesType.CONTEXT_RELATIVE, CoordinatesType.SCREENSHOT_AS_IS);
            }
            values.add(new Region(adjustedLocation, new RectangleSize(size.getWidth(), size.getHeight()), CoordinatesType.SCREENSHOT_AS_IS));
        }
        return values;
    }

    @Override
    public List<WebElement> getElements() {
        return this.driver.findElements(this.selector);
    }
}

