/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.fluent;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.FloatingMatchSettings;
import com.applitools.eyes.Location;
import com.applitools.eyes.fluent.GetFloatingRegion;
import com.applitools.eyes.selenium.fluent.IGetSeleniumRegion;
import com.applitools.eyes.visualgrid.model.IGetFloatingRegionOffsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;

public class FloatingRegionByElement
implements GetFloatingRegion,
IGetSeleniumRegion,
IGetFloatingRegionOffsets {
    protected final WebElement element;
    protected final int maxUpOffset;
    protected final int maxDownOffset;
    protected final int maxLeftOffset;
    protected final int maxRightOffset;

    public FloatingRegionByElement(WebElement element, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        this.element = element;
        this.maxUpOffset = maxUpOffset;
        this.maxDownOffset = maxDownOffset;
        this.maxLeftOffset = maxLeftOffset;
        this.maxRightOffset = maxRightOffset;
    }

    public List<FloatingMatchSettings> getRegions(EyesScreenshot screenshot) {
        Point locationAsPoint = this.element.getLocation();
        Dimension size = this.element.getSize();
        Location adjustedLocation = screenshot != null ? screenshot.getLocationInScreenshot(new Location(locationAsPoint.getX(), locationAsPoint.getY()), CoordinatesType.CONTEXT_RELATIVE) : new Location(locationAsPoint.getX(), locationAsPoint.getY());
        ArrayList<FloatingMatchSettings> value = new ArrayList<FloatingMatchSettings>();
        value.add(new FloatingMatchSettings(adjustedLocation.getX(), adjustedLocation.getY(), size.getWidth(), size.getHeight(), this.maxUpOffset, this.maxDownOffset, this.maxLeftOffset, this.maxRightOffset));
        return value;
    }

    @Override
    public List<WebElement> getElements() {
        return Collections.singletonList(this.element);
    }

    public int getMaxLeftOffset() {
        return this.maxLeftOffset;
    }

    public int getMaxUpOffset() {
        return this.maxUpOffset;
    }

    public int getMaxRightOffset() {
        return this.maxRightOffset;
    }

    public int getMaxDownOffset() {
        return this.maxDownOffset;
    }
}

