/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.utils;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.Region;
import com.applitools.utils.ArgumentGuard;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;

public class ImageUtils {
    public static byte[] encodeAsPng(BufferedImage image) {
        byte[] encodedImage;
        ArgumentGuard.notNull(image, "image");
        ByteArrayOutputStream pngBytesStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", pngBytesStream);
            pngBytesStream.flush();
            encodedImage = pngBytesStream.toByteArray();
        }
        catch (IOException e) {
            throw new EyesException("Failed to encode image", e);
        }
        finally {
            try {
                pngBytesStream.close();
            }
            catch (IOException e) {
                throw new EyesException("Failed to close png byte stream", e);
            }
        }
        return encodedImage;
    }

    public static BufferedImage imageFromFile(String path) throws EyesException {
        BufferedImage result;
        try {
            result = ImageIO.read(new File(path));
        }
        catch (IOException e) {
            throw new EyesException("Failed to to load the image bytes from " + path, e);
        }
        return result;
    }

    public static BufferedImage imageFromBase64(String image64) throws EyesException {
        byte[] imageBytes = Base64.decodeBase64((byte[])image64.getBytes(Charset.forName("UTF-8")));
        return ImageUtils.imageFromBytes(imageBytes);
    }

    public static BufferedImage imageFromBytes(byte[] imageBytes) throws EyesException {
        BufferedImage image;
        try {
            ByteArrayInputStream screenshotStream = new ByteArrayInputStream(imageBytes);
            image = ImageIO.read(screenshotStream);
            screenshotStream.close();
        }
        catch (IOException e) {
            throw new EyesException("Failed to create buffered image!", e);
        }
        return image;
    }

    public static BufferedImage getImagePart(BufferedImage image, Region region) {
        ArgumentGuard.notNull(image, "image");
        BufferedImage imagePart = image.getSubimage(region.getLeft(), region.getTop(), region.getWidth(), region.getHeight());
        byte[] imagePartBytes = ImageUtils.encodeAsPng(imagePart);
        return ImageUtils.imageFromBytes(imagePartBytes);
    }
}

