/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.ProxySettings;
import com.applitools.eyes.RestClient;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.SessionStartInfo;
import com.applitools.eyes.TestResults;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;

class ServerConnector
extends RestClient {
    private static final int TIMEOUT = 300000;
    private static final String API_PATH = "/api/sessions/running";
    protected String sdkName;
    protected String apiKey;

    public ServerConnector(Logger logger, String sdkName, URI serverUrl) {
        super(logger, serverUrl, 300000);
        this.sdkName = sdkName;
        this.endPoint = this.endPoint.path(API_PATH);
    }

    public void setApiKey(String apiKey) {
        ArgumentGuard.notNull(apiKey, "apiKey");
        this.apiKey = apiKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setProxy(ProxySettings proxySettings) {
        this.setProxyBase(proxySettings);
        this.endPoint = this.endPoint.path(API_PATH);
    }

    public ProxySettings getProxy() {
        return this.getProxyBase();
    }

    protected void setServerUrl(URI serverUrl) {
        this.setServerUrlBase(serverUrl);
        this.endPoint = this.endPoint.path(API_PATH);
    }

    protected URI getServerUrl() {
        return this.getServerUrlBase();
    }

    public RunningSession startSession(SessionStartInfo sessionStartInfo) throws EyesException {
        Response response;
        String postData;
        ArgumentGuard.notNull(sessionStartInfo, "sessionStartInfo");
        try {
            this.jsonMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
            postData = this.jsonMapper.writeValueAsString((Object)sessionStartInfo);
            this.jsonMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        }
        catch (IOException e) {
            throw new EyesException("Failed to convert sessionStartInfo into Json string!", e);
        }
        try {
            response = this.endPoint.queryParam("apiKey", new Object[]{this.apiKey}).request(new String[]{"application/json"}).post(Entity.json((Object)postData));
        }
        catch (RuntimeException e) {
            this.logger.log("startSession(): Server request failed: " + e.getMessage());
            throw e;
        }
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
        validStatusCodes.add(Response.Status.OK.getStatusCode());
        validStatusCodes.add(Response.Status.CREATED.getStatusCode());
        RunningSession runningSession = this.parseResponseWithJsonData(response, validStatusCodes, RunningSession.class);
        int statusCode = response.getStatus();
        boolean isNewSession = statusCode == Response.Status.CREATED.getStatusCode();
        runningSession.setIsNewSession(isNewSession);
        return runningSession;
    }

    public TestResults stopSession(RunningSession runningSession, final boolean isAborted, final boolean save) throws EyesException {
        ArgumentGuard.notNull(runningSession, "runningSession");
        final String sessionId = runningSession.getId();
        RestClient.HttpMethodCall delete = new RestClient.HttpMethodCall(){

            public Response call() {
                String currentTime = GeneralUtils.toRfc1123(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                Invocation.Builder invocationBuilder = ServerConnector.this.endPoint.path(sessionId).queryParam("apiKey", new Object[]{ServerConnector.this.apiKey}).queryParam("aborted", new Object[]{String.valueOf(isAborted)}).queryParam("updateBaseline", new Object[]{String.valueOf(save)}).request(new String[]{"application/json"}).header("Eyes-Expect", (Object)"202-accepted").header("Eyes-Date", (Object)currentTime);
                return invocationBuilder.delete();
            }
        };
        Response response = this.sendLongRequest(delete, "stopSession");
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
        validStatusCodes.add(Response.Status.OK.getStatusCode());
        TestResults result = this.parseResponseWithJsonData(response, validStatusCodes, TestResults.class);
        return result;
    }

    public MatchResult matchWindow(RunningSession runningSession, MatchWindowData matchData) throws EyesException {
        byte[] requestData;
        byte[] jsonBytes;
        String jsonData;
        ArgumentGuard.notNull(runningSession, "runningSession");
        ArgumentGuard.notNull(matchData, "data");
        WebTarget runningSessionsEndpoint = this.endPoint.path(runningSession.getId());
        try {
            jsonData = this.jsonMapper.writeValueAsString((Object)matchData);
        }
        catch (IOException e) {
            throw new EyesException("Failed to serialize data for matchWindow!", e);
        }
        ByteArrayOutputStream jsonToBytesConverter = new ByteArrayOutputStream();
        try {
            jsonToBytesConverter.write(jsonData.getBytes("UTF-8"));
            jsonToBytesConverter.flush();
            jsonBytes = jsonToBytesConverter.toByteArray();
        }
        catch (IOException e) {
            throw new EyesException("Failed create binary data from JSON!", e);
        }
        byte[] screenshot = Base64.decodeBase64((String)matchData.getAppOutput().getScreenshot64());
        ByteArrayOutputStream requestOutputStream = new ByteArrayOutputStream();
        DataOutputStream requestDos = new DataOutputStream(requestOutputStream);
        try {
            requestDos.writeInt(jsonBytes.length);
            requestDos.flush();
            requestOutputStream.write(jsonBytes);
            requestOutputStream.write(screenshot);
            requestOutputStream.flush();
            requestData = requestOutputStream.toByteArray();
            requestDos.close();
        }
        catch (IOException e) {
            throw new EyesException("Failed send check window request!", e);
        }
        Response response = runningSessionsEndpoint.queryParam("apiKey", new Object[]{this.apiKey}).request(new String[]{"application/json"}).post(Entity.entity((Object)requestData, (String)"application/octet-stream"));
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>(1);
        validStatusCodes.add(Response.Status.OK.getStatusCode());
        MatchResult result = this.parseResponseWithJsonData(response, validStatusCodes, MatchResult.class);
        return result;
    }
}

